/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzls;
import com.google.android.gms.measurement.internal.zzmp;
import com.google.android.gms.measurement.internal.zzmr;
import com.google.android.gms.measurement.internal.zzms;
import com.google.android.gms.measurement.internal.zzmt;
import com.google.android.gms.measurement.internal.zzmu;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzmq
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile @Nullable zzgj zzc;
    final /* synthetic */ zzls zza;

    static /* bridge */ /* synthetic */ void zza(zzmq zzmq2, boolean bl) {
        zzmq2.zzb = false;
    }

    protected zzmq(zzls zzls2) {
        this.zza = zzls2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzja)this.zza).zzt();
        Context context = ((zzja)this.zza).zza();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzmq zzmq2 = this;
        synchronized (zzmq2) {
            if (this.zzb) {
                ((zzja)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            ((zzja)this.zza).zzj().zzp().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzls.zzb(this.zza), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza() {
        ((zzja)this.zza).zzt();
        Context context = ((zzja)this.zza).zza();
        zzmq zzmq2 = this;
        synchronized (zzmq2) {
            if (this.zzb) {
                ((zzja)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzja)this.zza).zzj().zzp().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzgj(context, Looper.getMainLooper(), this, this);
            ((zzja)this.zza).zzj().zzp().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzmq zzmq2 = this;
        synchronized (zzmq2) {
            try {
                Preconditions.checkNotNull((Object)((Object)this.zzc));
                zzgb zzgb2 = (zzgb)this.zzc.getService();
                ((zzja)this.zza).zzl().zzb(new zzmr(this, zzgb2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzgo zzgo2 = this.zza.zzu.zzm();
        if (zzgo2 != null) {
            zzgo2.zzu().zza("Service connection failed", connectionResult);
        }
        zzmq zzmq2 = this;
        synchronized (zzmq2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzja)this.zza).zzl().zzb(new zzmt(this));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzja)this.zza).zzj().zzc().zza("Service connection suspended");
        ((zzja)this.zza).zzl().zzb(new zzmu(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, @Nullable IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzmq zzmq2 = this;
        synchronized (zzmq2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzja)this.zza).zzj().zzg().zza("Service connected with null binder");
                return;
            }
            zzgb zzgb2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzgb2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzgb ? (zzgb)iInterface : new zzgd(iBinder2));
                    ((zzja)this.zza).zzj().zzp().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzja)this.zza).zzj().zzg().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzja)this.zza).zzj().zzg().zza("Service connect failed to get IMeasurementService");
            }
            if (zzgb2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzja)this.zza).zza(), (ServiceConnection)zzls.zzb(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzgb2;
                ((zzja)this.zza).zzl().zzb(new zzmp(this, (zzgb)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzja)this.zza).zzj().zzc().zza("Service disconnected");
        ((zzja)this.zza).zzl().zzb(new zzms(this, componentName));
    }
}

