/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzhl;
import com.google.android.gms.internal.measurement.zzho;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzhi
implements zzhl {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzhi> zza = new ArrayMap();
    private static final String[] zzb = new String[]{"key", "value"};
    private final ContentResolver zzc;
    private final Uri zzd;
    private final Runnable zze;
    private final ContentObserver zzf = new zzhk(this, null);
    private final Object zzg = new Object();
    private volatile Map<String, String> zzh;
    @GuardedBy(value="this")
    private final List<zzhj> zzi = new ArrayList<zzhj>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzhi zza(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Class<zzhi> clazz = zzhi.class;
        synchronized (zzhi.class) {
            zzhi zzhi2 = zza.get(uri);
            if (zzhi2 == null) {
                try {
                    zzhi2 = new zzhi(contentResolver, uri, runnable);
                    zza.put(uri, zzhi2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzhi2;
        }
    }

    @Override
    public final /* synthetic */ Object zza(String string) {
        String string2 = string;
        return this.zza().get(string2);
    }

    public static /* synthetic */ Map zza(zzhi zzhi2) {
        return zzhi2.zzd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zza() {
        Map<String, String> map = this.zzh;
        if (map == null) {
            Object object = this.zzg;
            synchronized (object) {
                map = this.zzh;
                if (map == null) {
                    this.zzh = map = this.zze();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    private final /* synthetic */ Map zzd() {
        ContentProviderClient contentProviderClient = this.zzc.acquireUnstableContentProviderClient(this.zzd);
        if (contentProviderClient == null) {
            Log.w((String)"ConfigurationContentLdr", (String)"Unable to acquire ContentProviderClient, using default values");
            return Collections.emptyMap();
        }
        try {
            Object object;
            Cursor cursor;
            block23: {
                Map map;
                block24: {
                    int n;
                    block21: {
                        Map map2;
                        block22: {
                            block19: {
                                Map map3;
                                block20: {
                                    cursor = contentProviderClient.query(this.zzd, zzb, null, null, null);
                                    if (cursor != null) break block19;
                                    Log.w((String)"ConfigurationContentLdr", (String)"ContentProvider query returned null cursor, using default values");
                                    map3 = Collections.emptyMap();
                                    if (cursor == null) break block20;
                                    cursor.close();
                                }
                                return map3;
                            }
                            n = cursor.getCount();
                            if (n != 0) break block21;
                            map2 = Collections.emptyMap();
                            if (cursor == null) break block22;
                            cursor.close();
                        }
                        return map2;
                    }
                    try {
                        Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
                        while (cursor.moveToNext()) {
                            object.put(cursor.getString(0), cursor.getString(1));
                        }
                        if (cursor.isAfterLast()) break block23;
                        Log.w((String)"ConfigurationContentLdr", (String)"Cursor read incomplete (ContentProvider dead?), using default values");
                        map = Collections.emptyMap();
                        if (cursor == null) break block24;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (cursor != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (RemoteException remoteException) {
                            Log.w((String)"ConfigurationContentLdr", (String)"ContentProvider query failed, using default values", (Throwable)remoteException);
                            Map map4 = Collections.emptyMap();
                            return map4;
                        }
                    }
                    cursor.close();
                }
                return map;
            }
            Object object3 = object;
            if (cursor != null) {
                cursor.close();
            }
            return object3;
        }
        finally {
            contentProviderClient.release();
        }
    }

    private final Map<String, String> zze() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            zzhi zzhi2 = this;
            Map map = (Map)zzho.zza(new zzhh(zzhi2));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.w((String)"ConfigurationContentLdr", (String)"Unable to query ContentProvider, using default values", (Throwable)throwable);
            Map<String, String> map = Collections.emptyMap();
            return map;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private zzhi(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Preconditions.checkNotNull((Object)contentResolver);
        Preconditions.checkNotNull((Object)uri);
        this.zzc = contentResolver;
        this.zzd = uri;
        this.zze = runnable;
        contentResolver.registerContentObserver(uri, false, this.zzf);
    }

    static synchronized void zzb() {
        for (zzhi zzhi2 : zza.values()) {
            zzhi2.zzc.unregisterContentObserver(zzhi2.zzf);
        }
        zza.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc() {
        zzhi zzhi2;
        Object object = this.zzg;
        synchronized (object) {
            this.zzh = null;
            this.zze.run();
        }
        zzhi zzhi3 = zzhi2 = this;
        synchronized (zzhi2) {
            Iterator<zzhj> iterator = zzhi2.zzi.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }
}

