/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzhx;
import com.google.android.gms.internal.measurement.zzoy;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbn;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzls;
import com.google.android.gms.measurement.internal.zzlz;
import com.google.android.gms.measurement.internal.zzme;
import com.google.android.gms.measurement.internal.zznx;
import com.google.android.gms.measurement.internal.zzpn;
import com.google.android.gms.measurement.internal.zzq;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public class zzic
implements zzjh {
    private static volatile @Nullable zzic zzb;
    private final Context zzc;
    private final @Nullable String zzd;
    private final @Nullable String zze;
    private final @Nullable String zzf;
    private final boolean zzg;
    private final zzaf zzh;
    private final zzai zzi;
    private final zzha zzj;
    private final zzgo zzk;
    private final zzhv zzl;
    private final zznx zzm;
    private final zzpn zzn;
    private final zzgl zzo;
    private final Clock zzp;
    private final zzlz zzq;
    private final zzju zzr;
    private final zza zzs;
    private final zzlp zzt;
    private final @Nullable String zzu;
    private zzgj zzv;
    private zzme zzw;
    private zzbf zzx;
    private zzgg zzy;
    private zzls zzz;
    private boolean zzaa = false;
    private Boolean zzab;
    private long zzac;
    private volatile @Nullable Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    @VisibleForTesting
    private Boolean zzaf;
    private volatile boolean zzag;
    private int zzah;
    private int zzai;
    private AtomicInteger zzaj = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    @WorkerThread
    public final int zzc() {
        ((zzjf)this.zzl()).zzv();
        if (this.zzi.zzy()) {
            return 1;
        }
        if (this.zzaf != null && this.zzaf.booleanValue()) {
            return 2;
        }
        if (!this.zzaf()) {
            return 8;
        }
        Boolean bl = this.zzn().zzw();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzai zzai2 = this.zzi;
        Boolean bl2 = zzai2.zze("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzae != null) {
            if (this.zzae.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @Override
    @Pure
    public final Context zza() {
        return this.zzc;
    }

    @Override
    @Pure
    public final Clock zzb() {
        return this.zzp;
    }

    @Pure
    public final zza zze() {
        zzic.zza(this.zzs);
        return this.zzs;
    }

    @Override
    @Pure
    public final zzaf zzd() {
        return this.zzh;
    }

    @Pure
    public final zzai zzf() {
        return this.zzi;
    }

    @Pure
    public final zzbf zzg() {
        zzic.zza(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzgg zzh() {
        zzic.zza(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzgj zzi() {
        zzic.zza(this.zzv);
        return this.zzv;
    }

    @Pure
    public final zzgl zzk() {
        return this.zzo;
    }

    @Override
    @Pure
    public final zzgo zzj() {
        zzic.zza(this.zzk);
        return this.zzk;
    }

    public final @Nullable zzgo zzm() {
        if (this.zzk != null && this.zzk.zzag()) {
            return this.zzk;
        }
        return null;
    }

    @Pure
    public final zzha zzn() {
        zzic.zza((zzjf)this.zzj);
        return this.zzj;
    }

    @Override
    @Pure
    public final zzhv zzl() {
        zzic.zza(this.zzl);
        return this.zzl;
    }

    @SideEffectFree
    final @Nullable zzhv zzo() {
        return this.zzl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzic zza(Context context, @Nullable zzdz zzdz2, @Nullable Long l) {
        if (zzdz2 != null && (zzdz2.zze == null || zzdz2.zzf == null)) {
            zzdz2 = new zzdz(zzdz2.zza, zzdz2.zzb, zzdz2.zzc, zzdz2.zzd, null, null, zzdz2.zzg, null);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzic> clazz = zzic.class;
            synchronized (zzic.class) {
                if (zzb == null) {
                    zzjs zzjs2 = new zzjs(context, zzdz2, l);
                    zzb = new zzic(zzjs2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzdz2 != null && zzdz2.zzg != null && zzdz2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull((Object)zzb);
            zzb.zza(zzdz2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        {
            Preconditions.checkNotNull((Object)zzb);
            return zzb;
        }
    }

    @Pure
    public final zzju zzp() {
        zzic.zza(this.zzr);
        return this.zzr;
    }

    @Pure
    public final zzlp zzq() {
        zzic.zza(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzls zzr() {
        zzic.zza((zzg)this.zzz);
        return this.zzz;
    }

    @Pure
    public final zzlz zzs() {
        zzic.zza(this.zzq);
        return this.zzq;
    }

    @Pure
    public final zzme zzt() {
        zzic.zza(this.zzw);
        return this.zzw;
    }

    @Pure
    public final zznx zzu() {
        zzic.zza(this.zzm);
        return this.zzm;
    }

    @Pure
    public final zzpn zzv() {
        zzic.zza((zzjf)this.zzn);
        return this.zzn;
    }

    @Pure
    public final @Nullable String zzw() {
        return this.zzd;
    }

    @Pure
    public final @Nullable String zzx() {
        return this.zze;
    }

    @Pure
    public final @Nullable String zzy() {
        return this.zzf;
    }

    @Pure
    public final @Nullable String zzz() {
        return this.zzu;
    }

    public static /* synthetic */ void zza(zzic zzic2, String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2;
        byte[] byArray2 = byArray;
        Throwable throwable3 = throwable2 = throwable;
        byte[] byArray3 = byArray2;
        int n2 = n;
        zzic zzic3 = zzic2;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable3 == null)) {
            zzic3.zzj().zzr().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable3);
            return;
        }
        zzic3.zzn().zzo.zza(true);
        if (byArray3 == null || byArray3.length == 0) {
            zzic3.zzj().zzc().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray3);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzic3.zzj().zzc().zza("Deferred Deep Link is empty.");
                return;
            }
            String string4 = jSONObject.optString("gclid", "");
            String string5 = jSONObject.optString("gbraid", "");
            String string6 = jSONObject.optString("gad_source", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            Bundle bundle = new Bundle();
            String string7 = string3;
            zzpn zzpn2 = zzic3.zzv();
            if (!(!TextUtils.isEmpty((CharSequence)string7) && (list = ((zzjf)zzpn2).zza().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string7)), 0)) != null && !list.isEmpty())) {
                zzic3.zzj().zzr().zza("Deferred Deep Link validation failed. gclid, gbraid, deep link", string4, string5, string3);
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)string5)) {
                bundle.putString("gbraid", string5);
            }
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                bundle.putString("gad_source", string6);
            }
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzic3.zzr.zzc("auto", "_cmp", bundle);
            string7 = string3;
            zzpn2 = zzic3.zzv();
            if (!TextUtils.isEmpty((CharSequence)string7) && zzpn2.zza(string7, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzjf)zzpn2).zza().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzic3.zzj().zzg().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzic zzic2, zzjs zzjs2) {
        zzjs zzjs3 = zzjs2;
        zzic zzic3 = zzic2;
        ((zzjf)zzic3.zzl()).zzv();
        Object object = zzic3;
        zzbf zzbf2 = new zzbf((zzic)object);
        zzbf2.zzae();
        zzic3.zzx = zzbf2;
        zzic zzic4 = zzic3;
        object = zzjs3;
        zzgg zzgg2 = new zzgg(zzic4, ((zzjs)object).zzf);
        zzgg2.zzx();
        zzic3.zzy = zzgg2;
        object = zzic3;
        zzgj zzgj2 = new zzgj((zzic)object);
        zzgj2.zzx();
        zzic3.zzv = zzgj2;
        object = zzic3;
        zzme zzme2 = new zzme((zzic)object);
        zzme2.zzx();
        zzic3.zzw = zzme2;
        zzic3.zzn.zzaf();
        zzic3.zzj.zzaf();
        zzic3.zzy.zzy();
        object = zzic3;
        zzls zzls2 = new zzls((zzic)object);
        zzls2.zzx();
        zzic3.zzz = zzls2;
        zzic3.zzz.zzy();
        zzic3.zzj().zzp().zza("App measurement initialized, version", 114010L);
        zzic3.zzj().zzp().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzgg2.zzaf();
        if (TextUtils.isEmpty((CharSequence)zzic3.zzd)) {
            if (zzic3.zzv().zzd(string, zzic3.zzi.zzr())) {
                zzic3.zzj().zzp().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                String string2 = string;
                zzic3.zzj().zzp().zza("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app " + string2);
            }
        }
        zzic3.zzj().zzc().zza("Debug-level message logging enabled");
        if (zzic3.zzah != zzic3.zzaj.get()) {
            zzic3.zzj().zzg().zza("Not all components initialized", zzic3.zzah, zzic3.zzaj.get());
        }
        zzic3.zzaa = true;
    }

    private zzic(zzjs zzjs2) {
        Object object;
        Preconditions.checkNotNull((Object)zzjs2);
        Object object2 = zzjs2.zza;
        zzfu.zza = this.zzh = new zzaf((Context)object2);
        this.zzc = zzjs2.zza;
        this.zzd = zzjs2.zzb;
        this.zze = zzjs2.zzc;
        this.zzf = zzjs2.zzd;
        this.zzg = zzjs2.zzh;
        this.zzad = zzjs2.zze;
        this.zzu = zzjs2.zzj;
        this.zzag = true;
        zzdz zzdz2 = zzjs2.zzg;
        if (zzdz2 != null && zzdz2.zzg != null) {
            object = zzdz2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
            if ((object = zzdz2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzaf = (Boolean)object;
            }
        }
        zzhx.zzb(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzjs2.zzi != null ? zzjs2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzai((zzic)object2);
        object2 = this;
        object = new zzha((zzic)object2);
        ((zzji)object).zzae();
        this.zzj = object;
        object2 = this;
        zzgo zzgo2 = new zzgo((zzic)object2);
        zzgo2.zzae();
        this.zzk = zzgo2;
        object2 = this;
        zzpn zzpn2 = new zzpn((zzic)object2);
        zzpn2.zzae();
        this.zzn = zzpn2;
        zzic zzic2 = this;
        object2 = zzjs2;
        zzjv zzjv2 = new zzjv((zzjs)object2, zzic2);
        this.zzo = new zzgl(zzjv2);
        object2 = this;
        this.zzs = new zza((zzic)object2);
        object2 = this;
        zzlz zzlz2 = new zzlz((zzic)object2);
        zzlz2.zzx();
        this.zzq = zzlz2;
        object2 = this;
        zzju zzju2 = new zzju((zzic)object2);
        zzju2.zzx();
        this.zzr = zzju2;
        object2 = this;
        zznx zznx2 = new zznx((zzic)object2);
        zznx2.zzx();
        this.zzm = zznx2;
        object2 = this;
        zzlp zzlp2 = new zzlp((zzic)object2);
        zzlp2.zzae();
        this.zzt = zzlp2;
        object2 = this;
        zzhv zzhv2 = new zzhv((zzic)object2);
        zzhv2.zzae();
        this.zzl = zzhv2;
        boolean bl = zzjs2.zzg != null && zzjs2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzic)object2).zzc.getApplicationContext() instanceof Application) {
            ((zzic)object2).zzp().zzb(bl2);
        } else {
            ((zzic)object2).zzj().zzr().zza("Application context is not an Application");
        }
        this.zzl.zzb(new zzid(this, zzjs2));
    }

    private static void zza(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zzjf zzjf2) {
        if (zzjf2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zzf zzf2) {
        if (zzf2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzf2.zzaa()) {
            String string = String.valueOf(zzf2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    private static void zza(zzji zzji2) {
        if (zzji2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzji2.zzag()) {
            String string = String.valueOf(zzji2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    final void zzaa() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzab() {
        this.zzaj.incrementAndGet();
    }

    final void zzac() {
        ++this.zzah;
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzad = bl;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzjf)this.zzl()).zzv();
        this.zzag = bl;
    }

    @WorkerThread
    protected final void zza(@Nullable zzdz zzdz2) {
        zzjm zzjm2;
        zzjj zzjj2;
        Object object;
        zzjh zzjh2;
        boolean bl;
        ((zzjf)this.zzl()).zzv();
        boolean bl2 = bl = this.zzi.zza(zzbn.zzcl) && this.zzr().zzac() == zzgf.zzo.zza.zzb;
        if (zzoy.zza() && this.zzi.zza(zzbn.zzcq) && this.zzv().zzx() || bl) {
            zzjh2 = this.zzv();
            ((zzjf)zzjh2).zzv();
            object = new IntentFilter();
            object.addAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
            if (((zzjf)zzjh2).zze().zza(zzbn.zzcl)) {
                object.addAction("com.google.android.gms.measurement.BATCHES_AVAILABLE");
            }
            zzq zzq2 = new zzq(((zzpn)zzjh2).zzu);
            ContextCompat.registerReceiver((Context)((zzjf)zzjh2).zza(), (BroadcastReceiver)zzq2, (IntentFilter)object, (int)2);
            ((zzjf)zzjh2).zzj().zzc().zza("Registered app receiver");
        }
        if (bl) {
            this.zzr().zza((Long)zzbn.zzx.zza(null));
        }
        zzjj zzjj3 = this.zzn().zzp();
        int n = zzjj3.zza();
        zzjj zzjj4 = null;
        zzjm zzjm3 = this.zzi.zzc("google_analytics_default_allow_ad_storage", false);
        zzjm zzjm4 = this.zzi.zzc("google_analytics_default_allow_analytics_storage", false);
        if ((zzjm3 != zzjm.zza || zzjm4 != zzjm.zza) && this.zzn().zza(-10)) {
            zzjj4 = zzjj.zza(zzjm3, zzjm4, -10);
        } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzah()) || n != 0 && n != 30 && n != 10 && n != 30 && n != 30 && n != 40)) {
            this.zzp().zza(new zzjj(null, null, -10), false);
        } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzah()) && zzdz2 != null && zzdz2.zzg != null && this.zzn().zza(30) && (zzjj2 = zzjj.zza(zzdz2.zzg, 30)).zzi()) {
            zzjj4 = zzjj2;
        }
        if (zzjj4 != null) {
            zzjj3 = zzjj4;
            this.zzp().zza(zzjj3, true);
        }
        this.zzp().zza(zzjj3);
        object = zzdz2;
        zzjh2 = this;
        int n2 = ((zzic)zzjh2).zzn().zzo().zza();
        zzjm zzjm5 = ((zzic)zzjh2).zzi.zzc("google_analytics_default_allow_ad_personalization_signals", true);
        if (zzjm5 != zzjm.zza) {
            ((zzic)zzjh2).zzj().zzq().zza("Default ad personalization consent from Manifest", (Object)zzjm5);
        }
        if ((zzjm2 = ((zzic)zzjh2).zzi.zzc("google_analytics_default_allow_ad_user_data", true)) != zzjm.zza && zzjj.zza(-10, n2)) {
            ((zzic)zzjh2).zzp().zza(zzbd.zza(zzjm2, -10), true);
        } else if (!(TextUtils.isEmpty((CharSequence)((zzic)zzjh2).zzh().zzah()) || n2 != 0 && n2 != 30)) {
            ((zzic)zzjh2).zzp().zza(new zzbd(null, -10), true);
        } else {
            Boolean bl3;
            zzbd zzbd2;
            if (TextUtils.isEmpty((CharSequence)((zzic)zzjh2).zzh().zzah()) && object != null && ((zzdz)object).zzg != null && zzjj.zza(30, n2) && (zzbd2 = zzbd.zza(((zzdz)object).zzg, 30)).zzg()) {
                ((zzic)zzjh2).zzp().zza(zzbd2, true);
            }
            if (TextUtils.isEmpty((CharSequence)((zzic)zzjh2).zzh().zzah()) && object != null && ((zzdz)object).zzg != null && ((zzic)zzjh2).zzn().zzh.zza() == null && (bl3 = zzbd.zza(((zzdz)object).zzg)) != null) {
                ((zzic)zzjh2).zzp().zza(((zzdz)object).zze, "allow_personalized_ads", (Object)bl3.toString(), false);
            }
        }
        zzjh2 = this.zzi;
        object = ((zzai)zzjh2).zze("google_analytics_tcf_data_enabled");
        if (object == null ? true : (Boolean)object) {
            this.zzj().zzc().zza("TCF client enabled.");
            this.zzp().zzaw();
            this.zzp().zzau();
        }
        if (this.zzn().zzc.zza() == 0L) {
            this.zzj().zzq().zza("Persisting first open", this.zza);
            this.zzn().zzc.zza(this.zza);
        }
        this.zzp().zza.zzb();
        if (!this.zzah()) {
            if (this.zzae()) {
                if (!this.zzv().zze("android.permission.INTERNET")) {
                    this.zzj().zzg().zza("App is missing INTERNET permission");
                }
                if (!this.zzv().zze("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzj().zzg().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzz()) {
                    if (!zzpn.zza(this.zzc)) {
                        this.zzj().zzg().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzpn.zza(this.zzc, false)) {
                        this.zzj().zzg().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzj().zzg().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzah()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzae())) {
                this.zzv();
                if (zzpn.zza(this.zzh().zzah(), this.zzn().zzz(), this.zzh().zzae(), this.zzn().zzy())) {
                    this.zzj().zzp().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzn().zzaa();
                    this.zzi().zzac();
                    this.zzw.zzah();
                    this.zzw.zzag();
                    this.zzn().zzc.zza(this.zza);
                    this.zzn().zze.zza(null);
                }
                this.zzn().zzc(this.zzh().zzah());
                this.zzn().zzb(this.zzh().zzae());
            }
            if (!this.zzn().zzp().zza(zzjj.zza.zzb)) {
                this.zzn().zze.zza(null);
            }
            this.zzp().zzb(this.zzn().zze.zza());
            if (!this.zzv().zzy() && !TextUtils.isEmpty((CharSequence)this.zzn().zzq.zza())) {
                this.zzj().zzr().zza("Remote config removed with active feature rollouts");
                this.zzn().zzq.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzah()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzae())) {
                n = this.zzae() ? 1 : 0;
                if (!this.zzn().zzac() && !this.zzi.zzy()) {
                    this.zzn().zzb(n == 0);
                }
                if (n != 0) {
                    this.zzp().zzap();
                }
                this.zzu().zza.zza();
                this.zzt().zza(new AtomicReference<String>());
                this.zzt().zza(this.zzn().zzt.zza());
            }
        }
        if (zzoy.zza() && this.zzi.zza(zzbn.zzcq) && this.zzv().zzx()) {
            if ((Integer)zzbn.zzbr.zza(null) > 0) {
                long l = 1000L * (long)((Integer)zzbn.zzbr.zza(null)).intValue() + (long)new Random().nextInt(5000);
                long l2 = Math.max(500L, l - this.zzp.elapsedRealtime());
                if (l2 > 500L) {
                    this.zzj().zzq().zza("Waiting to fetch trigger URIs until some time after boot. Delay in millis", l2);
                }
                this.zzp().zzc(l2);
            } else {
                zzju zzju2 = this.zzp();
                Objects.requireNonNull(zzju2);
                zzju zzju3 = zzju2;
                new Thread(new zzib(zzju3)).start();
            }
        }
        this.zzn().zzj.zza(true);
    }

    @WorkerThread
    public final boolean zzad() {
        return this.zzad != null && this.zzad != false;
    }

    @WorkerThread
    public final boolean zzae() {
        return this.zzc() == 0;
    }

    @WorkerThread
    public final boolean zzaf() {
        ((zzjf)this.zzl()).zzv();
        return this.zzag;
    }

    @Pure
    public final boolean zzag() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    @WorkerThread
    protected final boolean zzah() {
        if (!this.zzaa) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzjf)this.zzl()).zzv();
        if (this.zzab == null || this.zzac == 0L || this.zzab != null && !this.zzab.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzac) > 1000L) {
            this.zzac = this.zzp.elapsedRealtime();
            this.zzab = this.zzv().zze("android.permission.INTERNET") && this.zzv().zze("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzz() || zzpn.zza(this.zzc) && zzpn.zza(this.zzc, false));
            if (this.zzab.booleanValue()) {
                this.zzab = this.zzv().zza(this.zzh().zzah(), this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzae());
            }
        }
        return this.zzab;
    }

    @Pure
    public final boolean zzai() {
        return this.zzg;
    }

    @WorkerThread
    public final boolean zzaj() {
        Object object;
        ((zzjf)this.zzl()).zzv();
        zzic.zza(this.zzq());
        String string = this.zzh().zzaf();
        if (!this.zzi.zzw()) {
            this.zzj().zzq().zza("ADID collection is disabled from Manifest. Skipping");
            return false;
        }
        Pair<String, Boolean> pair = this.zzn().zza(string);
        if (((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzj().zzq().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return false;
        }
        if (!this.zzq().zzc()) {
            this.zzj().zzr().zza("Network is not available for Deferred Deep Link request. Skipping");
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        zzjf zzjf2 = this.zzt();
        zzjf2.zzv();
        ((zzf)zzjf2).zzw();
        if (!((zzme)zzjf2).zzap() ? true : zzjf2.zzs().zzg() >= 234200) {
            object = null;
            zzap zzap2 = this.zzp().zzac();
            if (zzap2 != null) {
                object = zzap2.zza;
            }
            if (object == null) {
                boolean bl = this.zzai++ < 10;
                String string2 = bl ? "Retrying." : "Skipping.";
                this.zzj().zzc().zza("Failed to retrieve DMA consent from the service, " + string2 + " retryCount", this.zzai);
                return bl;
            }
            zzjj zzjj2 = zzjj.zza(object, 100);
            stringBuilder.append("&gcs=").append(zzjj2.zze());
            zzbd zzbd2 = zzbd.zza(object, 100);
            stringBuilder.append("&dma=").append(zzbd2.zzd() == Boolean.FALSE ? 0 : 1);
            if (!TextUtils.isEmpty((CharSequence)zzbd2.zze())) {
                stringBuilder.append("&dma_cps=").append(zzbd2.zze());
            }
            int n = zzbd.zza(object) == Boolean.TRUE ? 0 : 1;
            stringBuilder.append("&npa=").append(n);
            this.zzj().zzq().zza("Consent query parameters to Bow", stringBuilder);
        }
        zzpn zzpn2 = this.zzv();
        this.zzh();
        object = zzpn2.zza(114010L, string, (String)pair.first, this.zzn().zzp.zza() - 1L, stringBuilder.toString());
        if (object != null) {
            zzic zzic2 = this;
            zzie zzie2 = new zzie(zzic2);
            Object object2 = object;
            String string3 = string;
            zzjf2 = this.zzq();
            ((zzji)zzjf2).zzad();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)zzie2);
            zzjf2.zzl().zza(new zzlr((zzlp)zzjf2, string3, (URL)object2, null, null, zzie2));
        }
        return false;
    }
}

