/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjt;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzhc
extends zzjt {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private @MonotonicNonNull String zzc;
    private final zzhe zzd = new zzhe(this, 6, false, false);
    private final zzhe zze = new zzhe(this, 6, true, false);
    private final zzhe zzf = new zzhe(this, 6, false, true);
    private final zzhe zzg = new zzhe(this, 5, false, false);
    private final zzhe zzh = new zzhe(this, 5, true, false);
    private final zzhe zzi = new zzhe(this, 5, false, true);
    private final zzhe zzj = new zzhe(this, 4, false, false);
    private final zzhe zzk = new zzhe(this, 3, false, false);
    private final zzhe zzl = new zzhe(this, 2, false, false);

    static /* bridge */ /* synthetic */ char zza(zzhc zzhc2) {
        return zzhc2.zza;
    }

    static /* bridge */ /* synthetic */ long zzb(zzhc zzhc2) {
        return zzhc2.zzb;
    }

    public final zzhe zzc() {
        return this.zzk;
    }

    public final zzhe zzg() {
        return this.zzd;
    }

    public final zzhe zzm() {
        return this.zzf;
    }

    public final zzhe zzo() {
        return this.zze;
    }

    public final zzhe zzp() {
        return this.zzj;
    }

    public final zzhe zzq() {
        return this.zzl;
    }

    public final zzhe zzr() {
        return this.zzg;
    }

    public final zzhe zzw() {
        return this.zzi;
    }

    public final zzhe zzx() {
        return this.zzh;
    }

    protected static @Nullable Object zza(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return new zzhd(string);
    }

    static String zza(boolean bl, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzhc.zza(bl, object);
        String string3 = zzhc.zza(bl, object2);
        String string4 = zzhc.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, @Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            String string3 = string;
            long l2 = Math.round(Math.pow(10.0, string2.length() - 1));
            String string4 = string;
            return string4 + l2 + "..." + string3 + l;
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzhc.zzb(zzim.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string5;
                if (stackTraceElement.isNativeMethod() || (string5 = stackTraceElement.getClassName()) == null || !zzhc.zzb(string5).equals(string)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzhd) {
            return zzhd.zza((zzhd)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    @VisibleForTesting
    private static String zzb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public final @Nullable String zzy() {
        if (((zzjq)this).zzk().zzb == null) {
            return null;
        }
        Pair<String, Long> pair = ((zzjq)this).zzk().zzb.zza();
        if (pair == null || pair == zzho.zza) {
            return null;
        }
        String string = (String)pair.first;
        String string2 = String.valueOf(pair.second);
        return string2 + ":" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    private final String zzz() {
        zzhc zzhc2 = this;
        synchronized (zzhc2) {
            if (this.zzc == null) {
                String string;
                zzhc zzhc3;
                if (this.zzu.zzy() != null) {
                    zzhc3 = this;
                    string = this.zzu.zzy();
                } else {
                    zzhc3 = this;
                    string = "FA";
                }
                zzhc3.zzc = string;
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
        }
    }

    static /* bridge */ /* synthetic */ void zza(zzhc zzhc2, long l) {
        zzhc2.zzb = l;
    }

    static /* bridge */ /* synthetic */ void zza(zzhc zzhc2, char c) {
        zzhc2.zza = c;
    }

    zzhc(zzim zzim2) {
        super(zzim2);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (!bl && this.zza(n)) {
            String string2 = zzhc.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzhc zzhc2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzij zzij2 = zzhc2.zzu.zzo();
            if (zzij2 == null) {
                zzhc2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzij2.zzah()) {
                zzhc2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzij2.zzb(new zzhb(zzhc2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzz(), (String)string);
    }

    protected final boolean zza(int n) {
        return Log.isLoggable((String)this.zzz(), (int)n);
    }

    @Override
    protected final boolean zzh() {
        return false;
    }
}

