/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzmj;
import com.google.android.gms.measurement.internal.zzml;
import com.google.android.gms.measurement.internal.zzmm;
import com.google.android.gms.measurement.internal.zzmn;
import com.google.android.gms.measurement.internal.zzmo;
import com.google.android.gms.measurement.internal.zzmq;
import com.google.android.gms.measurement.internal.zzqd;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzmk
extends zzh {
    private volatile @Nullable zzmh zzb;
    private volatile @Nullable zzmh zzc;
    @VisibleForTesting
    protected @Nullable zzmh zza;
    private final Map<Integer, zzmh> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable zzeb zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzmh zzg;
    private @Nullable zzmh zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzmh zza(zzmk zzmk2) {
        return zzmk2.zzh;
    }

    @MainThread
    private final zzmh zzd(@NonNull zzeb zzeb2) {
        Preconditions.checkNotNull((Object)zzeb2);
        zzmh zzmh2 = this.zzd.get(zzeb2.zza);
        if (zzmh2 == null) {
            String string = this.zza(zzeb2.zzb, "Activity");
            zzmh2 = new zzmh(null, string, ((zzjq)this).zzs().zzo());
            this.zzd.put(zzeb2.zza, zzmh2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzmh2;
    }

    public final @Nullable zzmh zzac() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzmh zza(boolean bl) {
        this.zzw();
        ((zzjq)this).zzv();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(@Nullable String string, String string2) {
        if (string == null) {
            return string2;
        }
        String string3 = string;
        zzmk zzmk2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zzjq)zzmk2).zze().zza(null, false)) {
            return string4.substring(0, ((zzjq)zzmk2).zze().zza(null, false));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzmk zzmk2, zzmh zzmh2) {
        zzmk2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzmk zzmk2, zzmh zzmh2, zzmh zzmh3, long l, boolean bl, Bundle bundle) {
        zzmk2.zza(zzmh2, zzmh3, l, bl, null);
    }

    static /* synthetic */ void zza(zzmk zzmk2, Bundle bundle, zzmh zzmh2, zzmh zzmh3, long l) {
        long l2 = l;
        zzmh zzmh4 = zzmh3;
        zzmh zzmh5 = zzmh2;
        Bundle bundle2 = bundle;
        zzmk zzmk3 = zzmk2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zzjq)zzmk3).zzs().zza(null, "screen_view", bundle2, null, false);
        zzmk3.zza(zzmh5, zzmh4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzmk zzmk2, zzmh zzmh2, boolean bl, long l) {
        zzmk2.zza(zzmh2, false, l);
    }

    public zzmk(zzim zzim2) {
        super(zzim2);
        this.zzd = new ConcurrentHashMap<Integer, zzmh>();
    }

    @MainThread
    private final void zza(@Nullable String string, zzmh zzmh2, boolean bl) {
        zzmh zzmh3;
        zzmh zzmh4;
        zzmh zzmh5 = zzmh4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzmh2.zzb == null) {
            zzmh3 = string != null ? this.zza(string, "Activity") : null;
            zzmh2 = new zzmh(zzmh2.zza, (String)((Object)zzmh3), zzmh2.zzc, zzmh2.zze, zzmh2.zzf);
        }
        zzmh3 = zzmh2;
        this.zzc = this.zzb;
        this.zzb = zzmh3;
        long l = ((zzjq)this).zzb().elapsedRealtime();
        ((zzjq)this).zzl().zzb(new zzmm(this, zzmh3, zzmh4, l, bl));
    }

    @WorkerThread
    private final void zza(zzmh zzmh2, @Nullable zzmh zzmh3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zzjq)this).zzv();
        boolean bl3 = zzmh3 == null || zzmh3.zzc != zzmh2.zzc || !Objects.equals(zzmh3.zzb, zzmh2.zzb) || !Objects.equals(zzmh3.zza, zzmh2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zzqd.zza(zzmh2, bundle2, true);
            if (zzmh3 != null) {
                if (zzmh3.zza != null) {
                    bundle2.putString("_pn", zzmh3.zza);
                }
                if (zzmh3.zzb != null) {
                    bundle2.putString("_pc", zzmh3.zzb);
                }
                bundle2.putLong("_pi", zzmh3.zzc);
            }
            if (bl2 && (l3 = ((zze)this).zzr().zzb.zza(l2 = l)) > 0L) {
                ((zzjq)this).zzs().zza(bundle2, l3);
            }
            if (!((zzjq)this).zze().zzx()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzmh2.zze ? "app" : "auto";
            long l4 = ((zzjq)this).zzb().currentTimeMillis();
            if (zzmh2.zze && zzmh2.zzf != 0L) {
                l4 = zzmh2.zzf;
            }
            ((zze)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzmh2;
        if (zzmh2.zze) {
            this.zzh = zzmh2;
        }
        ((zze)this).zzq().zza(zzmh2);
    }

    @MainThread
    public final void zza(zzeb zzeb2, @Nullable Bundle bundle) {
        if (!((zzjq)this).zze().zzx()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzmh zzmh2 = new zzmh(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(zzeb2.zza, zzmh2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(zzeb zzeb2) {
        Object object = this.zzj;
        synchronized (object) {
            if (Objects.equals(this.zze, zzeb2)) {
                this.zze = null;
            }
        }
        if (!((zzjq)this).zze().zzx()) {
            return;
        }
        this.zzd.remove(zzeb2.zza);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(zzeb zzeb2) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zzjq)this).zzb().elapsedRealtime();
        if (!((zzjq)this).zze().zzx()) {
            this.zzb = null;
            ((zzjq)this).zzl().zzb(new zzmo(this, l));
            return;
        }
        zzmh zzmh2 = this.zzd(zzeb2);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzjq)this).zzl().zzb(new zzmn(this, zzmh2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(zzeb zzeb2) {
        zze zze2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (!Objects.equals(zzeb2, this.zze)) {
                zzeb zzeb3 = zzeb2;
                zze2 = this;
                Object object2 = ((zzmk)zze2).zzj;
                synchronized (object2) {
                    ((zzmk)zze2).zze = zzeb3;
                    ((zzmk)zze2).zzf = false;
                }
                if (zze2.zze().zzx()) {
                    ((zzmk)zze2).zzg = null;
                    zze2.zzl().zzb(new zzmq((zzmk)zze2));
                }
            }
        }
        if (!((zzjq)this).zze().zzx()) {
            this.zzb = this.zzg;
            ((zzjq)this).zzl().zzb(new zzml(this));
            return;
        }
        object = this.zzd(zzeb2);
        this.zza(zzeb2.zzb, (zzmh)object, false);
        zze2 = ((zze)this).zzc();
        long l = zze2.zzb().elapsedRealtime();
        zze2.zzl().zzb(new zzc((zzb)zze2, l));
    }

    @MainThread
    public final void zzb(zzeb zzeb2, Bundle bundle) {
        if (!((zzjq)this).zze().zzx()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzmh zzmh2 = this.zzd.get(zzeb2.zza);
        if (zzmh2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzmh2.zzc);
        bundle2.putString("name", zzmh2.zza);
        bundle2.putString("referrer_name", zzmh2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzmh zzmh2, boolean bl, long l) {
        boolean bl2;
        ((zze)this).zzc().zza(((zzjq)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzmh2 != null && zzmh2.zzd;
        if (((zze)this).zzr().zza(bl2, bl, l) && zzmh2 != null) {
            zzmh2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull zzeb zzeb2, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzjq)this).zze().zzx()) {
            ((zzjq)this).zzj().zzw().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzmh zzmh2 = this.zzb;
        if (zzmh2 == null) {
            ((zzjq)this).zzj().zzw().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(zzeb2.zza) == null) {
            ((zzjq)this).zzj().zzw().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(zzeb2.zzb, "Activity");
        }
        boolean bl = Objects.equals(zzmh2.zzb, string2);
        boolean bl2 = Objects.equals(zzmh2.zza, string);
        if (bl && bl2) {
            ((zzjq)this).zzj().zzw().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zzjq)this).zze().zza(null, false))) {
            ((zzjq)this).zzj().zzw().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzjq)this).zze().zza(null, false))) {
            ((zzjq)this).zzj().zzw().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzjq)this).zzj().zzq().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzmh zzmh3 = new zzmh(string, string2, ((zzjq)this).zzs().zzo());
        this.zzd.put(zzeb2.zza, zzmh3);
        this.zza(zzeb2.zzb, zzmh3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzmh zzmh2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzjq)this).zzj().zzw().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zzjq)this).zze().zza(null, false))) {
                    ((zzjq)this).zzj().zzw().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzjq)this).zze().zza(null, false))) {
                    ((zzjq)this).zzj().zzw().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.zzb, "Activity") : "Activity";
            }
            zzmh2 = this.zzb;
            if (this.zzf && zzmh2 != null) {
                this.zzf = false;
                boolean bl = Objects.equals(zzmh2.zzb, string2);
                boolean bl2 = Objects.equals(zzmh2.zza, string);
                if (bl && bl2) {
                    ((zzjq)this).zzj().zzw().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzjq)this).zzj().zzq().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzmh2 = new zzmh(string, string2, ((zzjq)this).zzs().zzo(), true, l);
        this.zzc = object;
        this.zzg = zzmh2;
        long l2 = ((zzjq)this).zzb().elapsedRealtime();
        ((zzjq)this).zzl().zzb(new zzmj(this, bundle, zzmh2, (zzmh)object, l2));
    }

    @Override
    protected final boolean zzab() {
        return false;
    }
}

