/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.database.ContentObserver;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.core.content.PermissionChecker;
import com.google.android.gms.internal.measurement.zzjb;
import com.google.android.gms.internal.measurement.zzjc;
import com.google.android.gms.internal.measurement.zzji;
import com.google.android.gms.internal.measurement.zzjp;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.common.base.Preconditions;

final class zzju
implements zzjr {
    @GuardedBy(value="GservicesLoader.class")
    private static zzju zza;
    private final Context zzb;
    private final ContentObserver zzc;
    @GuardedBy(value="GservicesLoader.class")
    private boolean zzd = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static zzju zza(Context object) {
        Class<zzju> clazz = zzju.class;
        synchronized (clazz) {
            zzju zzju2 = zza;
            if (zzju2 == null) {
                int n = PermissionChecker.checkSelfPermission((Context)object, (String)"com.google.android.providers.gsf.permission.READ_GSERVICES");
                zzju2 = n == 0 ? new zzju((Context)object) : new zzju();
                zza = zzju2;
            }
            if ((zzju2 = zza) == null) return (zzju)Preconditions.checkNotNull((Object)zza);
            ContentObserver contentObserver = zzju2.zzc;
            if (contentObserver == null) return (zzju)Preconditions.checkNotNull((Object)zza);
            boolean bl = zzju2.zzd;
            if (bl) return (zzju)Preconditions.checkNotNull((Object)zza);
            try {
                object.getContentResolver().registerContentObserver(zzjc.zza, true, zzju.zza.zzc);
                ((zzju)Preconditions.checkNotNull((Object)zzju.zza)).zzd = true;
                return (zzju)Preconditions.checkNotNull((Object)zza);
            }
            catch (SecurityException securityException) {
                Log.e((String)"GservicesLoader", (String)"Unable to register Gservices content observer", (Throwable)securityException);
            }
            return (zzju)Preconditions.checkNotNull((Object)zza);
        }
    }

    public static /* synthetic */ String zzc(zzju zzju2, String string) {
        return zzjb.zza(((Context)Preconditions.checkNotNull((Object)zzju2.zzb)).getContentResolver(), string, null);
    }

    public final String zzd(String string) {
        Context context = ((zzju)((Object)string2)).zzb;
        if (context == null || zzji.zza(context)) {
            return null;
        }
        try {
            String string2 = (String)zzjp.zza(new zzjs((zzju)((Object)string2), string));
            return string2;
        }
        catch (IllegalStateException | NullPointerException | SecurityException runtimeException) {
            string = "Unable to read GServices for: ".concat(string);
            Log.e((String)"GservicesLoader", (String)string, (Throwable)runtimeException);
            return null;
        }
    }

    private zzju() {
        this.zzb = null;
        this.zzc = null;
    }

    private zzju(Context context) {
        this.zzb = context;
        this.zzc = new zzjt(this, null);
    }

    static synchronized void zze() {
        Context context;
        zzju zzju2 = zza;
        if (zzju2 != null && (context = zzju2.zzb) != null && zzju2.zzc != null && zzju2.zzd) {
            context.getContentResolver().unregisterContentObserver(zzju.zza.zzc);
        }
        zza = null;
    }
}

