/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzqf;
import java.util.Iterator;
import java.util.Map;

public final class zzd
extends zzf {
    private final Map zza;
    private final Map zzb = new ArrayMap();
    private long zzc;

    static /* synthetic */ void zza(zzd zzd2, String string, long l) {
        Integer n;
        ((zzjq)zzd2).zzg();
        Preconditions.checkNotEmpty((String)string);
        Map map = zzd2.zzb;
        if (map.isEmpty()) {
            zzd2.zzc = l;
        }
        if ((n = (Integer)map.get(string)) != null) {
            map.put(string, n + 1);
            return;
        }
        if (map.size() >= 100) {
            zzd2.zzu.zzaW().zzk().zza("Too many ads visible");
            return;
        }
        map.put(string, 1);
        zzd2.zza.put(string, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* synthetic */ void zzb(zzd zzd2, String string, long l) {
        ((zzjq)zzd2).zzg();
        Preconditions.checkNotEmpty((String)string);
        Map map = zzd2.zzb;
        Integer n = (Integer)map.get(string);
        if (n == null) {
            zzd2.zzu.zzaW().zze().zzb("Call to endAdUnitExposure for unknown ad unit id", string);
            return;
        }
        zzmh zzmh2 = zzd2.zzu.zzt().zzj(false);
        int n2 = n + -1;
        if (n2 != 0) {
            map.put(string, n2);
            return;
        }
        map.remove(string);
        Map map2 = zzd2.zza;
        Long l2 = (Long)map2.get(string);
        if (l2 == null) {
            zzd2.zzu.zzaW().zze().zza("First ad unit exposure time was never set");
        } else {
            long l3 = l - l2;
            map2.remove(string);
            zzd2.zzi(string, l3, zzmh2);
        }
        if (!map.isEmpty()) {
            return;
        }
        long l4 = zzd2.zzc;
        if (l4 == 0L) {
            zzd2.zzu.zzaW().zze().zza("First ad exposure time was never set");
            return;
        }
        zzd2.zzh(l - l4, zzmh2);
        zzd2.zzc = 0L;
    }

    static /* bridge */ /* synthetic */ void zzc(zzd zzd2, long l) {
        zzd2.zzj(l);
    }

    public zzd(zzio zzio2) {
        super(zzio2);
        this.zza = new ArrayMap();
    }

    public final void zzd(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzu.zzaW().zze().zza("Ad unit id must be a non-empty string");
            return;
        }
        this.zzu.zzaX().zzq(new zza(this, string, l));
    }

    public final void zze(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzu.zzaW().zze().zza("Ad unit id must be a non-empty string");
            return;
        }
        this.zzu.zzaX().zzq(new zzb(this, string, l));
    }

    @WorkerThread
    private final void zzh(long l, zzmh zzmh2) {
        if (zzmh2 == null) {
            this.zzu.zzaW().zzj().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzu.zzaW().zzj().zzb("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzqf.zzN(zzmh2, bundle, true);
        this.zzu.zzq().zzR("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zzi(String string, long l, zzmh zzmh2) {
        if (zzmh2 == null) {
            this.zzu.zzaW().zzj().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzu.zzaW().zzj().zzb("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzqf.zzN(zzmh2, bundle, true);
        this.zzu.zzq().zzR("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzf(long l) {
        zzmh zzmh2 = this.zzu.zzt().zzj(false);
        Map map = this.zza;
        for (String string : map.keySet()) {
            this.zzi(string, l - (Long)map.get(string), zzmh2);
        }
        if (!map.isEmpty()) {
            this.zzh(l - this.zzc, zzmh2);
        }
        this.zzj(l);
    }

    @WorkerThread
    private final void zzj(long l) {
        Map map = this.zza;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            map.put((String)iterator.next(), l);
        }
        if (!map.isEmpty()) {
            this.zzc = l;
            return;
        }
    }
}

