/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzoq;
import com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzht
extends zzjr {
    static final Pair zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzv;
    private final Object zzw = new Object();
    private SharedPreferences zzx;
    public zzhq zzb;
    public final zzhp zzc;
    public final zzhp zzd;
    public final zzhr zze;
    private String zzy;
    private boolean zzz;
    private long zzA;
    public final zzhp zzf;
    public final zzhn zzg;
    public final zzhr zzh;
    public final zzho zzi;
    public final zzhn zzj;
    public final zzhp zzk;
    public final zzhp zzl;
    public boolean zzm;
    public final zzhn zzn;
    public final zzhn zzo;
    public final zzhp zzp;
    public final zzhr zzq;
    public final zzhr zzr;
    public final zzhp zzs;
    public final zzho zzt;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzv();
        if (this.zzx != null) return this.zzx;
        Object object = this.zzw;
        synchronized (object) {
            Object object2 = this.zzx;
            if (object2 != null) return this.zzx;
            object2 = this.zzu;
            Object object3 = ((zzio)object2).zzaT();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object3.getPackageName());
            stringBuilder.append("_preferences");
            object3 = stringBuilder.toString();
            zzhe zzhe2 = ((zzio)object2).zzaW();
            zzhe2.zzj().zzb("Default prefs file", object3);
            object2 = ((zzio)object2).zzaT();
            this.zzx = object2.getSharedPreferences((String)object3, 0);
            return this.zzx;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzb() {
        this.zzg();
        this.zzv();
        Preconditions.checkNotNull((Object)this.zzv);
        return this.zzv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzd(String string) {
        ((zzjq)((Object)bl)).zzg();
        if (!((zzht)((Object)bl)).zzh().zzr(zzjw.zza)) {
            Boolean bl = false;
            return new Pair((Object)"", (Object)bl);
        }
        Object object = ((zzjq)((Object)bl)).zzu;
        long l = ((zzio)object).zzaU().elapsedRealtime();
        String string2 = ((zzht)((Object)bl)).zzy;
        if (string2 != null && l < ((zzht)((Object)bl)).zzA) {
            return new Pair((Object)string2, (Object)((zzht)((Object)bl)).zzz);
        }
        ((zzht)((Object)bl)).zzA = l + ((zzio)object).zzf().zzk(string, zzgi.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = ((zzio)object).zzaT();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            ((zzht)((Object)bl)).zzy = "";
            object = string.getId();
            if (object != null) {
                ((zzht)((Object)bl)).zzy = object;
            }
            ((zzht)((Object)bl)).zzz = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            ((zzjq)((Object)bl)).zzu.zzaW().zzd().zzb("Unable to get advertising id", exception);
            ((zzht)((Object)bl)).zzy = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)((zzht)((Object)bl)).zzy, (Object)((zzht)((Object)bl)).zzz);
    }

    final SparseArray zze() {
        Bundle bundle = this.zzi.zza();
        int[] nArray = bundle.getIntArray("uriSources");
        long[] lArray = bundle.getLongArray("uriTimestamps");
        if (nArray == null || lArray == null) {
            return new SparseArray();
        }
        int n = lArray.length;
        if (nArray.length != n) {
            this.zzu.zzaW().zze().zza("Trigger URI source and timestamp array lengths do not match");
            return new SparseArray();
        }
        SparseArray sparseArray = new SparseArray();
        for (int i = 0; i < nArray.length; ++i) {
            sparseArray.put(nArray[i], (Object)lArray[i]);
        }
        return sparseArray;
    }

    @WorkerThread
    final zzba zzf() {
        this.zzg();
        return zzba.zze(this.zzb().getString("dma_consent_settings", null));
    }

    @WorkerThread
    final zzjx zzh() {
        this.zzg();
        return zzjx.zzk(this.zzb().getString("consent_settings", "G1"), this.zzb().getInt("consent_source", 100));
    }

    @WorkerThread
    final Boolean zzi() {
        this.zzg();
        if (this.zzb().contains("measurement_enabled")) {
            return this.zzb().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    final String zzj() {
        this.zzg();
        return this.zzb().getString("gmp_app_id", null);
    }

    zzht(zzio object) {
        super((zzio)object);
        object = "session_timeout";
        this.zzf = new zzhp(this, (String)object, 1800000L);
        object = "start_new_session";
        this.zzg = new zzhn(this, (String)object, true);
        object = "last_pause_time";
        this.zzk = new zzhp(this, (String)object, 0L);
        object = "session_id";
        this.zzl = new zzhp(this, (String)object, 0L);
        object = "non_personalized_ads";
        this.zzh = new zzhr(this, (String)object, null);
        object = "last_received_uri_timestamps_by_source";
        this.zzi = new zzho(this, (String)object, null);
        object = "allow_remote_dynamite";
        this.zzj = new zzhn(this, (String)object, false);
        object = "first_open_time";
        this.zzc = new zzhp(this, (String)object, 0L);
        object = "app_install_time";
        this.zzd = new zzhp(this, (String)object, 0L);
        object = "app_instance_id";
        this.zze = new zzhr(this, (String)object, null);
        object = "app_backgrounded";
        this.zzn = new zzhn(this, (String)object, false);
        object = "deep_link_retrieval_complete";
        this.zzo = new zzhn(this, (String)object, false);
        object = "deep_link_retrieval_attempts";
        this.zzp = new zzhp(this, (String)object, 0L);
        object = "firebase_feature_rollouts";
        this.zzq = new zzhr(this, (String)object, null);
        object = "deferred_attribution_cache";
        this.zzr = new zzhr(this, (String)object, null);
        object = "deferred_attribution_cache_timestamp";
        this.zzs = new zzhp(this, (String)object, 0L);
        object = "default_event_parameters";
        this.zzt = new zzho(this, (String)object, null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaZ() {
        zzio zzio2 = this.zzu;
        this.zzv = zzio2.zzaT().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzm = this.zzv.getBoolean("has_been_opened", false);
        if (!this.zzm) {
            SharedPreferences.Editor editor = this.zzv.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        zzio2.zzf();
        long l = Math.max(0L, (Long)zzgi.zzc.zza(null));
        this.zzb = new zzhq(this, "health_monitor", l, null);
    }

    @WorkerThread
    final void zzl(String string) {
        this.zzg();
        SharedPreferences.Editor editor = this.zzb().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzm(Boolean bl) {
        zzht2.zzg();
        zzht zzht2 = zzht2.zzb().edit();
        if (bl != null) {
            zzht2.putBoolean("measurement_enabled", bl);
        } else {
            zzht2.remove("measurement_enabled");
        }
        zzht2.apply();
    }

    @WorkerThread
    final void zzn(boolean bl) {
        this.zzg();
        this.zzu.zzaW().zzj().zzb("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zzb().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzo() {
        zzht zzht2 = zzht2.zzv;
        if (zzht2 == null) {
            return false;
        }
        return zzht2.contains("deferred_analytics_collection");
    }

    final boolean zzp(long l) {
        return l - this.zzf.zza() > this.zzk.zza();
    }

    @Override
    protected final boolean zzc() {
        return true;
    }

    @WorkerThread
    final boolean zzq(int n) {
        return zzjx.zzs(n, this.zzb().getInt("consent_source", 100));
    }

    @WorkerThread
    protected final boolean zzr(zzoq object) {
        this.zzg();
        String string = this.zzb().getString("stored_tcf_param", "");
        object = ((zzoq)object).zze();
        if (!((String)object).equals(string)) {
            SharedPreferences.Editor editor = this.zzb().edit();
            editor.putString("stored_tcf_param", (String)object);
            editor.apply();
            return true;
        }
        return false;
    }
}

