/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjr;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzil
extends zzjr {
    private static final AtomicLong zza = new AtomicLong(Long.MIN_VALUE);
    @Nullable
    private zzik zzb;
    @Nullable
    private zzik zzc;
    private final PriorityBlockingQueue zzd;
    private final BlockingQueue zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Thread.UncaughtExceptionHandler zzg;
    private final Object zzh = new Object();
    private final Semaphore zzi = new Semaphore(2);
    private volatile boolean zzj;

    static /* bridge */ /* synthetic */ zzik zza(zzil zzil2) {
        return zzil2.zzc;
    }

    static /* bridge */ /* synthetic */ zzik zzb(zzil zzil2) {
        return zzil2.zzb;
    }

    static /* bridge */ /* synthetic */ Object zzd(zzil zzil2) {
        return zzil2.zzh;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    final Object zze(AtomicReference atomicReference, long l, String string, Runnable runnable) {
        synchronized (atomicReference) {
            zzil zzil2 = zzjr2.zzu.zzaX();
            zzil2.zzq(runnable);
            try {
                atomicReference.wait(l);
                // MONITOREXIT @DISABLED, blocks:[1, 4] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1 /* !! */ 
                atomicReference = atomicReference.get();
                if (atomicReference == null) {
                    zzjr2.zzu.zzaW().zzk().zza("Timed out waiting for ".concat(string));
                }
                return atomicReference;
            }
            catch (InterruptedException interruptedException) {
                zzjr zzjr2 = zzjr2.zzu.zzaW();
                zzhc zzhc2 = ((zzhe)zzjr2).zzk();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Interrupted waiting for ");
                stringBuilder.append(string);
                zzhc2.zza(stringBuilder.toString());
                return null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Future zzf(Callable callable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)callable);
        String string = "Task exception on worker thread";
        zzij zzij2 = new zzij(this, callable, false, string);
        if (Thread.currentThread() == this.zzb) {
            if (!this.zzd.isEmpty()) {
                this.zzu.zzaW().zzk().zza("Callable skipped the worker queue.");
            }
            zzij2.run();
            return zzij2;
        }
        this.zzz(zzij2);
        return zzij2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Future zzh(Callable callable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)callable);
        String string = "Task exception on worker thread";
        zzij zzij2 = new zzij(this, callable, true, string);
        if (Thread.currentThread() == this.zzb) {
            zzij2.run();
            return zzij2;
        }
        this.zzz(zzij2);
        return zzij2;
    }

    static /* bridge */ /* synthetic */ Semaphore zzi(zzil zzil2) {
        return zzil2.zzi;
    }

    static /* bridge */ /* synthetic */ AtomicLong zzj() {
        return zza;
    }

    static /* bridge */ /* synthetic */ void zzl(zzil zzil2, zzik zzik2) {
        zzil2.zzc = null;
    }

    static /* bridge */ /* synthetic */ void zzm(zzil zzil2, zzik zzik2) {
        zzil2.zzb = null;
    }

    zzil(zzio object) {
        super((zzio)object);
        this.zzd = new PriorityBlockingQueue();
        this.zze = new LinkedBlockingQueue();
        object = "Thread death: Uncaught exception on worker thread";
        this.zzf = new zzii(this, (String)object);
        object = "Thread death: Uncaught exception on network thread";
        this.zzg = new zzii(this, (String)object);
    }

    public final void zzn() {
        if (Thread.currentThread() == this.zzb) {
            throw new IllegalStateException("Call not expected from worker thread");
        }
    }

    @Override
    public final void zzaY() {
        if (Thread.currentThread() != this.zzc) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    @Override
    public final void zzg() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzz(zzij runnable) {
        Object object = this.zzh;
        synchronized (object) {
            PriorityBlockingQueue priorityBlockingQueue = this.zzd;
            priorityBlockingQueue.add(runnable);
            runnable = this.zzb;
            if (runnable == null) {
                String string = "Measurement Worker";
                runnable = new zzik(this, string, priorityBlockingQueue);
                this.zzb = runnable;
                this.zzb.setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                ((zzik)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzp(Runnable object) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)object);
        Object object2 = "Task exception on network thread";
        Runnable runnable = new zzij(this, (Runnable)object, false, (String)object2);
        object = this.zzh;
        synchronized (object) {
            object2 = this.zze;
            object2.add(runnable);
            runnable = this.zzc;
            if (runnable == null) {
                String string = "Measurement Network";
                runnable = new zzik(this, string, (BlockingQueue)object2);
                this.zzc = runnable;
                this.zzc.setUncaughtExceptionHandler(this.zzg);
                this.zzc.start();
            } else {
                ((zzik)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzq(Runnable runnable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)runnable);
        String string = "Task exception on worker thread";
        zzil zzil2 = this;
        zzil2.zzz(new zzij(zzil2, runnable, false, string));
    }

    public final void zzr(Runnable runnable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)runnable);
        String string = "Task exception on worker thread";
        zzil zzil2 = this;
        zzil2.zzz(new zzij(zzil2, runnable, true, string));
    }

    static /* bridge */ /* synthetic */ boolean zzs(zzil zzil2) {
        boolean cfr_ignored_0 = zzil2.zzj;
        return false;
    }

    public final boolean zzt() {
        return Thread.currentThread() == this.zzc;
    }

    public final boolean zzu() {
        return Thread.currentThread() == this.zzb;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }
}

