/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.database.ContentObserver;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.core.content.PermissionChecker;
import com.google.android.gms.internal.measurement.zzjf;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzjm;
import com.google.android.gms.internal.measurement.zzju;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzjw;
import com.google.common.base.Preconditions;

final class zzjx
implements zzju {
    @GuardedBy(value="GservicesLoader.class")
    private static zzjx zza;
    private final Context zzb;
    private final ContentObserver zzc;
    @GuardedBy(value="GservicesLoader.class")
    private boolean zzd = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static zzjx zza(Context object) {
        Class<zzjx> clazz = zzjx.class;
        synchronized (clazz) {
            zzjx zzjx2 = zza;
            if (zzjx2 == null) {
                int n = PermissionChecker.checkSelfPermission((Context)object, (String)"com.google.android.providers.gsf.permission.READ_GSERVICES");
                zzjx2 = n == 0 ? new zzjx((Context)object) : new zzjx();
                zza = zzjx2;
            }
            if ((zzjx2 = zza) == null) return (zzjx)Preconditions.checkNotNull((Object)zza);
            ContentObserver contentObserver = zzjx2.zzc;
            if (contentObserver == null) return (zzjx)Preconditions.checkNotNull((Object)zza);
            boolean bl = zzjx2.zzd;
            if (bl) return (zzjx)Preconditions.checkNotNull((Object)zza);
            try {
                object.getContentResolver().registerContentObserver(zzjg.zza, true, zzjx.zza.zzc);
                ((zzjx)Preconditions.checkNotNull((Object)zzjx.zza)).zzd = true;
                return (zzjx)Preconditions.checkNotNull((Object)zza);
            }
            catch (SecurityException securityException) {
                Log.e((String)"GservicesLoader", (String)"Unable to register Gservices content observer", (Throwable)securityException);
            }
            return (zzjx)Preconditions.checkNotNull((Object)zza);
        }
    }

    private zzjx(Context context) {
        this.zzb = context;
        this.zzc = new zzjv(this, null);
    }

    private zzjx() {
        this.zzb = null;
        this.zzc = null;
    }

    public final String zzb(String string) {
        Context context = ((zzjx)((Object)string2)).zzb;
        if (context == null || zzjm.zzb(context)) {
            return null;
        }
        try {
            String string2 = (String)zzju.zzg(new zzjw((zzjx)((Object)string2), string));
            return string2;
        }
        catch (IllegalStateException | NullPointerException | SecurityException runtimeException) {
            string = "Unable to read GServices for: ".concat(string);
            Log.e((String)"GservicesLoader", (String)string, (Throwable)runtimeException);
            return null;
        }
    }

    static synchronized void zzc() {
        Context context;
        zzjx zzjx2 = zza;
        if (zzjx2 != null && (context = zzjx2.zzb) != null && zzjx2.zzc != null && zzjx2.zzd) {
            context.getContentResolver().unregisterContentObserver(zzjx.zza.zzc);
        }
        zza = null;
    }

    final /* synthetic */ String zzd(String string) {
        return zzjf.zza(((Context)Preconditions.checkNotNull((Object)this.zzb)).getContentResolver(), string, null);
    }
}

