/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzoc;
import com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzhg
extends zzje {
    static final Pair zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzv;
    private SharedPreferences zzw;
    public zzhe zzb;
    public final zzhd zzc;
    public final zzhd zzd;
    public final zzhf zze;
    private String zzx;
    private boolean zzy;
    private long zzz;
    public final zzhd zzf;
    public final zzhb zzg;
    public final zzhf zzh;
    public final zzhc zzi;
    public final zzhb zzj;
    public final zzhd zzk;
    public final zzhd zzl;
    public boolean zzm;
    public final zzhb zzn;
    public final zzhb zzo;
    public final zzhd zzp;
    public final zzhf zzq;
    public final zzhf zzr;
    public final zzhd zzs;
    public final zzhc zzt;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzb(String string) {
        ((zzjd)((Object)bl)).zzg();
        if (!((zzhg)((Object)bl)).zzl().zzo(zzjj.zza)) {
            Boolean bl = false;
            return new Pair((Object)"", (Object)bl);
        }
        Object object = ((zzjd)((Object)bl)).zzu;
        long l = ((zzib)object).zzaZ().elapsedRealtime();
        String string2 = ((zzhg)((Object)bl)).zzx;
        if (string2 != null && l < ((zzhg)((Object)bl)).zzz) {
            return new Pair((Object)string2, (Object)((zzhg)((Object)bl)).zzy);
        }
        ((zzhg)((Object)bl)).zzz = l + ((zzib)object).zzc().zzl(string, zzfx.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = ((zzib)object).zzaY();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            ((zzhg)((Object)bl)).zzx = "";
            object = string.getId();
            if (object != null) {
                ((zzhg)((Object)bl)).zzx = object;
            }
            ((zzhg)((Object)bl)).zzy = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            ((zzjd)((Object)bl)).zzu.zzaV().zzj().zzb("Unable to get advertising id", exception);
            ((zzhg)((Object)bl)).zzx = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)((zzhg)((Object)bl)).zzx, (Object)((zzhg)((Object)bl)).zzy);
    }

    zzhg(zzib object) {
        super((zzib)object);
        object = "session_timeout";
        this.zzf = new zzhd(this, (String)object, 1800000L);
        object = "start_new_session";
        this.zzg = new zzhb(this, (String)object, true);
        object = "last_pause_time";
        this.zzk = new zzhd(this, (String)object, 0L);
        object = "session_id";
        this.zzl = new zzhd(this, (String)object, 0L);
        object = "non_personalized_ads";
        this.zzh = new zzhf(this, (String)object, null);
        object = "last_received_uri_timestamps_by_source";
        this.zzi = new zzhc(this, (String)object, null);
        object = "allow_remote_dynamite";
        this.zzj = new zzhb(this, (String)object, false);
        object = "first_open_time";
        this.zzc = new zzhd(this, (String)object, 0L);
        object = "app_install_time";
        this.zzd = new zzhd(this, (String)object, 0L);
        object = "app_instance_id";
        this.zze = new zzhf(this, (String)object, null);
        object = "app_backgrounded";
        this.zzn = new zzhb(this, (String)object, false);
        object = "deep_link_retrieval_complete";
        this.zzo = new zzhb(this, (String)object, false);
        object = "deep_link_retrieval_attempts";
        this.zzp = new zzhd(this, (String)object, 0L);
        object = "firebase_feature_rollouts";
        this.zzq = new zzhf(this, (String)object, null);
        object = "deferred_attribution_cache";
        this.zzr = new zzhf(this, (String)object, null);
        object = "deferred_attribution_cache_timestamp";
        this.zzs = new zzhd(this, (String)object, 0L);
        object = "default_event_parameters";
        this.zzt = new zzhc(this, (String)object, null);
    }

    @Override
    protected final boolean zza() {
        return true;
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzba() {
        zzib zzib2 = this.zzu;
        this.zzv = zzib2.zzaY().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzm = this.zzv.getBoolean("has_been_opened", false);
        if (!this.zzm) {
            SharedPreferences.Editor editor = this.zzv.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        zzib2.zzc();
        long l = Math.max(0L, (Long)zzfx.zzc.zzb(null));
        this.zzb = new zzhe(this, "health_monitor", l, null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzd() {
        this.zzg();
        this.zzw();
        Preconditions.checkNotNull((Object)this.zzv);
        return this.zzv;
    }

    @WorkerThread
    protected final SharedPreferences zze() {
        this.zzg();
        this.zzw();
        if (this.zzw == null) {
            zzib zzib2 = this.zzu;
            String string = zzib2.zzaY().getPackageName();
            String.valueOf(string);
            String string2 = String.valueOf(string);
            string2 = string2.concat("_preferences");
            zzib2.zzaV().zzk().zzb("Default prefs file", string2);
            this.zzw = zzib2.zzaY().getSharedPreferences(string2, 0);
        }
        return this.zzw;
    }

    final SparseArray zzf() {
        Bundle bundle = this.zzi.zza();
        int[] nArray = bundle.getIntArray("uriSources");
        long[] lArray = bundle.getLongArray("uriTimestamps");
        if (nArray == null || lArray == null) {
            return new SparseArray();
        }
        int n = lArray.length;
        if (nArray.length != n) {
            this.zzu.zzaV().zzb().zza("Trigger URI source and timestamp array lengths do not match");
            return new SparseArray();
        }
        SparseArray sparseArray = new SparseArray();
        for (int i = 0; i < nArray.length; ++i) {
            sparseArray.put(nArray[i], (Object)lArray[i]);
        }
        return sparseArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzhg2.zzg();
        zzhg zzhg2 = zzhg2.zzd().edit();
        if (bl != null) {
            zzhg2.putBoolean("measurement_enabled", bl);
        } else {
            zzhg2.remove("measurement_enabled");
        }
        zzhg2.apply();
    }

    @WorkerThread
    final Boolean zzi() {
        this.zzg();
        if (this.zzd().contains("measurement_enabled")) {
            return this.zzd().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    final zzaz zzj() {
        this.zzg();
        return zzaz.zzg(this.zzd().getString("dma_consent_settings", null));
    }

    @WorkerThread
    final boolean zzk(int n) {
        return zzjk.zzu(n, this.zzd().getInt("consent_source", 100));
    }

    @WorkerThread
    final zzjk zzl() {
        this.zzg();
        return zzjk.zzf(this.zzd().getString("consent_settings", "G1"), this.zzd().getInt("consent_source", 100));
    }

    @WorkerThread
    protected final boolean zzm(zzoc object) {
        this.zzg();
        String string = this.zzd().getString("stored_tcf_param", "");
        object = ((zzoc)object).zza();
        if (!((String)object).equals(string)) {
            SharedPreferences.Editor editor = this.zzd().edit();
            editor.putString("stored_tcf_param", (String)object);
            editor.apply();
            return true;
        }
        return false;
    }

    @WorkerThread
    final void zzn(boolean bl) {
        this.zzg();
        this.zzu.zzaV().zzk().zzb("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zzd().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzo() {
        zzhg zzhg2 = zzhg2.zzv;
        if (zzhg2 == null) {
            return false;
        }
        return zzhg2.contains("deferred_analytics_collection");
    }

    final boolean zzp(long l) {
        return l - this.zzf.zza() > this.zzk.zza();
    }
}

