/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzqp;
import com.google.android.gms.internal.measurement.zzrn;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzpp;
import com.google.android.gms.measurement.internal.zzr;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzgi
extends zzg {
    private String zza;
    private String zzb;
    private int zzc;
    private String zzd;
    private String zze;
    private long zzf;
    private final long zzg;
    private final long zzh;
    private List zzi;
    private String zzj;
    private int zzk;
    private String zzl;
    private String zzm;
    private long zzn = 0L;
    private String zzo = null;

    zzgi(zzic zzic2, long l, long l2) {
        super(zzic2);
        this.zzg = l;
        this.zzh = l2;
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @EnsuresNonNull(value={"appId", "appStore", "appName", "gmpAppId", "gaAppId"})
    @WorkerThread
    protected final void zzf() {
        block33: {
            block32: {
                var1_1 = this.zzu;
                var5_3 = this.zzh;
                var1_1.zzaV().zzk().zzc("sdkVersion bundled with app, dynamiteVersion", var5_3, this.zzg);
                var7_4 = var1_1.zzaY().getPackageName();
                var8_5 = var1_1.zzaY().getPackageManager();
                var4_6 = "Unknown";
                var2_9 = "Unknown";
                var3_13 = "unknown";
                if (var8_5 == null) {
                    v0 = var1_1.zzaV().zzb();
                    var1_1 = zzgu.zzl(var7_4);
                    v0.zzb("PackageManager is null, app identity information might be inaccurate. appId", var1_1);
                    var1_1 = var3_13;
                    var3_14 = -2147483648;
                } else {
                    block30: {
                        block31: {
                            try {
                                var1_1 = var8_5.getInstallerPackageName(var7_4);
                            }
                            catch (IllegalArgumentException v1) {
                                var1_1 = zzgu.zzl(var7_4);
                                this.zzu.zzaV().zzb().zzb("Error retrieving app installer package name. appId", var1_1);
                                var1_1 = var3_13;
                            }
                            if (var1_1 == null) {
                                var1_1 = "manual_install";
                            } else if ("com.android.vending".equals(var1_1)) {
                                var1_1 = "";
                            }
                            var3_13 = this.zzu.zzaY();
                            var3_13 = var8_5.getPackageInfo(var3_13.getPackageName(), 0);
                            if (var3_13 == null) break block30;
                            var9_16 = var8_5.getApplicationLabel(var3_13.applicationInfo);
                            var10_17 = TextUtils.isEmpty((CharSequence)var9_16);
                            if (var10_17) break block31;
                            var4_6 = var9_16.toString();
                        }
                        var2_9 = var3_13.versionName;
                        var3_14 = var3_13.versionCode;
                        break block32;
                    }
                    var3_14 = -2147483648;
                }
                break block32;
                catch (PackageManager.NameNotFoundException v2) {}
                ** GOTO lbl-1000
                catch (PackageManager.NameNotFoundException v3) {
                    ** GOTO lbl-1000
                }
                catch (PackageManager.NameNotFoundException v4) {}
lbl-1000:
                // 3 sources

                {
                    var3_13 = zzgu.zzl(var7_4);
                    this.zzu.zzaV().zzb().zzc("Error retrieving package info. appId, appName", var3_13, var4_6);
                    var3_14 = -2147483648;
                }
            }
            this.zza = var7_4;
            this.zzd = var1_1;
            this.zzb = var2_9;
            this.zzc = var3_14;
            this.zze = var4_6;
            this.zzf = 0L;
            var1_1 = this.zzu;
            var2_10 = var1_1.zzC();
            switch (var2_10) {
                default: {
                    v5 = this.zzu;
                    v5.zzaV().zzi().zza("App measurement disabled");
                    v5.zzaV().zzc().zza("Invalid scion state in identity");
                    break;
                }
                case 0: {
                    this.zzu.zzaV().zzk().zza("App measurement collection enabled");
                    break;
                }
                case 1: {
                    this.zzu.zzaV().zzi().zza("App measurement deactivated via the manifest");
                    break;
                }
                case 3: {
                    this.zzu.zzaV().zzi().zza("App measurement disabled by setAnalyticsCollectionEnabled(false)");
                    break;
                }
                case 4: {
                    this.zzu.zzaV().zzi().zza("App measurement disabled via the manifest");
                    break;
                }
                case 6: {
                    this.zzu.zzaV().zzh().zza("App measurement deactivated via resources. This method is being deprecated. Please refer to https://firebase.google.com/support/guides/disable-analytics");
                    break;
                }
                case 7: {
                    this.zzu.zzaV().zzi().zza("App measurement disabled via the global data collection setting");
                    break;
                }
                case 8: {
                    this.zzu.zzaV().zzi().zza("App measurement disabled due to denied storage consent");
                }
            }
            this.zzl = "";
            var3_15 = this.zzu;
            var3_15.zzaU();
            try {
                var4_6 = var3_15.zzaY();
                var1_1 = var1_1.zzq();
                var1_1 = zzlt.zza((Context)var4_6, (String)"google_app_id", (String)var1_1);
                var4_7 = TextUtils.isEmpty((CharSequence)var1_1);
                if (var4_7) {
                    var1_1 = "";
                }
                this.zzl = var1_1;
                if (var2_10 == 0) {
                    var1_1 = var3_15.zzaV();
                    var1_1.zzk().zzc("App measurement enabled for app package, google app id", this.zza, this.zzl);
                }
            }
            catch (IllegalStateException var1_2) {
                var2_12 = zzgu.zzl(var7_4);
                this.zzu.zzaV().zzb().zzc("Fetching Google App Id failed with exception. appId", var2_12, var1_2);
            }
            this.zzi = null;
            var1_1 = this.zzu;
            var1_1.zzaU();
            var2_11 = var1_1.zzc().zzs("analytics.safelisted_events");
            if (var2_11 == null) ** GOTO lbl119
            if (var2_11.isEmpty()) {
                var1_1.zzaV().zzh().zza("Safelisted event list is empty. Ignoring");
            } else {
                for (String var4_8 : var2_11) {
                    if (var1_1.zzk().zzk("safelisted event", var4_8)) continue;
                    break block33;
                }
lbl119:
                // 2 sources

                this.zzi = var2_11;
            }
        }
        if (var8_5 != null) {
            this.zzk = (int)InstantApps.isInstantApp((Context)var1_1.zzaY());
            return;
        }
        this.zzk = 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final zzr zzh(String string) {
        long l;
        String string2;
        boolean bl;
        boolean bl2;
        long l2;
        Object object;
        Object object2;
        Object object3;
        String string3;
        long l3;
        String string4;
        String string5;
        String string6;
        block35: {
            block34: {
                long l4;
                block33: {
                    block32: {
                        ((zzje)zzjg2).zzg();
                        string6 = ((zzgi)zzjg2).zzj();
                        string5 = ((zzgi)zzjg2).zzk();
                        ((zzg)zzjg2).zzb();
                        string4 = ((zzgi)zzjg2).zzb;
                        ((zzg)zzjg2).zzb();
                        l3 = ((zzgi)zzjg2).zzc;
                        ((zzg)zzjg2).zzb();
                        Preconditions.checkNotNull((Object)((zzgi)zzjg2).zzd);
                        string3 = ((zzgi)zzjg2).zzd;
                        object3 = ((zzje)zzjg2).zzu;
                        ((zzic)object3).zzc().zzi();
                        ((zzg)zzjg2).zzb();
                        ((zzje)zzjg2).zzg();
                        l4 = ((zzgi)zzjg2).zzf;
                        if (l4 != 0L) break block32;
                        object2 = ((zzgi)zzjg2).zzu.zzk();
                        object = ((zzic)object3).zzaY();
                        object3 = ((zzic)object3).zzaY().getPackageName();
                        ((zzje)object2).zzg();
                        Preconditions.checkNotNull((Object)object);
                        Preconditions.checkNotEmpty((String)object3);
                        Signature[] signatureArray = object.getPackageManager();
                        MessageDigest messageDigest = zzpp.zzO();
                        if (messageDigest == null) {
                            ((zzje)object2).zzu.zzaV().zzb().zza("Could not get MD5 instance");
                            l4 = -1L;
                            break block33;
                        } else {
                            if (signatureArray != null) {
                                long l5;
                                boolean bl3 = ((zzpp)object2).zzad((Context)object, (String)object3);
                                if (!bl3) {
                                    int n;
                                    Object object4 = Wrappers.packageManager((Context)object);
                                    object = ((zzje)object2).zzu;
                                    signatureArray = ((zzic)object).zzaY();
                                    object4 = object4.getPackageInfo(signatureArray.getPackageName(), 64);
                                    signatureArray = ((PackageInfo)object4).signatures;
                                    if (signatureArray != null && (n = ((PackageInfo)object4).signatures.length) > 0) {
                                        l5 = l4 = zzpp.zzP(messageDigest.digest(((PackageInfo)object4).signatures[0].toByteArray()));
                                    } else {
                                        object4 = ((zzic)object).zzaV();
                                        ((zzgu)object4).zze().zza("Could not get signatures");
                                        l5 = -1L;
                                    }
                                } else {
                                    l5 = 0L;
                                }
                                l4 = l5;
                            }
                            l4 = 0L;
                        }
                        break block33;
                    }
                    l2 = l4;
                    break block34;
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        ((zzje)object2).zzu.zzaV().zzb().zzb("Package name not found", (Object)nameNotFoundException);
                        l4 = 0L;
                    }
                }
                ((zzgi)zzjg2).zzf = l4;
                l2 = l4;
            }
            zzic zzic2 = ((zzgi)zzjg2).zzu;
            object3 = ((zzje)zzjg2).zzu;
            bl2 = zzic2.zzB();
            bl = ((zzic)object3).zzd().zzm ^ true;
            ((zzje)zzjg2).zzg();
            if (!zzic2.zzB()) {
                object3 = null;
            } else {
                zzrn.zza();
                if (((zzic)object3).zzc().zzp(null, zzfy.zzaH)) {
                    ((zzje)zzjg2).zzu.zzaV().zzk().zza("Disabled IID for tests.");
                    object3 = null;
                } else {
                    block31: {
                        block30: {
                            object3 = ((zzic)object3).zzaY();
                            object3 = object3.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
                            if (object3 != null) break block30;
                            object3 = null;
                        }
                        object2 = ((Class)object3).getDeclaredMethod("getInstance", Context.class);
                        object = new Object[1];
                        Context context = ((zzje)zzjg2).zzu.zzaY();
                        object[0] = context;
                        object2 = ((Method)object2).invoke(null, (Object[])object);
                        if (object2 != null) break block31;
                        object3 = null;
                    }
                    object3 = (String)((Class)object3).getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object2, new Object[0]);
                    catch (ClassNotFoundException classNotFoundException) {
                        object3 = null;
                    }
                }
            }
            break block35;
            catch (Exception exception) {
                ((zzje)zzjg2).zzu.zzaV().zzf().zza("Failed to obtain Firebase Analytics instance");
                object3 = null;
            }
            break block35;
            catch (Exception exception) {
                ((zzje)zzjg2).zzu.zzaV().zzh().zza("Failed to retrieve Firebase Instance Id");
                object3 = null;
            }
        }
        object2 = ((zzgi)zzjg2).zzu;
        long l6 = ((zzic)object2).zzd().zzc.zza();
        long l7 = l6 == 0L ? ((zzic)object2).zza : Math.min(((zzic)object2).zza, l6);
        ((zzg)zzjg2).zzb();
        int n = ((zzgi)zzjg2).zzk;
        object = ((zzje)zzjg2).zzu;
        boolean bl4 = ((zzic)object).zzc().zzu();
        zzhh zzhh2 = ((zzic)object).zzd();
        zzhh2.zzg();
        boolean bl5 = zzhh2.zzd().getBoolean("deferred_analytics_collection", false);
        boolean bl6 = ((zzic)object).zzc().zzw("google_analytics_default_allow_ad_personalization_signals", true) != zzji.zzd;
        long l8 = ((zzgi)zzjg2).zzg;
        Boolean bl7 = bl6;
        List list = ((zzgi)zzjg2).zzi;
        String string7 = ((zzic)object).zzd().zzl().zzl();
        if (((zzgi)zzjg2).zzj == null) {
            ((zzgi)zzjg2).zzj = ((zzic)object).zzk().zzaw();
        }
        String string8 = ((zzgi)zzjg2).zzj;
        if (!((zzic)object).zzd().zzl().zzo(zzjk.zzb)) {
            string2 = null;
        } else {
            ((zzje)zzjg2).zzg();
            if (((zzgi)zzjg2).zzn != 0L) {
                l6 = ((zzic)object).zzaZ().currentTimeMillis() - ((zzgi)zzjg2).zzn;
                if (((zzgi)zzjg2).zzm != null && l6 > 86400000L && ((zzgi)zzjg2).zzo == null) {
                    ((zzgi)zzjg2).zzi();
                }
            }
            if (((zzgi)zzjg2).zzm == null) {
                ((zzgi)zzjg2).zzi();
            }
            string2 = ((zzgi)zzjg2).zzm;
        }
        boolean bl8 = ((zzic)object).zzc().zzx();
        object = ((zzic)object).zzk();
        String string9 = ((zzgi)zzjg2).zzj();
        zzic zzic3 = ((zzje)object).zzu;
        if (zzic3.zzaY().getPackageManager() == null) {
            l = 0L;
        } else {
            int n2;
            try {
                zzic3 = zzic3.zzaY();
                zzic3 = Wrappers.packageManager((Context)zzic3).getApplicationInfo(string9, 0);
                n2 = zzic3 != null ? ((ApplicationInfo)zzic3).targetSdkVersion : 0;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                zzic zzic4 = ((zzje)object).zzu;
                zzic4.zzaU();
                zzic4.zzaV().zzi().zzb("PackageManager failed to find running app: app_id", string9);
                n2 = 0;
            }
            l = n2;
        }
        zzic zzic5 = ((zzje)zzjg2).zzu;
        int n3 = zzic5.zzd().zzl().zzb();
        String string10 = zzic5.zzd().zzj().zze();
        zzqp.zza();
        zzfx zzfx2 = zzfy.zzaQ;
        int n4 = zzic5.zzc().zzp(null, zzfx2) ? zzic5.zzk().zzU() : 0;
        zzqp.zza();
        l6 = zzic5.zzc().zzp(null, zzfx2) ? zzic5.zzk().zzV() : 0L;
        zzji zzji2 = zzic5.zzc().zzw("google_analytics_default_allow_ad_personalization_signals", true);
        zzjg zzjg2 = ((zzf)zzjg2).zzu;
        return new zzr(string6, string5, string4, l3, string3, 133005L, l2, string, bl2, bl, (String)object3, l7, n, bl4, bl5, bl7, l8, list, string7, string8, string2, bl8, l, n3, string10, n4, l6, zzic5.zzc().zzz(), new zze(zzji2).zzb(), ((zzgi)zzjg2).zzu.zza, ((zzic)zzjg2).zzx().zzj().zza());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzi() {
        void var1_3;
        Object object;
        ((zzje)this).zzg();
        zzic zzic2 = this.zzu;
        if (!zzic2.zzd().zzl().zzo(zzjk.zzb)) {
            zzic2.zzaV().zzj().zza("Analytics Storage consent is not granted");
            Object var1_2 = null;
        } else {
            byte[] byArray = new byte[16];
            zzic2.zzk().zzf().nextBytes(byArray);
            object = new Object[]{new BigInteger(1, byArray)};
            String string = String.format(Locale.US, "%032x", object);
        }
        zzgs zzgs2 = zzic2.zzaV().zzj();
        Object[] objectArray = new Object[1];
        object = var1_3 == null ? "null" : "not null";
        objectArray[0] = object;
        zzgs2.zza(String.format("Resetting session stitching token to %s", objectArray));
        this.zzm = var1_3;
        this.zzn = zzic2.zzaZ().currentTimeMillis();
    }

    @WorkerThread
    final String zzj() {
        this.zzb();
        Preconditions.checkNotNull((Object)this.zza);
        return this.zza;
    }

    @WorkerThread
    final String zzk() {
        ((zzje)this).zzg();
        this.zzb();
        Preconditions.checkNotNull((Object)this.zzl);
        return this.zzl;
    }

    @WorkerThread
    final String zzl() {
        this.zzb();
        Preconditions.checkNotNull((Object)this.zze);
        return this.zze;
    }

    @WorkerThread
    final int zzm() {
        this.zzb();
        return this.zzc;
    }

    final long zzn() {
        return this.zzh;
    }

    @WorkerThread
    final int zzo() {
        this.zzb();
        return this.zzk;
    }

    @WorkerThread
    final List zzp() {
        return this.zzi;
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean zzq(String string) {
        String string2 = this.zzo;
        boolean bl = string2 != null ? !string2.equals(string) : false;
        this.zzo = string;
        return bl;
    }
}

