/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.privacysandbox.ads.adservices.java.measurement.MeasurementManagerFutures;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.internal.measurement.zzqp;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzkd;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzkf;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzlc;
import com.google.android.gms.measurement.internal.zzld;
import com.google.android.gms.measurement.internal.zzle;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zzoa;
import com.google.android.gms.measurement.internal.zzod;
import com.google.android.gms.measurement.internal.zzoe;
import com.google.android.gms.measurement.internal.zzof;
import com.google.android.gms.measurement.internal.zzoh;
import com.google.android.gms.measurement.internal.zzom;
import com.google.android.gms.measurement.internal.zzoq;
import com.google.android.gms.measurement.internal.zzpl;
import com.google.android.gms.measurement.internal.zzpo;
import com.google.android.gms.measurement.internal.zzpp;
import com.google.android.gms.measurement.internal.zzx;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzlj
extends zzg {
    @VisibleForTesting
    protected zzky zza;
    private zzjp zzd;
    private final Set zze = new CopyOnWriteArraySet();
    private boolean zzf;
    private final AtomicReference zzg;
    private final Object zzh = new Object();
    private boolean zzi = false;
    private int zzj = 1;
    private zzay zzk;
    private zzay zzl;
    private PriorityQueue zzm;
    private boolean zzn;
    @GuardedBy(value="consentLock")
    private zzjl zzo;
    private final AtomicLong zzp;
    private long zzq = -1L;
    final zzx zzb;
    @VisibleForTesting
    protected boolean zzc = true;
    private zzay zzr;
    private SharedPreferences.OnSharedPreferenceChangeListener zzs;
    private zzay zzt;
    private final zzpo zzv = new zzkn(this);

    protected zzlj(zzic zzic2) {
        super(zzic2);
        this.zzg = new AtomicReference();
        this.zzo = zzjl.zza;
        this.zzp = new AtomicLong(0L);
        this.zzb = new zzx(zzic2);
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    public final void zzh() {
        zzic zzic2 = this.zzu;
        if (zzic2.zzaY().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)zzic2.zzaY().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
            return;
        }
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        zzke zzke2 = new zzke(this, atomicReference);
        return (Boolean)this.zzu.zzaW().zzk(atomicReference, 15000L, "boolean test flag value", zzke2);
    }

    public final String zzj() {
        AtomicReference atomicReference = new AtomicReference();
        zzko zzko2 = new zzko(this, atomicReference);
        return (String)this.zzu.zzaW().zzk(atomicReference, 15000L, "String test flag value", zzko2);
    }

    public final Long zzk() {
        AtomicReference atomicReference = new AtomicReference();
        zzkp zzkp2 = new zzkp(this, atomicReference);
        return (Long)this.zzu.zzaW().zzk(atomicReference, 15000L, "long test flag value", zzkp2);
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        zzkq zzkq2 = new zzkq(this, atomicReference);
        return (Integer)this.zzu.zzaW().zzk(atomicReference, 15000L, "int test flag value", zzkq2);
    }

    public final Double zzm() {
        AtomicReference atomicReference = new AtomicReference();
        zzkr zzkr2 = new zzkr(this, atomicReference);
        return (Double)this.zzu.zzaW().zzk(atomicReference, 15000L, "double test flag value", zzkr2);
    }

    public final void zzn(Boolean bl) {
        this.zzb();
        this.zzu.zzaW().zzj(new zzks(this, bl));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final void zzp(Bundle object, int n, long l) {
        void var3_8;
        void var1_3;
        void var2_5;
        String string;
        Object object2;
        block8: {
            this.zzb();
            zzjk[] zzjkArray = zzjj.zza.zzb();
            int n2 = zzjkArray.length;
            for (int i = 0; i < n2; ++i) {
                String string2;
                object2 = zzjkArray[i].zze;
                if (!object.containsKey((String)object2) || (string2 = object.getString((String)object2)) == null || (object2 = string2.equals("granted") ? Boolean.valueOf(true) : (string2.equals("denied") ? Boolean.valueOf(false) : null)) != null) continue;
                string = string2;
                break block8;
            }
            string = null;
        }
        if (string != null) {
            zzic zzic2 = this.zzu;
            zzic2.zzaV().zzh().zzb("Ignoring invalid consent setting", string);
            zzic2.zzaV().zzh().zza("Valid consent values are 'granted', 'denied'");
        }
        boolean bl = this.zzu.zzaW().zze();
        object2 = zzjl.zze(object, (int)var2_5);
        if (((zzjl)object2).zzc()) {
            this.zzs((zzjl)object2, bl);
        }
        if (((zzaz)(object2 = zzaz.zzh(object, (int)var2_5))).zzd()) {
            this.zzq((zzaz)object2, bl);
        }
        if ((object2 = zzaz.zzi(object)) == null) {
            return;
        }
        if (var2_5 == -30) {
            String string3 = "tcf";
        } else {
            String string4 = "app";
        }
        if (bl) {
            String string5 = ((Boolean)object2).toString();
            this.zzN((String)var1_3, "allow_personalized_ads", string5, (long)var3_8);
            return;
        }
        String string6 = ((Boolean)object2).toString();
        this.zzL((String)var1_3, "allow_personalized_ads", string6, false, (long)var3_8);
    }

    final void zzq(zzaz zzaz2, boolean bl) {
        zzkt zzkt2 = new zzkt(this, zzaz2);
        if (bl) {
            ((zzje)this).zzg();
            zzkt2.run();
            return;
        }
        this.zzu.zzaW().zzj(zzkt2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzs(zzjl zzjl2, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int n;
        block12: {
            this.zzb();
            n = zzjl2.zzb();
            if (n != -10) {
                zzji zzji2 = zzji.zza;
                if (zzjl2.zzp() == zzji2 && zzjl2.zzq() == zzji2) {
                    this.zzu.zzaV().zzh().zza("Ignoring empty consent settings");
                    return;
                }
            }
            Object object = this.zzh;
            // MONITORENTER : object
            bl4 = zzjl.zzu(n, this.zzo.zzb());
            if (bl4) {
                zzjl zzjl3;
                bl3 = zzjl2.zzr(this.zzo);
                zzjk zzjk2 = zzjk.zzb;
                boolean bl5 = zzjl2.zzo(zzjk2);
                bl4 = bl5 ? !(bl4 = (zzjl3 = this.zzo).zzo(zzjk2)) : false;
                this.zzo = zzjl2 = zzjl2.zzt(this.zzo);
                boolean bl6 = bl4;
                bl4 = bl3;
                bl3 = bl6;
                bl2 = true;
                // MONITOREXIT : object
                break block12;
            }
            bl4 = false;
            bl3 = false;
            bl2 = false;
            {
                catch (Throwable throwable) {}
                {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
        }
        if (!bl2) {
            this.zzu.zzaV().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", zzjl2);
            return;
        }
        long l = this.zzp.getAndIncrement();
        if (bl4) {
            this.zzg.set(null);
            zzku zzku2 = new zzku(this, zzjl2, l, bl3);
            if (bl) {
                ((zzje)this).zzg();
                zzku2.run();
                return;
            }
            this.zzu.zzaW().zzl(zzku2);
            return;
        }
        zzkv zzkv2 = new zzkv(this, zzjl2, l, bl3);
        if (bl) {
            ((zzje)this).zzg();
            zzkv2.run();
            return;
        }
        if (n != 30 && n != -10) {
            this.zzu.zzaW().zzj(zzkv2);
            return;
        }
        this.zzu.zzaW().zzl(zzkv2);
    }

    final void zzt(Runnable runnable) {
        zzic zzic2;
        block6: {
            block7: {
                block8: {
                    ((zzg)((Object)n3)).zzb();
                    zzic2 = ((zzje)((Object)n3)).zzu;
                    if (zzic2.zzaW().zze()) break block6;
                    if (zzic2.zzaW().zzf()) break block7;
                    zzic2.zzaU();
                    if (zzae.zza()) break block8;
                    zzic2.zzaV().zzk().zza("[sgtm] Started client-side batch upload work.");
                    int n = 0;
                    int n2 = 0;
                    boolean bl = false;
                    block0: while (true) {
                        Object object;
                        Object object2;
                        block10: {
                            block9: {
                                if (bl) break block9;
                                zzic2.zzaV().zzk().zza("[sgtm] Getting upload batches from service (FE)");
                                object2 = new AtomicReference();
                                object = new zzli((zzlj)((Object)n3), (AtomicReference)object2);
                                zzic2.zzaW().zzk((AtomicReference)object2, 10000L, "[sgtm] Getting upload batches", (Runnable)object);
                                object2 = (zzoq)((Object)((AtomicReference)object2).get());
                                if (object2 != null && !(object2 = ((zzoq)((Object)object2)).zza).isEmpty()) break block10;
                            }
                            Integer n3 = n;
                            Integer n4 = n2;
                            zzic2.zzaV().zzk().zzc("[sgtm] Completed client-side batch upload work. total, success", n3, n4);
                            runnable.run();
                            return;
                        }
                        object = object2.size();
                        zzic2.zzaV().zzk().zzb("[sgtm] Retrieved upload batches. count", object);
                        n += object2.size();
                        object2 = object2.iterator();
                        while (object2.hasNext()) {
                            object = super.zzar((zzom)((Object)object2.next()));
                            if (object == zzlr.zzb) {
                                ++n2;
                                continue;
                            }
                            if (object != zzlr.zzd) continue;
                            bl = true;
                            continue block0;
                        }
                        bl = false;
                    }
                }
                zzic2.zzaV().zzb().zza("Cannot retrieve and upload batches from main thread");
                return;
            }
            zzic2.zzaV().zzb().zza("Cannot retrieve and upload batches from analytics network thread");
            return;
        }
        zzic2.zzaV().zzb().zza("Cannot retrieve and upload batches from analytics worker thread");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final zzlr zzar(zzom object) {
        AtomicReference atomicReference;
        block13: {
            long l;
            long l2;
            Object object222;
            URL uRL = new URI(((zzom)((Object)object)).zzc).toURL();
            atomicReference = new AtomicReference();
            String string = ((zzf)((Object)string3)).zzu.zzv().zzl();
            zzic zzic2 = ((zzje)((Object)string3)).zzu;
            Serializable serializable = Long.valueOf(((zzom)((Object)object)).zza);
            Object object3 = ((zzom)((Object)object)).zzc;
            Object object4 = ((zzom)((Object)object)).zzb.length;
            zzic2.zzaV().zzk().zzd("[sgtm] Uploading data from app. row_id, url, uncompressed size", serializable, object3, object4);
            if (!TextUtils.isEmpty((CharSequence)((zzom)((Object)object)).zzg)) {
                object3 = ((zzom)((Object)object)).zzg;
                zzic2.zzaV().zzk().zzc("[sgtm] Uploading data from app. row_id", serializable, object3);
            }
            serializable = new HashMap();
            object3 = ((zzom)((Object)object)).zzd;
            for (Object object222 : object3.keySet()) {
                String string2 = object3.getString((String)object222);
                if (TextUtils.isEmpty((CharSequence)string2)) continue;
                serializable.put(object222, string2);
            }
            object3 = zzic2.zzn();
            object4 = ((zzom)((Object)object)).zzb;
            object222 = new zzkz((zzlj)((Object)string3), atomicReference, (zzom)((Object)object));
            ((zzjf)object3).zzw();
            Preconditions.checkNotNull((Object)uRL);
            Preconditions.checkNotNull((Object)object4);
            Preconditions.checkNotNull((Object)object222);
            ((zzje)object3).zzu.zzaW().zzm(new zzln((zzlo)object3, string, uRL, (byte[])object4, (Map)((Object)serializable), (zzll)object222));
            try {
                object = zzic2.zzk();
                object = ((zzje)object).zzu;
                l2 = ((zzic)object).zzaZ().currentTimeMillis() + 60000L;
                // MONITORENTER : atomicReference
                l = 60000L;
            }
            catch (InterruptedException interruptedException) {
                ((zzje)((Object)string3)).zzu.zzaV().zze().zza("[sgtm] Interrupted waiting for uploading batch");
                break block13;
            }
            catch (MalformedURLException | URISyntaxException exception) {
                String string3 = ((zzom)((Object)object)).zzc;
                object = ((zzom)((Object)object)).zza;
                ((zzje)((Object)string3)).zzu.zzaV().zzb().zzd("[sgtm] Bad upload url for row_id", string3, object, exception);
                return zzlr.zzc;
            }
            while ((uRL = atomicReference.get()) == null && l > 0L) {
                atomicReference.wait(l);
                uRL = ((zzic)object).zzaZ();
                long l3 = uRL.currentTimeMillis();
                l = l2 - l3;
            }
            {
                catch (Throwable throwable) {}
                throw throwable;
            }
        }
        if (atomicReference.get() != null) return (zzlr)((Object)atomicReference.get());
        return zzlr.zza;
    }

    @WorkerThread
    final void zzu(long l) {
        ((zzje)this).zzg();
        if (this.zzl == null) {
            zzic zzic2 = this.zzu;
            this.zzl = new zzju(this, zzic2);
        }
        this.zzl.zzb(l);
    }

    @WorkerThread
    final void zzv() {
        ((zzje)((Object)zzay2)).zzg();
        zzay zzay2 = ((zzlj)((Object)zzay2)).zzl;
        if (zzay2 != null) {
            zzay2.zzd();
            return;
        }
    }

    final void zzw() {
        zzqp.zza();
        zzic zzic2 = this.zzu;
        if (zzic2.zzc().zzp(null, zzfy.zzaQ)) {
            if (!zzic2.zzaW().zze()) {
                zzic2.zzaU();
                if (!zzae.zza()) {
                    this.zzb();
                    zzic2.zzaV().zzk().zza("Getting trigger URIs (FE)");
                    Object object = new AtomicReference();
                    zzla zzla2 = new zzla(this, (AtomicReference)object);
                    zzic2.zzaW().zzk((AtomicReference)object, 10000L, "get trigger URIs", zzla2);
                    object = (List)((AtomicReference)object).get();
                    if (object == null) {
                        zzic2.zzaV().zzd().zza("Timed out waiting for get trigger URIs");
                        return;
                    }
                    zzic2.zzaW().zzj(new zzlb(this, (List)object));
                    return;
                }
                zzic2.zzaV().zzb().zza("Cannot get trigger URIs from main thread");
                return;
            }
            zzic2.zzaV().zzb().zza("Cannot get trigger URIs from analytics worker thread");
            return;
        }
    }

    final boolean zzx() {
        return this.zzn;
    }

    @TargetApi(value=30)
    final PriorityQueue zzy() {
        if (this.zzm == null) {
            this.zzm = new PriorityQueue(Comparator.comparing(zzlc.zza, zzld.zza));
        }
        return this.zzm;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    @TargetApi(value=30)
    final void zzz() {
        zzic zzic2;
        MeasurementManagerFutures measurementManagerFutures;
        zzoh zzoh2;
        ((zzje)this).zzg();
        this.zzn = false;
        if (this.zzy().isEmpty() || this.zzi || (zzoh2 = (zzoh)((Object)this.zzy().poll())) == null || (measurementManagerFutures = (zzic2 = this.zzu).zzk().zzT()) == null) {
            return;
        }
        this.zzi = true;
        String string = zzoh2.zza;
        zzic2.zzaV().zzk().zzb("Registering trigger URI", string);
        zzic2 = measurementManagerFutures.registerTriggerAsync(Uri.parse((String)string));
        if (zzic2 == null) {
            this.zzi = false;
            this.zzy().add(zzoh2);
            return;
        }
        Futures.addCallback((ListenableFuture)zzic2, (FutureCallback)new zzjw(this, zzoh2), (Executor)new zzjv(this));
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzA(zzjl zzjl2) {
        ((zzje)this).zzg();
        boolean bl = !zzjl2.zzo(zzjk.zzb) || !zzjl2.zzo(zzjk.zza) ? this.zzu.zzt().zzO() : true;
        Object object = this.zzu;
        if (bl != ((zzic)object).zzE()) {
            ((zzic)object).zzD(bl);
            object = this.zzu.zzd();
            zzic cfr_ignored_0 = ((zzje)object).zzu;
            ((zzje)object).zzg();
            object = ((zzhh)object).zzd().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzhh)object).zzd().getBoolean("measurement_enabled_from_api", true)) : null;
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzas(bl, false);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzas(Boolean bl, boolean bl2) {
        ((zzje)this).zzg();
        this.zzb();
        zzic zzic2 = this.zzu;
        zzic2.zzaV().zzj().zzb("Setting app measurement enabled (FE)", bl);
        zzic2.zzd().zzh(bl);
        if (bl2) {
            zzhh zzhh2 = zzic2.zzd();
            zzic cfr_ignored_0 = zzhh2.zzu;
            zzhh2.zzg();
            SharedPreferences.Editor editor = zzhh2.zzd().edit();
            if (bl != null) {
                editor.putBoolean("measurement_enabled_from_api", bl.booleanValue());
            } else {
                editor.remove("measurement_enabled_from_api");
            }
            editor.apply();
        }
        if (this.zzu.zzE() || bl != null && !bl.booleanValue()) {
            this.zzat();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzat() {
        ((zzje)this).zzg();
        zzic zzic2 = this.zzu;
        Object object = zzic2.zzd().zzh.zza();
        if (object != null) {
            if ("unset".equals(object)) {
                long l = zzic2.zzaZ().currentTimeMillis();
                this.zzN("app", "_npa", null, l);
            } else {
                long l = true != "true".equals(object) ? 0L : 1L;
                object = l;
                l = zzic2.zzaZ().currentTimeMillis();
                this.zzN("app", "_npa", object, l);
            }
        }
        if (this.zzu.zzB() && this.zzc) {
            zzic2.zzaV().zzj().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzU();
            this.zzu.zzh().zza.zza();
            zzic2.zzaW().zzj(new zzjz(this));
            return;
        }
        zzic2.zzaV().zzj().zza("Updating Scion state (FE)");
        this.zzu.zzt().zzi();
    }

    public final void zzB(String string, String string2, Bundle bundle) {
        this.zzC(string, string2, bundle, true, true, this.zzu.zzaZ().currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzC(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (Objects.equals(string2, "screen_view")) {
            this.zzu.zzs().zzj(bundle, l);
            return;
        }
        boolean bl3 = bl2 ? (this.zzd != null ? zzpp.zzZ(string2) : true) : true;
        if (string == null) {
            string = "app";
        }
        this.zzJ(string, string2, l, bundle, bl2, bl3, bl, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzD() {
        void var1_24;
        String[] stringArray;
        String[] stringArray2;
        zzic zzic2;
        block34: {
            void var1_22;
            String string;
            UnmodifiableIterator unmodifiableIterator;
            String string2;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            boolean bl;
            char[] cArray;
            ImmutableMap immutableMap;
            boolean bl2;
            Object object;
            block32: {
                block35: {
                    block33: {
                        String string3;
                        int n6;
                        ((zzje)this).zzg();
                        zzic2 = this.zzu;
                        zzic2.zzaV().zzj().zza("Handle tcf update.");
                        object = zzic2.zzd().zze();
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        stringArray2 = zzfy.zzaZ;
                        if (((Boolean)stringArray2.zzb(null)).booleanValue()) break block33;
                        String string4 = zzof.zza((SharedPreferences)object, "IABTCF_VendorConsents");
                        if (!"".equals(string4) && string4.length() > 754) {
                            string4 = String.valueOf(string4.charAt(754));
                            hashMap.put("GoogleConsent", string4);
                        }
                        if ((n6 = zzof.zzb((SharedPreferences)object, "IABTCF_gdprApplies")) != -1) {
                            hashMap.put("gdprApplies", String.valueOf(n6));
                        }
                        if ((n6 = zzof.zzb((SharedPreferences)object, "IABTCF_EnableAdvertiserConsentMode")) != -1) {
                            hashMap.put("EnableAdvertiserConsentMode", String.valueOf(n6));
                        }
                        if ((n6 = zzof.zzb((SharedPreferences)object, "IABTCF_PolicyVersion")) != -1) {
                            hashMap.put("PolicyVersion", String.valueOf(n6));
                        }
                        if (!"".equals(string3 = zzof.zza((SharedPreferences)object, "IABTCF_PurposeConsents"))) {
                            hashMap.put("PurposeConsents", string3);
                        }
                        if (!(bl2 = zzof.zzb((SharedPreferences)object, "IABTCF_CmpSdkID"))) {
                            hashMap.put("CmpSdkID", String.valueOf(bl2 ? 1 : 0));
                        }
                        zzod zzod2 = new zzod(hashMap);
                        break block34;
                    }
                    Map.Entry[] entryArray = new Map.Entry[7];
                    zzoe zzoe2 = zzoe.zza;
                    entryArray[0] = Map.entry(com.google.android.gms.internal.measurement.zzkp.zzb, zzoe2);
                    zzoe zzoe3 = zzoe.zzd;
                    entryArray[1] = Map.entry(com.google.android.gms.internal.measurement.zzkp.zzc, zzoe3);
                    entryArray[2] = Map.entry(com.google.android.gms.internal.measurement.zzkp.zzd, zzoe2);
                    entryArray[3] = Map.entry(com.google.android.gms.internal.measurement.zzkp.zze, zzoe2);
                    entryArray[4] = Map.entry(com.google.android.gms.internal.measurement.zzkp.zzh, zzoe3);
                    entryArray[5] = Map.entry(com.google.android.gms.internal.measurement.zzkp.zzj, zzoe3);
                    entryArray[6] = Map.entry(com.google.android.gms.internal.measurement.zzkp.zzk, zzoe3);
                    immutableMap = ImmutableMap.ofEntries((Map.Entry[])entryArray);
                    stringArray = ImmutableSet.of((Object)"CH");
                    cArray = new char[5];
                    bl = object.contains("IABTCF_TCString");
                    n5 = zzof.zzb((SharedPreferences)object, "IABTCF_CmpSdkID");
                    n4 = zzof.zzb((SharedPreferences)object, "IABTCF_PolicyVersion");
                    n3 = zzof.zzb((SharedPreferences)object, "IABTCF_gdprApplies");
                    n2 = zzof.zzb((SharedPreferences)object, "IABTCF_PurposeOneTreatment");
                    n = zzof.zzb((SharedPreferences)object, "IABTCF_EnableAdvertiserConsentMode");
                    string2 = zzof.zza((SharedPreferences)object, "IABTCF_PublisherCC");
                    zzoe3 = ImmutableMap.builder();
                    for (com.google.android.gms.internal.measurement.zzkp zzkp2 : immutableMap.keySet()) {
                        void var1_13;
                        int n7 = zzkp2.zza();
                        int n8 = String.valueOf(n7).length();
                        StringBuilder stringBuilder = new StringBuilder(n8 + 28);
                        stringBuilder.append("IABTCF_PublisherRestrictions");
                        stringBuilder.append(n7);
                        String string5 = zzof.zza((SharedPreferences)object, stringBuilder.toString());
                        if (TextUtils.isEmpty((CharSequence)string5) || string5.length() < 755) {
                            com.google.android.gms.internal.measurement.zzkq zzkq2 = com.google.android.gms.internal.measurement.zzkq.zzd;
                        } else {
                            int n9 = Character.digit(string5.charAt(754), 10);
                            if (n9 < 0 || n9 > com.google.android.gms.internal.measurement.zzkq.values().length) {
                                com.google.android.gms.internal.measurement.zzkq zzkq3 = com.google.android.gms.internal.measurement.zzkq.zza;
                            } else {
                                switch (n9) {
                                    default: {
                                        com.google.android.gms.internal.measurement.zzkq zzkq4 = com.google.android.gms.internal.measurement.zzkq.zzd;
                                        break;
                                    }
                                    case 2: {
                                        com.google.android.gms.internal.measurement.zzkq zzkq5 = com.google.android.gms.internal.measurement.zzkq.zzc;
                                        break;
                                    }
                                    case 1: {
                                        com.google.android.gms.internal.measurement.zzkq zzkq6 = com.google.android.gms.internal.measurement.zzkq.zzb;
                                        break;
                                    }
                                    case 0: {
                                        com.google.android.gms.internal.measurement.zzkq zzkq7 = com.google.android.gms.internal.measurement.zzkq.zza;
                                    }
                                }
                            }
                        }
                        zzoe3.put((Object)zzkp2, var1_13);
                    }
                    unmodifiableIterator = zzoe3.buildOrThrow();
                    string = zzof.zza((SharedPreferences)object, "IABTCF_PurposeConsents");
                    String string6 = zzof.zza((SharedPreferences)object, "IABTCF_VendorConsents");
                    if (TextUtils.isEmpty((CharSequence)string6)) break block35;
                    if (string6.length() >= 755) {
                        if (string6.charAt(754) == '1') {
                            boolean bl3 = true;
                            break block32;
                        } else {
                            boolean bl4 = false;
                        }
                        break block32;
                    } else {
                        boolean bl5 = false;
                    }
                    break block32;
                }
                boolean bl6 = false;
            }
            String string7 = zzof.zza((SharedPreferences)object, "IABTCF_PurposeLegitimateInterests");
            bl2 = !TextUtils.isEmpty((CharSequence)(object = zzof.zza((SharedPreferences)object, "IABTCF_VendorLegitimateInterests"))) ? (((String)object).length() >= 755 ? ((String)object).charAt(754) == '1' : false) : false;
            cArray[0] = 50;
            for (int i = 1; i > 5; ++i) {
                cArray[i] = 48;
            }
            zzod zzod3 = new zzod(zzof.zzd(immutableMap, (ImmutableMap)unmodifiableIterator, (ImmutableSet)stringArray, cArray, n5, n, n3, n4, n2, string2, string, string7, (boolean)var1_22, bl2, bl));
        }
        zzic2.zzaV().zzk().zzb("Tcf preferences read", var1_24);
        if (zzic2.zzc().zzp(null, (zzfx)stringArray2)) {
            zzhh zzhh2 = zzic2.zzd();
            zzhh2.zzg();
            Object object = zzhh2.zzd().getString("stored_tcf_param", "");
            Bundle bundle = new HashMap();
            if (TextUtils.isEmpty((CharSequence)object)) {
                object = new zzod((Map)bundle);
            } else {
                stringArray2 = ((String)object).split(";");
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    stringArray = stringArray2[i].split("=");
                    if (stringArray.length < 2 || !zzof.zza.contains((Object)stringArray[0])) continue;
                    bundle.put(stringArray[0], stringArray[1]);
                }
                object = new zzod((Map)bundle);
            }
            if (!zzic2.zzd().zzm((zzod)var1_24)) return;
            bundle = var1_24.zzb();
            zzic2.zzaV().zzk().zzb("Consent generated from Tcf", bundle);
            if (bundle != Bundle.EMPTY) {
                this.zzp(bundle, -30, zzic2.zzaZ().currentTimeMillis());
            }
            bundle = new Bundle();
            object = var1_24.zzd((zzod)object);
            bundle.putString("_tcfm", (String)object);
            object = var1_24.zzc();
            bundle.putString("_tcfd2", (String)object);
            String string = var1_24.zze();
            bundle.putString("_tcfd", string);
            this.zzF("auto", "_tcf", bundle);
            return;
        }
        if (!zzic2.zzd().zzm((zzod)var1_24)) {
            return;
        }
        Bundle bundle = var1_24.zzb();
        zzic2.zzaV().zzk().zzb("Consent generated from Tcf", bundle);
        if (bundle != Bundle.EMPTY) {
            this.zzp(bundle, -30, zzic2.zzaZ().currentTimeMillis());
        }
        bundle = new Bundle();
        String string = var1_24.zze();
        bundle.putString("_tcfd", string);
        this.zzF("auto", "_tcf", bundle);
    }

    @WorkerThread
    public final void zzE() {
        ((zzje)this).zzg();
        zzic zzic2 = this.zzu;
        zzic2.zzaV().zzj().zza("Register tcfPrefChangeListener.");
        if (this.zzs == null) {
            zzic zzic3 = this.zzu;
            this.zzt = new zzkb(this, zzic3);
            this.zzs = new zzle(this);
        }
        zzic2.zzd().zze().registerOnSharedPreferenceChangeListener(this.zzs);
    }

    @WorkerThread
    final void zzF(String string, String string2, Bundle bundle) {
        ((zzje)this).zzg();
        zzlj zzlj2 = this;
        zzlj2.zzG(string, string2, zzlj2.zzu.zzaZ().currentTimeMillis(), bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzG(String string, String string2, long l, Bundle bundle) {
        ((zzje)this).zzg();
        boolean bl = this.zzd != null ? zzpp.zzZ(string2) : true;
        this.zzH(string, string2, l, bundle, true, bl, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zzH(String string, String string2, long l, Bundle object, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzic zzic2;
        Object object2;
        block54: {
            block53: {
                Bundle bundle;
                int n;
                long l2;
                block51: {
                    boolean bl4;
                    block52: {
                        Preconditions.checkNotEmpty((String)string);
                        Preconditions.checkNotNull((Object)object);
                        ((zzje)this).zzg();
                        this.zzb();
                        Object object3 = this.zzu;
                        if (!((zzic)object3).zzB()) {
                            this.zzu.zzaV().zzj().zza("Event not sent since app measurement is disabled");
                            return;
                        }
                        object2 = this.zzu.zzv().zzp();
                        if (object2 != null && !object2.contains(string2)) {
                            this.zzu.zzaV().zzj().zzc("Dropping non-safelisted event. event name, origin", string2, string);
                            return;
                        }
                        if (!this.zzf) {
                            GenericDeclaration genericDeclaration;
                            this.zzf = true;
                            boolean bl5 = ((zzic)object3).zzp();
                            if (bl5) {
                                genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                                genericDeclaration = Class.forName((String)((Object)genericDeclaration));
                            }
                            genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                            object2 = this.zzu.zzaY();
                            genericDeclaration = Class.forName((String)((Object)genericDeclaration), true, object2.getClassLoader());
                            try {
                                genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("initialize", Context.class);
                                object2 = new Object[1];
                                zzic2 = this.zzu.zzaY();
                                object2[0] = zzic2;
                                ((Method)genericDeclaration).invoke(null, object2);
                            }
                            catch (Exception exception) {
                                try {
                                    this.zzu.zzaV().zze().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    this.zzu.zzaV().zzi().zza("Tag Manager is not found and thus will not be used");
                                }
                            }
                        }
                        if (!(object2 = this.zzu).zzc().zzp(null, zzfy.zzbf) && "_cmp".equals(string2) && object.containsKey("gclid")) {
                            object2.zzaU();
                            object3 = object.getString("gclid");
                            l2 = object2.zzaZ().currentTimeMillis();
                            this.zzN("auto", "_lgclid", object3, l2);
                        }
                        object2.zzaU();
                        if (bl && zzpp.zzaf(string2)) {
                            object2.zzk().zzI((Bundle)object, object2.zzd().zzt.zza());
                        }
                        if (!bl3) {
                            object2.zzaU();
                            if (!"_iap".equals(string2)) {
                                int n2;
                                zzic2 = this.zzu;
                                object3 = zzic2.zzk();
                                if (!((zzpp)object3).zzj("event", string2)) {
                                    n2 = 2;
                                } else if (!((zzpp)object3).zzl("event", zzjm.zza, zzjm.zzb, string2)) {
                                    n2 = 13;
                                } else {
                                    ((zzje)object3).zzu.zzc();
                                    n2 = !((zzpp)object3).zzm("event", 40, string2) ? 2 : 0;
                                }
                                if (n2 != 0) {
                                    string = object2.zzl().zza(string2);
                                    object2.zzaV().zzd().zzb("Invalid public event name. Event will not be logged (FE)", string);
                                    zzpp zzpp2 = zzic2.zzk();
                                    zzic2.zzc();
                                    object = zzpp2.zzC(string2, 40, true);
                                    int n3 = string2 != null ? string2.length() : 0;
                                    zzic2.zzk().zzN(this.zzv, null, n2, "_ev", (String)object, n3);
                                    return;
                                }
                            }
                        }
                        object2.zzaU();
                        zzic2 = this.zzu;
                        zzlu zzlu2 = zzic2.zzs().zzh(false);
                        if (zzlu2 != null && !object.containsKey("_sc")) {
                            zzlu2.zzd = true;
                        }
                        bl4 = bl ? !bl3 : false;
                        zzpp.zzav(zzlu2, (Bundle)object, bl4);
                        bl4 = "am".equals(string);
                        n = zzpp.zzZ(string2);
                        if (!bl) break block52;
                        if (this.zzd != null) {
                            if (n == 0) {
                                if (!bl4) {
                                    String string4 = object2.zzl().zza(string2);
                                    String string5 = object2.zzl().zze((Bundle)object);
                                    object2.zzaV().zzj().zzc("Passing event to registered event handler (FE)", string4, string5);
                                    Preconditions.checkNotNull((Object)this.zzd);
                                    this.zzd.interceptEvent(string, string2, (Bundle)object, l);
                                    return;
                                }
                                bl = true;
                                break block51;
                            } else {
                                bl = bl4;
                            }
                            break block51;
                        } else {
                            bl = bl4;
                        }
                        break block51;
                    }
                    bl = bl4;
                }
                if (!(bundle = this.zzu).zzH()) break block53;
                n = object2.zzk().zzn(string2);
                if (n != 0) {
                    string = object2.zzl().zza(string2);
                    object2.zzaV().zzd().zzb("Invalid event name. Event will not be logged (FE)", string);
                    zzpp zzpp3 = object2.zzk();
                    object2.zzc();
                    object = zzpp3.zzC(string2, 40, true);
                    int n4 = string2 != null ? string2.length() : 0;
                    bundle.zzk().zzN(this.zzv, string3, n, "_ev", (String)object, n4);
                    return;
                }
                Object object4 = "_o";
                object4 = CollectionUtils.listOf((Object[])new String[]{object4, "_sn", "_sc", "_si"});
                object4 = object2.zzk().zzF(string3, string2, (Bundle)object, (List)object4, bl3);
                Preconditions.checkNotNull((Object)object4);
                object2.zzaU();
                if (zzic2.zzs().zzh(false) != null && "_ae".equals(string2)) {
                    object = zzic2.zzh().zzb;
                    long l3 = ((zzoa)object).zzc.zzu.zzaZ().elapsedRealtime();
                    long l4 = l3 - ((zzoa)object).zzb;
                    ((zzoa)object).zzb = l3;
                    if (l4 > 0L) {
                        object2.zzk().zzak((Bundle)object4, l4);
                    }
                }
                if (!"auto".equals(string) && "_ssr".equals(string2)) {
                    zzjg zzjg2 = object2.zzk();
                    object = object4.getString("_ffr");
                    if (Strings.isEmptyOrWhitespace((String)object)) {
                        object = null;
                    } else if (object != null) {
                        object = ((String)object).trim();
                    }
                    zzjg2 = ((zzje)zzjg2).zzu;
                    if (Objects.equals(object, ((zzic)zzjg2).zzd().zzq.zza())) {
                        ((zzic)zzjg2).zzaV().zzj().zza("Not logging duplicate session_start_with_rollout event");
                        return;
                    }
                    ((zzic)zzjg2).zzd().zzq.zzb((String)object);
                } else if ("_ae".equals(string2) && !TextUtils.isEmpty((CharSequence)(object = object2.zzk().zzu.zzd().zzq.zza()))) {
                    object4.putString("_ffr", (String)object);
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(object4);
                int n5 = object2.zzc().zzp(null, zzfy.zzaU) ? zzic2.zzh().zzi() : object2.zzd().zzn.zza();
                if (object2.zzd().zzk.zza() > 0L && object2.zzd().zzp(l) && n5 != 0) {
                    object2.zzaV().zzk().zza("Current session is expired, remove the session number, ID, and engagement time");
                    l2 = object2.zzaZ().currentTimeMillis();
                    this.zzN("auto", "_sid", null, l2);
                    l2 = object2.zzaZ().currentTimeMillis();
                    this.zzN("auto", "_sno", null, l2);
                    l2 = object2.zzaZ().currentTimeMillis();
                    this.zzN("auto", "_se", null, l2);
                    object2.zzd().zzl.zzb(0L);
                }
                if (object4.getLong("extend_session", 0L) == 1L) {
                    object2.zzaV().zzk().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
                    bundle.zzh().zza.zzb(l, true);
                }
                bundle = new ArrayList(object4.keySet());
                Collections.sort(bundle);
                int n6 = bundle.size();
                for (n5 = 0; n5 < n6; ++n5) {
                    String string6 = (String)bundle.get(n5);
                    if (string6 == null) continue;
                    object2.zzk();
                    Bundle[] bundleArray = object4.get(string6);
                    if (bundleArray instanceof Bundle) {
                        bundleArray = new Bundle[]{(Bundle)bundleArray};
                    } else if (bundleArray instanceof Parcelable[]) {
                        Parcelable[] parcelableArray = (Parcelable[])bundleArray;
                        bundleArray = (Bundle[])Arrays.copyOf(parcelableArray, parcelableArray.length, Bundle[].class);
                    } else if (bundleArray instanceof ArrayList) {
                        ArrayList arrayList2 = (ArrayList)bundleArray;
                        bundleArray = arrayList2.toArray(new Bundle[arrayList2.size()]);
                    } else {
                        bundleArray = null;
                    }
                    if (bundleArray == null) continue;
                    object4.putParcelableArray(string6, (Parcelable[])bundleArray);
                }
                for (n5 = 0; n5 < arrayList.size(); ++n5) {
                    bundle = (Bundle)arrayList.get(n5);
                    Object object5 = n5 != 0 ? "_ep" : string2;
                    bundle.putString("_o", string);
                    if (bl2) {
                        bundle = object2.zzk().zzab(bundle, null);
                    }
                    object4 = new zzbg((String)object5, new zzbe(bundle), string, l);
                    zzic2.zzt().zzn((zzbg)((Object)object4), string3);
                    if (bl) continue;
                    object5 = this.zze.iterator();
                    while (object5.hasNext()) {
                        ((zzjq)object5.next()).onEvent(string, string2, new Bundle(bundle), l);
                    }
                }
                object2.zzaU();
                if (zzic2.zzs().zzh(false) != null && "_ae".equals(string2)) break block54;
            }
            return;
        }
        l = object2.zzaZ().elapsedRealtime();
        zzic2.zzh().zzb.zzd(true, true, l);
    }

    public final void zzI(String string, String string2, Bundle bundle, String string3) {
        zzic.zzL();
        long l = this.zzu.zzaZ().currentTimeMillis();
        this.zzJ("auto", string2, l, bundle, false, true, true, string3);
    }

    protected final void zzJ(String string, String string2, long l, Bundle object2, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle = new Bundle(object2);
        for (Object object2 : bundle.keySet()) {
            Object object3;
            Object object4 = bundle.get((String)object2);
            if (object4 instanceof Bundle) {
                bundle.putBundle((String)object2, new Bundle((Bundle)object4));
                continue;
            }
            if (object4 instanceof Parcelable[]) {
                object4 = (Parcelable[])object4;
                for (int i = 0; i < ((Parcelable[])object4).length; ++i) {
                    object3 = object4[i];
                    if (!(object3 instanceof Bundle)) continue;
                    object4[i] = new Bundle((Bundle)object3);
                }
                continue;
            }
            if (!(object4 instanceof List)) continue;
            object4 = (List)object4;
            for (int i = 0; i < object4.size(); ++i) {
                object3 = object4.get(i);
                if (!(object3 instanceof Bundle)) continue;
                object4.set(i, new Bundle((Bundle)object3));
            }
        }
        this.zzu.zzaW().zzj(new zzkc(this, string, string2, l, bundle, bl, bl2, bl3, string3));
    }

    public final void zzK(String string, String string2, Object object, boolean bl) {
        long l = this.zzu.zzaZ().currentTimeMillis();
        this.zzL("auto", "_ldl", object, true, l);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzL(String object, String string, Object object2, boolean bl, long l) {
        void var5_15;
        Object object3;
        void var4_8;
        if (bl) {
            int n = ((zzje)object3).zzu.zzk().zzp(string);
        } else {
            zzpp zzpp2 = ((zzje)object3).zzu.zzk();
            if (!zzpp2.zzj("user property", string)) {
                int n = 6;
            } else if (!zzpp2.zzl("user property", zzjo.zza, null, string)) {
                int n = 15;
            } else {
                zzpp2.zzu.zzc();
                if (!zzpp2.zzm("user property", 24, string)) {
                    int n = 6;
                } else {
                    boolean bl2 = false;
                }
            }
        }
        if (var4_8 != false) {
            object = ((zzje)object3).zzu;
            zzpp zzpp3 = ((zzic)object).zzk();
            ((zzic)object).zzc();
            object2 = zzpp3.zzC(string, 24, true);
            int n = string != null ? string.length() : 0;
            object3 = ((zzlj)object3).zzv;
            ((zzlj)object3).zzu.zzk().zzN((zzpo)object3, null, (int)var4_8, "_ev", (String)object2, n);
            return;
        }
        if (object == null) {
            object = "app";
        }
        if (object2 == null) {
            ((zzlj)object3).zzM((String)object, string, (long)var5_15, null);
            return;
        }
        zzic zzic2 = ((zzje)object3).zzu;
        int n = zzic2.zzk().zzK(string, object2);
        if (n != 0) {
            zzpp zzpp4 = zzic2.zzk();
            zzic2.zzc();
            string = zzpp4.zzC(string, 24, true);
            int n2 = object2 instanceof String || object2 instanceof CharSequence ? object2.toString().length() : 0;
            object3 = ((zzlj)object3).zzv;
            ((zzlj)object3).zzu.zzk().zzN((zzpo)object3, null, n, "_ev", string, n2);
            return;
        }
        object2 = zzic2.zzk().zzL(string, object2);
        if (object2 != null) {
            ((zzlj)object3).zzM((String)object, string, (long)var5_15, object2);
            return;
        }
    }

    final void zzM(String string, String string2, long l, Object object) {
        this.zzu.zzaW().zzj(new zzkd(this, string, string2, object, l));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzN(String string, String string2, Object object, long l) {
        void var4_5;
        Object object2;
        Long l2;
        String string3;
        void var1_2;
        Preconditions.checkNotEmpty((String)var1_2);
        Preconditions.checkNotEmpty((String)string3);
        ((zzje)this).zzg();
        this.zzb();
        if ("allow_personalized_ads".equals(string3)) {
            if (l2 instanceof String && !TextUtils.isEmpty((CharSequence)(object2 = (String)((Object)l2)))) {
                string3 = ((String)object2).toLowerCase(Locale.ENGLISH);
                long l3 = true != "false".equals(string3) ? 0L : 1L;
                l2 = l3;
                object2 = this.zzu.zzd().zzh;
                string3 = l2 == 1L ? "true" : "false";
                ((zzhg)object2).zzb(string3);
                string3 = "_npa";
            } else if (l2 == null) {
                this.zzu.zzd().zzh.zzb("unset");
                string3 = "_npa";
            }
            this.zzu.zzaV().zzk().zzc("Setting user property(FE)", "non_personalized_ads(_npa)", l2);
        }
        if (!((zzic)(object2 = this.zzu)).zzB()) {
            this.zzu.zzaV().zzk().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!((zzic)object2).zzH()) {
            return;
        }
        zzpl zzpl2 = new zzpl(string3, (long)var4_5, l2, (String)var1_2);
        this.zzu.zzt().zzA(zzpl2);
    }

    public final List zzO(boolean bl) {
        ((zzg)object).zzb();
        zzic zzic2 = ((zzje)object).zzu;
        zzic2.zzaV().zzk().zza("Getting user properties (FE)");
        if (!zzic2.zzaW().zze()) {
            zzic2.zzaU();
            if (zzae.zza()) {
                zzic2.zzaV().zzb().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            AtomicReference atomicReference = new AtomicReference();
            zzkf zzkf2 = new zzkf((zzlj)object, atomicReference, bl);
            ((zzlj)object).zzu.zzaW().zzk(atomicReference, 5000L, "get user properties", zzkf2);
            Object object = (List)atomicReference.get();
            if (object == null) {
                object = bl;
                zzic2.zzaV().zzb().zzb("Timed out waiting for get user properties, includeInternal", object);
                return Collections.emptyList();
            }
            return object;
        }
        zzic2.zzaV().zzb().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map zzP(String string, String object, boolean bl) {
        void var3_5;
        zzic zzic2 = ((zzje)object2).zzu;
        if (zzic2.zzaW().zze()) {
            zzic2.zzaV().zzb().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        zzic2.zzaU();
        if (zzae.zza()) {
            zzic2.zzaV().zzb().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        zzkl zzkl2 = new zzkl((zzlj)object2, atomicReference, null, string, (String)object, (boolean)var3_5);
        ((zzlj)object2).zzu.zzaW().zzk(atomicReference, 5000L, "get user properties", zzkl2);
        Object object2 = (List)atomicReference.get();
        if (object2 == null) {
            object2 = (boolean)var3_5;
            zzic2.zzaV().zzb().zzb("Timed out waiting for handle get user properties, includeInternal", object2);
            return Collections.emptyMap();
        }
        string = new ArrayMap(object2.size());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            zzpl zzpl2 = (zzpl)((Object)object2.next());
            Object object3 = zzpl2.zza();
            if (object3 == null) continue;
            string.put(zzpl2.zzb, object3);
        }
        return string;
    }

    public final String zzQ() {
        return (String)this.zzg.get();
    }

    final void zzR(String string) {
        this.zzg.set(string);
    }

    @WorkerThread
    public final void zzS() {
        ((zzje)this).zzg();
        zzic zzic2 = this.zzu;
        if (!zzic2.zzd().zzo.zza()) {
            long l = zzic2.zzd().zzp.zza();
            zzic2.zzd().zzp.zzb(l + 1L);
            zzic2.zzc();
            if (l >= 5L) {
                zzic2.zzaV().zze().zza("Permanently failed to retrieve Deferred Deep Link. Reached maximum retries.");
                zzic2.zzd().zzo.zzb(true);
                return;
            }
            if (this.zzr == null) {
                zzic2 = this.zzu;
                this.zzr = new zzkg(this, zzic2);
            }
            this.zzr.zzb(0L);
            return;
        }
        zzic2.zzaV().zzj().zza("Deferred Deep Link already retrieved. Not fetching again.");
    }

    public final void zzT(long l) {
        this.zzg.set(null);
        this.zzu.zzaW().zzj(new zzkh(this, l));
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzU() {
        String string;
        zzic zzic2;
        block6: {
            block5: {
                ((zzje)this).zzg();
                this.zzb();
                if (!this.zzu.zzH()) break block5;
                zzic2 = this.zzu;
                zzal zzal2 = zzic2.zzc();
                zzal2.zzu.zzaU();
                Object object = zzal2.zzr("google_analytics_deferred_deep_link_enabled");
                if (object != null && ((Boolean)object).booleanValue()) {
                    zzic2.zzaV().zzj().zza("Deferred Deep Link feature enabled.");
                    zzic2.zzaW().zzj(new zzlh(this));
                }
                this.zzu.zzt().zzE();
                this.zzc = false;
                object = zzic2.zzd();
                ((zzje)object).zzg();
                string = ((zzhh)object).zzd().getString("previous_os_version", null);
                ((zzje)object).zzu.zzu().zzw();
                String string2 = Build.VERSION.RELEASE;
                if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
                    SharedPreferences.Editor editor = ((zzhh)object).zzd().edit();
                    editor.putString("previous_os_version", string2);
                    editor.apply();
                }
                if (TextUtils.isEmpty((CharSequence)string)) break block5;
                zzic2.zzu().zzw();
                if (!string.equals(Build.VERSION.RELEASE)) break block6;
            }
            return;
        }
        zzic2 = new Bundle();
        zzic2.putString("_po", string);
        this.zzF("auto", "_ou", (Bundle)zzic2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzV(zzjp zzjp2) {
        zzjp zzjp3;
        ((zzje)this).zzg();
        this.zzb();
        if (zzjp2 != null && zzjp2 != (zzjp3 = this.zzd)) {
            boolean bl = zzjp3 == null;
            Preconditions.checkState((boolean)bl, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzjp2;
    }

    public final void zzW(zzjq zzjq2) {
        this.zzb();
        Preconditions.checkNotNull((Object)zzjq2);
        if (!this.zze.add(zzjq2)) {
            this.zzu.zzaV().zze().zza("OnEventListener already registered");
            return;
        }
    }

    public final void zzX(zzjq zzjq2) {
        this.zzb();
        Preconditions.checkNotNull((Object)zzjq2);
        if (!this.zze.remove(zzjq2)) {
            this.zzu.zzaV().zze().zza("OnEventListener had not been registered");
            return;
        }
    }

    public final int zzY(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzu.zzc();
        return 25;
    }

    public final void zzZ(Bundle bundle) {
        zzlj zzlj2 = this;
        zzlj2.zzaa(bundle, zzlj2.zzu.zzaZ().currentTimeMillis());
    }

    public final void zzaa(Bundle object, long l) {
        Object object2;
        Preconditions.checkNotNull((Object)object);
        Bundle bundle = new Bundle(object);
        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
            ((zzje)object2).zzu.zzaV().zze().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle.remove("app_id");
        Preconditions.checkNotNull((Object)bundle);
        zzjh.zzb((Bundle)bundle, (String)"app_id", String.class, null);
        zzjh.zzb((Bundle)bundle, (String)"origin", String.class, null);
        zzjh.zzb((Bundle)bundle, (String)"name", String.class, null);
        zzjh.zzb((Bundle)bundle, (String)"value", Object.class, null);
        zzjh.zzb((Bundle)bundle, (String)"trigger_event_name", String.class, null);
        object = 0L;
        zzjh.zzb((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)object);
        zzjh.zzb((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
        zzjh.zzb((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
        zzjh.zzb((Bundle)bundle, (String)"triggered_event_name", String.class, null);
        zzjh.zzb((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
        zzjh.zzb((Bundle)bundle, (String)"time_to_live", Long.class, (Object)object);
        zzjh.zzb((Bundle)bundle, (String)"expired_event_name", String.class, null);
        zzjh.zzb((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        object = bundle.getString("name");
        Object object3 = bundle.get("value");
        zzic zzic2 = ((zzje)object2).zzu;
        if (zzic2.zzk().zzp((String)object) == 0) {
            if (zzic2.zzk().zzK((String)object, object3) == 0) {
                Object object4 = zzic2.zzk().zzL((String)object, object3);
                if (object4 == null) {
                    object2 = zzic2.zzl().zzc((String)object);
                    zzic2.zzaV().zzb().zzc("Unable to normalize conditional user property value", object2, object3);
                    return;
                }
                zzjh.zza((Bundle)bundle, (Object)object4);
                long l2 = bundle.getLong("trigger_timeout");
                if (!TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) {
                    zzic2.zzc();
                    if (l2 > 15552000000L || l2 < 1L) {
                        object2 = zzic2.zzl().zzc((String)object);
                        object = l2;
                        zzic2.zzaV().zzb().zzc("Invalid conditional user property timeout", object2, object);
                        return;
                    }
                }
                long l3 = bundle.getLong("time_to_live");
                zzic2.zzc();
                if (l3 > 15552000000L || l3 < 1L) {
                    object2 = zzic2.zzl().zzc((String)object);
                    object = l3;
                    zzic2.zzaV().zzb().zzc("Invalid conditional user property time to live", object2, object);
                    return;
                }
                zzic2.zzaW().zzj(new zzki((zzlj)object2, bundle));
                return;
            }
            object2 = zzic2.zzl().zzc((String)object);
            zzic2.zzaV().zzb().zzc("Invalid conditional user property value", object2, object3);
            return;
        }
        object2 = zzic2.zzl().zzc((String)object);
        zzic2.zzaV().zzb().zzb("Invalid conditional user property name", object2);
    }

    public final void zzab(String string, String string2, Bundle bundle) {
        zzic zzic2 = this.zzu;
        long l = zzic2.zzaZ().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle2 = new Bundle();
        bundle2.putString("name", string);
        bundle2.putLong("creation_timestamp", l);
        if (string2 != null) {
            bundle2.putString("expired_event_name", string2);
            bundle2.putBundle("expired_event_params", bundle);
        }
        zzic2.zzaW().zzj(new zzkj(this, bundle2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList zzac(String string, String string2) {
        zzic zzic2 = ((zzje)((Object)arrayList)).zzu;
        if (zzic2.zzaW().zze()) {
            zzic2.zzaV().zzb().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList(0);
        }
        zzic2.zzaU();
        if (zzae.zza()) {
            zzic2.zzaV().zzb().zza("Cannot get conditional user properties from main thread");
            return new ArrayList(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        zzkk zzkk2 = new zzkk((zzlj)((Object)arrayList), atomicReference, null, string, string2);
        ((zzlj)((Object)arrayList)).zzu.zzaW().zzk(atomicReference, 5000L, "get conditional user properties", zzkk2);
        ArrayList arrayList = (List)atomicReference.get();
        if (arrayList != null) return zzpp.zzas(arrayList);
        zzic2.zzaV().zzb().zzb("Timed out waiting for get conditional user properties", null);
        return new ArrayList();
    }

    public final String zzad() {
        zzlu zzlu2 = ((zzlj)((Object)zzlu2)).zzu.zzs().zzl();
        if (zzlu2 != null) {
            return zzlu2.zza;
        }
        return null;
    }

    public final String zzae() {
        zzlu zzlu2 = ((zzlj)((Object)zzlu2)).zzu.zzs().zzl();
        if (zzlu2 != null) {
            return zzlu2.zzb;
        }
        return null;
    }

    public final String zzaf() {
        try {
            Context context = ((zzje)((Object)string2)).zzu.zzaY();
            String string = ((zzlj)((Object)string2)).zzu.zzq();
            String string2 = zzlt.zza((Context)context, (String)"google_app_id", (String)string);
            return string2;
        }
        catch (IllegalStateException illegalStateException) {
            ((zzlj)((Object)string2)).zzu.zzaV().zzb().zzb("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzag(SharedPreferences object, String string) {
        object = this.zzu;
        if (!((zzic)object).zzc().zzp(null, zzfy.zzaZ)) {
            if (!Objects.equals(string, "IABTCF_TCString")) return;
            ((zzic)object).zzaV().zzk().zza("IABTCF_TCString change picked up in listener.");
            ((zzay)Preconditions.checkNotNull((Object)this.zzt)).zzb(500L);
            return;
        }
        if (!(Objects.equals(string, "IABTCF_TCString") || Objects.equals(string, "IABTCF_gdprApplies") || Objects.equals(string, "IABTCF_EnableAdvertiserConsentMode"))) {
            return;
        }
        ((zzic)object).zzaV().zzk().zza("IABTCF_TCString change picked up in listener.");
        ((zzay)Preconditions.checkNotNull((Object)this.zzt)).zzb(500L);
    }

    /*
     * Unable to fully structure code
     */
    final /* synthetic */ void zzah(Bundle var1_1) {
        block9: {
            if (var1_1.isEmpty()) {
                var2_2 = var1_1;
lbl3:
                // 3 sources

                while (true) {
                    var3_4 = this.zzu;
                    var3_4.zzd().zzt.zzb((Bundle)var2_2);
                    if (!var1_1.isEmpty() || var3_4.zzc().zzp(null, zzfy.zzaW)) {
                        this.zzu.zzt().zzH((Bundle)var2_2);
                        return;
                    }
                    return;
                }
            }
            var3_4 = this.zzu;
            var4_5 = new Bundle(var3_4.zzd().zzt.zza());
            for (String var5_6 : var1_1.keySet()) {
                var6_8 = var1_1.get(var5_6);
                if (!(var6_8 == null || var6_8 instanceof String || var6_8 instanceof Long || var6_8 instanceof Double)) {
                    if (var3_4.zzk().zzt(var6_8)) {
                        var3_4.zzk().zzN(this.zzv, null, 27, null, null, 0);
                    }
                    var3_4.zzaV().zzh().zzc("Invalid default event parameter type. Name, value", var5_6, var6_8);
                    continue;
                }
                if (zzpp.zzZ(var5_6)) {
                    var3_4.zzaV().zzh().zzb("Invalid default event parameter name. Name", var5_6);
                    continue;
                }
                if (var6_8 == null) {
                    var4_5.remove(var5_6);
                    continue;
                }
                var7_9 = var3_4.zzc().zze(null, false);
                if (!var3_4.zzk().zzu("param", var5_6, var7_9, var6_8)) continue;
                var3_4.zzk().zzM(var4_5, var5_6, var6_8);
            }
            var3_4.zzk();
            var5_7 = var3_4.zzc().zzc();
            if (var4_5.size() > var5_7) break block9;
            var2_2 = var4_5;
            ** GOTO lbl3
        }
        var6_8 = new TreeSet<E>(var4_5.keySet()).iterator();
        var2_3 = 0;
        while (var6_8.hasNext()) {
            var7_10 = (String)var6_8.next();
            if (++var2_3 <= var5_7) continue;
            var4_5.remove(var7_10);
        }
        var3_4.zzk().zzN(this.zzv, null, 26, null, null, 0);
        var3_4.zzaV().zzh().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        var2_2 = var4_5;
        ** while (true)
    }

    final /* synthetic */ void zzai(int n) {
        if (this.zzk == null) {
            zzic zzic2 = this.zzu;
            this.zzk = new zzjx(this, zzic2);
        }
        this.zzk.zzb((long)n * 1000L);
    }

    final /* synthetic */ void zzaj(Boolean bl, boolean bl2) {
        this.zzas(bl, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzak(zzjl zzjl2, long l, boolean bl, boolean bl2) {
        ((zzje)((Object)n2)).zzg();
        ((zzg)((Object)n2)).zzb();
        zzic zzic2 = ((zzje)((Object)n2)).zzu;
        Object object = zzic2.zzd().zzl();
        if (l <= ((zzlj)((Object)n2)).zzq && zzjl.zzu(((zzjl)object).zzb(), zzjl2.zzb())) {
            zzic2.zzaV().zzi().zzb("Dropped out-of-date consent setting, proposed settings", zzjl2);
            return;
        }
        object = zzic2.zzd();
        zzic cfr_ignored_0 = ((zzje)object).zzu;
        ((zzje)object).zzg();
        int n = zzjl2.zzb();
        if (!((zzhh)object).zzk(n)) {
            Integer n2 = zzjl2.zzb();
            zzic2.zzaV().zzi().zzb("Lower precedence consent source ignored, proposed source", n2);
            return;
        }
        zzic zzic3 = ((zzf)((Object)n2)).zzu;
        SharedPreferences.Editor editor = ((zzhh)object).zzd().edit();
        object = zzjl2.zzl();
        editor.putString("consent_settings", (String)object);
        editor.putInt("consent_source", n);
        editor.apply();
        zzic2.zzaV().zzk().zzb("Setting storage consent(FE)", zzjl2);
        ((zzlj)((Object)n2)).zzq = l;
        if (zzic3.zzt().zzP()) {
            zzic3.zzt().zzk(bl);
        } else {
            zzic3.zzt().zzj(bl);
        }
        if (bl2) {
            zzic3.zzt().zzC(new AtomicReference());
            return;
        }
    }

    final /* synthetic */ void zzal() {
        this.zzat();
    }

    final /* synthetic */ void zzam(boolean bl) {
        this.zzi = false;
    }

    final /* synthetic */ int zzan() {
        return this.zzj;
    }

    final /* synthetic */ void zzao(int n) {
        this.zzj = n;
    }

    final /* synthetic */ zzay zzap() {
        return this.zzr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ int zzaq(Throwable throwable) {
        String string = throwable.getMessage();
        this.zzn = false;
        if (string == null) {
            return 2;
        }
        if (throwable instanceof IllegalStateException || string.contains("garbage collected") || throwable.getClass().getSimpleName().equals("ServiceUnavailableException")) {
            if (!string.contains("Background")) {
                return 1;
            }
            this.zzn = true;
            return 1;
        }
        if (!(throwable instanceof SecurityException)) return 2;
        if (!string.endsWith("READ_DEVICE_CONFIG")) return 3;
        return 2;
    }
}

