/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzin;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzpp;

public final class zzlq
extends zzg {
    private JobScheduler zza;

    public zzlq(zzic zzic2) {
        super(zzic2);
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    @Override
    @WorkerThread
    @TargetApi(value=24)
    protected final void zzf() {
        this.zza = (JobScheduler)this.zzu.zzaY().getSystemService("jobscheduler");
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=24)
    @WorkerThread
    public final void zzh(long l) {
        Object object;
        ((zzg)object).zzb();
        ((zzje)object).zzg();
        JobScheduler jobScheduler = ((zzlq)object).zza;
        if (jobScheduler != null && jobScheduler.getPendingJob(((zzlq)object).zzi()) != null) {
            ((zzje)object).zzu.zzaV().zzk().zza("[sgtm] There's an existing pending job, skip this schedule.");
            return;
        }
        zzin zzin2 = ((zzlq)object).zzj();
        if (zzin2 != zzin.zzb) {
            object = zzin2.name();
            ((zzje)object).zzu.zzaV().zzk().zzb("[sgtm] Not eligible for Scion upload", object);
            return;
        }
        zzic zzic2 = ((zzje)object).zzu;
        Long l2 = l;
        zzic2.zzaV().zzk().zzb("[sgtm] Scheduling Scion upload, millis", l2);
        l2 = new PersistableBundle();
        l2.putString("action", "com.google.android.gms.measurement.SCION_UPLOAD");
        long l3 = l;
        l2 = new JobInfo.Builder(((zzlq)object).zzi(), new ComponentName(zzic2.zzaY(), "com.google.android.gms.measurement.AppMeasurementJobService")).setRequiredNetworkType(1).setMinimumLatency(l).setOverrideDeadline(l3 + l3).setExtras((PersistableBundle)l2).build();
        zzgs zzgs2 = zzic2.zzaV().zzk();
        object = ((JobScheduler)Preconditions.checkNotNull((Object)((zzlq)object).zza)).schedule((JobInfo)l2) == 1 ? "SUCCESS" : "FAILURE";
        zzgs2.zzb("[sgtm] Scion upload job scheduled with result", object);
    }

    @VisibleForTesting
    final int zzi() {
        String string = ((zzje)((Object)string2)).zzu.zzaY().getPackageName();
        String.valueOf(string);
        String string2 = String.valueOf(string);
        return "measurement-client".concat(string2).hashCode();
    }

    @WorkerThread
    final zzin zzj() {
        ((zzg)zzjg2).zzb();
        ((zzje)zzjg2).zzg();
        if (((zzlq)zzjg2).zza != null) {
            zzic zzic2 = ((zzje)zzjg2).zzu;
            if (zzic2.zzc().zzx()) {
                zzjg zzjg2 = ((zzf)zzjg2).zzu;
                if (((zzic)zzjg2).zzv().zzn() >= 119000L) {
                    if (!zzpp.zzR(zzic2.zzaY(), "com.google.android.gms.measurement.AppMeasurementJobService")) {
                        return zzin.zzc;
                    }
                    if (Build.VERSION.SDK_INT >= 24) {
                        if (!((zzic)zzjg2).zzt().zzK()) {
                            return zzin.zze;
                        }
                        return zzin.zzb;
                    }
                    return zzin.zzd;
                }
                return zzin.zzf;
            }
            return zzin.zzh;
        }
        return zzin.zzg;
    }
}

