/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzmy;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zzna;
import com.google.android.gms.measurement.internal.zznb;
import com.google.android.gms.measurement.internal.zzne;
import com.google.android.gms.measurement.internal.zznl;
import java.util.Objects;

public final class zznf
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzgo zzc;
    final /* synthetic */ zznl zza;

    protected zznf(zznl zznl2) {
        Objects.requireNonNull(zznl2);
        this.zza = zznl2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zza(Intent object) {
        zznl zznl2 = this.zza;
        ((zzje)zznl2).zzg();
        Context context = zznl2.zzu.zzaY();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzje)object).zzu.zzaV();
                ((zzgu)object).zzk().zza("Connection attempt already in progress");
                return;
            }
            zznl zznl3 = this.zza;
            zzgu zzgu2 = zznl3.zzu.zzaV();
            zzgu2.zzk().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zznl3.zzY(), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        block13: {
            this.zza.zzu.zzaW().zzd();
            // MONITORENTER : this
            if (object2 == null) {
                this.zzb = false;
                object = this.zza;
                object = ((zzje)object).zzu.zzaV();
                ((zzgu)object).zzb().zza("Service connected with null binder");
                // MONITOREXIT : this
                return;
            }
            try {
                object = object2.getInterfaceDescriptor();
                boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
                if (bl) {
                    object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                    bl = object instanceof zzgb;
                    object = bl ? (zzgb)object : new zzfz((IBinder)object2);
                    object2 = this.zza;
                    object2 = ((zzje)object2).zzu.zzaV();
                    ((zzgu)object2).zzk().zza("Bound to IMeasurementService interface");
                    break block13;
                }
                object2 = this.zza;
                object2 = ((zzje)object2).zzu.zzaV();
                ((zzgu)object2).zzb().zzb("Got binder with a wrong descriptor", object);
                object = null;
            }
            catch (RemoteException remoteException) {
                block14: {
                    object = null;
                    break block14;
                    catch (RemoteException remoteException2) {}
                }
                object2 = this.zza;
                object2 = ((zzje)object2).zzu.zzaV();
                ((zzgu)object2).zzb().zza("Service connect failed to get IMeasurementService");
            }
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzje)object2).zzu.zzaW();
            ((zzhz)object2).zzj(new zzmy(this, (zzgb)object));
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            Context context = ((zzje)object2).zzu.zzaY();
            object.unbindService(context, (ServiceConnection)((zznl)object2).zzY());
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzic zzic2 = this.zza.zzu;
        zzic2.zzaW().zzd();
        zzic2.zzaV().zzj().zza("Service disconnected");
        zzic2.zzaW().zzj(new zzmz(this, componentName));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        zznl zznl2 = this.zza;
        ((zzje)zznl2).zzg();
        Object object = zznl2.zzu.zzaY();
        synchronized (this) {
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = ((zzje)object).zzu.zzaV();
                ((zzgu)object).zzk().zza("Connection attempt already in progress");
                return;
            }
            zzgo zzgo2 = this.zzc;
            if (zzgo2 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = ((zzje)object).zzu.zzaV();
                ((zzgu)object).zzk().zza("Already awaiting connection attempt");
                return;
            }
            zznf zznf2 = this;
            this.zzc = new zzgo((Context)object, Looper.getMainLooper(), zznf2, zznf2);
            object = this.zza;
            object = ((zzje)object).zzu.zzaV();
            ((zzgu)object).zzk().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        this.zza.zzu.zzaW().zzd();
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzgb)this.zzc.getService();
            zzje zzje2 = this.zza;
            zzje2 = zzje2.zzu.zzaW();
            ((zzhz)zzje2).zzj(new zzna(this, (zzgb)object));
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzic zzic2 = this.zza.zzu;
        zzic2.zzaW().zzd();
        zzic2.zzaV().zzj().zza("Service connection suspended");
        zzic2.zzaW().zzj(new zznb(this));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zznl zznl2 = this.zza;
        zznl2.zzu.zzaW().zzd();
        zzgu zzgu2 = zznl2.zzu.zzf();
        if (zzgu2 != null) {
            zzgu2.zzk().zzb("Service connection failed", connectionResult);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        this.zza.zzu.zzaW().zzj(new zzne(this, connectionResult));
    }

    final /* synthetic */ void zzd(boolean bl) {
        this.zzb = false;
    }
}

