/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ext.SdkExtensions;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.privacysandbox.ads.adservices.java.measurement.MeasurementManagerFutures;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcu;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zznl;
import com.google.android.gms.measurement.internal.zzpo;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzpp
extends zzjf {
    private static final String[] zzb;
    private static final String[] zzc;
    private SecureRandom zzd;
    private final AtomicLong zze = new AtomicLong(0L);
    private int zzf;
    private MeasurementManagerFutures zzg;
    private Boolean zzh;
    private Integer zzi = null;
    public static final /* synthetic */ int zza;

    zzpp(zzic zzic2) {
        super(zzic2);
    }

    @Override
    protected final boolean zza() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @WorkerThread
    protected final void zzba() {
        long l;
        this.zzg();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = secureRandom.nextLong();
        if (l2 == 0L) {
            long l3 = secureRandom.nextLong();
            if (l3 == 0L) {
                this.zzu.zzaV().zze().zza("Utils falling back to Random for random id");
                l = l3;
            } else {
                l = l3;
            }
        } else {
            l = l2;
        }
        this.zze.set(l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzd() {
        AtomicLong atomicLong = ((zzpp)((Object)atomicLong2)).zze;
        if (atomicLong.get() == 0L) {
            synchronized (atomicLong) {
                long l = System.nanoTime();
                Clock clock = ((zzje)((Object)atomicLong2)).zzu.zzaZ();
                Random random = new Random(l ^ clock.currentTimeMillis());
                return random.nextLong() + (long)(++((zzpp)((Object)atomicLong2)).zzf);
            }
        }
        AtomicLong atomicLong2 = ((zzpp)((Object)atomicLong2)).zze;
        synchronized (atomicLong2) {
            atomicLong2.compareAndSet(-1L, 1L);
            return atomicLong2.getAndIncrement();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @EnsuresNonNull(value={"this.secureRandom"})
    @WorkerThread
    final SecureRandom zzf() {
        this.zzg();
        if (this.zzd == null) {
            this.zzd = new SecureRandom();
        }
        return this.zzd;
    }

    static boolean zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Bundle zzi(Uri uri) {
        Iterator iterator;
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        block25: {
            block24: {
                Iterator iterator2;
                if (uri == null) {
                    return null;
                }
                try {
                    boolean bl = uri.isHierarchical();
                    if (!bl) break block24;
                    string7 = uri.getQueryParameter("utm_campaign");
                    string6 = uri.getQueryParameter("utm_source");
                    string5 = uri.getQueryParameter("utm_medium");
                    string4 = uri.getQueryParameter("gclid");
                    string3 = uri.getQueryParameter("gbraid");
                    string2 = uri.getQueryParameter("utm_id");
                    string = uri.getQueryParameter("dclid");
                    object = uri.getQueryParameter("srsltid");
                    iterator2 = iterator = uri.getQueryParameter("sfmc_id");
                    iterator = string7;
                    string7 = string6;
                    string6 = string5;
                    string5 = string4;
                    string4 = string3;
                    string3 = string2;
                    string2 = string;
                    string = object;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    ((zzje)((Object)iterator)).zzu.zzaV().zze().zzb("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
                    return null;
                }
                object = iterator2;
                break block25;
            }
            iterator = null;
            string7 = null;
            string6 = null;
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            string = null;
            object = null;
        }
        if (TextUtils.isEmpty((CharSequence)((Object)iterator)) && TextUtils.isEmpty((CharSequence)string7) && TextUtils.isEmpty((CharSequence)string6) && TextUtils.isEmpty((CharSequence)string5) && TextUtils.isEmpty((CharSequence)string4) && TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)((Object)iterator))) {
            bundle.putString("campaign", (String)((Object)iterator));
        }
        if (!TextUtils.isEmpty((CharSequence)string7)) {
            bundle.putString("source", string7);
        }
        if (!TextUtils.isEmpty((CharSequence)string6)) {
            bundle.putString("medium", string6);
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            bundle.putString("gclid", string5);
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            bundle.putString("gbraid", string4);
        }
        if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = uri.getQueryParameter("gad_source"))))) {
            bundle.putString("gad_source", (String)((Object)iterator));
        }
        if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = uri.getQueryParameter("utm_term"))))) {
            bundle.putString("term", (String)((Object)iterator));
        }
        if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = uri.getQueryParameter("utm_content"))))) {
            bundle.putString("content", (String)((Object)iterator));
        }
        if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = uri.getQueryParameter("aclid"))))) {
            bundle.putString("aclid", (String)((Object)iterator));
        }
        if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = uri.getQueryParameter("cp1"))))) {
            bundle.putString("cp1", (String)((Object)iterator));
        }
        if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = uri.getQueryParameter("anid"))))) {
            bundle.putString("anid", (String)((Object)iterator));
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString("campaign_id", string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString("dclid", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = uri.getQueryParameter("utm_source_platform"))))) {
            bundle.putString("source_platform", (String)((Object)iterator));
        }
        if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = uri.getQueryParameter("utm_creative_format"))))) {
            bundle.putString("creative_format", (String)((Object)iterator));
        }
        if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = uri.getQueryParameter("utm_marketing_tactic"))))) {
            bundle.putString("marketing_tactic", (String)((Object)iterator));
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("srsltid", string);
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            bundle.putString("sfmc_id", (String)object);
        }
        iterator = uri.getQueryParameterNames().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return bundle;
            }
            string7 = (String)iterator.next();
            if (!string7.startsWith("gad_") || TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter(string7)))) continue;
            bundle.putString(string7, string6);
        }
    }

    final boolean zzj(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzu.zzaV().zzd().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzu.zzaV().zzd().zzb("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzu.zzaV().zzd().zzc("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
            n = string2.codePointAt(n2);
            if (n == 95 || Character.isLetterOrDigit(n)) {
                continue;
            }
            this.zzu.zzaV().zzd().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzk(String string, String string2) {
        block8: {
            int n;
            int n2;
            block7: {
                if (string2 == null) {
                    this.zzu.zzaV().zzd().zzb("Name is required and can't be null. Type", string);
                    return false;
                }
                if (string2.length() == 0) {
                    this.zzu.zzaV().zzd().zzb("Name is required and can't be empty. Type", string);
                    return false;
                }
                n2 = string2.codePointAt(0);
                if (Character.isLetter(n2)) break block7;
                if (n2 != 95) break block8;
                n2 = 95;
            }
            int n3 = string2.length();
            for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
                n = string2.codePointAt(n2);
                if (n == 95 || Character.isLetterOrDigit(n)) {
                    continue;
                }
                this.zzu.zzaV().zzd().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
                return false;
            }
            return true;
        }
        this.zzu.zzaV().zzd().zzc("Name must start with a letter or _ (underscore). Type, name", string, string2);
        return false;
    }

    final boolean zzl(String string, String[] stringArray, String[] stringArray2, String string2) {
        if (string2 == null) {
            this.zzu.zzaV().zzd().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        Preconditions.checkNotNull((Object)string2);
        String[] stringArray3 = zzb;
        for (int i = 0; i < 3; ++i) {
            if (!string2.startsWith(stringArray3[i])) continue;
            this.zzu.zzaV().zzd().zzc("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzpp.zzaA(string2, stringArray) && (stringArray2 == null || !zzpp.zzaA(string2, stringArray2))) {
            this.zzu.zzaV().zzd().zzc("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzm(String string, int n, String string2) {
        if (string2 == null) {
            ((zzje)((Object)n2)).zzu.zzaV().zzd().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        String string3 = string2;
        if (string3.codePointCount(0, string3.length()) > n) {
            Integer n2 = n;
            ((zzje)((Object)n2)).zzu.zzaV().zzd().zzd("Name is too long. Type, maximum supported length, name", string, n2, string2);
            return false;
        }
        return true;
    }

    final int zzn(String string) {
        if (!this.zzk("event", string)) {
            return 2;
        }
        if (!this.zzl("event", zzjm.zza, zzjm.zzb, string)) {
            return 13;
        }
        this.zzu.zzc();
        if (!this.zzm("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzp(String string) {
        if (!this.zzk("user property", string)) {
            return 6;
        }
        if (!this.zzl("user property", zzjo.zza, null, string)) {
            return 15;
        }
        this.zzu.zzc();
        if (!this.zzm("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    final int zzq(String string) {
        if (!this.zzj("event param", string)) {
            return 3;
        }
        if (!this.zzl("event param", null, null, string)) {
            return 14;
        }
        this.zzu.zzc();
        if (!this.zzm("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzs(String string) {
        if (!this.zzk("event param", string)) {
            return 3;
        }
        if (!this.zzl("event param", null, null, string)) {
            return 14;
        }
        this.zzu.zzc();
        if (!this.zzm("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final boolean zzt(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    final boolean zzu(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            Object object2 = object = object.toString();
            if (((String)object2).codePointCount(0, ((String)object2).length()) > n) {
                Integer n2 = ((String)object).length();
                ((zzje)((Object)n2)).zzu.zzaV().zzh().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, n2);
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzz(String string, String string2, String string3, Bundle bundle, List list, boolean bl) {
        if (bundle != null) {
            zzic zzic2 = this.zzu;
            int n = true != zzic2.zzc().zzu.zzk().zzag(231100000, true) ? 0 : 35;
            Iterator iterator = new TreeSet(bundle.keySet()).iterator();
            int n2 = 0;
            int n3 = 0;
            while (iterator.hasNext()) {
                String string4;
                int n4;
                String string5 = (String)iterator.next();
                if (list == null || !list.contains(string5)) {
                    n4 = !bl ? this.zzq(string5) : 0;
                    if (n4 == 0) {
                        n4 = this.zzs(string5);
                    }
                } else {
                    n4 = 0;
                }
                if (n4 != 0) {
                    string4 = n4 == 3 ? string5 : null;
                    this.zzJ(bundle, n4, string5, string4);
                    bundle.remove(string5);
                    continue;
                }
                if (this.zzt(bundle.get(string5))) {
                    zzic2.zzaV().zzh().zzd("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string5);
                    n4 = 22;
                } else {
                    String string6 = string5;
                    n4 = this.zzD(string, string2, string6, bundle.get(string6), bundle, list, bl, false);
                }
                if (n4 != 0 && !"_ev".equals(string5)) {
                    Bundle bundle2 = bundle;
                    String string7 = string5;
                    this.zzJ(bundle2, n4, string7, bundle2.get(string7));
                    bundle.remove(string5);
                    continue;
                }
                if (!zzpp.zzh(string5) || zzpp.zzaA(string5, zzjn.zzd)) continue;
                ++n2;
                if (!this.zzag(231100000, true)) {
                    String string8 = zzic2.zzl().zza(string2);
                    string4 = zzic2.zzl().zze(bundle);
                    zzic2.zzaV().zzd().zzc("Item array not supported on client's version of Google Play Services (Android Only)", string8, string4);
                    zzpp.zzax(bundle, 23);
                    bundle.remove(string5);
                    continue;
                }
                if (n2 <= n) continue;
                if (!zzic2.zzc().zzp(null, zzfy.zzbe) || n3 == 0) {
                    zzgs zzgs2 = zzic2.zzaV().zzd();
                    n3 = String.valueOf(n).length();
                    StringBuilder stringBuilder = new StringBuilder(n3 + 55);
                    stringBuilder.append("Item can't contain more than ");
                    stringBuilder.append(n);
                    stringBuilder.append(" item-scoped custom params");
                    zzgs2.zzc(stringBuilder.toString(), zzic2.zzl().zza(string2), zzic2.zzl().zze(bundle));
                }
                zzpp.zzax(bundle, 28);
                bundle.remove(string5);
                n3 = 1;
            }
        }
    }

    final boolean zzA(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Preconditions.checkNotNull((Object)string);
            if (!string.matches("^1:\\d+:android:[a-f0-9]+$")) {
                Object object = zzgu.zzl(string);
                ((zzje)object).zzu.zzaV().zzd().zzb("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", object);
                return false;
            }
            return true;
        }
        ((zzje)object).zzu.zzaV().zzd().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
        return false;
    }

    final boolean zzB(String string, String string2) {
        boolean bl = TextUtils.isEmpty((CharSequence)string2);
        if (!TextUtils.isEmpty((CharSequence)string) && !bl) {
            Preconditions.checkNotNull((Object)string);
            return !string.equals(string2);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object zzay(int n, Object parcelableArray, boolean bl, boolean n2, String string) {
        if (parcelableArray == null) {
            return null;
        }
        if (parcelableArray instanceof Long || parcelableArray instanceof Double) {
            return parcelableArray;
        }
        if (parcelableArray instanceof Integer) {
            return (long)((Integer)parcelableArray).intValue();
        }
        if (parcelableArray instanceof Byte) {
            return (long)((Byte)parcelableArray).byteValue();
        }
        if (parcelableArray instanceof Short) {
            return (long)((Short)parcelableArray).shortValue();
        }
        if (parcelableArray instanceof Boolean) {
            long l;
            if (!((Boolean)parcelableArray).booleanValue()) {
                l = 0L;
                return l;
            }
            l = 1L;
            return l;
        }
        if (parcelableArray instanceof Float) {
            return ((Float)parcelableArray).doubleValue();
        }
        if (parcelableArray instanceof String || parcelableArray instanceof Character || parcelableArray instanceof CharSequence) {
            return this.zzC(parcelableArray.toString(), n, bl);
        }
        if (n2 == 0 || !(parcelableArray instanceof Bundle[]) && !(parcelableArray instanceof Parcelable[])) return null;
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        for (Parcelable parcelable : parcelableArray) {
            Bundle bundle;
            if (!(parcelable instanceof Bundle) || (bundle = this.zzab((Bundle)parcelable, null)).isEmpty()) continue;
            arrayList.add(bundle);
        }
        ArrayList<Bundle> arrayList2 = arrayList;
        return arrayList2.toArray(new Bundle[arrayList2.size()]);
    }

    public final String zzC(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.codePointCount(0, string2.length()) > n) {
            if (bl) {
                String string3 = string;
                String string4 = string3.substring(0, string3.offsetByCodePoints(0, n));
                String.valueOf(string4);
                return String.valueOf(string4).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final int zzD(String object, String string, String string2, Object object2, Bundle bundle, List list, boolean bl, boolean bl2) {
        Object object3;
        int n;
        block15: {
            block16: {
                block19: {
                    block20: {
                        Object object4;
                        block21: {
                            int n2;
                            boolean bl3;
                            zzic zzic2;
                            block18: {
                                block17: {
                                    ((zzje)object3).zzg();
                                    if (!((zzpp)object3).zzt(object2)) break block16;
                                    if (!bl2) return 21;
                                    if (!zzpp.zzaA(string2, zzjn.zzc)) {
                                        return 20;
                                    }
                                    zznl zznl2 = ((zzpp)object3).zzu.zzt();
                                    ((zzje)zznl2).zzg();
                                    zznl2.zzb();
                                    if (zznl2.zzK() && zznl2.zzu.zzk().zzah() < 200900) {
                                        return 25;
                                    }
                                    zzic2 = ((zzje)object3).zzu;
                                    zzic2.zzc();
                                    bl3 = object2 instanceof Parcelable[];
                                    if (!bl3) break block17;
                                    n2 = ((Parcelable[])object2).length;
                                    break block18;
                                }
                                if (!(object2 instanceof ArrayList)) break block19;
                                n2 = ((ArrayList)object2).size();
                            }
                            if (n2 <= 200) break block20;
                            object4 = Integer.valueOf(n2);
                            zzic2.zzaV().zzh().zzd("Parameter array is too long; discarded. Value kind, name, array length", "param", string2, object4);
                            zzic2.zzc();
                            if (!bl3) break block21;
                            object4 = (Parcelable[])object2;
                            if (((Parcelable[])object4).length > 200) {
                                bundle.putParcelableArray(string2, (Parcelable[])Arrays.copyOf(object4, 200));
                                n = 17;
                                break block15;
                            } else {
                                n = 17;
                            }
                            break block15;
                        }
                        if (object2 instanceof ArrayList) {
                            object4 = (ArrayList)object2;
                            if (((ArrayList)object4).size() > 200) {
                                bundle.putParcelableArrayList(string2, new ArrayList(((ArrayList)object4).subList(0, 200)));
                                n = 17;
                                break block15;
                            } else {
                                n = 17;
                            }
                            break block15;
                        } else {
                            n = 17;
                        }
                        break block15;
                    }
                    n = 0;
                    break block15;
                }
                n = 0;
                break block15;
            }
            n = 0;
        }
        int n3 = zzpp.zzZ(string) || zzpp.zzZ(string2) ? ((zzje)object3).zzu.zzc().zzf(null, false) : ((zzje)object3).zzu.zzc().zze(null, false);
        if (((zzpp)object3).zzu("param", string2, n3, object2)) {
            return n;
        }
        if (!bl2) return 4;
        if (object2 instanceof Bundle) {
            ((zzpp)object3).zzz((String)object, string, string2, (Bundle)object2, list, bl);
            return n;
        }
        if (object2 instanceof Parcelable[]) {
            Parcelable[] parcelableArray = (Parcelable[])object2;
            n3 = parcelableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Parcelable parcelable = parcelableArray[n4];
                if (!(parcelable instanceof Bundle)) {
                    object3 = parcelable.getClass();
                    ((zzje)object3).zzu.zzaV().zzh().zzc("All Parcelable[] elements must be of type Bundle. Value type, name", object3, string2);
                    return 4;
                }
                ((zzpp)object3).zzz((String)object, string, string2, (Bundle)parcelable, list, bl);
                ++n4;
            }
            return n;
        }
        if (!(object2 instanceof ArrayList)) return 4;
        ArrayList arrayList = (ArrayList)object2;
        n3 = arrayList.size();
        int n5 = 0;
        while (n5 < n3) {
            Object e = arrayList.get(n5);
            if (!(e instanceof Bundle)) {
                object = ((zzje)object3).zzu.zzaV().zzh();
                object3 = e != null ? e.getClass() : "null";
                ((zzgs)object).zzc("All ArrayList elements must be of type Bundle. Value type, name", object3, string2);
                return 4;
            }
            ((zzpp)object3).zzz((String)object, string, string2, (Bundle)e, list, bl);
            ++n5;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Object zzE(String string, Object object) {
        int n;
        if ("_ev".equals(string)) {
            zzpp zzpp2 = this;
            return zzpp2.zzay(zzpp2.zzu.zzc().zzf(null, false), object, true, true, null);
        }
        if (zzpp.zzZ(string)) {
            n = this.zzu.zzc().zzf(null, false);
            return this.zzay(n, object, false, true, null);
        }
        n = this.zzu.zzc().zze(null, false);
        return this.zzay(n, object, false, true, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    final Bundle zzF(String string, String string2, Bundle bundle, List list, boolean bl) {
        boolean bl2 = zzpp.zzaA(string2, zzjm.zzd);
        if (bundle == null) {
            return null;
        }
        Bundle bundle2 = new Bundle(bundle);
        zzic zzic2 = this.zzu;
        int n = zzic2.zzc().zzc();
        Iterator iterator = new TreeSet(bundle.keySet()).iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            String string3;
            int n4;
            String string4 = (String)iterator.next();
            if (list == null || !list.contains(string4)) {
                n4 = !bl ? this.zzq(string4) : 0;
                if (n4 == 0) {
                    n4 = this.zzs(string4);
                }
            } else {
                n4 = 0;
            }
            if (n4 != 0) {
                String string5 = n4 == 3 ? string4 : null;
                this.zzJ(bundle2, n4, string4, string5);
                bundle2.remove(string4);
                continue;
            }
            String string6 = string4;
            int n5 = this.zzD(string, string2, string6, bundle.get(string6), bundle2, list, bl, bl2);
            if (n5 == 17) {
                this.zzJ(bundle2, 17, string4, false);
            } else if (n5 != 0 && !"_ev".equals(string4)) {
                string3 = n5 == 21 ? string2 : string4;
            }
            if (!zzpp.zzh(string4) || ++n2 <= n) continue;
            if (!zzic2.zzc().zzp(null, zzfy.zzbe) || n3 == 0) {
                n3 = String.valueOf(n).length();
                StringBuilder stringBuilder = new StringBuilder(n3 + 37);
                stringBuilder.append("Event can't contain more than ");
                stringBuilder.append(n);
                stringBuilder.append(" params");
                String string7 = stringBuilder.toString();
                zzic2.zzaV().zzd().zzc(string7, zzic2.zzl().zza(string2), zzic2.zzl().zze(bundle));
            }
            zzpp.zzax(bundle2, 5);
            bundle2.remove(string4);
            n3 = 1;
            continue;
            this.zzJ(bundle2, n5, string3, bundle.get(string4));
            bundle2.remove(string4);
        }
        return bundle2;
    }

    final void zzG(zzgv zzgv2, int n) {
        Bundle bundle = zzgv2.zzd;
        Iterator iterator = new TreeSet(bundle.keySet()).iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!zzpp.zzh(string) || ++n2 <= n) continue;
            zzic zzic2 = this.zzu;
            if (!zzic2.zzc().zzp(null, zzfy.zzbe) || n3 == 0) {
                n3 = String.valueOf(n).length();
                StringBuilder stringBuilder = new StringBuilder(n3 + 37);
                stringBuilder.append("Event can't contain more than ");
                stringBuilder.append(n);
                stringBuilder.append(" params");
                String string2 = stringBuilder.toString();
                zzic2.zzaV().zzd().zzc(string2, zzic2.zzl().zza(zzgv2.zza), zzic2.zzl().zze(bundle));
                zzpp.zzax(bundle, 5);
            }
            bundle.remove(string);
            n3 = 1;
        }
    }

    final void zzH(Parcelable[] parcelableArray, int n) {
        Preconditions.checkNotNull((Object)parcelableArray);
        int n2 = parcelableArray.length;
        for (int i = 0; i < n2; ++i) {
            Bundle bundle = (Bundle)parcelableArray[i];
            Iterator iterator = new TreeSet(bundle.keySet()).iterator();
            int n3 = 0;
            int n4 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!zzpp.zzh(string) || zzpp.zzaA(string, zzjn.zzd) || ++n3 <= n) continue;
                zzic zzic2 = this.zzu;
                if (!zzic2.zzc().zzp(null, zzfy.zzbe) || n4 == 0) {
                    zzgs zzgs2 = zzic2.zzaV().zzd();
                    n4 = String.valueOf(n).length();
                    StringBuilder stringBuilder = new StringBuilder(n4 + 60);
                    stringBuilder.append("Param can't contain more than ");
                    stringBuilder.append(n);
                    stringBuilder.append(" item-scoped custom parameters");
                    zzgs2.zzc(stringBuilder.toString(), zzic2.zzl().zzb(string), zzic2.zzl().zze(bundle));
                }
                zzpp.zzax(bundle, 28);
                bundle.remove(string);
                n4 = 1;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzI(Bundle bundle, Bundle bundle2) {
        if (bundle2 != null) {
            for (String string : bundle2.keySet()) {
                if (bundle.containsKey(string)) continue;
                String string2 = string;
                this.zzu.zzk().zzM(bundle, string2, bundle2.get(string2));
            }
        }
    }

    final void zzJ(Bundle bundle, int n, String string, Object object) {
        if (zzpp.zzax(bundle, n)) {
            ((zzje)((Object)string2)).zzu.zzc();
            String string2 = ((zzpp)((Object)string2)).zzC(string, 40, true);
            bundle.putString("_ev", string2);
            if (object != null) {
                Preconditions.checkNotNull((Object)bundle);
                if (object instanceof String || object instanceof CharSequence) {
                    int n2 = object.toString().length();
                    bundle.putLong("_el", (long)n2);
                    return;
                }
            }
        }
    }

    private final int zzaz(String string) {
        if ("_ldl".equals(string)) {
            this.zzu.zzc();
            return 2048;
        }
        if ("_id".equals(string)) {
            this.zzu.zzc();
            return 256;
        }
        if ("_lgclid".equals(string)) {
            this.zzu.zzc();
            return 100;
        }
        this.zzu.zzc();
        return 36;
    }

    /*
     * Enabled aggressive block sorting
     */
    final int zzK(String string, Object object) {
        boolean bl;
        if ("_ldl".equals(string)) {
            int n = this.zzaz(string);
            bl = this.zzu("user property referrer", string, n, object);
        } else {
            int n = this.zzaz(string);
            bl = this.zzu("user property", string, n, object);
        }
        if (bl) {
            return 0;
        }
        return 7;
    }

    final Object zzL(String string, Object object) {
        if ("_ldl".equals(string)) {
            zzpp zzpp2 = this;
            return zzpp2.zzay(zzpp2.zzaz(string), object, true, false, null);
        }
        zzpp zzpp3 = this;
        return zzpp3.zzay(zzpp3.zzaz(string), object, false, false, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void zzM(Bundle object, String string, Object object2) {
        void var1_3;
        void var2_5;
        void var3_6;
        block10: {
            block9: {
                if (object == null) break block9;
                if (var3_6 instanceof Long) {
                    object.putLong((String)var2_5, ((Long)var3_6).longValue());
                    return;
                }
                if (var3_6 instanceof String) {
                    object.putString((String)var2_5, String.valueOf(var3_6));
                    return;
                }
                if (var3_6 instanceof Double) {
                    object.putDouble((String)var2_5, ((Double)var3_6).doubleValue());
                    return;
                }
                if (var3_6 instanceof Bundle[]) {
                    object.putParcelableArray((String)var2_5, (Parcelable[])((Bundle[])var3_6));
                    return;
                }
                if (var2_5 != null) break block10;
            }
            return;
        }
        if (var3_6 != null) {
            String string2 = var3_6.getClass().getSimpleName();
        } else {
            Object var1_4 = null;
        }
        Object object3 = ((zzje)object3).zzu;
        zzgs zzgs2 = ((zzic)object3).zzaV().zzh();
        object3 = ((zzic)object3).zzl().zzb((String)var2_5);
        zzgs2.zzc("Not putting event parameter. Invalid value type. name, type", object3, var1_3);
    }

    final void zzN(zzpo zzpo2, String string, int n, String string2, String string3, int n2) {
        zzpp zzpp2 = new Bundle();
        zzpp.zzax((Bundle)zzpp2, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            zzpp2.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            long l = n2;
            zzpp2.putLong("_el", l);
        }
        zzpo2.zza(string, "_err", (Bundle)zzpp2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MessageDigest zzO() {
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest != null) {
                    return messageDigest;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static long zzP(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        int n = byArray.length;
        int n2 = n > 0 ? 1 : 0;
        Preconditions.checkState(n2 != 0);
        long l = 0L;
        n2 = 0;
        --n;
        while (n >= 0 && n >= byArray.length + -8) {
            l += ((long)byArray[n] & 0xFFL) << n2;
            n2 += 8;
            --n;
        }
        return l;
    }

    static boolean zzQ(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzpp.zzR(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzpp.zzR(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean zzR(Context context, String string) {
        block6: {
            PackageManager packageManager;
            block5: {
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            context = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    @WorkerThread
    final boolean zzS() {
        this.zzg();
        return this.zzV() == 1L;
    }

    final MeasurementManagerFutures zzT() {
        if (this.zzg == null) {
            this.zzg = MeasurementManagerFutures.from((Context)this.zzu.zzaY());
        }
        return this.zzg;
    }

    final int zzU() {
        if (Build.VERSION.SDK_INT >= 30 && SdkExtensions.getExtensionVersion((int)30) > 3) {
            return SdkExtensions.getExtensionVersion((int)1000000);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final long zzV() {
        long l;
        long l2;
        this.zzg();
        zzpp zzpp2 = this;
        if (!zzpp2.zzX(zzpp2.zzu.zzv().zzj())) {
            return 0L;
        }
        if (Build.VERSION.SDK_INT < 30) {
            l2 = 4L;
        } else if (SdkExtensions.getExtensionVersion((int)30) < 4) {
            l2 = 8L;
        } else {
            zzic zzic2 = this.zzu;
            int n = this.zzU();
            zzic2.zzc();
            l2 = n < (Integer)zzfy.zzal.zzb(null) ? 16L : 0L;
        }
        long l3 = !this.zzY("android.permission.ACCESS_ADSERVICES_ATTRIBUTION") ? l2 | 2L : l2;
        if (l3 == 0L) {
            if (!this.zzW()) {
                return 64L;
            }
            l = l3;
        } else {
            l = l3;
        }
        if (l != 0L) return l;
        return 1L;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    @TargetApi(value=30)
    final boolean zzW() {
        block9: {
            block10: {
                if (this.zzh != null) ** GOTO lbl19
                var1_1 = this.zzT();
                if (var1_1 == null) {
                    return false;
                }
                var1_1 = var1_1.getMeasurementApiStatusAsync();
                var2_6 = (Integer)var1_1.get(10000L, TimeUnit.MILLISECONDS);
                if (var2_6 == null) break block9;
                try {
                    var1_2 = var2_6.intValue();
                    if (!var1_2) break block10;
                    var1_2 = true;
                }
                catch (InterruptedException | CancellationException | ExecutionException | TimeoutException var1_5) {
                    ** continue;
                }
lbl13:
                // 3 sources

                while (true) {
                    this.zzh = var1_2;
                    var1_3 = var2_6;
lbl17:
                    // 2 sources

                    while (true) {
                        this.zzu.zzaV().zzk().zzb("Measurement manager api status result", var1_3);
lbl19:
                        // 2 sources

                        return this.zzh;
                    }
                    break;
                }
            }
            var1_2 = false;
            ** GOTO lbl13
        }
        var1_2 = false;
        ** while (true)
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException var1_4) {
            var2_6 = null;
lbl28:
            // 2 sources

            while (true) {
                this.zzu.zzaV().zze().zzb("Measurement manager api exception", var1_3);
                this.zzh = false;
                var1_3 = var2_6;
                ** continue;
                break;
            }
        }
    }

    final boolean zzX(String string) {
        String string2 = (String)zzfy.zzar.zzb(null);
        return string2.equals("*") || Arrays.asList(string2.split(",")).contains(string);
    }

    @WorkerThread
    final boolean zzY(String string) {
        ((zzje)zzjg2).zzg();
        zzjg zzjg2 = ((zzje)zzjg2).zzu;
        if (Wrappers.packageManager((Context)((zzic)zzjg2).zzaY()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        ((zzic)zzjg2).zzaV().zzj().zzb("Permission not granted", string);
        return false;
    }

    static boolean zzZ(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    final boolean zzaa(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzjg zzjg2 = ((zzje)zzjg2).zzu;
        String string3 = ((zzic)zzjg2).zzc().zzA();
        ((zzic)zzjg2).zzaU();
        return string3.equals(string);
    }

    final Bundle zzab(Bundle bundle, String string) {
        string = new Bundle();
        if (bundle != null) {
            Iterator iterator = bundle.keySet().iterator();
            while (iterator.hasNext()) {
                String string2;
                String string3 = string2 = (String)iterator.next();
                Object object = this.zzE(string3, bundle.get(string3));
                if (object == null) {
                    object = this.zzu;
                    string2 = ((zzic)object).zzl().zzb(string2);
                    ((zzic)object).zzaV().zzh().zzb("Param value can't be null", string2);
                    continue;
                }
                this.zzM((Bundle)string, string2, object);
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    final zzbg zzac(String string, String string2, Bundle bundle, String string3, long l, boolean bl, boolean bl2) {
        Object object;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (((zzpp)object).zzn(string2) != 0) {
            object = ((zzje)object).zzu;
            zzgs zzgs2 = ((zzic)object).zzaV().zzb();
            object = ((zzic)object).zzl().zzc(string2);
            zzgs2.zzb("Invalid conditional property event name", object);
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string3);
        bundle = ((zzpp)object).zzF(string, string2, bundle, CollectionUtils.listOf((Object)"_o"), true);
        object = bl ? ((zzpp)object).zzab(bundle, string) : bundle;
        Preconditions.checkNotNull((Object)object);
        return new zzbg(string2, new zzbe((Bundle)object), string3, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final boolean zzad(Context context, String signatureArray) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        context = Wrappers.packageManager((Context)context).getPackageInfo((String)signatureArray, 64);
        if (context == null) return true;
        signatureArray = context.signatures;
        if (signatureArray == null) return true;
        int n = context.signatures.length;
        if (n <= 0) return true;
        try {
            context = context.signatures[0];
            return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(context.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
        }
        catch (CertificateException certificateException) {
            this.zzu.zzaV().zzb().zzb("Error obtaining certificate", certificateException);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzu.zzaV().zzb().zzb("Package name not found", (Object)nameNotFoundException);
            return true;
        }
    }

    final byte[] zzae(Parcelable object) {
        if (object == null) {
            return null;
        }
        zzpp zzpp2 = Parcel.obtain();
        try {
            object.writeToParcel((Parcel)zzpp2, 0);
            object = zzpp2.marshall();
        }
        catch (Throwable throwable) {
            zzpp2.recycle();
            throw throwable;
        }
        zzpp2.recycle();
        return object;
    }

    private static boolean zzaA(String string, String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!Objects.equals(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean zzaf(String string) {
        return !zzc[0].equals(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzag(int n, boolean bl) {
        Boolean bl2 = this.zzu.zzt().zzJ();
        if (this.zzah() >= n / 1000) return true;
        if (bl2 == null) return false;
        if (bl2 != false) return false;
        return true;
    }

    @EnsuresNonNull(value={"this.apkVersion"})
    public final int zzah() {
        if (this.zzi == null) {
            zzic zzic2 = this.zzu;
            this.zzi = GoogleApiAvailabilityLight.getInstance().getApkVersion(zzic2.zzaY()) / 1000;
        }
        return this.zzi;
    }

    public final int zzai(int n) {
        zzjg zzjg2 = ((zzje)zzjg2).zzu;
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzic)zzjg2).zzaY(), 12451000);
    }

    public final long zzaj(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzak(Bundle bundle, long l) {
        long l2;
        long l3 = bundle.getLong("_et");
        if (l3 != 0L) {
            this.zzu.zzaV().zze().zzb("Params already contained engagement", l3);
            l2 = l3;
        } else {
            l2 = 0L;
        }
        bundle.putLong("_et", l += l2);
    }

    public final void zzal(zzcu zzcu2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzcu2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaV().zze().zzb("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzam(zzcu zzcu2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzcu2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaV().zze().zzb("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzan(zzcu zzcu2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzcu2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaV().zze().zzb("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzao(zzcu zzcu2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzcu2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaV().zze().zzb("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzap(zzcu zzcu2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzcu2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaV().zze().zzb("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzaq(zzcu zzcu2, Bundle bundle) {
        try {
            zzcu2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaV().zze().zzb("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzar(zzcu zzcu2, ArrayList arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzcu2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaV().zze().zzb("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public static ArrayList zzas(List object) {
        if (object == null) {
            return new ArrayList(0);
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractSafeParcelable abstractSafeParcelable = (zzah)((Object)object.next());
            Bundle bundle = new Bundle();
            Object object2 = abstractSafeParcelable.zza;
            bundle.putString("app_id", (String)object2);
            object2 = abstractSafeParcelable.zzb;
            bundle.putString("origin", (String)object2);
            long l = abstractSafeParcelable.zzd;
            bundle.putLong("creation_timestamp", l);
            object2 = abstractSafeParcelable.zzc.zzb;
            bundle.putString("name", (String)object2);
            zzjh.zza((Bundle)bundle, (Object)Preconditions.checkNotNull((Object)abstractSafeParcelable.zzc.zza()));
            boolean bl = abstractSafeParcelable.zze;
            bundle.putBoolean("active", bl);
            object2 = abstractSafeParcelable.zzf;
            if (object2 != null) {
                bundle.putString("trigger_event_name", (String)object2);
            }
            if ((object2 = abstractSafeParcelable.zzg) != null) {
                bundle.putString("timed_out_event_name", ((zzbg)((Object)object2)).zza);
                object2 = ((zzbg)((Object)object2)).zzb;
                if (object2 != null) {
                    bundle.putBundle("timed_out_event_params", ((zzbe)object2).zzf());
                }
            }
            l = abstractSafeParcelable.zzh;
            bundle.putLong("trigger_timeout", l);
            object2 = abstractSafeParcelable.zzi;
            if (object2 != null) {
                bundle.putString("triggered_event_name", ((zzbg)((Object)object2)).zza);
                object2 = ((zzbg)((Object)object2)).zzb;
                if (object2 != null) {
                    bundle.putBundle("triggered_event_params", ((zzbe)object2).zzf());
                }
            }
            l = abstractSafeParcelable.zzc.zzc;
            bundle.putLong("triggered_timestamp", l);
            l = abstractSafeParcelable.zzj;
            bundle.putLong("time_to_live", l);
            abstractSafeParcelable = abstractSafeParcelable.zzk;
            if (abstractSafeParcelable != null) {
                bundle.putString("expired_event_name", abstractSafeParcelable.zza);
                abstractSafeParcelable = abstractSafeParcelable.zzb;
                if (abstractSafeParcelable != null) {
                    bundle.putBundle("expired_event_params", abstractSafeParcelable.zzf());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final URL zzat(long l, String string, String string2, long l2, String string3) {
        try {
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string);
            string2 = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", String.format("v%s.%s", 133005L, this.zzah()), string2, string, l2);
            zzal zzal2 = this.zzu.zzc();
            boolean bl = string.equals(zzal2.zzB());
            String string4 = bl ? string2.concat("&ddl_test=1") : string2;
            char c = string3.isEmpty();
            if (c != '\u0000') return new URL(string4);
            c = string3.charAt(0);
            if (c != '&') {
                string4 = string4.concat("&");
            }
            string4 = string4.concat(string3);
            return new URL(string4);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            this.zzu.zzaV().zzb().zzb("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean zzau(Context context) {
        block6: {
            PackageManager packageManager;
            block5: {
                Preconditions.checkNotNull((Object)context);
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            context = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public static void zzav(zzlu zzlu2, Bundle bundle, boolean bl) {
        if (bundle != null && zzlu2 != null) {
            if (!bundle.containsKey("_sc") || bl) {
                String string = zzlu2.zza;
                if (string != null) {
                    bundle.putString("_sn", string);
                } else {
                    bundle.remove("_sn");
                }
                if ((string = zzlu2.zzb) != null) {
                    bundle.putString("_sc", string);
                } else {
                    bundle.remove("_sc");
                }
                long l = zzlu2.zzc;
                bundle.putLong("_si", l);
                return;
            }
            bl = false;
        }
        if (bundle != null && zzlu2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
            return;
        }
    }

    final String zzaw() {
        byte[] byArray = new byte[16];
        objectArray.zzf().nextBytes(byArray);
        Object[] objectArray = new Object[]{new BigInteger(1, byArray)};
        return String.format(Locale.US, "%032x", objectArray);
    }

    static {
        String string = "firebase_";
        zzb = new String[]{string, "google_", "ga_"};
        string = "_err";
        zzc = new String[]{string};
    }

    /*
     * Enabled aggressive block sorting
     */
    static final boolean zzax(Bundle bundle, int n) {
        if (bundle == null || bundle.getLong("_err") != 0L) {
            return false;
        }
        long l = n;
        bundle.putLong("_err", l);
        return true;
    }
}

