/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzfm;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzfq;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzcv;
import com.google.android.gms.measurement.internal.zzcw;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class zzep {
    private static volatile zzep zzadz;
    private final String zzadw;
    protected final Clock zzrz;
    private final ExecutorService zzaea;
    private final AppMeasurementSdk zzaeb;
    private Map<zzcw, zzd> zzaec;
    private int zzaed;
    private boolean zzaee;
    private String zzaef;
    private zzec zzaeg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzep zza(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzadz != null) return zzadz;
        Class<zzep> clazz = zzep.class;
        synchronized (zzep.class) {
            if (zzadz != null) return zzadz;
            zzadz = new zzep(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzadz;
        }
    }

    public final AppMeasurementSdk zzga() {
        return this.zzaeb;
    }

    private zzep(Context context, String string, String string2, String string3, Bundle bundle) {
        this.zzadw = string == null || !zzep.zze(string2, string3) ? "FA" : string;
        this.zzrz = DefaultClock.getInstance();
        this.zzaea = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        Application application = (Application)context.getApplicationContext();
        zzep zzep2 = this;
        if (application == null) {
            Log.w((String)zzep2.zzadw, (String)"Unable to register lifecycle notifications. Application null.");
        } else {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzep2.new zze());
        }
        this.zzaeb = new AppMeasurementSdk(this);
        application = context;
        if (!(!zzep.zzf((Context)application) || zzep.zzgb())) {
            this.zzaef = null;
            this.zzaee = true;
            Log.w((String)this.zzadw, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!zzep.zze(string2, string3)) {
            this.zzaef = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzadw, (String)"Deferring to Google Analytics for Firebase for event data collection. https://goo.gl/J1sWQy");
                this.zzaee = true;
                return;
            }
            if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzadw, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzaef = string2;
        }
        this.zza(new zzeq(this, context, string2, string3, bundle));
    }

    private static boolean zzf(Context context) {
        try {
            GoogleServices.initialize((Context)context);
            return GoogleServices.getGoogleAppId() != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private static boolean zze(String string, String string2) {
        return string2 != null && string != null && !zzep.zzgb();
    }

    private final void zza(zzb zzb2) {
        this.zzaea.execute(zzb2);
    }

    protected final zzec zzg(Context context) {
        try {
            return zzed.asInterface(DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    private static int zzh(Context context) {
        return DynamiteModule.getRemoteVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private static int zzi(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzaee |= bl;
        if (bl) {
            Log.w((String)this.zzadw, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zzc(5, string, exception, null, null);
        }
        Log.w((String)this.zzadw, (String)string, (Throwable)exception);
    }

    private static boolean zzgb() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public final void zza(zzcv zzcv2) {
        this.zza(new zzex(this, zzcv2));
    }

    public final void zza(zzcw zzcw2) {
        this.zza(new zzfh(this, zzcw2));
    }

    public final void zzb(zzcw zzcw2) {
        this.zza(new zzfi(this, zzcw2));
    }

    public final void logEventInternal(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        this.zza(new zzfj(this, l, string, string2, bundle, true, bl2));
    }

    public final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(new zzfk(this, string, string2, object, true));
    }

    public final void setConditionalUserProperty(Bundle bundle) {
        this.zza(new zzfl(this, bundle));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(new zzer(this, string, string2, bundle));
    }

    public final List<Bundle> getConditionalUserProperties(String string, String string2) {
        zza zza2 = new zza();
        this.zza(new zzes(this, string, string2, zza2));
        List<Bundle> list = zza2.zzl(5000L);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final void setCurrentScreen(Activity activity, String string, String string2) {
        this.zza(new zzet(this, activity, string, string2));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zza(new zzeu(this, bl));
    }

    public final void beginAdUnitExposure(String string) {
        this.zza(new zzev(this, string));
    }

    public final void endAdUnitExposure(String string) {
        this.zza(new zzew(this, string));
    }

    public final String getGmpAppId() {
        zza zza2 = new zza();
        this.zza(new zzey(this, zza2));
        return zza2.zzk(500L);
    }

    public final String zzgc() {
        zza zza2 = new zza();
        this.zza(new zzez(this, zza2));
        return zza2.zzk(50L);
    }

    public final long generateEventId() {
        zza zza2 = new zza();
        this.zza(new zzfa(this, zza2));
        Long l = zza2.zzm(500L);
        if (l == null) {
            zzep zzep2 = this;
            return new Random(System.nanoTime() ^ zzep2.zzrz.currentTimeMillis()).nextLong() + (long)(++zzep2.zzaed);
        }
        return l;
    }

    public final String getCurrentScreenName() {
        zza zza2 = new zza();
        this.zza(new zzfb(this, zza2));
        return zza2.zzk(500L);
    }

    public final String getCurrentScreenClass() {
        zza zza2 = new zza();
        this.zza(new zzfc(this, zza2));
        return zza2.zzk(500L);
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        zza zza2 = new zza();
        this.zza(new zzfd(this, string, string2, bl, zza2));
        Bundle bundle = zza2.zzo(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    public final void zzc(int n, String string, Object object, Object object2, Object object3) {
        this.zza(new zzfe(this, false, 5, string, object, object2, object3));
    }

    public final Bundle zza(Bundle bundle, boolean bl) {
        zza zza2 = new zza();
        this.zza(new zzff(this, bundle, zza2));
        if (bl) {
            return zza2.zzo(5000L);
        }
        return null;
    }

    public final int getMaxUserProperties(String string) {
        zza zza2 = new zza();
        this.zza(new zzfg(this, string, zza2));
        Integer n = zza2.zzn(10000L);
        if (n == null) {
            return 25;
        }
        return n;
    }

    public final String getAppIdOrigin() {
        return this.zzaef;
    }

    static /* synthetic */ Map zza(zzep zzep2, Map map) {
        zzep2.zzaec = map;
        return zzep2.zzaec;
    }

    static /* synthetic */ zzec zza(zzep zzep2, zzec zzec2) {
        zzep2.zzaeg = zzec2;
        return zzep2.zzaeg;
    }

    static /* synthetic */ zzec zzb(zzep zzep2) {
        return zzep2.zzaeg;
    }

    static /* synthetic */ boolean zza(zzep zzep2, String string, String string2) {
        return zzep.zze(string, string2);
    }

    static /* synthetic */ int zzj(Context context) {
        return zzep.zzi(context);
    }

    static /* synthetic */ int zzk(Context context) {
        return zzep.zzh(context);
    }

    static /* synthetic */ Map zzd(zzep zzep2) {
        return zzep2.zzaec;
    }

    final class zze
    implements Application.ActivityLifecycleCallbacks {
        zze() {
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
            zzep.this.zza(new zzfm(this, activity, bundle));
        }

        public final void onActivityStarted(Activity activity) {
            zzep.this.zza(new zzfn(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzep.this.zza(new zzfo(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzep.this.zza(new zzfp(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzep.this.zza(new zzfq(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zza zza2 = new zza();
            zzep.this.zza(new zzfr(this, activity, zza2));
            Bundle bundle2 = zza2.zzo(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityDestroyed(Activity activity) {
            zzep.this.zza(new zzfs(this, activity));
        }
    }

    static final class zzc
    extends zzej {
        private final zzcv zzafm;

        zzc(zzcv zzcv2) {
            this.zzafm = zzcv2;
        }

        @Override
        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            this.zzafm.interceptEvent(string, string2, bundle, l);
        }

        @Override
        public final int id() {
            return this.zzafm.hashCode();
        }
    }

    static final class zzd
    extends zzej {
        private final zzcw zzafn;

        zzd(zzcw zzcw2) {
            this.zzafn = zzcw2;
        }

        @Override
        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            this.zzafn.onEvent(string, string2, bundle, l);
        }

        @Override
        public final int id() {
            return this.zzafn.hashCode();
        }
    }

    final class zza
    extends zzeg {
        private final AtomicReference<Bundle> zzafi = new AtomicReference();
        private boolean zzafj;

        zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzb(Bundle bundle) {
            AtomicReference<Bundle> atomicReference = this.zzafi;
            synchronized (atomicReference) {
                try {
                    this.zzafi.set(bundle);
                    this.zzafj = true;
                }
                finally {
                    this.zzafi.notify();
                }
                return;
            }
        }

        final String zzk(long l) {
            return this.zza(this.zzp(l), String.class);
        }

        final <T extends Parcelable> List<T> zzl(long l) {
            return this.zza(this.zzp(5000L), List.class);
        }

        final Long zzm(long l) {
            return this.zza(this.zzp(500L), Long.class);
        }

        final Integer zzn(long l) {
            return this.zza(this.zzp(10000L), Integer.class);
        }

        final Bundle zzo(long l) {
            return this.zzp(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Bundle zzp(long l) {
            AtomicReference<Bundle> atomicReference = this.zzafi;
            synchronized (atomicReference) {
                if (!this.zzafj) {
                    try {
                        this.zzafi.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                return this.zzafi.get();
            }
        }

        private final <T> T zza(Bundle bundle, Class<T> clazz) {
            if (bundle != null) {
                Object object = bundle.get("r");
                try {
                    if (object != null) {
                        return clazz.cast(object);
                    }
                    return null;
                }
                catch (ClassCastException classCastException) {
                    String string = "Unexpected object type. Expected, Received";
                    String string2 = clazz.getCanonicalName();
                    String string3 = object.getClass().getCanonicalName();
                    zzep.this.zzc(5, string, string2, string3, classCastException);
                    Log.w((String)zzep.this.zzadw, (String)String.format(String.valueOf(string).concat(": %s, %s"), string2, string3), (Throwable)classCastException);
                    throw classCastException;
                }
            }
            return null;
        }
    }

    abstract class zzb
    implements Runnable {
        final long timestamp;
        final long zzafk;
        private final boolean zzafl;

        zzb() {
            this(true);
        }

        zzb(boolean bl) {
            this.timestamp = zzep.this.zzrz.currentTimeMillis();
            this.zzafk = zzep.this.zzrz.elapsedRealtime();
            this.zzafl = bl;
        }

        @Override
        public void run() {
            if (zzep.this.zzaee) {
                this.zzge();
                return;
            }
            try {
                this.zzgd();
                return;
            }
            catch (Exception exception) {
                zzep.this.zza(exception, false, this.zzafl);
                this.zzge();
                return;
            }
        }

        protected void zzge() {
        }

        abstract void zzgd() throws RemoteException;
    }
}

