/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.api;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.measurement.zzz;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgn;
import java.util.List;
import java.util.Map;

@KeepForSdk
public class AppMeasurementSdk {
    private final zzz zzo;

    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurementSdk getInstance(@NonNull Context context) {
        return zzz.zza(context).zzg();
    }

    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurementSdk getInstance(@NonNull Context context, @NonNull String string, @NonNull String string2, @NonNull String string3, Bundle bundle) {
        return zzz.zza(context, string, string2, string3, bundle).zzg();
    }

    public AppMeasurementSdk(zzz zzz2) {
        this.zzo = zzz2;
    }

    @KeepForSdk
    public void setMeasurementEnabled(boolean bl) {
        this.zzo.setMeasurementEnabled(bl);
    }

    @KeepForSdk
    public void logEvent(String string, String string2, Bundle bundle) {
        this.zzo.logEventInternal(string, string2, bundle);
    }

    @KeepForSdk
    public void logEventNoInterceptor(String string, String string2, Bundle bundle, long l) {
        this.zzo.logEventInternalNoInterceptor(string, string2, bundle, l);
    }

    @KeepForSdk
    public void setUserProperty(String string, String string2, Object object) {
        this.zzo.setUserPropertyInternal(string, string2, object);
    }

    @KeepForSdk
    @WorkerThread
    public Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        return this.zzo.getUserProperties(string, string2, bl);
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull Bundle bundle) {
        this.zzo.setConditionalUserProperty(bundle);
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zzo.clearConditionalUserProperty(string, string2, bundle);
    }

    @KeepForSdk
    @WorkerThread
    public List<Bundle> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        return this.zzo.getConditionalUserProperties(string, string2);
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenName() {
        return this.zzo.getCurrentScreenName();
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenClass() {
        return this.zzo.getCurrentScreenClass();
    }

    @Nullable
    @KeepForSdk
    public String getAppInstanceId() {
        return this.zzo.zzi();
    }

    @Nullable
    @KeepForSdk
    public String getGmpAppId() {
        return this.zzo.getGmpAppId();
    }

    @KeepForSdk
    public long generateEventId() {
        return this.zzo.generateEventId();
    }

    @KeepForSdk
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzo.beginAdUnitExposure(string);
    }

    @KeepForSdk
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzo.endAdUnitExposure(string);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        this.zzo.zza(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzo.zza(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzo.zzb(onEventListener);
    }

    @KeepForSdk
    public Bundle performActionWithResponse(Bundle bundle) {
        return this.zzo.zza(bundle, true);
    }

    @KeepForSdk
    public void performAction(Bundle bundle) {
        this.zzo.zza(bundle, false);
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zzo.getMaxUserProperties(string);
    }

    @KeepForSdk
    public void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        this.zzo.setCurrentScreen(activity, string, string2);
    }

    @KeepForSdk
    public String getAppIdOrigin() {
        return this.zzo.getAppIdOrigin();
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzgn {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzgk {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }

    @KeepForSdk
    public static final class ConditionalUserProperty {
        @KeepForSdk
        public static final String ORIGIN = "origin";
        @KeepForSdk
        public static final String NAME = "name";
        @KeepForSdk
        public static final String VALUE = "value";
        @KeepForSdk
        public static final String TRIGGER_EVENT_NAME = "trigger_event_name";
        @KeepForSdk
        public static final String TRIGGER_TIMEOUT = "trigger_timeout";
        @KeepForSdk
        public static final String TIMED_OUT_EVENT_NAME = "timed_out_event_name";
        @KeepForSdk
        public static final String TIMED_OUT_EVENT_PARAMS = "timed_out_event_params";
        @KeepForSdk
        public static final String TRIGGERED_EVENT_NAME = "triggered_event_name";
        @KeepForSdk
        public static final String TRIGGERED_EVENT_PARAMS = "triggered_event_params";
        @KeepForSdk
        public static final String TIME_TO_LIVE = "time_to_live";
        @KeepForSdk
        public static final String EXPIRED_EVENT_NAME = "expired_event_name";
        @KeepForSdk
        public static final String EXPIRED_EVENT_PARAMS = "expired_event_params";
        @KeepForSdk
        public static final String CREATION_TIMESTAMP = "creation_timestamp";
        @KeepForSdk
        public static final String ACTIVE = "active";
        @KeepForSdk
        public static final String TRIGGERED_TIMESTAMP = "triggered_timestamp";

        private ConditionalUserProperty() {
        }
    }
}

