/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzab;
import com.google.android.gms.internal.measurement.zzac;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzag;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzaj;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzam;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzay;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzba;
import com.google.android.gms.internal.measurement.zzbb;
import com.google.android.gms.internal.measurement.zzbc;
import com.google.android.gms.internal.measurement.zzbd;
import com.google.android.gms.internal.measurement.zzbe;
import com.google.android.gms.internal.measurement.zzbf;
import com.google.android.gms.internal.measurement.zzbg;
import com.google.android.gms.internal.measurement.zzbh;
import com.google.android.gms.internal.measurement.zzbi;
import com.google.android.gms.internal.measurement.zzbq;
import com.google.android.gms.internal.measurement.zzk;
import com.google.android.gms.internal.measurement.zzm;
import com.google.android.gms.internal.measurement.zzo;
import com.google.android.gms.internal.measurement.zzp;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;

public final class zzbr {
    private static volatile zzbr zzc;
    private final String zzd;
    protected final Clock zza;
    protected final ExecutorService zzb;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List<Pair<zzgx, zzbi>> zzf;
    private int zzg;
    private static Boolean zzh;
    private boolean zzi;
    private final String zzj;
    private volatile zzp zzk;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzbr zza(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzc != null) return zzc;
        Class<zzbr> clazz = zzbr.class;
        synchronized (clazz) {
            zzbr zzbr2 = zzc;
            if (zzbr2 != null) return zzc;
            zzc = zzbr2 = new zzbr(context, string, string2, string3, bundle);
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final AppMeasurementSdk zzb() {
        return this.zze;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected zzbr(Context context, String object, String string, String string2, Bundle bundle) {
        block8: {
            block7: {
                this.zzd = object == null || !zzbr.zzX(string, string2) ? "FA" : object;
                this.zza = DefaultClock.getInstance();
                object = com.google.android.gms.internal.measurement.zzk.zza();
                zzav zzav2 = new zzav(this);
                this.zzb = object.zzb(zzav2, 1);
                this.zze = object = new AppMeasurementSdk(this);
                object = new ArrayList();
                this.zzf = object;
                try {
                    object = zzfo.zza((Context)context);
                    object = zzie.zzb((Context)context, (String)"google_app_id", (String)object);
                }
                catch (IllegalStateException illegalStateException) {}
                if (object != null && !zzbr.zzT()) {
                    this.zzj = null;
                    this.zzi = true;
                    Log.w((String)this.zzd, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
                    return;
                }
                if (zzbr.zzX(string, string2)) break block7;
                this.zzj = "fa";
                if (string != null && string2 != null) {
                    Log.v((String)this.zzd, (String)"Deferring to Google Analytics for Firebase for event data collection. https://goo.gl/J1sWQy");
                    break block8;
                } else {
                    boolean bl;
                    boolean bl2 = string == null;
                    if (bl2 ^ (bl = string2 == null)) {
                        Log.w((String)this.zzd, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
                    }
                }
                break block8;
            }
            this.zzj = string;
        }
        Object object2 = new zzak(this, string, string2, context, bundle);
        this.zzU((zzbg)object2);
        context = (Application)context.getApplicationContext();
        if (context == null) {
            Log.w((String)this.zzd, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        object2 = new zzbq(this);
        context.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)object2);
    }

    private final void zzU(zzbg zzbg2) {
        this.zzb.execute(zzbg2);
    }

    /*
     * Unable to fully structure code
     */
    protected final zzp zzc(Context var1_1, boolean var2_3) {
        if (var2_3) {
            var2_4 = DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION;
lbl4:
            // 2 sources

            while (true) {
                var1_1 = DynamiteModule.load((Context)var1_1, (DynamiteModule.VersionPolicy)var2_4, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService");
                var1_1 = zzo.asInterface((IBinder)var1_1);
                return var1_1;
            }
        }
        try {
            var2_4 = DynamiteModule.PREFER_LOCAL;
            ** continue;
        }
        catch (DynamiteModule.LoadingException var1_2) {
            this.zzV((Exception)var1_2, true, false);
            return null;
        }
    }

    private final void zzV(Exception exception, boolean bl, boolean bl2) {
        this.zzi |= bl;
        if (bl) {
            Log.w((String)this.zzd, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zzC(5, string, exception, null, null);
        }
        Log.w((String)this.zzd, (String)string, (Throwable)exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzd(zzgw object) {
        zzbh zzbh2 = new zzbh((zzgw)object);
        if (this.zzk != null) {
            try {
                this.zzk.setEventInterceptor((zzv)zzbh2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzbb zzbb2 = new zzbb(this, zzbh2);
        this.zzU(zzbb2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zze(zzgx object) {
        int n;
        Preconditions.checkNotNull((Object)object);
        List<Pair<zzgx, zzbi>> list = this.zzf;
        // MONITORENTER : list
        for (int i = 0; i < (n = this.zzf.size()); ++i) {
            n = object.equals(this.zzf.get((int)i).first) ? 1 : 0;
            if (n == 0) continue;
            Log.w((String)this.zzd, (String)"OnEventListener already registered.");
            // MONITOREXIT : list
            return;
        }
        zzbi zzbi2 = new zzbi((zzgx)object);
        List<Pair<zzgx, zzbi>> list2 = this.zzf;
        Pair pair = new Pair(object, (Object)zzbi2);
        list2.add((Pair<zzgx, zzbi>)pair);
        // MONITOREXIT : list
        if (this.zzk != null) {
            try {
                this.zzk.registerOnMeasurementEventListener((zzv)zzbi2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        object = new zzbc(this, zzbi2);
        this.zzU((zzbg)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzf(zzgx object) {
        block8: {
            int n;
            Preconditions.checkNotNull(object);
            List<Pair<zzgx, zzbi>> list = this.zzf;
            // MONITORENTER : list
            for (int i = 0; i < (n = this.zzf.size()); ++i) {
                n = object.equals(this.zzf.get((int)i).first) ? 1 : 0;
                if (n == 0) continue;
                object = this.zzf.get(i);
                break block8;
            }
            object = null;
        }
        if (object == null) {
            Log.w((String)this.zzd, (String)"OnEventListener had not been registered.");
            // MONITOREXIT : list
            return;
        }
        this.zzf.remove(object);
        object = (zzbi)((Object)object.second);
        // MONITOREXIT : list
        if (this.zzk != null) {
            try {
                this.zzk.unregisterOnMeasurementEventListener(object);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzbd zzbd2 = new zzbd(this, (zzbi)((Object)object));
        this.zzU(zzbd2);
    }

    public final void zzg(@NonNull String string, Bundle bundle) {
        this.zzW(null, string, bundle, false, true, null);
    }

    public final void zzh(String string, String string2, Bundle bundle) {
        this.zzW(string, string2, bundle, true, true, null);
    }

    public final void zzi(String string, String string2, Bundle bundle, long l) {
        this.zzW(string, string2, bundle, true, false, l);
    }

    private final void zzW(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        zzbe zzbe2 = new zzbe(this, l, string, string2, bundle, bl, bl2);
        this.zzU(zzbe2);
    }

    public final void zzj(String string, String string2, Object object, boolean bl) {
        zzbf zzbf2 = new zzbf(this, string, string2, object, bl);
        this.zzU(zzbf2);
    }

    public final void zzk(Bundle bundle) {
        zzaa zzaa2 = new zzaa(this, bundle);
        this.zzU(zzaa2);
    }

    public final void zzl(String string, String string2, Bundle bundle) {
        zzab zzab2 = new zzab(this, string, string2, bundle);
        this.zzU(zzab2);
    }

    public final List<Bundle> zzm(String string, String string2) {
        zzm zzm2 = new zzm();
        zzac zzac2 = new zzac((zzbr)((Object)list), string, string2, zzm2);
        ((zzbr)((Object)list)).zzU(zzac2);
        List list = (List)zzm.zze((Bundle)zzm2.zzd(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final void zzn(String string) {
        zzad zzad2 = new zzad(this, string);
        this.zzU(zzad2);
    }

    public final void zzo(Activity activity, String string, String string2) {
        zzae zzae2 = new zzae(this, activity, string, string2);
        this.zzU(zzae2);
    }

    public final void zzp(Boolean bl) {
        zzaf zzaf2 = new zzaf(this, bl);
        this.zzU(zzaf2);
    }

    public final void zzq(Bundle bundle) {
        zzag zzag2 = new zzag(this, bundle);
        this.zzU(zzag2);
    }

    public final void zzr(Bundle bundle) {
        zzah zzah2 = new zzah(this, bundle);
        this.zzU(zzah2);
    }

    public final void zzs() {
        zzai zzai2 = new zzai(this);
        this.zzU(zzai2);
    }

    public final void zzt(long l) {
        zzaj zzaj2 = new zzaj(this, l);
        this.zzU(zzaj2);
    }

    public final void zzu(String string) {
        zzal zzal2 = new zzal(this, string);
        this.zzU(zzal2);
    }

    public final void zzv(String string) {
        zzam zzam2 = new zzam(this, string);
        this.zzU(zzam2);
    }

    public final String zzw() {
        zzm zzm2 = new zzm();
        zzan zzan2 = new zzan(this, zzm2);
        this.zzU(zzan2);
        return zzm2.zzc(500L);
    }

    public final String zzx() {
        zzm zzm2 = new zzm();
        zzao zzao2 = new zzao(this, zzm2);
        this.zzU(zzao2);
        return zzm2.zzc(50L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long zzy() {
        int n;
        Object object = new zzm();
        zzap zzap2 = new zzap(this, (zzm)object);
        this.zzU(zzap2);
        object = (Long)zzm.zze((Bundle)object.zzd(500L), Long.class);
        long l = (Long)object;
        if (object != null) return l;
        object = new Random(System.nanoTime() ^ this.zza.currentTimeMillis());
        long l2 = ((Random)object).nextLong();
        this.zzg = n = this.zzg + 1;
        return l2 += (long)n;
    }

    public final String zzz() {
        zzm zzm2 = new zzm();
        zzaq zzaq2 = new zzaq(this, zzm2);
        this.zzU(zzaq2);
        return zzm2.zzc(500L);
    }

    public final String zzA() {
        zzm zzm2 = new zzm();
        zzar zzar2 = new zzar(this, zzm2);
        this.zzU(zzar2);
        return zzm2.zzc(500L);
    }

    public final Map<String, Object> zzB(String hashMap, String object, boolean bl) {
        Object object2 = new zzm();
        zzas zzas2 = new zzas(zzbr2, (String)((Object)hashMap), (String)object, bl, (zzm)object2);
        zzbr2.zzU(zzas2);
        zzbr zzbr2 = object2.zzd(5000L);
        if (zzbr2 == null || zzbr2.size() == 0) {
            return Collections.emptyMap();
        }
        hashMap = new HashMap<String, Object>(zzbr2.size());
        for (String string : zzbr2.keySet()) {
            object2 = zzbr2.get(string);
            if (!(object2 instanceof Double) && !(object2 instanceof Long) && !(object2 instanceof String)) continue;
            hashMap.put(string, object2);
        }
        return hashMap;
    }

    public final void zzC(int n, String string, Object object, Object object2, Object object3) {
        zzat zzat2 = new zzat(this, false, 5, string, object, null, null);
        this.zzU(zzat2);
    }

    public final Bundle zzD(Bundle bundle, boolean bl) {
        zzm zzm2 = new zzm();
        zzau zzau2 = new zzau(this, bundle, zzm2);
        this.zzU(zzau2);
        if (bl) {
            return zzm2.zzd(5000L);
        }
        return null;
    }

    public final int zzE(String string) {
        zzm zzm2 = new zzm();
        zzaw zzaw2 = new zzaw((zzbr)((Object)n), string, zzm2);
        ((zzbr)((Object)n)).zzU(zzaw2);
        Integer n = (Integer)zzm.zze((Bundle)zzm2.zzd(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    @WorkerThread
    public final String zzF() {
        zzm zzm2 = new zzm();
        zzax zzax2 = new zzax(this, zzm2);
        this.zzU(zzax2);
        return zzm2.zzc(120000L);
    }

    public final String zzG() {
        return this.zzj;
    }

    public final Object zzH(int n) {
        zzm zzm2 = new zzm();
        zzay zzay2 = new zzay(this, zzm2, n);
        this.zzU(zzay2);
        return zzm.zze((Bundle)zzm2.zzd(15000L), Object.class);
    }

    public final void zzI(boolean bl) {
        zzaz zzaz2 = new zzaz(this, bl);
        this.zzU(zzaz2);
    }

    public final void zzJ(Bundle bundle) {
        zzba zzba2 = new zzba(this, bundle);
        this.zzU(zzba2);
    }

    static /* synthetic */ boolean zzK(zzbr zzbr2) {
        return zzbr2.zzi;
    }

    static /* synthetic */ void zzL(zzbr zzbr2, Exception exception, boolean bl, boolean bl2) {
        zzbr2.zzV(exception, bl, bl2);
    }

    static /* synthetic */ boolean zzM(zzbr zzbr2, String string, String string2) {
        return zzbr.zzX(string, string2);
    }

    static /* synthetic */ String zzN(zzbr zzbr2) {
        return zzbr2.zzd;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ void zzO(Context var0) {
        var1_2 = zzbr.class;
        var2_3 = "allow_remote_dynamite";
        synchronized (var1_2) {
            block11: {
                block10: {
                    var3_4 = zzbr.zzh;
                    if (var3_4 == null) break block10;
                    return;
                }
                try {
                    var3_4 = "app_measurement_internal_disable_startup_flags";
                    Preconditions.checkNotEmpty((String)var3_4);
                    try {}
                    catch (PackageManager.NameNotFoundException v0) {}
                    break block11;
                    while (true) {
                        var0 = var0.getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
                        zzbr.zzh = var0.getBoolean(var2_3, true);
                        var0 = var0.edit();
                        var0.remove(var2_3);
                        var0.apply();
lbl23:
                        // 2 sources

                        return;
                    }
                }
                catch (Exception var0_1) {
                    Log.e((String)"FA", (String)"Exception reading flag from SharedPreferences.", (Throwable)var0_1);
                    zzbr.zzh = true;
                    ** continue;
                }
            }
            if ((var4_6 = Wrappers.packageManager((Context)var0).getApplicationInfo(var0.getPackageName(), 128)) == null || (var5_7 = var4_6.metaData) == null || !(var3_5 = var4_6.metaData.getBoolean((String)var3_4))) ** continue;
            zzbr.zzh = true;
            return;
        }
    }

    static /* synthetic */ Boolean zzP() {
        return zzh;
    }

    static /* synthetic */ zzp zzQ(zzbr zzbr2, zzp zzp2) {
        zzbr2.zzk = zzp2;
        return zzp2;
    }

    static /* synthetic */ zzp zzR(zzbr zzbr2) {
        return zzbr2.zzk;
    }

    static /* synthetic */ void zzS(zzbr zzbr2, zzbg zzbg2) {
        zzbr2.zzU(zzbg2);
    }

    static {
        zzh = null;
    }

    protected static final boolean zzT() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static final boolean zzX(String string, String string2) {
        return string2 != null && string != null && !zzbr.zzT();
    }
}

