/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzn;
import com.google.android.gms.internal.measurement.zzs;
import com.google.android.gms.internal.measurement.zzt;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import java.util.Map;

@DynamiteApi
public class AppMeasurementDynamiteService
extends com.google.android.gms.internal.measurement.zzl {
    @VisibleForTesting
    zzfl zza = null;
    private Map<Integer, zzgp> zzb = new ArrayMap();

    private final void zza() {
        if (this.zza == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzv zzv2, long l) throws RemoteException {
        Context context = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        if (this.zza == null) {
            this.zza = zzfl.zza((Context)context, (zzv)zzv2);
            return;
        }
        this.zza.zzr().zzi().zza("Attempting to initialize multiple times");
    }

    public void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(string, string2, bundle, bl, bl2, l);
    }

    public void setUserProperty(String string, String string2, IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zza();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza.zzh().zza(string, string2, object, bl, l);
    }

    public void setUserId(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(null, "_id", (Object)string, true, l);
    }

    public void setCurrentScreen(IObjectWrapper iObjectWrapper, String string, String string2, long l) throws RemoteException {
        this.zza();
        this.zza.zzv().zza((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(bl);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zzd(l);
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(l);
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zzb(l);
    }

    public void getMaxUserProperties(String string, zzn zzn2) throws RemoteException {
        this.zza();
        this.zza.zzh();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        string2 = zzn2;
        this.zza.zzi().zza((zzn)string2, 25);
    }

    public void getCurrentScreenName(zzn zzn2) throws RemoteException {
        this.zza();
        this.zza(zzn2, this.zza.zzh().zzaj());
    }

    public void getCurrentScreenClass(zzn zzn2) throws RemoteException {
        this.zza();
        this.zza(zzn2, this.zza.zzh().zzak());
    }

    public void getCachedAppInstanceId(zzn zzn2) throws RemoteException {
        this.zza();
        this.zza(zzn2, this.zza.zzh().zzah());
    }

    public void getAppInstanceId(zzn zzn2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzi(this, zzn2));
    }

    public void getGmpAppId(zzn zzn2) throws RemoteException {
        this.zza();
        this.zza(zzn2, this.zza.zzh().zzal());
    }

    public void generateEventId(zzn zzn2) throws RemoteException {
        this.zza();
        long l = this.zza.zzi().zzg();
        zzn zzn3 = zzn2;
        this.zza.zzi().zza(zzn3, l);
    }

    public void beginAdUnitExposure(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzz().zza(string, l);
    }

    public void endAdUnitExposure(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzz().zzb(string, l);
    }

    public void initForTests(Map map) throws RemoteException {
        this.zza();
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzn zzn2, long l) throws RemoteException {
        this.zza();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzak zzak2 = new zzak(string2, new zzaf(bundle), string3, l);
        this.zza.zzq().zza((Runnable)new zzh(this, zzn2, zzak2, string));
    }

    public void onActivityStarted(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzho zzho2 = this.zza.zzh().zza;
        if (zzho2 != null) {
            this.zza.zzh().zzab();
            zzho2.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzho zzho2 = this.zza.zzh().zza;
        if (zzho2 != null) {
            this.zza.zzh().zzab();
            zzho2.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityCreated(IObjectWrapper iObjectWrapper, Bundle bundle, long l) throws RemoteException {
        this.zza();
        zzho zzho2 = this.zza.zzh().zza;
        if (zzho2 != null) {
            this.zza.zzh().zzab();
            zzho2.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzho zzho2 = this.zza.zzh().zza;
        if (zzho2 != null) {
            this.zza.zzh().zzab();
            zzho2.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzho zzho2 = this.zza.zzh().zza;
        if (zzho2 != null) {
            this.zza.zzh().zzab();
            zzho2.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzho zzho2 = this.zza.zzh().zza;
        if (zzho2 != null) {
            this.zza.zzh().zzab();
            zzho2.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzn zzn2, long l) throws RemoteException {
        this.zza();
        zzho zzho2 = this.zza.zzh().zza;
        Bundle bundle = new Bundle();
        if (zzho2 != null) {
            this.zza.zzh().zzab();
            zzho2.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzn2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzr().zzi().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void performAction(Bundle bundle, zzn zzn2, long l) throws RemoteException {
        this.zza();
        zzn2.zza(null);
    }

    public void getUserProperties(String string, String string2, boolean bl, zzn zzn2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzk(this, zzn2, string, string2, bl));
    }

    public void logHealthData(int n, String string, IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zza();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zza.zzr().zza(n, true, false, string, object, object2, object3);
    }

    public void setEventInterceptor(zzs zzs2) throws RemoteException {
        this.zza();
        zza zza2 = new zza(zzs2);
        zzgr zzgr2 = this.zza.zzh();
        zzgr2.zzb();
        zzgr2.zzw();
        zzgr2.zzq().zza((Runnable)new zzgz(zzgr2, (zzgq)zza2));
    }

    public void registerOnMeasurementEventListener(zzs zzs2) throws RemoteException {
        this.zza();
        zzgp zzgp2 = this.zzb.get(zzs2.zza());
        if (zzgp2 == null) {
            zzgp2 = new zzb(zzs2);
            this.zzb.put(zzs2.zza(), zzgp2);
        }
        this.zza.zzh().zza(zzgp2);
    }

    public void unregisterOnMeasurementEventListener(zzs zzs2) throws RemoteException {
        this.zza();
        zzgp zzgp2 = this.zzb.remove(zzs2.zza());
        if (zzgp2 == null) {
            zzgp2 = new zzb(zzs2);
        }
        this.zza.zzh().zzb(zzgp2);
    }

    public void setInstanceIdProvider(zzt zzt2) throws RemoteException {
        this.zza();
    }

    public void setConditionalUserProperty(Bundle bundle, long l) throws RemoteException {
        this.zza();
        if (bundle == null) {
            this.zza.zzr().zzf().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzh().zza(bundle, l);
    }

    public void clearConditionalUserProperty(String string, String string2, Bundle bundle) throws RemoteException {
        this.zza();
        this.zza.zzh().zzc(string, string2, bundle);
    }

    public void getConditionalUserProperties(String string, String string2, zzn zzn2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzj(this, zzn2, string, string2));
    }

    public void getTestFlag(zzn zzn2, int n) throws RemoteException {
        this.zza();
        switch (n) {
            case 0: {
                this.zza.zzi().zza(zzn2, this.zza.zzh().zzad());
                return;
            }
            case 1: {
                this.zza.zzi().zza(zzn2, this.zza.zzh().zzae().longValue());
                return;
            }
            case 2: {
                double d = this.zza.zzh().zzag();
                zzn zzn3 = zzn2;
                zzjy zzjy2 = this.zza.zzi();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzn3.zza(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzjy2.zzw.zzr().zzi().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zza.zzi().zza(zzn2, this.zza.zzh().zzaf().intValue());
                return;
            }
            case 4: {
                this.zza.zzi().zza(zzn2, this.zza.zzh().zzac().booleanValue());
            }
        }
    }

    private final void zza(zzn zzn2, String string) {
        this.zza.zzi().zza(zzn2, string);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zza();
        this.zza.zzh().zzb(bl);
    }

    public void isDataCollectionEnabled(zzn zzn2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzl(this, zzn2));
    }

    final class zza
    implements zzgq {
        private zzs zza;

        zza(zzs zzs2) {
            this.zza = zzs2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zza.zzr().zzi().zza("Event interceptor threw exception", (Object)remoteException);
                return;
            }
        }
    }

    final class zzb
    implements zzgp {
        private zzs zza;

        zzb(zzs zzs2) {
            this.zza = zzs2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zza.zzr().zzi().zza("Event listener threw exception", (Object)remoteException);
                return;
            }
        }
    }
}

