/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzq;
import com.google.android.gms.internal.measurement.zzs;
import com.google.android.gms.internal.measurement.zzx;
import com.google.android.gms.internal.measurement.zzy;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzl;
import java.util.Map;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzq {
    @VisibleForTesting
    zzfx zza = null;
    private Map<Integer, zzha> zzb = new ArrayMap();

    private final void zza() {
        if (this.zza == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzaa zzaa2, long l) throws RemoteException {
        Context context = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        if (this.zza == null) {
            this.zza = zzfx.zza((Context)context, (zzaa)zzaa2, (Long)l);
            return;
        }
        this.zza.zzr().zzi().zza("Attempting to initialize multiple times");
    }

    public void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(string, string2, bundle, bl, bl2, l);
    }

    public void setUserProperty(String string, String string2, IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zza();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza.zzh().zza(string, string2, object, bl, l);
    }

    public void setUserId(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(null, "_id", (Object)string, true, l);
    }

    public void setCurrentScreen(IObjectWrapper iObjectWrapper, String string, String string2, long l) throws RemoteException {
        this.zza();
        this.zza.zzv().zza((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(bl);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zzd(l);
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(l);
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zzb(l);
    }

    public void getMaxUserProperties(String string, zzs zzs2) throws RemoteException {
        this.zza();
        this.zza.zzh();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        string2 = zzs2;
        this.zza.zzi().zza((zzs)string2, 25);
    }

    public void getCurrentScreenName(zzs zzs2) throws RemoteException {
        this.zza();
        this.zza(zzs2, this.zza.zzh().zzaj());
    }

    public void getCurrentScreenClass(zzs zzs2) throws RemoteException {
        this.zza();
        this.zza(zzs2, this.zza.zzh().zzak());
    }

    public void getCachedAppInstanceId(zzs zzs2) throws RemoteException {
        this.zza();
        this.zza(zzs2, this.zza.zzh().zzah());
    }

    public void getAppInstanceId(zzs zzs2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzi(this, zzs2));
    }

    public void getGmpAppId(zzs zzs2) throws RemoteException {
        this.zza();
        this.zza(zzs2, this.zza.zzh().zzal());
    }

    public void generateEventId(zzs zzs2) throws RemoteException {
        this.zza();
        long l = this.zza.zzi().zzg();
        zzs zzs3 = zzs2;
        this.zza.zzi().zza(zzs3, l);
    }

    public void beginAdUnitExposure(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzz().zza(string, l);
    }

    public void endAdUnitExposure(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzz().zzb(string, l);
    }

    public void initForTests(Map map) throws RemoteException {
        this.zza();
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzs zzs2, long l) throws RemoteException {
        this.zza();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzaq zzaq2 = new zzaq(string2, new zzal(bundle), string3, l);
        this.zza.zzq().zza((Runnable)new zzh(this, zzs2, zzaq2, string));
    }

    public void onActivityStarted(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhx zzhx2 = this.zza.zzh().zza;
        if (zzhx2 != null) {
            this.zza.zzh().zzab();
            zzhx2.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhx zzhx2 = this.zza.zzh().zza;
        if (zzhx2 != null) {
            this.zza.zzh().zzab();
            zzhx2.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityCreated(IObjectWrapper iObjectWrapper, Bundle bundle, long l) throws RemoteException {
        this.zza();
        zzhx zzhx2 = this.zza.zzh().zza;
        if (zzhx2 != null) {
            this.zza.zzh().zzab();
            zzhx2.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhx zzhx2 = this.zza.zzh().zza;
        if (zzhx2 != null) {
            this.zza.zzh().zzab();
            zzhx2.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhx zzhx2 = this.zza.zzh().zza;
        if (zzhx2 != null) {
            this.zza.zzh().zzab();
            zzhx2.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhx zzhx2 = this.zza.zzh().zza;
        if (zzhx2 != null) {
            this.zza.zzh().zzab();
            zzhx2.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzs zzs2, long l) throws RemoteException {
        this.zza();
        zzhx zzhx2 = this.zza.zzh().zza;
        Bundle bundle = new Bundle();
        if (zzhx2 != null) {
            this.zza.zzh().zzab();
            zzhx2.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzs2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzr().zzi().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void performAction(Bundle bundle, zzs zzs2, long l) throws RemoteException {
        this.zza();
        zzs2.zza(null);
    }

    public void getUserProperties(String string, String string2, boolean bl, zzs zzs2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzk(this, zzs2, string, string2, bl));
    }

    public void logHealthData(int n, String string, IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zza();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zza.zzr().zza(n, true, false, string, object, object2, object3);
    }

    public void setEventInterceptor(zzx zzx2) throws RemoteException {
        this.zza();
        zza zza2 = new zza(zzx2);
        zzhc zzhc2 = this.zza.zzh();
        zzhc2.zzb();
        zzhc2.zzw();
        zzhc2.zzq().zza((Runnable)new zzhm(zzhc2, (zzgx)zza2));
    }

    public void registerOnMeasurementEventListener(zzx zzx2) throws RemoteException {
        this.zza();
        zzha zzha2 = this.zzb.get(zzx2.zza());
        if (zzha2 == null) {
            zzha2 = new zzb(zzx2);
            this.zzb.put(zzx2.zza(), zzha2);
        }
        this.zza.zzh().zza(zzha2);
    }

    public void unregisterOnMeasurementEventListener(zzx zzx2) throws RemoteException {
        this.zza();
        zzha zzha2 = this.zzb.remove(zzx2.zza());
        if (zzha2 == null) {
            zzha2 = new zzb(zzx2);
        }
        this.zza.zzh().zzb(zzha2);
    }

    public void setInstanceIdProvider(zzy zzy2) throws RemoteException {
        this.zza();
    }

    public void setConditionalUserProperty(Bundle bundle, long l) throws RemoteException {
        this.zza();
        if (bundle == null) {
            this.zza.zzr().zzf().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzh().zza(bundle, l);
    }

    public void clearConditionalUserProperty(String string, String string2, Bundle bundle) throws RemoteException {
        this.zza();
        this.zza.zzh().zzc(string, string2, bundle);
    }

    public void getConditionalUserProperties(String string, String string2, zzs zzs2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzj(this, zzs2, string, string2));
    }

    public void getTestFlag(zzs zzs2, int n) throws RemoteException {
        this.zza();
        switch (n) {
            case 0: {
                this.zza.zzi().zza(zzs2, this.zza.zzh().zzad());
                return;
            }
            case 1: {
                this.zza.zzi().zza(zzs2, this.zza.zzh().zzae().longValue());
                return;
            }
            case 2: {
                double d = this.zza.zzh().zzag();
                zzs zzs3 = zzs2;
                zzko zzko2 = this.zza.zzi();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzs3.zza(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzko2.zzz.zzr().zzi().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zza.zzi().zza(zzs2, this.zza.zzh().zzaf().intValue());
                return;
            }
            case 4: {
                this.zza.zzi().zza(zzs2, this.zza.zzh().zzac().booleanValue());
            }
        }
    }

    private final void zza(zzs zzs2, String string) {
        this.zza.zzi().zza(zzs2, string);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zza();
        this.zza.zzh().zzb(bl);
    }

    public void isDataCollectionEnabled(zzs zzs2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzl(this, zzs2));
    }

    public void setDefaultEventParameters(Bundle bundle) {
        this.zza();
        Bundle bundle2 = bundle;
        zzhc zzhc2 = this.zza.zzh();
        Bundle bundle3 = bundle2 == null ? null : new Bundle(bundle2);
        zzhc2.zzq().zza((Runnable)new zzhb(zzhc2, bundle3));
    }

    final class zza
    implements zzgx {
        private zzx zza;

        zza(zzx zzx2) {
            this.zza = zzx2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zza.zzr().zzi().zza("Event interceptor threw exception", (Object)remoteException);
                return;
            }
        }
    }

    final class zzb
    implements zzha {
        private zzx zza;

        zzb(zzx zzx2) {
            this.zza = zzx2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zza.zzr().zzi().zza("Event listener threw exception", (Object)remoteException);
                return;
            }
        }
    }
}

