/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzab;
import com.google.android.gms.internal.measurement.zzac;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzu;
import com.google.android.gms.internal.measurement.zzw;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzl;
import java.util.Map;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzu {
    @VisibleForTesting
    zzgd zza = null;
    private Map<Integer, zzhf> zzb = new ArrayMap();

    public AppMeasurementDynamiteService() {
    }

    private final void zza() {
        if (this.zza == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzae zzae2, long l) throws RemoteException {
        Context context = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        if (this.zza == null) {
            this.zza = zzgd.zza((Context)context, (zzae)zzae2, (Long)l);
            return;
        }
        this.zza.zzr().zzi().zza("Attempting to initialize multiple times");
    }

    public void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(string, string2, bundle, bl, bl2, l);
    }

    public void setUserProperty(String string, String string2, IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zza();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza.zzh().zza(string, string2, object, bl, l);
    }

    public void setUserId(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(null, "_id", (Object)string, true, l);
    }

    public void setCurrentScreen(IObjectWrapper iObjectWrapper, String string, String string2, long l) throws RemoteException {
        this.zza();
        this.zza.zzv().zza((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(bl);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zza();
        zzhh zzhh2 = this.zza.zzh();
        zzhh2.zza(null);
        zzhh2.zzq().zza((Runnable)new zzhp(zzhh2, l));
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zza();
        zzhh zzhh2 = this.zza.zzh();
        zzhh2.zzb();
        zzhh2.zzq().zza((Runnable)new zzia(zzhh2, l));
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zza();
        zzhh zzhh2 = this.zza.zzh();
        zzhh2.zzb();
        zzhh2.zzq().zza((Runnable)new zzhl(zzhh2, l));
    }

    public void getMaxUserProperties(String string, zzw zzw2) throws RemoteException {
        this.zza();
        this.zza.zzh();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        string2 = zzw2;
        this.zza.zzi().zza((zzw)string2, 25);
    }

    public void getCurrentScreenName(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza(zzw2, this.zza.zzh().zzaj());
    }

    public void getCurrentScreenClass(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza(zzw2, this.zza.zzh().zzak());
    }

    public void getCachedAppInstanceId(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza(zzw2, this.zza.zzh().zzah());
    }

    public void getAppInstanceId(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzh(this, zzw2));
    }

    public void getGmpAppId(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza(zzw2, this.zza.zzh().zzal());
    }

    public void generateEventId(zzw zzw2) throws RemoteException {
        this.zza();
        long l = this.zza.zzi().zzg();
        zzw zzw3 = zzw2;
        this.zza.zzi().zza(zzw3, l);
    }

    public void beginAdUnitExposure(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzz().zza(string, l);
    }

    public void endAdUnitExposure(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzz().zzb(string, l);
    }

    public void initForTests(Map map) throws RemoteException {
        this.zza();
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzw zzw2, long l) throws RemoteException {
        this.zza();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzao zzao2 = new zzao(string2, new zzan(bundle), string3, l);
        this.zza.zzq().zza((Runnable)new zzj(this, zzw2, zzao2, string));
    }

    public void onActivityStarted(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzid zzid2 = this.zza.zzh().zza;
        if (zzid2 != null) {
            this.zza.zzh().zzab();
            zzid2.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzid zzid2 = this.zza.zzh().zza;
        if (zzid2 != null) {
            this.zza.zzh().zzab();
            zzid2.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityCreated(IObjectWrapper iObjectWrapper, Bundle bundle, long l) throws RemoteException {
        this.zza();
        zzid zzid2 = this.zza.zzh().zza;
        if (zzid2 != null) {
            this.zza.zzh().zzab();
            zzid2.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzid zzid2 = this.zza.zzh().zza;
        if (zzid2 != null) {
            this.zza.zzh().zzab();
            zzid2.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzid zzid2 = this.zza.zzh().zza;
        if (zzid2 != null) {
            this.zza.zzh().zzab();
            zzid2.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzid zzid2 = this.zza.zzh().zza;
        if (zzid2 != null) {
            this.zza.zzh().zzab();
            zzid2.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzw zzw2, long l) throws RemoteException {
        this.zza();
        zzid zzid2 = this.zza.zzh().zza;
        Bundle bundle = new Bundle();
        if (zzid2 != null) {
            this.zza.zzh().zzab();
            zzid2.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzw2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzr().zzi().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void performAction(Bundle bundle, zzw zzw2, long l) throws RemoteException {
        this.zza();
        zzw2.zza(null);
    }

    public void getUserProperties(String string, String string2, boolean bl, zzw zzw2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzi(this, zzw2, string, string2, bl));
    }

    public void logHealthData(int n, String string, IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zza();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zza.zzr().zza(n, true, false, string, object, object2, object3);
    }

    public void setEventInterceptor(zzab zzab2) throws RemoteException {
        this.zza();
        zzb zzb2 = new zzb(zzab2);
        zzhh zzhh2 = this.zza.zzh();
        zzhh2.zzb();
        zzhh2.zzw();
        zzhh2.zzq().zza((Runnable)new zzho(zzhh2, (zzhc)zzb2));
    }

    public void registerOnMeasurementEventListener(zzab zzab2) throws RemoteException {
        this.zza();
        zzhf zzhf2 = this.zzb.get(zzab2.zza());
        if (zzhf2 == null) {
            zzhf2 = new zza(zzab2);
            this.zzb.put(zzab2.zza(), zzhf2);
        }
        this.zza.zzh().zza(zzhf2);
    }

    public void unregisterOnMeasurementEventListener(zzab zzab2) throws RemoteException {
        this.zza();
        zzhf zzhf2 = this.zzb.remove(zzab2.zza());
        if (zzhf2 == null) {
            zzhf2 = new zza(zzab2);
        }
        this.zza.zzh().zzb(zzhf2);
    }

    public void setInstanceIdProvider(zzac zzac2) throws RemoteException {
        this.zza();
    }

    public void setConditionalUserProperty(Bundle bundle, long l) throws RemoteException {
        this.zza();
        if (bundle == null) {
            this.zza.zzr().zzf().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzh().zza(bundle, l);
    }

    public void clearConditionalUserProperty(String string, String string2, Bundle bundle) throws RemoteException {
        this.zza();
        this.zza.zzh().zzc(string, string2, bundle);
    }

    public void getConditionalUserProperties(String string, String string2, zzw zzw2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzl(this, zzw2, string, string2));
    }

    public void getTestFlag(zzw zzw2, int n) throws RemoteException {
        this.zza();
        switch (n) {
            case 0: {
                this.zza.zzi().zza(zzw2, this.zza.zzh().zzad());
                return;
            }
            case 1: {
                this.zza.zzi().zza(zzw2, this.zza.zzh().zzae().longValue());
                return;
            }
            case 2: {
                double d = this.zza.zzh().zzag();
                zzw zzw3 = zzw2;
                zzkw zzkw2 = this.zza.zzi();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzw3.zza(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzkw2.zzy.zzr().zzi().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zza.zzi().zza(zzw2, this.zza.zzh().zzaf().intValue());
                return;
            }
            case 4: {
                this.zza.zzi().zza(zzw2, this.zza.zzh().zzac().booleanValue());
            }
        }
    }

    private final void zza(zzw zzw2, String string) {
        this.zza.zzi().zza(zzw2, string);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zza();
        zzhh zzhh2 = this.zza.zzh();
        zzhh2.zzw();
        zzhh2.zzb();
        zzhh2.zzq().zza((Runnable)new zzhy(zzhh2, bl));
    }

    public void isDataCollectionEnabled(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzk(this, zzw2));
    }

    public void setDefaultEventParameters(Bundle bundle) {
        this.zza();
        Bundle bundle2 = bundle;
        zzhh zzhh2 = this.zza.zzh();
        Bundle bundle3 = bundle2 == null ? null : new Bundle(bundle2);
        zzhh2.zzq().zza((Runnable)new zzhg(zzhh2, bundle3));
    }

    final class zzb
    implements zzhc {
        private zzab zza;

        zzb(zzab zzab2) {
            this.zza = zzab2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zza.zzr().zzi().zza("Event interceptor threw exception", (Object)remoteException);
                return;
            }
        }
    }

    final class zza
    implements zzhf {
        private zzab zza;

        zza(zzab zzab2) {
            this.zza = zzab2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zza.zzr().zzi().zza("Event listener threw exception", (Object)remoteException);
                return;
            }
        }
    }
}

