/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzab;
import com.google.android.gms.internal.measurement.zzac;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzml;
import com.google.android.gms.internal.measurement.zzu;
import com.google.android.gms.internal.measurement.zzw;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzm;
import java.util.Map;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzu {
    @VisibleForTesting
    zzfu zza = null;
    @GuardedBy(value="listenerMap")
    private final Map<Integer, zzgz> zzb = new ArrayMap();

    private final void zza() {
        if (this.zza == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzae zzae2, long l) throws RemoteException {
        Context context = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        if (this.zza == null) {
            this.zza = zzfu.zza((Context)context, (zzae)zzae2, (Long)l);
            return;
        }
        this.zza.zzq().zzh().zza("Attempting to initialize multiple times");
    }

    public void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zza();
        this.zza.zzg().zza(string, string2, bundle, bl, bl2, l);
    }

    public void setUserProperty(String string, String string2, IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zza();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza.zzg().zza(string, string2, object, bl, l);
    }

    public void setUserId(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzg().zza(null, "_id", (Object)string, true, l);
    }

    public void setCurrentScreen(IObjectWrapper iObjectWrapper, String string, String string2, long l) throws RemoteException {
        this.zza();
        this.zza.zzu().zza((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zza();
        this.zza.zzg().zza(Boolean.valueOf(bl));
    }

    public void clearMeasurementEnabled(long l) throws RemoteException {
        this.zza();
        this.zza.zzg().zza(null);
    }

    public void setConsent(Bundle bundle, long l) throws RemoteException {
        this.zza();
        Bundle bundle2 = bundle;
        zzhb zzhb2 = this.zza.zzg();
        if (zzml.zzb()) {
            zzej zzej2 = zzas.zzcg;
            if (zzhb2.zzs().zzd(null, zzej2)) {
                zzhb2.zza(bundle2, 30, l);
            }
        }
    }

    public void setConsentThirdParty(Bundle bundle, long l) throws RemoteException {
        this.zza();
        Bundle bundle2 = bundle;
        zzhb zzhb2 = this.zza.zzg();
        if (zzml.zzb()) {
            zzej zzej2 = zzas.zzch;
            if (zzhb2.zzs().zzd(null, zzej2)) {
                zzhb2.zza(bundle2, 10, l);
            }
        }
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zza();
        zzhb zzhb2 = this.zza.zzg();
        zzhb2.zza(null);
        zzhb2.zzp().zza((Runnable)new zzhk(zzhb2, l));
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zza();
        zzhb zzhb2 = this.zza.zzg();
        zzhb2.zzp().zza((Runnable)new zzhh(zzhb2, l));
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zza();
        zzhb zzhb2 = this.zza.zzg();
        zzhb2.zzp().zza((Runnable)new zzhg(zzhb2, l));
    }

    public void getMaxUserProperties(String string, zzw zzw2) throws RemoteException {
        this.zza();
        this.zza.zzg();
        Preconditions.checkNotEmpty((String)string);
        zzw zzw3 = zzw2;
        this.zza.zzh().zza(zzw3, 25);
    }

    public void getCurrentScreenName(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza(zzw2, this.zza.zzg().zzai());
    }

    public void getCurrentScreenClass(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza(zzw2, this.zza.zzg().zzaj());
    }

    public void getCachedAppInstanceId(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza(zzw2, this.zza.zzg().zzag());
    }

    public void getAppInstanceId(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza.zzp().zza((Runnable)new zzh(this, zzw2));
    }

    public void getGmpAppId(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza(zzw2, this.zza.zzg().zzak());
    }

    public void generateEventId(zzw zzw2) throws RemoteException {
        this.zza();
        long l = this.zza.zzh().zzf();
        zzw zzw3 = zzw2;
        this.zza.zzh().zza(zzw3, l);
    }

    public void beginAdUnitExposure(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzy().zza(string, l);
    }

    public void endAdUnitExposure(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzy().zzb(string, l);
    }

    public void initForTests(Map map) throws RemoteException {
        this.zza();
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzw zzw2, long l) throws RemoteException {
        this.zza();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzaq zzaq2 = new zzaq(string2, new zzap(bundle), string3, l);
        this.zza.zzp().zza((Runnable)new zzj(this, zzw2, zzaq2, string));
    }

    public void onActivityStarted(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhy zzhy2 = this.zza.zzg().zza;
        if (zzhy2 != null) {
            this.zza.zzg().zzaa();
            zzhy2.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhy zzhy2 = this.zza.zzg().zza;
        if (zzhy2 != null) {
            this.zza.zzg().zzaa();
            zzhy2.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityCreated(IObjectWrapper iObjectWrapper, Bundle bundle, long l) throws RemoteException {
        this.zza();
        zzhy zzhy2 = this.zza.zzg().zza;
        if (zzhy2 != null) {
            this.zza.zzg().zzaa();
            zzhy2.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhy zzhy2 = this.zza.zzg().zza;
        if (zzhy2 != null) {
            this.zza.zzg().zzaa();
            zzhy2.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhy zzhy2 = this.zza.zzg().zza;
        if (zzhy2 != null) {
            this.zza.zzg().zzaa();
            zzhy2.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhy zzhy2 = this.zza.zzg().zza;
        if (zzhy2 != null) {
            this.zza.zzg().zzaa();
            zzhy2.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzw zzw2, long l) throws RemoteException {
        this.zza();
        zzhy zzhy2 = this.zza.zzg().zza;
        Bundle bundle = new Bundle();
        if (zzhy2 != null) {
            this.zza.zzg().zzaa();
            zzhy2.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzw2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzq().zzh().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void performAction(Bundle bundle, zzw zzw2, long l) throws RemoteException {
        this.zza();
        zzw2.zza(null);
    }

    public void getUserProperties(String string, String string2, boolean bl, zzw zzw2) throws RemoteException {
        this.zza();
        this.zza.zzp().zza((Runnable)new zzi(this, zzw2, string, string2, bl));
    }

    public void logHealthData(int n, String string, IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zza();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zza.zzq().zza(n, true, false, string, object, object2, object3);
    }

    public void setEventInterceptor(zzab zzab2) throws RemoteException {
        this.zza();
        zza zza2 = new zza(zzab2);
        if (this.zza.zzp().zzf()) {
            this.zza.zzg().zza((zzgw)zza2);
            return;
        }
        this.zza.zzp().zza((Runnable)new zzl(this, zza2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnMeasurementEventListener(zzab zzab2) throws RemoteException {
        zzgz zzgz2;
        this.zza();
        Map<Integer, zzgz> map = this.zzb;
        synchronized (map) {
            zzgz2 = this.zzb.get(zzab2.zza());
            if (zzgz2 == null) {
                zzgz2 = new zzb(zzab2);
                this.zzb.put(zzab2.zza(), zzgz2);
            }
        }
        this.zza.zzg().zza(zzgz2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnMeasurementEventListener(zzab zzab2) throws RemoteException {
        zzgz zzgz2;
        this.zza();
        Map<Integer, zzgz> map = this.zzb;
        synchronized (map) {
            zzgz2 = this.zzb.remove(zzab2.zza());
        }
        if (zzgz2 == null) {
            zzgz2 = new zzb(zzab2);
        }
        this.zza.zzg().zzb(zzgz2);
    }

    public void setInstanceIdProvider(zzac zzac2) throws RemoteException {
        this.zza();
    }

    public void setConditionalUserProperty(Bundle bundle, long l) throws RemoteException {
        this.zza();
        if (bundle == null) {
            this.zza.zzq().zze().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzg().zza(bundle, l);
    }

    public void clearConditionalUserProperty(String string, String string2, Bundle bundle) throws RemoteException {
        this.zza();
        this.zza.zzg().zzc(string, string2, bundle);
    }

    public void getConditionalUserProperties(String string, String string2, zzw zzw2) throws RemoteException {
        this.zza();
        this.zza.zzp().zza((Runnable)new zzk(this, zzw2, string, string2));
    }

    public void getTestFlag(zzw zzw2, int n) throws RemoteException {
        this.zza();
        switch (n) {
            case 0: {
                this.zza.zzh().zza(zzw2, this.zza.zzg().zzac());
                return;
            }
            case 1: {
                this.zza.zzh().zza(zzw2, this.zza.zzg().zzad().longValue());
                return;
            }
            case 2: {
                double d = this.zza.zzg().zzaf();
                zzw zzw3 = zzw2;
                zzkv zzkv2 = this.zza.zzh();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzw3.zza(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzkv2.zzy.zzq().zzh().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zza.zzh().zza(zzw2, this.zza.zzg().zzae().intValue());
                return;
            }
            case 4: {
                this.zza.zzh().zza(zzw2, this.zza.zzg().zzab().booleanValue());
            }
        }
    }

    private final void zza(zzw zzw2, String string) {
        this.zza.zzh().zza(zzw2, string);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zza();
        zzhb zzhb2 = this.zza.zzg();
        zzhb2.zzv();
        zzhb2.zzp().zza((Runnable)new zzhf(zzhb2, bl));
    }

    public void isDataCollectionEnabled(zzw zzw2) throws RemoteException {
        this.zza();
        this.zza.zzp().zza((Runnable)new zzm(this, zzw2));
    }

    public void setDefaultEventParameters(Bundle bundle) {
        this.zza();
        Bundle bundle2 = bundle;
        zzhb zzhb2 = this.zza.zzg();
        Bundle bundle3 = bundle2 == null ? null : new Bundle(bundle2);
        zzhb2.zzp().zza((Runnable)new zzha(zzhb2, bundle3));
    }

    final class zza
    implements zzgw {
        private zzab zza;

        zza(zzab zzab2) {
            this.zza = zzab2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zza.zzq().zzh().zza("Event interceptor threw exception", (Object)remoteException);
                return;
            }
        }
    }

    final class zzb
    implements zzgz {
        private zzab zza;

        zzb(zzab zzab2) {
            this.zza = zzab2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zza.zzq().zzh().zza("Event listener threw exception", (Object)remoteException);
                return;
            }
        }
    }
}

