/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzct;
import com.google.android.gms.internal.measurement.zzcv;
import com.google.android.gms.internal.measurement.zzda;
import com.google.android.gms.internal.measurement.zzdb;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzng;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzct {
    @VisibleForTesting
    @MonotonicNonNull zzhd zza = null;
    @GuardedBy(value="listenerMap")
    private final Map<Integer, zzij> zzb = new ArrayMap();

    public void beginAdUnitExposure(@NonNull String string, long l) throws RemoteException {
        this.zza();
        this.zza.zze().zza(string, l);
    }

    @EnsuresNonNull(value={"scion"})
    private final void zza() {
        if (this.zza == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void clearConditionalUserProperty(@NonNull String string, @NonNull @Nullable String string2, @NonNull @Nullable Bundle bundle) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, string2, bundle);
    }

    public void clearMeasurementEnabled(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(null);
    }

    public void endAdUnitExposure(@NonNull String string, long l) throws RemoteException {
        this.zza();
        this.zza.zze().zzb(string, l);
    }

    public void generateEventId(zzcv zzcv2) throws RemoteException {
        this.zza();
        long l = this.zza.zzt().zzm();
        zzcv zzcv3 = zzcv2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        appMeasurementDynamiteService.zza();
        appMeasurementDynamiteService.zza.zzt().zza(zzcv3, l);
    }

    public void getAppInstanceId(zzcv zzcv2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzi(this, zzcv2));
    }

    public void getCachedAppInstanceId(zzcv zzcv2) throws RemoteException {
        this.zza();
        this.zza(zzcv2, this.zza.zzp().zzae());
    }

    public void getConditionalUserProperties(@Nullable String string, @Nullable String string2, zzcv zzcv2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzm(this, zzcv2, string, string2));
    }

    public void getCurrentScreenClass(zzcv zzcv2) throws RemoteException {
        this.zza();
        this.zza(zzcv2, this.zza.zzp().zzaf());
    }

    public void getCurrentScreenName(zzcv zzcv2) throws RemoteException {
        this.zza();
        this.zza(zzcv2, this.zza.zzp().zzag());
    }

    public void getGmpAppId(zzcv zzcv2) throws RemoteException {
        this.zza();
        this.zza(zzcv2, this.zza.zzp().zzah());
    }

    public void getMaxUserProperties(String string, zzcv zzcv2) throws RemoteException {
        this.zza();
        this.zza.zzp();
        Preconditions.checkNotEmpty((String)string);
        zzcv zzcv3 = zzcv2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        appMeasurementDynamiteService.zza();
        appMeasurementDynamiteService.zza.zzt().zza(zzcv3, 25);
    }

    public void getSessionId(zzcv zzcv2) throws RemoteException {
        this.zza();
        zzcv zzcv3 = zzcv2;
        zzio zzio2 = this.zza.zzp();
        zzio2.zzl().zzb((Runnable)new zzjq(zzio2, zzcv3));
    }

    public void getTestFlag(zzcv zzcv2, int n) throws RemoteException {
        this.zza();
        switch (n) {
            case 0: {
                this.zza.zzt().zza(zzcv2, this.zza.zzp().zzai());
                return;
            }
            case 1: {
                this.zza.zzt().zza(zzcv2, this.zza.zzp().zzad().longValue());
                return;
            }
            case 2: {
                double d = this.zza.zzp().zzab();
                zzcv zzcv3 = zzcv2;
                zzng zzng2 = this.zza.zzt();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzcv3.zza(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzng2.zzu.zzj().zzu().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zza.zzt().zza(zzcv2, this.zza.zzp().zzac().intValue());
                return;
            }
            case 4: {
                this.zza.zzt().zza(zzcv2, this.zza.zzp().zzaa().booleanValue());
            }
        }
    }

    public void getUserProperties(@Nullable String string, @Nullable String string2, boolean bl, zzcv zzcv2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzk(this, zzcv2, string, string2, bl));
    }

    public void initForTests(@NonNull Map map) throws RemoteException {
        this.zza();
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzdd zzdd2, long l) throws RemoteException {
        if (this.zza == null) {
            this.zza = zzhd.zza((Context)((Context)Preconditions.checkNotNull((Object)((Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)))), (zzdd)zzdd2, (Long)l);
            return;
        }
        this.zza.zzj().zzu().zza("Attempting to initialize multiple times");
    }

    public void isDataCollectionEnabled(zzcv zzcv2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzl(this, zzcv2));
    }

    public void logEvent(@NonNull @Nullable String string, @NonNull String string2, @NonNull @Nullable Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, string2, bundle, bl, bl2, l);
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzcv zzcv2, long l) throws RemoteException {
        this.zza();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzbe zzbe2 = new zzbe(string2, new zzaz(bundle), string3, l);
        this.zza.zzl().zzb((Runnable)new zzh(this, zzcv2, zzbe2, string));
    }

    public void logHealthData(int n, @NonNull String string, @NonNull IObjectWrapper iObjectWrapper, @NonNull IObjectWrapper iObjectWrapper2, @NonNull IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zza();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zza.zzj().zza(n, true, false, string, object, object2, object3);
    }

    public void onActivityCreated(@NonNull IObjectWrapper iObjectWrapper, @NonNull @Nullable Bundle bundle, long l) throws RemoteException {
        this.zza();
        zzjx zzjx2 = this.zza.zzp().zza;
        if (zzjx2 != null) {
            this.zza.zzp().zzak();
            zzjx2.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzjx zzjx2 = this.zza.zzp().zza;
        if (zzjx2 != null) {
            this.zza.zzp().zzak();
            zzjx2.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzjx zzjx2 = this.zza.zzp().zza;
        if (zzjx2 != null) {
            this.zza.zzp().zzak();
            zzjx2.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzjx zzjx2 = this.zza.zzp().zza;
        if (zzjx2 != null) {
            this.zza.zzp().zzak();
            zzjx2.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzcv zzcv2, long l) throws RemoteException {
        this.zza();
        zzjx zzjx2 = this.zza.zzp().zza;
        Bundle bundle = new Bundle();
        if (zzjx2 != null) {
            this.zza.zzp().zzak();
            zzjx2.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzcv2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzj().zzu().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void onActivityStarted(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzjx zzjx2 = this.zza.zzp().zza;
        if (zzjx2 != null) {
            this.zza.zzp().zzak();
            zzjx2.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzjx zzjx2 = this.zza.zzp().zza;
        if (zzjx2 != null) {
            this.zza.zzp().zzak();
            zzjx2.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void performAction(Bundle bundle, zzcv zzcv2, long l) throws RemoteException {
        this.zza();
        zzcv2.zza(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnMeasurementEventListener(zzda zzda2) throws RemoteException {
        zzij zzij2;
        this.zza();
        Map<Integer, zzij> map = this.zzb;
        synchronized (map) {
            zzij2 = this.zzb.get(zzda2.zza());
            if (zzij2 == null) {
                zzij2 = new zza(zzda2);
                this.zzb.put(zzda2.zza(), zzij2);
            }
        }
        this.zza.zzp().zza(zzij2);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zza();
        zzio zzio2 = this.zza.zzp();
        zzio2.zza(null);
        zzio2.zzl().zzb((Runnable)new zzjj(zzio2, l));
    }

    private final void zza(zzcv zzcv2, @Nullable String string) {
        this.zza();
        this.zza.zzt().zza(zzcv2, string);
    }

    public void setConditionalUserProperty(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        if (bundle == null) {
            this.zza.zzj().zzg().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzp().zza(bundle, l);
    }

    public void setConsent(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        Bundle bundle2 = bundle;
        zzio zzio2 = this.zza.zzp();
        Bundle bundle3 = bundle2;
        zzio zzio3 = zzio2;
        zzio2.zzl().zzc((Runnable)new zziu(zzio3, bundle3, l));
    }

    public void setConsentThirdParty(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(bundle, -20, l);
    }

    public void setCurrentScreen(@NonNull IObjectWrapper iObjectWrapper, @NonNull @Nullable String string, @NonNull @Nullable String string2, long l) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zza();
        zzio zzio2 = this.zza.zzp();
        zzio2.zzu();
        zzio2.zzl().zzb((Runnable)new zzjc(zzio2, bl));
    }

    public void setDefaultEventParameters(@NonNull @Nullable Bundle bundle) {
        Bundle bundle2;
        this.zza();
        Bundle bundle3 = bundle;
        zzio zzio2 = this.zza.zzp();
        Bundle bundle4 = bundle2 = bundle3 == null ? null : new Bundle(bundle3);
        zzio zzio3 = zzio2;
        zzio2.zzl().zzb((Runnable)new zzir(zzio3, bundle4));
    }

    public void setEventInterceptor(zzda zzda2) throws RemoteException {
        this.zza();
        zzb zzb2 = new zzb(zzda2);
        if (this.zza.zzl().zzg()) {
            this.zza.zzp().zza((zzik)zzb2);
            return;
        }
        this.zza.zzl().zzb((Runnable)new zzj(this, zzb2));
    }

    public void setInstanceIdProvider(zzdb zzdb2) throws RemoteException {
        this.zza();
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(Boolean.valueOf(bl));
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zza();
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zza();
        zzio zzio2 = this.zza.zzp();
        zzio2.zzl().zzb((Runnable)new zzje(zzio2, l));
    }

    public void setUserId(@NonNull @Nullable String string, long l) throws RemoteException {
        this.zza();
        String string2 = string;
        zzio zzio2 = this.zza.zzp();
        if (string2 != null && TextUtils.isEmpty((CharSequence)string2)) {
            zzio2.zzu.zzj().zzu().zza("User ID must be non-empty or null");
            return;
        }
        String string3 = string2;
        zzio zzio3 = zzio2;
        zzio2.zzl().zzb((Runnable)new zziv(zzio3, string3));
        zzio2.zza(null, "_id", (Object)string2, true, l);
    }

    public void setUserProperty(@NonNull @Nullable String string, @NonNull String string2, @NonNull IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zza();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza.zzp().zza(string, string2, object, bl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnMeasurementEventListener(zzda zzda2) throws RemoteException {
        zzij zzij2;
        this.zza();
        Map<Integer, zzij> map = this.zzb;
        synchronized (map) {
            zzij2 = this.zzb.remove(zzda2.zza());
        }
        if (zzij2 == null) {
            zzij2 = new zza(zzda2);
        }
        this.zza.zzp().zzb(zzij2);
    }

    final class zzb
    implements zzik {
        private zzda zza;

        zzb(zzda zzda2) {
            this.zza = zzda2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                if (AppMeasurementDynamiteService.this.zza != null) {
                    AppMeasurementDynamiteService.this.zza.zzj().zzu().zza("Event interceptor threw exception", (Object)remoteException);
                }
                return;
            }
        }
    }

    final class zza
    implements zzij {
        private zzda zza;

        zza(zzda zzda2) {
            this.zza = zzda2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                if (AppMeasurementDynamiteService.this.zza != null) {
                    AppMeasurementDynamiteService.this.zza.zzj().zzu().zza("Event listener threw exception", (Object)remoteException);
                }
                return;
            }
        }
    }
}

