/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzdb;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzdl;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zznt;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzdb {
    @VisibleForTesting
    @MonotonicNonNull zzhj zza = null;
    @GuardedBy(value="listenerMap")
    private final Map<Integer, zziu> zzb = new ArrayMap();

    public void beginAdUnitExposure(@NonNull String string, long l) throws RemoteException {
        this.zza();
        this.zza.zze().zza(string, l);
    }

    @EnsuresNonNull(value={"scion"})
    private final void zza() {
        if (this.zza == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void clearConditionalUserProperty(@NonNull String string, @NonNull @Nullable String string2, @NonNull @Nullable Bundle bundle) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, string2, bundle);
    }

    public void clearMeasurementEnabled(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(null);
    }

    public void endAdUnitExposure(@NonNull String string, long l) throws RemoteException {
        this.zza();
        this.zza.zze().zzb(string, l);
    }

    public void generateEventId(zzdd zzdd2) throws RemoteException {
        this.zza();
        long l = this.zza.zzt().zzm();
        zzdd zzdd3 = zzdd2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        appMeasurementDynamiteService.zza();
        appMeasurementDynamiteService.zza.zzt().zza(zzdd3, l);
    }

    public void getAppInstanceId(zzdd zzdd2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzh(this, zzdd2));
    }

    public void getCachedAppInstanceId(zzdd zzdd2) throws RemoteException {
        this.zza();
        this.zza(zzdd2, this.zza.zzp().zzag());
    }

    public void getConditionalUserProperties(@Nullable String string, @Nullable String string2, zzdd zzdd2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzk(this, zzdd2, string, string2));
    }

    public void getCurrentScreenClass(zzdd zzdd2) throws RemoteException {
        this.zza();
        this.zza(zzdd2, this.zza.zzp().zzah());
    }

    public void getCurrentScreenName(zzdd zzdd2) throws RemoteException {
        this.zza();
        this.zza(zzdd2, this.zza.zzp().zzai());
    }

    public void getGmpAppId(zzdd zzdd2) throws RemoteException {
        this.zza();
        this.zza(zzdd2, this.zza.zzp().zzaj());
    }

    public void getMaxUserProperties(String string, zzdd zzdd2) throws RemoteException {
        this.zza();
        this.zza.zzp();
        zziz.zza((String)string);
        zzdd zzdd3 = zzdd2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        appMeasurementDynamiteService.zza();
        appMeasurementDynamiteService.zza.zzt().zza(zzdd3, 25);
    }

    public void getSessionId(zzdd zzdd2) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(zzdd2);
    }

    public void getTestFlag(zzdd zzdd2, int n) throws RemoteException {
        this.zza();
        switch (n) {
            case 0: {
                this.zza.zzt().zza(zzdd2, this.zza.zzp().zzak());
                return;
            }
            case 1: {
                this.zza.zzt().zza(zzdd2, this.zza.zzp().zzaf().longValue());
                return;
            }
            case 2: {
                double d = this.zza.zzp().zzad();
                zzdd zzdd3 = zzdd2;
                zznt zznt2 = this.zza.zzt();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzdd3.zza(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zznt2.zzu.zzj().zzu().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zza.zzt().zza(zzdd2, this.zza.zzp().zzae().intValue());
                return;
            }
            case 4: {
                this.zza.zzt().zza(zzdd2, this.zza.zzp().zzac().booleanValue());
            }
        }
    }

    public void getUserProperties(@Nullable String string, @Nullable String string2, boolean bl, zzdd zzdd2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzi(this, zzdd2, string, string2, bl));
    }

    public void initForTests(@NonNull Map map) throws RemoteException {
        this.zza();
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzdl zzdl2, long l) throws RemoteException {
        if (this.zza == null) {
            this.zza = zzhj.zza((Context)((Context)Preconditions.checkNotNull((Object)((Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)))), (zzdl)zzdl2, (Long)l);
            return;
        }
        this.zza.zzj().zzu().zza("Attempting to initialize multiple times");
    }

    public void isDataCollectionEnabled(zzdd zzdd2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzm(this, zzdd2));
    }

    public void logEvent(@NonNull @Nullable String string, @NonNull String string2, @NonNull @Nullable Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, string2, bundle, bl, bl2, l);
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzdd zzdd2, long l) throws RemoteException {
        this.zza();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzbf zzbf2 = new zzbf(string2, new zzba(bundle), string3, l);
        this.zza.zzl().zzb((Runnable)new zzj(this, zzdd2, zzbf2, string));
    }

    public void logHealthData(int n, @NonNull String string, @NonNull IObjectWrapper iObjectWrapper, @NonNull IObjectWrapper iObjectWrapper2, @NonNull IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zza();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zza.zzj().zza(n, true, false, string, object, object2, object3);
    }

    public void onActivityCreated(@NonNull IObjectWrapper iObjectWrapper, @NonNull @Nullable Bundle bundle, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzan();
            activityLifecycleCallbacks.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzan();
            activityLifecycleCallbacks.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzan();
            activityLifecycleCallbacks.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzan();
            activityLifecycleCallbacks.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzdd zzdd2, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        Bundle bundle = new Bundle();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzan();
            activityLifecycleCallbacks.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzdd2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzj().zzu().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void onActivityStarted(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzan();
            activityLifecycleCallbacks.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzan();
            activityLifecycleCallbacks.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void performAction(Bundle bundle, zzdd zzdd2, long l) throws RemoteException {
        this.zza();
        zzdd2.zza(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnMeasurementEventListener(zzdi zzdi2) throws RemoteException {
        zziu zziu2;
        this.zza();
        Map<Integer, zziu> map = this.zzb;
        synchronized (map) {
            zziu2 = this.zzb.get(zzdi2.zza());
            if (zziu2 == null) {
                zziu2 = new zzb(zzdi2);
                this.zzb.put(zzdi2.zza(), zziu2);
            }
        }
        this.zza.zzp().zza(zziu2);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(l);
    }

    private final void zza(zzdd zzdd2, @Nullable String string) {
        this.zza();
        this.zza.zzt().zza(zzdd2, string);
    }

    public void setConditionalUserProperty(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        if (bundle == null) {
            this.zza.zzj().zzg().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzp().zzb(bundle, l);
    }

    public void setConsent(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zzc(bundle, l);
    }

    public void setConsentThirdParty(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zzd(bundle, l);
    }

    public void setCurrentScreen(@NonNull IObjectWrapper iObjectWrapper, @NonNull @Nullable String string, @NonNull @Nullable String string2, long l) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zza();
        this.zza.zzp().zzc(bl);
    }

    public void setDefaultEventParameters(@NonNull @Nullable Bundle bundle) {
        this.zza();
        this.zza.zzp().zzc(bundle);
    }

    public void setEventInterceptor(zzdi zzdi2) throws RemoteException {
        this.zza();
        zza zza2 = new zza(zzdi2);
        if (this.zza.zzl().zzg()) {
            this.zza.zzp().zza((zziv)zza2);
            return;
        }
        this.zza.zzl().zzb((Runnable)new zzl(this, zza2));
    }

    public void setInstanceIdProvider(zzdj zzdj2) throws RemoteException {
        this.zza();
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(Boolean.valueOf(bl));
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zza();
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zzc(l);
    }

    public void setSgtmDebugInfo(@NonNull Intent intent) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(intent);
    }

    public void setUserId(@NonNull @Nullable String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, l);
    }

    public void setUserProperty(@NonNull @Nullable String string, @NonNull String string2, @NonNull IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zza();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza.zzp().zza(string, string2, object, bl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnMeasurementEventListener(zzdi zzdi2) throws RemoteException {
        zziu zziu2;
        this.zza();
        Map<Integer, zziu> map = this.zzb;
        synchronized (map) {
            zziu2 = this.zzb.remove(zzdi2.zza());
        }
        if (zziu2 == null) {
            zziu2 = new zzb(zzdi2);
        }
        this.zza.zzp().zzb(zziu2);
    }

    final class zza
    implements zziv {
        private zzdi zza;

        zza(zzdi zzdi2) {
            this.zza = zzdi2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                if (AppMeasurementDynamiteService.this.zza != null) {
                    AppMeasurementDynamiteService.this.zza.zzj().zzu().zza("Event interceptor threw exception", (Object)remoteException);
                }
                return;
            }
        }
    }

    final class zzb
    implements zziu {
        private zzdi zza;

        zzb(zzdi zzdi2) {
            this.zza = zzdi2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                if (AppMeasurementDynamiteService.this.zza != null) {
                    AppMeasurementDynamiteService.this.zza.zzj().zzu().zza("Event listener threw exception", (Object)remoteException);
                }
                return;
            }
        }
    }
}

