/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzdm;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzos;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzdm {
    @VisibleForTesting
    @MonotonicNonNull zzhy zza = null;
    @GuardedBy(value="listenerMap")
    private final Map<Integer, zzjl> zzb = new ArrayMap();

    public void beginAdUnitExposure(@NonNull String string, long l) throws RemoteException {
        this.zza();
        this.zza.zze().zza(string, l);
    }

    @EnsuresNonNull(value={"scion"})
    private final void zza() {
        if (this.zza == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void clearConditionalUserProperty(@NonNull String string, @NonNull @Nullable String string2, @NonNull @Nullable Bundle bundle) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, string2, bundle);
    }

    public void clearMeasurementEnabled(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(null);
    }

    public void endAdUnitExposure(@NonNull String string, long l) throws RemoteException {
        this.zza();
        this.zza.zze().zzb(string, l);
    }

    public void generateEventId(zzdo zzdo2) throws RemoteException {
        this.zza();
        long l = this.zza.zzt().zzn();
        zzdo zzdo3 = zzdo2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        appMeasurementDynamiteService.zza();
        appMeasurementDynamiteService.zza.zzt().zza(zzdo3, l);
    }

    public void getAppInstanceId(zzdo zzdo2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzi(this, zzdo2));
    }

    public void getCachedAppInstanceId(zzdo zzdo2) throws RemoteException {
        this.zza();
        this.zza(zzdo2, this.zza.zzp().zzag());
    }

    public void getConditionalUserProperties(@Nullable String string, @Nullable String string2, zzdo zzdo2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzl(this, zzdo2, string, string2));
    }

    public void getCurrentScreenClass(zzdo zzdo2) throws RemoteException {
        this.zza();
        this.zza(zzdo2, this.zza.zzp().zzah());
    }

    public void getCurrentScreenName(zzdo zzdo2) throws RemoteException {
        this.zza();
        this.zza(zzdo2, this.zza.zzp().zzai());
    }

    public void getGmpAppId(zzdo zzdo2) throws RemoteException {
        this.zza();
        this.zza(zzdo2, this.zza.zzp().zzaj());
    }

    public void getMaxUserProperties(String string, zzdo zzdo2) throws RemoteException {
        this.zza();
        this.zza.zzp();
        zzjq.zza((String)string);
        zzdo zzdo3 = zzdo2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        appMeasurementDynamiteService.zza();
        appMeasurementDynamiteService.zza.zzt().zza(zzdo3, 25);
    }

    public void getSessionId(zzdo zzdo2) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(zzdo2);
    }

    public void getTestFlag(zzdo zzdo2, int n) throws RemoteException {
        this.zza();
        switch (n) {
            case 0: {
                this.zza.zzt().zza(zzdo2, this.zza.zzp().zzak());
                return;
            }
            case 1: {
                this.zza.zzt().zza(zzdo2, this.zza.zzp().zzaf().longValue());
                return;
            }
            case 2: {
                double d = this.zza.zzp().zzad();
                zzdo zzdo3 = zzdo2;
                zzos zzos2 = this.zza.zzt();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzdo3.zza(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzos2.zzu.zzj().zzu().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zza.zzt().zza(zzdo2, this.zza.zzp().zzae().intValue());
                return;
            }
            case 4: {
                this.zza.zzt().zza(zzdo2, this.zza.zzp().zzac().booleanValue());
            }
        }
    }

    public void getUserProperties(@Nullable String string, @Nullable String string2, boolean bl, zzdo zzdo2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzj(this, zzdo2, string, string2, bl));
    }

    public void initForTests(@NonNull Map map) throws RemoteException {
        this.zza();
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzdw zzdw2, long l) throws RemoteException {
        if (this.zza == null) {
            this.zza = zzhy.zza((Context)((Context)Preconditions.checkNotNull((Object)((Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)))), (zzdw)zzdw2, (Long)l);
            return;
        }
        this.zza.zzj().zzu().zza("Attempting to initialize multiple times");
    }

    public void isDataCollectionEnabled(zzdo zzdo2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzn(this, zzdo2));
    }

    public void logEvent(@NonNull @Nullable String string, @NonNull String string2, @NonNull @Nullable Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, string2, bundle, bl, bl2, l);
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzdo zzdo2, long l) throws RemoteException {
        this.zza();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzbf zzbf2 = new zzbf(string2, new zzbe(bundle), string3, l);
        this.zza.zzl().zzb((Runnable)new zzk(this, zzdo2, zzbf2, string));
    }

    public void logHealthData(int n, @NonNull String string, @NonNull IObjectWrapper iObjectWrapper, @NonNull IObjectWrapper iObjectWrapper2, @NonNull IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zza();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zza.zzj().zza(n, true, false, string, object, object2, object3);
    }

    public void onActivityCreated(@NonNull IObjectWrapper iObjectWrapper, @NonNull @Nullable Bundle bundle, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzao();
            activityLifecycleCallbacks.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzao();
            activityLifecycleCallbacks.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzao();
            activityLifecycleCallbacks.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzao();
            activityLifecycleCallbacks.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzdo zzdo2, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        Bundle bundle = new Bundle();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzao();
            activityLifecycleCallbacks.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzdo2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzj().zzu().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void onActivityStarted(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzao();
            activityLifecycleCallbacks.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.zza.zzp().zzaa();
        if (activityLifecycleCallbacks != null) {
            this.zza.zzp().zzao();
            activityLifecycleCallbacks.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void performAction(Bundle bundle, zzdo zzdo2, long l) throws RemoteException {
        this.zza();
        zzdo2.zza(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnMeasurementEventListener(zzdp zzdp2) throws RemoteException {
        zzjl zzjl2;
        this.zza();
        Map<Integer, zzjl> map = this.zzb;
        synchronized (map) {
            zzjl2 = this.zzb.get(zzdp2.zza());
            if (zzjl2 == null) {
                zzjl2 = new zzb(zzdp2);
                this.zzb.put(zzdp2.zza(), zzjl2);
            }
        }
        this.zza.zzp().zza(zzjl2);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(l);
    }

    private final void zza(zzdo zzdo2, @Nullable String string) {
        this.zza();
        this.zza.zzt().zza(zzdo2, string);
    }

    public void setConditionalUserProperty(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        if (bundle == null) {
            this.zza.zzj().zzg().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzp().zzb(bundle, l);
    }

    public void setConsent(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zzc(bundle, l);
    }

    public void setConsentThirdParty(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zzd(bundle, l);
    }

    public void setCurrentScreen(@NonNull IObjectWrapper iObjectWrapper, @NonNull @Nullable String string, @NonNull @Nullable String string2, long l) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zza();
        this.zza.zzp().zzc(bl);
    }

    public void setDefaultEventParameters(@NonNull @Nullable Bundle bundle) {
        this.zza();
        this.zza.zzp().zzc(bundle);
    }

    public void setEventInterceptor(zzdp zzdp2) throws RemoteException {
        this.zza();
        zza zza2 = new zza(zzdp2);
        if (this.zza.zzl().zzg()) {
            this.zza.zzp().zza((zzjm)zza2);
            return;
        }
        this.zza.zzl().zzb((Runnable)new zzm(this, zza2));
    }

    public void setInstanceIdProvider(zzdu zzdu2) throws RemoteException {
        this.zza();
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(Boolean.valueOf(bl));
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zza();
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zzc(l);
    }

    public void setSgtmDebugInfo(@NonNull Intent intent) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(intent);
    }

    public void setUserId(@NonNull @Nullable String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, l);
    }

    public void setUserProperty(@NonNull @Nullable String string, @NonNull String string2, @NonNull IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zza();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza.zzp().zza(string, string2, object, bl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnMeasurementEventListener(zzdp zzdp2) throws RemoteException {
        zzjl zzjl2;
        this.zza();
        Map<Integer, zzjl> map = this.zzb;
        synchronized (map) {
            zzjl2 = this.zzb.remove(zzdp2.zza());
        }
        if (zzjl2 == null) {
            zzjl2 = new zzb(zzdp2);
        }
        this.zza.zzp().zzb(zzjl2);
    }

    final class zza
    implements zzjm {
        private zzdp zza;

        zza(zzdp zzdp2) {
            this.zza = zzdp2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                if (AppMeasurementDynamiteService.this.zza != null) {
                    AppMeasurementDynamiteService.this.zza.zzj().zzu().zza("Event interceptor threw exception", (Object)remoteException);
                }
                return;
            }
        }
    }

    final class zzb
    implements zzjl {
        private zzdp zza;

        zzb(zzdp zzdp2) {
            this.zza = zzdp2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                if (AppMeasurementDynamiteService.this.zza != null) {
                    AppMeasurementDynamiteService.this.zza.zzj().zzu().zza("Event listener threw exception", (Object)remoteException);
                }
                return;
            }
        }
    }
}

