/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzcb;
import com.google.android.gms.measurement.internal.zzcc;
import com.google.android.gms.measurement.internal.zzcd;
import com.google.android.gms.measurement.internal.zzce;
import com.google.android.gms.measurement.internal.zzcf;
import com.google.android.gms.measurement.internal.zzcg;
import com.google.android.gms.measurement.internal.zzch;
import com.google.android.gms.measurement.internal.zzci;
import com.google.android.gms.measurement.internal.zzcj;
import com.google.android.gms.measurement.internal.zzck;
import com.google.android.gms.measurement.internal.zzcl;
import com.google.android.gms.measurement.internal.zzcm;
import com.google.android.gms.measurement.internal.zzcn;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzcq;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzcs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzca
extends zzan {
    private final zzft zzkt;
    private Boolean zzoq;
    @Nullable
    private String zzor;

    public zzca(zzft zzft2) {
        this(zzft2, null);
    }

    private zzca(zzft zzft2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzft2);
        this.zzkt = zzft2;
        this.zzor = null;
    }

    @BinderThread
    public final void zzb(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zzc(new zzcb(this, zzm2));
    }

    @BinderThread
    public final void zza(zzaj zzaj2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzaj2);
        this.zzb(zzm2, false);
        this.zzc(new zzcl(this, zzaj2, zzm2));
    }

    @VisibleForTesting
    final zzaj zzb(zzaj zzaj2, zzm zzm2) {
        String string;
        zzm zzm3 = zzm2;
        zzaj zzaj3 = zzaj2;
        zzca zzca2 = this;
        if (!"_cmp".equals(zzaj3.name) || zzaj3.zzfd == null || zzaj3.zzfd.size() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzaj3.zzfd.getString("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzca2.zzkt.zzaf().zzw(zzm3.packageName)) {
            this.zzkt.zzad().zzdg().zza("Event has been filtered ", (Object)zzaj2.toString());
            return new zzaj("_cmpx", zzaj2.zzfd, zzaj2.origin, zzaj2.zzfp);
        }
        return zzaj2;
    }

    @BinderThread
    public final void zza(zzaj zzaj2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzaj2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zzc(new zzcm(this, zzaj2, string));
    }

    @BinderThread
    public final byte[] zza(zzaj zzaj2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzaj2);
        this.zza(string, true);
        this.zzkt.zzad().zzdh().zza("Log and bundle. event", (Object)this.zzkt.zzaa().zzal(zzaj2.name));
        long l = this.zzkt.zzz().nanoTime() / 1000000L;
        Future future = this.zzkt.zzac().zzb((Callable)new zzcn(this, zzaj2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zzkt.zzad().zzda().zza("Log and bundle returned null. appId", zzau.zzao((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zzkt.zzz().nanoTime() / 1000000L;
            this.zzkt.zzad().zzdh().zza("Log and bundle processed. event, size, time_ms", (Object)this.zzkt.zzaa().zzal(zzaj2.name), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkt.zzad().zzda().zza("Failed to log and bundle. appId, event, error", zzau.zzao((String)string), (Object)this.zzkt.zzaa().zzal(zzaj2.name), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzga zzga2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzga2);
        this.zzb(zzm2, false);
        if (zzga2.getValue() == null) {
            this.zzc(new zzco(this, zzga2, zzm2));
            return;
        }
        this.zzc(new zzcp(this, zzga2, zzm2));
    }

    @BinderThread
    public final List<zzga> zza(zzm zzm2, boolean bl) {
        this.zzb(zzm2, false);
        Future future = this.zzkt.zzac().zza((Callable)new zzcq(this, zzm2));
        try {
            List list = (List)future.get();
            ArrayList<zzga> arrayList = new ArrayList<zzga>(list.size());
            for (zzgc zzgc2 : list) {
                if (!bl && zzgd.zzbs((String)zzgc2.name)) continue;
                arrayList.add(new zzga(zzgc2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkt.zzad().zzda().zza("Failed to get user attributes. appId", zzau.zzao((String)zzm2.packageName), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zzc(new zzcr(this, zzm2));
    }

    @BinderThread
    private final void zzb(zzm zzm2, boolean bl) {
        Preconditions.checkNotNull((Object)zzm2);
        this.zza(zzm2.packageName, false);
        this.zzkt.zzab().zzr(zzm2.zzch, zzm2.zzcv);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzkt.zzad().zzda().zzaq("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzca zzca2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzca2 = this;
                    if (!bl2) break block9;
                    if (zzca2.zzoq == null) {
                        zzca2.zzoq = "com.google.android.gms".equals(zzca2.zzor) || UidVerifier.isGooglePlayServicesUid((Context)zzca2.zzkt.getContext(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzca2.zzkt.getContext()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzca2.zzoq.booleanValue()) break block10;
                }
                if (zzca2.zzor == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzca2.zzkt.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzca2.zzor = string2;
                }
                if (!string2.equals(zzca2.zzor)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzkt.zzad().zzda().zza("Measurement Service called with invalid calling package. appId", zzau.zzao((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzc(new zzcs(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzm zzm2) {
        this.zzb(zzm2, false);
        return this.zzkt.zzh(zzm2);
    }

    @BinderThread
    public final void zza(zzr zzr2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzr2);
        Preconditions.checkNotNull((Object)zzr2.zzdv);
        this.zzb(zzm2, false);
        zzr zzr3 = new zzr(zzr2);
        new zzr(zzr2).packageName = zzm2.packageName;
        if (zzr2.zzdv.getValue() == null) {
            this.zzc(new zzcc(this, zzr3, zzm2));
            return;
        }
        this.zzc(new zzcd(this, zzr3, zzm2));
    }

    @BinderThread
    public final void zzb(zzr zzr2) {
        Preconditions.checkNotNull((Object)zzr2);
        Preconditions.checkNotNull((Object)zzr2.zzdv);
        this.zza(zzr2.packageName, true);
        zzr zzr3 = new zzr(zzr2);
        if (zzr2.zzdv.getValue() == null) {
            this.zzc(new zzce(this, zzr3));
            return;
        }
        this.zzc(new zzcf(this, zzr3));
    }

    @BinderThread
    public final List<zzga> zza(String string, String string2, boolean bl, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zzkt.zzac().zza((Callable)new zzcg(this, zzm2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzga> arrayList = new ArrayList<zzga>(list.size());
            for (zzgc zzgc2 : list) {
                if (!bl && zzgd.zzbs((String)zzgc2.name)) continue;
                arrayList.add(new zzga(zzgc2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkt.zzad().zzda().zza("Failed to get user attributes. appId", zzau.zzao((String)zzm2.packageName), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzga> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zzkt.zzac().zza((Callable)new zzch(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzga> arrayList = new ArrayList<zzga>(list.size());
            for (zzgc zzgc2 : list) {
                if (!bl && zzgd.zzbs((String)zzgc2.name)) continue;
                arrayList.add(new zzga(zzgc2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkt.zzad().zzda().zza("Failed to get user attributes. appId", zzau.zzao((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzr> zza(String string, String string2, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zzkt.zzac().zza((Callable)new zzci(this, zzm2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkt.zzad().zzda().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzr> zzd(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zzkt.zzac().zza((Callable)new zzcj(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkt.zzad().zzda().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzm zzm2) {
        this.zza(zzm2.packageName, false);
        this.zzc(new zzck(this, zzm2));
    }

    @VisibleForTesting
    private final void zzc(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (((Boolean)zzal.zzhw.get(null)).booleanValue() && this.zzkt.zzac().zzef()) {
            runnable.run();
            return;
        }
        this.zzkt.zzac().zza(runnable);
    }

    static /* synthetic */ zzft zza(zzca zzca2) {
        return zzca2.zzkt;
    }
}

