/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzbt;
import com.google.android.gms.internal.measurement.zzby;
import com.google.android.gms.internal.measurement.zzbz;
import com.google.android.gms.internal.measurement.zzca;
import com.google.android.gms.internal.measurement.zzcb;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzcg;
import com.google.android.gms.internal.measurement.zzch;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzin;
import com.google.android.gms.internal.measurement.zziv;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzq;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class zzfz
extends zzfs {
    zzfz(zzft zzft2) {
        super(zzft2);
    }

    @Override
    protected final boolean zzak() {
        return false;
    }

    final void zza(zzbt.zzh.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zziw().zzix().zziy();
        if (object instanceof String) {
            zza2.zzbz((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zzao((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zzc((Double)object);
            return;
        }
        this.zzad().zzda().zza("Ignoring invalid (type) user attribute value", object);
    }

    final void zza(zzbt.zzd.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zzhv().zzhw().zzhx();
        if (object instanceof String) {
            zza2.zzbx((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zzaj((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zzb((Double)object);
            return;
        }
        this.zzad().zzda().zza("Ignoring invalid (type) event param value", object);
    }

    final byte[] zza(zzcg zzcg2) {
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzcg2.zzly()];
            zzin zzin2 = zzin.zzk(byArray, 0, byArray2.length);
            ((zziv)zzcg2).zza(zzin2);
            zzin2.zzlk();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzad().zzda().zza("Data loss. Failed to serialize batch", (Object)iOException);
            return null;
        }
    }

    static zzbt.zzd zza(zzcf zzcf2, String string) {
        zzbt.zzd[] zzdArray = zzcf2.zzxi;
        int n = zzcf2.zzxi.length;
        for (int i = 0; i < n; ++i) {
            zzbt.zzd zzd2 = zzdArray[i];
            if (!zzd2.getName().equals(string)) continue;
            return zzd2;
        }
        return null;
    }

    static Object zzb(zzcf zzcf2, String string) {
        zzbt.zzd zzd2 = zzfz.zza(zzcf2, string);
        if (zzd2 != null) {
            if (zzd2.zzhk()) {
                return zzd2.zzhl();
            }
            if (zzd2.zzhn()) {
                return zzd2.zzho();
            }
            if (zzd2.zzhq()) {
                return zzd2.zzhr();
            }
        }
        return null;
    }

    static zzbt.zzd[] zza(zzbt.zzd[] zzdArray, String string, Object object) {
        zzbt.zzd.zza zza2;
        for (int i = 0; i < zzdArray.length; ++i) {
            zza2 = (zzbt.zzd.zza)zzdArray[i].zzmh();
            if (!string.equals(zza2.getName())) continue;
            zza2.zzhw().zzhv().zzhx();
            if (object instanceof Long) {
                zza2.zzaj((Long)object);
            } else if (object instanceof String) {
                zza2.zzbx((String)object);
            } else if (object instanceof Double) {
                zza2.zzb((Double)object);
            }
            zzdArray[i] = (zzbt.zzd)((zzez)zza2.zzmr());
            return zzdArray;
        }
        zzbt.zzd[] zzdArray2 = new zzbt.zzd[zzdArray.length + 1];
        System.arraycopy(zzdArray, 0, zzdArray2, 0, zzdArray.length);
        zza2 = zzbt.zzd.zzht().zzbw(string);
        if (object instanceof Long) {
            zza2.zzaj((Long)object);
        } else if (object instanceof String) {
            zza2.zzbx((String)object);
        } else if (object instanceof Double) {
            zza2.zzb((Double)object);
        }
        zzdArray2[zzdArray.length] = (zzbt.zzd)((zzez)zza2.zzmr());
        return zzdArray2;
    }

    final String zzb(zzcg zzcg2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzcg2.zzxl != null) {
            zzch[] zzchArray = zzcg2.zzxl;
            int n = zzcg2.zzxl.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                int n2;
                int n3;
                Object object2;
                zzch zzch2 = zzchArray[i];
                if (zzch2 == null) continue;
                zzch zzch3 = zzch2;
                StringBuilder stringBuilder2 = stringBuilder;
                zzfz zzfz2 = this;
                if (zzch3 == null) continue;
                zzfz.zza(stringBuilder2, 1);
                stringBuilder2.append("bundle {\n");
                zzfz.zza(stringBuilder2, 1, "protocol_version", zzch3.zzxn);
                zzfz.zza(stringBuilder2, 1, "platform", zzch3.zzxv);
                zzfz.zza(stringBuilder2, 1, "gmp_version", zzch3.zzxz);
                zzfz.zza(stringBuilder2, 1, "uploading_gmp_version", zzch3.zzya);
                zzfz.zza(stringBuilder2, 1, "dynamite_version", zzch3.zzys);
                zzfz.zza(stringBuilder2, 1, "config_version", zzch3.zzyl);
                zzfz.zza(stringBuilder2, 1, "gmp_app_id", zzch3.zzch);
                zzfz.zza(stringBuilder2, 1, "admob_app_id", zzch3.zzxf);
                zzfz.zza(stringBuilder2, 1, "app_id", zzch3.zzcf);
                zzfz.zza(stringBuilder2, 1, "app_version", zzch3.zzcn);
                zzfz.zza(stringBuilder2, 1, "app_version_major", zzch3.zzyh);
                zzfz.zza(stringBuilder2, 1, "firebase_instance_id", zzch3.zzcj);
                zzfz.zza(stringBuilder2, 1, "dev_cert_hash", zzch3.zzyd);
                zzfz.zza(stringBuilder2, 1, "app_store", zzch3.zzcp);
                zzfz.zza(stringBuilder2, 1, "upload_timestamp_millis", zzch3.zzxq);
                zzfz.zza(stringBuilder2, 1, "start_timestamp_millis", zzch3.zzxr);
                zzfz.zza(stringBuilder2, 1, "end_timestamp_millis", zzch3.zzxs);
                zzfz.zza(stringBuilder2, 1, "previous_bundle_start_timestamp_millis", zzch3.zzxt);
                zzfz.zza(stringBuilder2, 1, "previous_bundle_end_timestamp_millis", zzch3.zzxu);
                zzfz.zza(stringBuilder2, 1, "app_instance_id", zzch3.zzcg);
                zzfz.zza(stringBuilder2, 1, "resettable_device_id", zzch3.zzyb);
                zzfz.zza(stringBuilder2, 1, "device_id", zzch3.zzyk);
                zzfz.zza(stringBuilder2, 1, "ds_id", zzch3.zzyn);
                zzfz.zza(stringBuilder2, 1, "limited_ad_tracking", zzch3.zzyc);
                zzfz.zza(stringBuilder2, 1, "os_version", zzch3.zzxw);
                zzfz.zza(stringBuilder2, 1, "device_model", zzch3.zzxx);
                zzfz.zza(stringBuilder2, 1, "user_default_language", zzch3.zzex);
                zzfz.zza(stringBuilder2, 1, "time_zone_offset_minutes", zzch3.zzxy);
                zzfz.zza(stringBuilder2, 1, "bundle_sequential_index", zzch3.zzye);
                zzfz.zza(stringBuilder2, 1, "service_upload", zzch3.zzyf);
                zzfz.zza(stringBuilder2, 1, "health_monitor", zzch3.zzdn);
                if (zzch3.zzym != null && zzch3.zzym != 0L) {
                    zzfz.zza(stringBuilder2, 1, "android_id", zzch3.zzym);
                }
                if (zzch3.zzyp != null) {
                    zzfz.zza(stringBuilder2, 1, "retry_counter", zzch3.zzyp);
                }
                Object[] objectArray = zzch3.zzxp;
                int n4 = 1;
                StringBuilder stringBuilder3 = stringBuilder2;
                zzfz zzfz3 = zzfz2;
                if (objectArray != null) {
                    ++n4;
                    object2 = objectArray;
                    n3 = objectArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzbt.zzh zzh2 = object2[n2];
                        if (zzh2 == null) continue;
                        zzfz.zza(stringBuilder3, 2);
                        stringBuilder3.append("user_property {\n");
                        zzfz.zza(stringBuilder3, 2, "set_timestamp_millis", zzh2.zzis() ? Long.valueOf(zzh2.zzit()) : null);
                        zzfz.zza(stringBuilder3, 2, "name", zzfz3.zzaa().zzan(zzh2.getName()));
                        zzfz.zza(stringBuilder3, 2, "string_value", zzh2.zzhl());
                        zzfz.zza(stringBuilder3, 2, "int_value", zzh2.zzhn() ? Long.valueOf(zzh2.zzho()) : null);
                        zzfz.zza(stringBuilder3, 2, "double_value", zzh2.zzhq() ? Double.valueOf(zzh2.zzhr()) : null);
                        zzfz.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                object2 = zzch3.zzcf;
                objectArray = zzch3.zzyg;
                n4 = 1;
                stringBuilder3 = stringBuilder2;
                zzfz3 = zzfz2;
                if (objectArray != null) {
                    ++n4;
                    zzez[] zzezArray = objectArray;
                    n2 = objectArray.length;
                    for (int j = 0; j < n2; ++j) {
                        object = zzezArray[j];
                        if (object == null) continue;
                        zzfz.zza(stringBuilder3, 2);
                        stringBuilder3.append("audience_membership {\n");
                        if (object.zzgu()) {
                            zzfz.zza(stringBuilder3, 2, "audience_id", object.zzgv());
                        }
                        if (object.zzgz()) {
                            zzfz.zza(stringBuilder3, 2, "new_audience", object.zzha());
                        }
                        zzfz3.zza(stringBuilder3, 2, "current_data", object.zzgw(), (String)object2);
                        zzfz3.zza(stringBuilder3, 2, "previous_data", object.zzgy(), (String)object2);
                        zzfz.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                objectArray = zzch3.zzxo;
                n4 = 1;
                stringBuilder3 = stringBuilder2;
                zzfz3 = zzfz2;
                if (objectArray != null) {
                    ++n4;
                    object2 = objectArray;
                    n3 = objectArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzbt.zzh zzh3 = object2[n2];
                        if (zzh3 == null) continue;
                        zzfz.zza(stringBuilder3, 2);
                        stringBuilder3.append("event {\n");
                        zzfz.zza(stringBuilder3, 2, "name", zzfz3.zzaa().zzal(((zzcf)((Object)zzh3)).name));
                        zzfz.zza(stringBuilder3, 2, "timestamp_millis", ((zzcf)((Object)zzh3)).zzxj);
                        zzfz.zza(stringBuilder3, 2, "previous_timestamp_millis", ((zzcf)((Object)zzh3)).zzxk);
                        zzfz.zza(stringBuilder3, 2, "count", ((zzcf)((Object)zzh3)).count);
                        zzbt.zzd[] zzdArray = ((zzcf)((Object)zzh3)).zzxi;
                        int n5 = 2;
                        StringBuilder stringBuilder4 = stringBuilder3;
                        object = zzfz3;
                        if (zzdArray != null) {
                            ++n5;
                            zzbt.zzd[] zzdArray2 = zzdArray;
                            int n6 = zzdArray.length;
                            for (int j = 0; j < n6; ++j) {
                                zzbt.zzd zzd2 = zzdArray2[j];
                                if (zzd2 == null) continue;
                                zzfz.zza(stringBuilder4, 3);
                                stringBuilder4.append("param {\n");
                                zzfz.zza(stringBuilder4, 3, "name", object.zzaa().zzam(zzd2.getName()));
                                zzfz.zza(stringBuilder4, 3, "string_value", zzd2.zzhl());
                                zzfz.zza(stringBuilder4, 3, "int_value", zzd2.zzhn() ? Long.valueOf(zzd2.zzho()) : null);
                                zzfz.zza(stringBuilder4, 3, "double_value", zzd2.zzhq() ? Double.valueOf(zzd2.zzhr()) : null);
                                zzfz.zza(stringBuilder4, 3);
                                stringBuilder4.append("}\n");
                            }
                        }
                        zzfz.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzfz.zza(stringBuilder2, 1);
                stringBuilder2.append("}\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzby zzby2) {
        if (zzby2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        zzfz.zza(stringBuilder, 0, "filter_id", zzby2.zzwa);
        zzfz.zza(stringBuilder, 0, "event_name", this.zzaa().zzal(zzby2.zzwb));
        this.zza(stringBuilder, 1, "event_count_filter", zzby2.zzwe);
        stringBuilder.append("  filters {\n");
        zzbz[] zzbzArray = zzby2.zzwc;
        int n = zzby2.zzwc.length;
        for (int i = 0; i < n; ++i) {
            zzbz zzbz2 = zzbzArray[i];
            this.zza(stringBuilder, 2, zzbz2);
        }
        zzfz.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zzb(zzcb zzcb2) {
        if (zzcb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        zzfz.zza(stringBuilder, 0, "filter_id", zzcb2.zzwa);
        zzfz.zza(stringBuilder, 0, "property_name", this.zzaa().zzan(zzcb2.zzwq));
        this.zza(stringBuilder, 1, zzcb2.zzwr);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzbt.zzf zzf2, String string2) {
        int n2;
        if (zzf2 == null) {
            return;
        }
        ++n;
        zzfz.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzf2.zzid() != 0) {
            zzfz.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n2 = 0;
            for (Long object : zzf2.zzic()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzf2.zzib() != 0) {
            zzfz.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n2 = 0;
            for (Long l : zzf2.zzia()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (this.zzaf().zzt(string2)) {
            if (zzf2.zzif() != 0) {
                zzfz.zza(stringBuilder, 4);
                stringBuilder.append("dynamic_filter_timestamps: {");
                n2 = 0;
                for (zzbt.zzb zzb2 : zzf2.zzie()) {
                    if (n2++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(zzb2.zzhd() ? Integer.valueOf(zzb2.getIndex()) : null).append(":").append(zzb2.zzhe() ? Long.valueOf(zzb2.zzhf()) : null);
                }
                stringBuilder.append("}\n");
            }
            if (zzf2.zzih() != 0) {
                zzfz.zza(stringBuilder, 4);
                stringBuilder.append("sequence_filter_timestamps: {");
                n2 = 0;
                for (zzbt.zzg zzg2 : zzf2.zzig()) {
                    if (n2++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(zzg2.zzhd() ? Integer.valueOf(zzg2.getIndex()) : null).append(": [");
                    int n3 = 0;
                    for (long l : zzg2.zzil()) {
                        if (n3++ != 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(l);
                    }
                    stringBuilder.append("]");
                }
                stringBuilder.append("}\n");
            }
        }
        zzfz.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzca zzca2) {
        if (zzca2 == null) {
            return;
        }
        zzfz.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzca2.zzwk != null) {
            zzfz.zza(stringBuilder, n, "comparison_type", zzca2.zzwk.name());
        }
        zzfz.zza(stringBuilder, n, "match_as_float", zzca2.zzwl);
        zzfz.zza(stringBuilder, n, "comparison_value", zzca2.zzwm);
        zzfz.zza(stringBuilder, n, "min_comparison_value", zzca2.zzwn);
        zzfz.zza(stringBuilder, n, "max_comparison_value", zzca2.zzwo);
        zzfz.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, zzbz zzbz2) {
        if (zzbz2 == null) {
            return;
        }
        zzfz.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        zzfz.zza(stringBuilder, n, "complement", zzbz2.zzwi);
        zzfz.zza(stringBuilder, n, "param_name", this.zzaa().zzam(zzbz2.zzwj));
        zzcc zzcc2 = zzbz2.zzwg;
        String string = "string_filter";
        int n2 = n + 1;
        StringBuilder stringBuilder2 = stringBuilder;
        zzfz zzfz2 = this;
        if (zzcc2 != null) {
            zzfz.zza(stringBuilder2, n2);
            stringBuilder2.append(string);
            stringBuilder2.append(" {\n");
            if (zzcc2.zzws != null) {
                zzfz.zza(stringBuilder2, n2, "match_type", zzcc2.zzws.name());
            }
            zzfz.zza(stringBuilder2, n2, "expression", zzcc2.zzwt);
            zzfz.zza(stringBuilder2, n2, "case_sensitive", zzcc2.zzwu);
            if (zzcc2.zzwv.length > 0) {
                zzfz.zza(stringBuilder2, n2 + 1);
                stringBuilder2.append("expression_list {\n");
                String[] stringArray = zzcc2.zzwv;
                int n3 = zzcc2.zzwv.length;
                for (int i = 0; i < n3; ++i) {
                    String string2 = stringArray[i];
                    zzfz.zza(stringBuilder2, n2 + 2);
                    stringBuilder2.append(string2);
                    stringBuilder2.append("\n");
                }
                stringBuilder2.append("}\n");
            }
            zzfz.zza(stringBuilder2, n2);
            stringBuilder2.append("}\n");
        }
        this.zza(stringBuilder, n + 1, "number_filter", zzbz2.zzwh);
        zzfz.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzfz.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final <T extends Parcelable> T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzad().zzda().zzaq("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    @WorkerThread
    final boolean zze(zzaj zzaj2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzaj2);
        Preconditions.checkNotNull((Object)zzm2);
        if (TextUtils.isEmpty((CharSequence)zzm2.zzch) && TextUtils.isEmpty((CharSequence)zzm2.zzcv)) {
            zzq zzq2 = this.zzag();
            return false;
        }
        return true;
    }

    static boolean zzbl(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    static boolean zza(List<Long> list, int n) {
        return n < list.size() << 6 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    static List<Long> zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                l |= 1L << j;
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    final boolean zzb(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzz().currentTimeMillis() - l) > l2;
    }

    @WorkerThread
    final long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzab().zzq();
        MessageDigest messageDigest = zzgd.getMessageDigest();
        if (messageDigest == null) {
            this.zzad().zzda().zzaq("Failed to get MD5");
            return 0L;
        }
        return zzgd.zzd((byte[])messageDigest.digest(byArray));
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzad().zzda().zza("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzc(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzad().zzda().zza("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    @Nullable
    final int[] zzgj() {
        Map map = zzal.zzk((Context)this.zzkt.getContext());
        if (map == null || map.size() == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzal.zzhp.get(null);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzad().zzdd().zza("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzad().zzdd().zza("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Object object = new int[arrayList.size()];
        int n3 = 0;
        ArrayList<Integer> arrayList2 = arrayList;
        int n4 = arrayList2.size();
        for (int i = 0; i < n4; ++i) {
            Object e = arrayList2.get(i);
            Integer n5 = (Integer)e;
            object[n3++] = n5;
        }
        return object;
    }
}

