/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzin;
import com.google.android.gms.internal.measurement.zziw;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzio {
    private final ByteBuffer zzaei;
    private zzee zzaol;
    private int zzaom;

    private zzio(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, 0, n2));
    }

    private zzio(ByteBuffer byteBuffer) {
        this.zzaei = byteBuffer;
        this.zzaei.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzio zzj(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zzio(byArray2, 0, n);
    }

    public static zzio zzk(byte[] byArray, int n, int n2) {
        return new zzio(byArray, 0, n2);
    }

    public final void zzc(int n, int n2) throws IOException {
        this.zzb(n, 0);
        int n3 = n2;
        zzio zzio2 = this;
        if (n3 >= 0) {
            zzio2.zzck(n3);
            return;
        }
        zzio2.zzbz(n3);
    }

    public final void zzb(int n, boolean bl) throws IOException {
        this.zzb(n, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        zzio zzio2 = this;
        if (!zzio2.zzaei.hasRemaining()) {
            throw new zzin(zzio2.zzaei.position(), zzio2.zzaei.limit());
        }
        zzio2.zzaei.put(by);
    }

    public final void zzb(int n, String string) throws IOException {
        this.zzb(n, 2);
        String string2 = string;
        zzio zzio2 = this;
        try {
            int n2 = zzio.zzbq(string2.length());
            int n3 = zzio.zzbq(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzio2.zzaei.position();
                if (zzio2.zzaei.remaining() < n2) {
                    throw new zzin(n4 + n2, zzio2.zzaei.limit());
                }
                zzio2.zzaei.position(n4 + n2);
                zzio.zzd(string2, zzio2.zzaei);
                int n5 = zzio2.zzaei.position();
                zzio2.zzaei.position(n4);
                zzio2.zzck(n5 - n4 - n2);
                zzio2.zzaei.position(n5);
                return;
            }
            zzio2.zzck(zzio.zza(string2));
            zzio.zzd(string2, zzio2.zzaei);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzin zzin2 = new zzin(zzio2.zzaei.position(), zzio2.zzaei.limit());
            zzin2.initCause(bufferOverflowException);
            throw zzin2;
        }
    }

    public final void zza(int n, zziw zziw2) throws IOException {
        this.zzb(n, 2);
        zziw zziw3 = zziw2;
        zzio zzio2 = this;
        zziw zziw4 = zziw3;
        if (zziw4.zzaow < 0) {
            zziw4.zzuk();
        }
        zzio2.zzck(zziw4.zzaow);
        zziw3.zza(zzio2);
    }

    public final void zze(int n, zzgi zzgi2) throws IOException {
        zzio zzio2 = this;
        if (zzio2.zzaol == null) {
            zzio2.zzaol = zzee.zza((ByteBuffer)zzio2.zzaei);
            zzio2.zzaom = zzio2.zzaei.position();
        } else if (zzio2.zzaom != zzio2.zzaei.position()) {
            zzio2.zzaol.write(zzio2.zzaei.array(), zzio2.zzaom, zzio2.zzaei.position() - zzio2.zzaom);
            zzio2.zzaom = zzio2.zzaei.position();
        }
        zzee zzee2 = zzio2.zzaol;
        zzee2.zza(n, zzgi2);
        zzee2.flush();
        this.zzaom = this.zzaei.position();
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zzd(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public static int zzg(int n, int n2) {
        return zzio.zzbi(n) + zzio.zzbj(n2);
    }

    public static int zzc(int n, String string) {
        int n2 = zzio.zza(string);
        return zzio.zzbi(n) + (zzio.zzbq(n2) + n2);
    }

    public static int zzb(int n, zziw zziw2) {
        int n2 = zziw2.zzuk();
        return zzio.zzbi(n) + (zzio.zzbq(n2) + n2);
    }

    public static int zzbj(int n) {
        if (n >= 0) {
            return zzio.zzbq(n);
        }
        return 10;
    }

    private final void zzcj(int n) throws IOException {
        byte by = (byte)n;
        zzio zzio2 = this;
        if (!zzio2.zzaei.hasRemaining()) {
            throw new zzin(zzio2.zzaei.position(), zzio2.zzaei.limit());
        }
        zzio2.zzaei.put(by);
    }

    public final void zzk(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        zzio zzio2 = this;
        if (zzio2.zzaei.remaining() >= n) {
            zzio2.zzaei.put(byArray2, 0, n);
            return;
        }
        throw new zzin(zzio2.zzaei.position(), zzio2.zzaei.limit());
    }

    public final void zzb(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzck(n << 3 | n3);
    }

    public static int zzbi(int n) {
        return zzio.zzbq(n << 3);
    }

    public final void zzck(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzcj(n);
                return;
            }
            this.zzcj(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzbq(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public final void zzbz(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzcj((int)l);
                return;
            }
            this.zzcj((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }
}

