/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzbk;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class zzjo
extends zzjh {
    zzjo(zzjg zzjg2) {
        super(zzjg2);
    }

    @Override
    protected final boolean zzbk() {
        return false;
    }

    final void zza(zzbs.zzk.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zzqz().zzra().zzrb();
        if (object instanceof String) {
            zza2.zzdc((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zzbl((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zzc((Double)object);
            return;
        }
        this.zzab().zzgk().zza("Ignoring invalid (type) user attribute value", object);
    }

    final void zza(zzbs.zze.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zzmu().zzmv().zzmw();
        if (object instanceof String) {
            zza2.zzca((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zzam((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        this.zzab().zzgk().zza("Ignoring invalid (type) event param value", object);
    }

    static zzbs.zze zza(zzbs.zzc zzc2, String string) {
        for (zzbs.zze zze2 : zzc2.zzmj()) {
            if (!zze2.getName().equals(string)) continue;
            return zze2;
        }
        return null;
    }

    static Object zzb(zzbs.zzc zzc2, String string) {
        zzbs.zze zze2 = zzjo.zza(zzc2, string);
        if (zze2 != null) {
            if (zze2.zzmx()) {
                return zze2.zzmy();
            }
            if (zze2.zzna()) {
                return zze2.zznb();
            }
            if (zze2.zznd()) {
                return zze2.zzne();
            }
        }
        return null;
    }

    static void zza(zzbs.zzc.zza zza2, String string, Object object) {
        List<zzbs.zze> list = zza2.zzmj();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).getName())) continue;
            n = i;
            break;
        }
        zzbs.zze.zza zza3 = zzbs.zze.zzng().zzbz(string);
        if (object instanceof Long) {
            zza3.zzam((Long)object);
        } else if (object instanceof String) {
            zza3.zzca((String)object);
        } else if (object instanceof Double) {
            zza3.zza((Double)object);
        }
        if (n >= 0) {
            zza2.zza(n, zza3);
            return;
        }
        zza2.zza(zza3);
    }

    final String zza(zzbs.zzf zzf2) {
        if (zzf2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        Iterator<zzbs.zzg> iterator = zzf2.zzni().iterator();
        while (iterator.hasNext()) {
            zzbs.zzg zzg2;
            zzbs.zzg zzg3 = zzg2 = iterator.next();
            StringBuilder stringBuilder2 = stringBuilder;
            zzjo zzjo2 = this;
            if (zzg3 == null) continue;
            zzjo.zza(stringBuilder2, 1);
            stringBuilder2.append("bundle {\n");
            if (zzg3.zznx()) {
                zzjo.zza(stringBuilder2, 1, "protocol_version", zzg3.zzny());
            }
            zzjo.zza(stringBuilder2, 1, "platform", zzg3.zzom());
            if (zzg3.zzoq()) {
                zzjo.zza(stringBuilder2, 1, "gmp_version", zzg3.zzao());
            }
            if (zzg3.zzor()) {
                zzjo.zza(stringBuilder2, 1, "uploading_gmp_version", zzg3.zzos());
            }
            if (zzg3.zzpq()) {
                zzjo.zza(stringBuilder2, 1, "dynamite_version", zzg3.zzaq());
            }
            if (zzg3.zzpi()) {
                zzjo.zza(stringBuilder2, 1, "config_version", zzg3.zzpj());
            }
            zzjo.zza(stringBuilder2, 1, "gmp_app_id", zzg3.getGmpAppId());
            zzjo.zza(stringBuilder2, 1, "admob_app_id", zzg3.zzpp());
            zzjo.zza(stringBuilder2, 1, "app_id", zzg3.zzag());
            zzjo.zza(stringBuilder2, 1, "app_version", zzg3.zzal());
            if (zzg3.zzpf()) {
                zzjo.zza(stringBuilder2, 1, "app_version_major", zzg3.zzpg());
            }
            zzjo.zza(stringBuilder2, 1, "firebase_instance_id", zzg3.getFirebaseInstanceId());
            if (zzg3.zzow()) {
                zzjo.zza(stringBuilder2, 1, "dev_cert_hash", zzg3.zzap());
            }
            zzjo.zza(stringBuilder2, 1, "app_store", zzg3.zzan());
            if (zzg3.zzoc()) {
                zzjo.zza(stringBuilder2, 1, "upload_timestamp_millis", zzg3.zzod());
            }
            if (zzg3.zzoe()) {
                zzjo.zza(stringBuilder2, 1, "start_timestamp_millis", zzg3.zznq());
            }
            if (zzg3.zzof()) {
                zzjo.zza(stringBuilder2, 1, "end_timestamp_millis", zzg3.zznr());
            }
            if (zzg3.zzog()) {
                zzjo.zza(stringBuilder2, 1, "previous_bundle_start_timestamp_millis", zzg3.zzoh());
            }
            if (zzg3.zzoj()) {
                zzjo.zza(stringBuilder2, 1, "previous_bundle_end_timestamp_millis", zzg3.zzok());
            }
            zzjo.zza(stringBuilder2, 1, "app_instance_id", zzg3.getAppInstanceId());
            zzjo.zza(stringBuilder2, 1, "resettable_device_id", zzg3.zzot());
            zzjo.zza(stringBuilder2, 1, "device_id", zzg3.zzph());
            zzjo.zza(stringBuilder2, 1, "ds_id", zzg3.zzpl());
            if (zzg3.zzou()) {
                zzjo.zza(stringBuilder2, 1, "limited_ad_tracking", zzg3.zzov());
            }
            zzjo.zza(stringBuilder2, 1, "os_version", zzg3.getOsVersion());
            zzjo.zza(stringBuilder2, 1, "device_model", zzg3.zzon());
            zzjo.zza(stringBuilder2, 1, "user_default_language", zzg3.zzcr());
            if (zzg3.zzoo()) {
                zzjo.zza(stringBuilder2, 1, "time_zone_offset_minutes", zzg3.zzop());
            }
            if (zzg3.zzox()) {
                zzjo.zza(stringBuilder2, 1, "bundle_sequential_index", zzg3.zzoy());
            }
            if (zzg3.zzpb()) {
                zzjo.zza(stringBuilder2, 1, "service_upload", zzg3.zzpc());
            }
            zzjo.zza(stringBuilder2, 1, "health_monitor", zzg3.zzoz());
            if (zzg3.zzpk() && zzg3.zzbd() != 0L) {
                zzjo.zza(stringBuilder2, 1, "android_id", zzg3.zzbd());
            }
            if (zzg3.zzpn()) {
                zzjo.zza(stringBuilder2, 1, "retry_counter", zzg3.zzpo());
            }
            List<zzey> list = zzg3.zzno();
            int n = 1;
            StringBuilder stringBuilder3 = stringBuilder2;
            zzjo zzjo3 = zzjo2;
            if (list != null) {
                ++n;
                for (zzbs.zzk zzk2 : list) {
                    if (zzk2 == null) continue;
                    zzjo.zza(stringBuilder3, 2);
                    stringBuilder3.append("user_property {\n");
                    zzjo.zza(stringBuilder3, 2, "set_timestamp_millis", zzk2.zzqs() ? Long.valueOf(zzk2.zzqt()) : null);
                    zzjo.zza(stringBuilder3, 2, "name", zzjo3.zzy().zzal(zzk2.getName()));
                    zzjo.zza(stringBuilder3, 2, "string_value", zzk2.zzmy());
                    zzjo.zza(stringBuilder3, 2, "int_value", zzk2.zzna() ? Long.valueOf(zzk2.zznb()) : null);
                    zzjo.zza(stringBuilder3, 2, "double_value", zzk2.zznd() ? Double.valueOf(zzk2.zzne()) : null);
                    zzjo.zza(stringBuilder3, 2);
                    stringBuilder3.append("}\n");
                }
            }
            Iterator<zzey> iterator2 = zzg3.zzag();
            list = zzg3.zzpd();
            n = 1;
            stringBuilder3 = stringBuilder2;
            zzjo3 = zzjo2;
            if (list != null) {
                ++n;
                for (Object object : list) {
                    if (object == null) continue;
                    zzjo.zza(stringBuilder3, 2);
                    stringBuilder3.append("audience_membership {\n");
                    if (object.zzly()) {
                        zzjo.zza(stringBuilder3, 2, "audience_id", object.zzlz());
                    }
                    if (object.zzma()) {
                        zzjo.zza(stringBuilder3, 2, "new_audience", object.zzmb());
                    }
                    zzjo3.zza(stringBuilder3, 2, "current_data", object.zzlv(), (String)((Object)iterator2));
                    zzjo3.zza(stringBuilder3, 2, "previous_data", object.zzlx(), (String)((Object)iterator2));
                    zzjo.zza(stringBuilder3, 2);
                    stringBuilder3.append("}\n");
                }
            }
            list = zzg3.zznl();
            n = 1;
            stringBuilder3 = stringBuilder2;
            zzjo3 = zzjo2;
            if (list != null) {
                ++n;
                for (zzbs.zzc zzc2 : list) {
                    if (zzc2 == null) continue;
                    zzjo.zza(stringBuilder3, 2);
                    stringBuilder3.append("event {\n");
                    zzjo.zza(stringBuilder3, 2, "name", zzjo3.zzy().zzaj(zzc2.getName()));
                    if (zzc2.zzml()) {
                        zzjo.zza(stringBuilder3, 2, "timestamp_millis", zzc2.getTimestampMillis());
                    }
                    if (zzc2.zzmo()) {
                        zzjo.zza(stringBuilder3, 2, "previous_timestamp_millis", zzc2.zzmm());
                    }
                    if (zzc2.zzmp()) {
                        zzjo.zza(stringBuilder3, 2, "count", zzc2.getCount());
                    }
                    if (zzc2.zzmk() != 0) {
                        Object object;
                        List<zzbs.zze> list2 = zzc2.zzmj();
                        int n2 = 2;
                        StringBuilder stringBuilder4 = stringBuilder3;
                        object = zzjo3;
                        if (list2 != null) {
                            ++n2;
                            for (zzbs.zze zze2 : list2) {
                                if (zze2 == null) continue;
                                zzjo.zza(stringBuilder4, 3);
                                stringBuilder4.append("param {\n");
                                zzjo.zza(stringBuilder4, 3, "name", object.zzy().zzak(zze2.getName()));
                                zzjo.zza(stringBuilder4, 3, "string_value", zze2.zzmy());
                                zzjo.zza(stringBuilder4, 3, "int_value", zze2.zzna() ? Long.valueOf(zze2.zznb()) : null);
                                zzjo.zza(stringBuilder4, 3, "double_value", zze2.zznd() ? Double.valueOf(zze2.zzne()) : null);
                                zzjo.zza(stringBuilder4, 3);
                                stringBuilder4.append("}\n");
                            }
                        }
                    }
                    zzjo.zza(stringBuilder3, 2);
                    stringBuilder3.append("}\n");
                }
            }
            zzjo.zza(stringBuilder2, 1);
            stringBuilder2.append("}\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzbk.zza zza2) {
        if (zza2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (zza2.zzkb()) {
            zzjo.zza(stringBuilder, 0, "filter_id", zza2.getId());
        }
        zzjo.zza(stringBuilder, 0, "event_name", this.zzy().zzaj(zza2.zzjz()));
        String string = zzjo.zza(zza2.zzkf(), zza2.zzkg(), zza2.zzki());
        if (!string.isEmpty()) {
            zzjo.zza(stringBuilder, 0, "filter_type", string);
        }
        this.zza(stringBuilder, 1, "event_count_filter", zza2.zzke());
        stringBuilder.append("  filters {\n");
        for (zzbk.zzb zzb2 : zza2.zzkc()) {
            this.zza(stringBuilder, 2, zzb2);
        }
        zzjo.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zza(zzbk.zzd zzd2) {
        if (zzd2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zzd2.zzkb()) {
            zzjo.zza(stringBuilder, 0, "filter_id", zzd2.getId());
        }
        zzjo.zza(stringBuilder, 0, "property_name", this.zzy().zzal(zzd2.getPropertyName()));
        String string = zzjo.zza(zzd2.zzkf(), zzd2.zzkg(), zzd2.zzki());
        if (!string.isEmpty()) {
            zzjo.zza(stringBuilder, 0, "filter_type", string);
        }
        this.zza(stringBuilder, 1, zzd2.zzli());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private static String zza(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzbs.zzi zzi2, String string2) {
        int n2;
        if (zzi2 == null) {
            return;
        }
        ++n;
        zzjo.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzi2.zzpz() != 0) {
            zzjo.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n2 = 0;
            for (Long object : zzi2.zzpy()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzi2.zzpw() != 0) {
            zzjo.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n2 = 0;
            for (Long l : zzi2.zzpv()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (this.zzad().zzq(string2)) {
            if (zzi2.zzqc() != 0) {
                zzjo.zza(stringBuilder, 4);
                stringBuilder.append("dynamic_filter_timestamps: {");
                n2 = 0;
                for (zzbs.zzb zzb2 : zzi2.zzqb()) {
                    if (n2++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(zzb2.zzme() ? Integer.valueOf(zzb2.getIndex()) : null).append(":").append(zzb2.zzmf() ? Long.valueOf(zzb2.zzmg()) : null);
                }
                stringBuilder.append("}\n");
            }
            if (zzi2.zzqf() != 0) {
                zzjo.zza(stringBuilder, 4);
                stringBuilder.append("sequence_filter_timestamps: {");
                n2 = 0;
                for (zzbs.zzj zzj2 : zzi2.zzqe()) {
                    if (n2++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(zzj2.zzme() ? Integer.valueOf(zzj2.getIndex()) : null).append(": [");
                    int n3 = 0;
                    for (long l : zzj2.zzqk()) {
                        if (n3++ != 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(l);
                    }
                    stringBuilder.append("]");
                }
                stringBuilder.append("}\n");
            }
        }
        zzjo.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzbk.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zzjo.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzc2.zzku()) {
            zzjo.zza(stringBuilder, n, "comparison_type", zzc2.zzkv().name());
        }
        if (zzc2.zzkw()) {
            zzjo.zza(stringBuilder, n, "match_as_float", zzc2.zzkx());
        }
        zzjo.zza(stringBuilder, n, "comparison_value", zzc2.zzkz());
        zzjo.zza(stringBuilder, n, "min_comparison_value", zzc2.zzlb());
        zzjo.zza(stringBuilder, n, "max_comparison_value", zzc2.zzld());
        zzjo.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, zzbk.zzb zzb2) {
        if (zzb2 == null) {
            return;
        }
        zzjo.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzb2.zzkp()) {
            zzjo.zza(stringBuilder, n, "complement", zzb2.zzkq());
        }
        zzjo.zza(stringBuilder, n, "param_name", this.zzy().zzak(zzb2.zzkr()));
        zzbk.zze zze2 = zzb2.zzkm();
        String string = "string_filter";
        int n2 = n + 1;
        StringBuilder stringBuilder2 = stringBuilder;
        zzjo zzjo2 = this;
        if (zze2 != null) {
            zzjo.zza(stringBuilder2, n2);
            stringBuilder2.append(string);
            stringBuilder2.append(" {\n");
            if (zze2.zzlk()) {
                zzjo.zza(stringBuilder2, n2, "match_type", zze2.zzll().name());
            }
            zzjo.zza(stringBuilder2, n2, "expression", zze2.zzln());
            if (zze2.zzlo()) {
                zzjo.zza(stringBuilder2, n2, "case_sensitive", zze2.zzlp());
            }
            if (zze2.zzlr() > 0) {
                zzjo.zza(stringBuilder2, n2 + 1);
                stringBuilder2.append("expression_list {\n");
                for (String string2 : zze2.zzlq()) {
                    zzjo.zza(stringBuilder2, n2 + 2);
                    stringBuilder2.append(string2);
                    stringBuilder2.append("\n");
                }
                stringBuilder2.append("}\n");
            }
            zzjo.zza(stringBuilder2, n2);
            stringBuilder2.append("}\n");
        }
        this.zza(stringBuilder, n + 1, "number_filter", zzb2.zzko());
        zzjo.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzjo.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final <T extends Parcelable> T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzab().zzgk().zzao("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    @WorkerThread
    final boolean zze(zzai zzai2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzai2);
        Preconditions.checkNotNull((Object)zzn2);
        if (TextUtils.isEmpty((CharSequence)zzn2.zzcg) && TextUtils.isEmpty((CharSequence)zzn2.zzcu)) {
            zzr zzr2 = this.zzae();
            return false;
        }
        return true;
    }

    static boolean zzbj(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    static boolean zza(List<Long> list, int n) {
        return n < list.size() << 6 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    static List<Long> zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                l |= 1L << j;
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    final List<Long> zza(List<Long> list, List<Integer> list2) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list);
        for (Integer n : list2) {
            if (n < 0) {
                this.zzab().zzgn().zza("Ignoring negative bit index to be cleared", (Object)n);
                continue;
            }
            int n2 = n / 64;
            if (n2 >= arrayList.size()) {
                this.zzab().zzgn().zza("Ignoring bit index greater than bitSet size", (Object)n, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n2, arrayList.get(n2) & (1L << n % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n3 = arrayList.size() - 1;
        while (n3 >= 0 && arrayList.get(n3) == 0L) {
            n = n3--;
        }
        return arrayList.subList(0, n);
    }

    final boolean zzb(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzx().currentTimeMillis() - l) > l2;
    }

    @WorkerThread
    final long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzz().zzo();
        MessageDigest messageDigest = zzjs.getMessageDigest();
        if (messageDigest == null) {
            this.zzab().zzgk().zzao("Failed to get MD5");
            return 0L;
        }
        return zzjs.zzd((byte[])messageDigest.digest(byArray));
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzab().zzgk().zza("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzc(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzab().zzgk().zza("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    @Nullable
    final List<Integer> zzju() {
        Map map = zzak.zzk((Context)this.zzkz.getContext());
        if (map == null || map.size() == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzak.zzhr.get(null);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzab().zzgn().zza("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzab().zzgn().zza("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }
}

