/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbj;
import com.google.android.gms.internal.measurement.zzbo;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzgq;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzz;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class zzfr
extends zzjz
implements zzz {
    @VisibleForTesting
    private static int zzb = 65535;
    @VisibleForTesting
    private static int zzc = 2;
    private final Map<String, Map<String, String>> zzd = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zze = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzf = new ArrayMap();
    private final Map<String, zzbo.zzb> zzg = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzh;
    private final Map<String, String> zzi = new ArrayMap();

    zzfr(zzkc zzkc2) {
        super(zzkc2);
        this.zzh = new ArrayMap();
    }

    @WorkerThread
    private final void zzi(String string) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzg.get(string) == null) {
            byte[] byArray = ((zzka)this).zzi().zzd(string);
            if (byArray == null) {
                this.zzd.put(string, null);
                this.zze.put(string, null);
                this.zzf.put(string, null);
                this.zzg.put(string, null);
                this.zzi.put(string, null);
                this.zzh.put(string, null);
                return;
            }
            zzbo.zzb.zza zza2 = (zzbo.zzb.zza)this.zza(string, byArray).zzbl();
            this.zza(string, zza2);
            this.zzd.put(string, zzfr.zza((zzbo.zzb)((zzfd)zza2.zzt())));
            this.zzg.put(string, (zzbo.zzb)((zzfd)zza2.zzt()));
            this.zzi.put(string, null);
        }
    }

    @WorkerThread
    protected final zzbo.zzb zza(String string) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        this.zzi(string);
        return this.zzg.get(string);
    }

    @WorkerThread
    protected final String zzb(String string) {
        this.zzd();
        return this.zzi.get(string);
    }

    @WorkerThread
    protected final void zzc(String string) {
        this.zzd();
        this.zzi.put(string, null);
    }

    @WorkerThread
    final void zzd(String string) {
        this.zzd();
        this.zzg.remove(string);
    }

    @WorkerThread
    final boolean zze(String string) {
        this.zzd();
        zzbo.zzb zzb2 = this.zza(string);
        if (zzb2 == null) {
            return false;
        }
        return zzb2.zzh();
    }

    @WorkerThread
    public final String zza(String string, String string2) {
        this.zzd();
        this.zzi(string);
        Map<String, String> map = this.zzd.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzbo.zzb zzb2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzb2 != null) {
            for (zzbo.zzc zzc2 : zzb2.zze()) {
                arrayMap.put(zzc2.zza(), zzc2.zzb());
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzbo.zzb.zza zza2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zza2 != null) {
            for (int i = 0; i < zza2.zza(); ++i) {
                zzbo.zza.zza zza3 = (zzbo.zza.zza)zza2.zza(i).zzbl();
                if (TextUtils.isEmpty((CharSequence)zza3.zza())) {
                    this.zzr().zzi().zza("EventConfig contained null event name");
                    continue;
                }
                String string2 = zzgw.zzb((String)zza3.zza());
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zza3 = zza3.zza(string2);
                    zza2.zza(i, zza3);
                }
                arrayMap.put(zza3.zza(), zza3.zzb());
                arrayMap2.put(zza3.zza(), zza3.zzc());
                if (!zza3.zzd()) continue;
                if (zza3.zze() < zzc || zza3.zze() > zzb) {
                    this.zzr().zzi().zza("Invalid sampling rate. Event name, sample rate", (Object)zza3.zza(), (Object)zza3.zze());
                    continue;
                }
                arrayMap3.put(zza3.zza(), zza3.zze());
            }
        }
        this.zze.put(string, (Map<String, Boolean>)arrayMap);
        this.zzf.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzh.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        zzbo.zzb.zza zza2 = (zzbo.zzb.zza)this.zza(string, byArray).zzbl();
        if (zza2 == null) {
            return false;
        }
        this.zza(string, zza2);
        this.zzg.put(string, (zzbo.zzb)((zzfd)zza2.zzt()));
        this.zzi.put(string, string2);
        this.zzd.put(string, zzfr.zza((zzbo.zzb)((zzfd)zza2.zzt())));
        Object object = new ArrayList<zzbj.zza>(zza2.zzb());
        String string3 = string;
        zzjz zzjz2 = ((zzka)this).e_();
        Preconditions.checkNotNull(object);
        for (int i = 0; i < object.size(); ++i) {
            Object object2;
            zzgq zzgq2;
            int n;
            zzbj.zza.zza zza3 = (zzbj.zza.zza)((zzbj.zza)((Object)object.get(i))).zzbl();
            if (zza3.zzb() != 0) {
                for (n = 0; n < zza3.zzb(); ++n) {
                    zzgq2 = (zzbj.zzb.zza)zza3.zzb(n).zzbl();
                    object2 = (zzbj.zzb.zza)((zzfd.zzb)zzgq2.clone());
                    boolean bl = false;
                    String string4 = zzgw.zzb((String)zzgq2.zza());
                    if (string4 != null) {
                        ((zzbj.zzb.zza)((Object)object2)).zza(string4);
                        bl = true;
                    }
                    for (int j = 0; j < zzgq2.zzb(); ++j) {
                        zzbj.zzc zzc2 = zzgq2.zza(j);
                        String string5 = zzgv.zza((String)zzc2.zzg());
                        if (string5 == null) continue;
                        zzbj.zzc zzc3 = (zzbj.zzc)((zzfd)((zzbj.zzc.zza)zzc2.zzbl()).zza(string5).zzt());
                        ((zzbj.zzb.zza)((Object)object2)).zza(j, zzc3);
                        bl = true;
                    }
                    if (!bl) continue;
                    zza3 = zza3.zza(n, (zzbj.zzb.zza)((Object)object2));
                    object.set(i, (zzbj.zza)((zzfd)zza3.zzt()));
                }
            }
            if (zza3.zza() == 0) continue;
            for (n = 0; n < zza3.zza(); ++n) {
                zzgq2 = zza3.zza(n);
                object2 = zzgy.zza((String)zzgq2.zzc());
                if (object2 == null) continue;
                zza3 = zza3.zza(n, ((zzbj.zze.zza)zzgq2.zzbl()).zza((String)object2));
                object.set(i, (zzbj.zza)((zzfd)zza3.zzt()));
            }
        }
        zzjz2.zzi().zza(string3, (List<zzbj.zza>)object);
        try {
            zza2.zzc();
            byArray = ((zzbo.zzb)((zzfd)zza2.zzt())).zzbh();
        }
        catch (RuntimeException runtimeException) {
            this.zzr().zzi().zza("Unable to serialize reduced-size config. Storing full config instead. appId", zzet.zza((String)string), (Object)runtimeException);
        }
        object = byArray;
        string3 = string;
        zzjz2 = ((zzka)this).zzi();
        Preconditions.checkNotEmpty((String)string3);
        zzjz2.zzd();
        zzjz2.zzak();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", (byte[])object);
        try {
            if ((long)((zzac)zzjz2).c_().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                zzjz2.zzr().zzf().zza("Failed to update remote config (got 0). appId", zzet.zza((String)string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            zzjz2.zzr().zzf().zza("Error storing remote config. appId", zzet.zza((String)string3), (Object)sQLiteException);
        }
        this.zzg.put(string, (zzbo.zzb)((zzfd)zza2.zzt()));
        return true;
    }

    @WorkerThread
    final boolean zzb(String string, String string2) {
        this.zzd();
        this.zzi(string);
        if (this.zzg(string) && zzkk.zze((String)string2)) {
            return true;
        }
        if (this.zzh(string) && zzkk.zza((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zze.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzc(String string, String string2) {
        this.zzd();
        this.zzi(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzf.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzd(String string, String string2) {
        this.zzd();
        this.zzi(string);
        Map<String, Integer> map = this.zzh.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zzf(String string) {
        String string2 = this.zza(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzr().zzi().zza("Unable to parse timezone offset. appId", zzet.zza((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    @WorkerThread
    private final zzbo.zzb zza(String string, byte[] byArray) {
        zzbo.zzb zzb2;
        if (byArray == null) {
            return zzbo.zzb.zzj();
        }
        try {
            zzb2 = (zzbo.zzb)((zzfd)zzkg.zza(zzbo.zzb.zzi(), byArray).zzt());
            this.zzr().zzx().zza("Parsed config. version, gmp_app_id", (Object)(zzb2.zza() ? Long.valueOf(zzb2.zzb()) : null), (Object)(zzb2.zzc() ? zzb2.zzd() : null));
        }
        catch (zzfo zzfo2) {
            this.zzr().zzi().zza("Unable to merge remote config. appId", zzet.zza((String)string), (Object)zzfo2);
            return zzbo.zzb.zzj();
        }
        catch (RuntimeException runtimeException) {
            this.zzr().zzi().zza("Unable to merge remote config. appId", zzet.zza((String)string), (Object)runtimeException);
            return zzbo.zzb.zzj();
        }
        return zzb2;
    }

    final boolean zzg(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzh(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zze() {
        return false;
    }
}

