/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgc
extends zzeo {
    private final zzkc zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzgc(zzkc zzkc2) {
        this(zzkc2, null);
    }

    private zzgc(zzkc zzkc2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzkc2);
        this.zza = zzkc2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzgb(this, zzm2));
    }

    @BinderThread
    public final void zza(zzan zzan2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzan2);
        this.zzb(zzm2, false);
        this.zza(new zzgk(this, zzan2, zzm2));
    }

    @VisibleForTesting
    final zzan zzb(zzan zzan2, zzm zzm2) {
        String string;
        zzm zzm3 = zzm2;
        zzan zzan3 = zzan2;
        zzgc zzgc2 = this;
        if (!"_cmp".equals(zzan3.zza) || zzan3.zzb == null || zzan3.zzb.zza() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzan3.zzb.zzd("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzgc2.zza.zzb().zzj(zzm3.zza)) {
            this.zza.zzr().zzv().zza("Event has been filtered ", (Object)zzan2.toString());
            return new zzan("_cmpx", zzan2.zzb, zzan2.zzc, zzan2.zzd);
        }
        return zzan2;
    }

    @BinderThread
    public final void zza(zzan zzan2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzan2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzgj(this, zzan2, string));
    }

    @BinderThread
    public final byte[] zza(zzan zzan2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzan2);
        this.zza(string, true);
        this.zza.zzr().zzw().zza("Log and bundle. event", (Object)this.zza.zzi().zza(zzan2.zza));
        long l = this.zza.zzm().nanoTime() / 1000000L;
        Future future = this.zza.zzq().zzb((Callable)new zzgm(this, zzan2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzr().zzf().zza("Log and bundle returned null. appId", zzet.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzm().nanoTime() / 1000000L;
            this.zza.zzr().zzw().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzi().zza(zzan2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to log and bundle. appId, event, error", zzet.zza((String)string), (Object)this.zza.zzi().zza(zzan2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzkj zzkj2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzkj2);
        this.zzb(zzm2, false);
        this.zza(new zzgl(this, zzkj2, zzm2));
    }

    @BinderThread
    public final List<zzkj> zza(zzm zzm2, boolean bl) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgo(this, zzm2));
        try {
            List list = (List)future.get();
            ArrayList<zzkj> arrayList = new ArrayList<zzkj>(list.size());
            for (zzkl zzkl2 : list) {
                if (!bl && zzkk.zze((String)zzkl2.zzc)) continue;
                arrayList.add(new zzkj(zzkl2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzet.zza((String)zzm2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzgn(this, zzm2));
    }

    @BinderThread
    private final void zzb(zzm zzm2, boolean bl) {
        Preconditions.checkNotNull((Object)zzm2);
        this.zza(zzm2.zza, false);
        this.zza.zzj().zzc(zzm2.zzb, zzm2.zzr);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzr().zzf().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgc zzgc2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgc2 = this;
                    if (!bl2) break block9;
                    if (zzgc2.zzb == null) {
                        zzgc2.zzb = "com.google.android.gms".equals(zzgc2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzgc2.zza.zzn(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgc2.zza.zzn()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgc2.zzb.booleanValue()) break block10;
                }
                if (zzgc2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgc2.zza.zzn(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgc2.zzc = string2;
                }
                if (!string2.equals(zzgc2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzr().zzf().zza("Measurement Service called with invalid calling package. appId", zzet.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgq(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzm zzm2) {
        this.zzb(zzm2, false);
        return this.zza.zzd(zzm2);
    }

    @BinderThread
    public final void zza(zzv zzv2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzv2);
        Preconditions.checkNotNull((Object)zzv2.zzc);
        this.zzb(zzm2, false);
        zzv zzv3 = new zzv(zzv2);
        new zzv(zzv2).zza = zzm2.zza;
        this.zza(new zzgp(this, zzv3, zzm2));
    }

    @BinderThread
    public final void zza(zzv zzv2) {
        Preconditions.checkNotNull((Object)zzv2);
        Preconditions.checkNotNull((Object)zzv2.zzc);
        this.zza(zzv2.zza, true);
        zzv zzv3 = new zzv(zzv2);
        this.zza(new zzge(this, zzv3));
    }

    @BinderThread
    public final List<zzkj> zza(String string, String string2, boolean bl, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgd(this, zzm2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzkj> arrayList = new ArrayList<zzkj>(list.size());
            for (zzkl zzkl2 : list) {
                if (!bl && zzkk.zze((String)zzkl2.zzc)) continue;
                arrayList.add(new zzkj(zzkl2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzet.zza((String)zzm2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzkj> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgg(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzkj> arrayList = new ArrayList<zzkj>(list.size());
            for (zzkl zzkl2 : list) {
                if (!bl && zzkk.zze((String)zzkl2.zzc)) continue;
                arrayList.add(new zzkj(zzkl2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzet.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzv> zza(String string, String string2, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgf(this, zzm2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzv> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgi(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzm zzm2) {
        this.zza(zzm2.zza, false);
        this.zza(new zzgh(this, zzm2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzq().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzq().zza(runnable);
    }

    static /* synthetic */ zzkc zza(zzgc zzgc2) {
        return zzgc2.zza;
    }
}

