/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgb
extends zzen {
    private final zzke zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzgb(zzke zzke2) {
        this(zzke2, null);
    }

    private zzgb(zzke zzke2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzke2);
        this.zza = zzke2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzge(this, zzm2));
    }

    @BinderThread
    public final void zza(zzan zzan2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzan2);
        this.zzb(zzm2, false);
        this.zza(new zzgj(this, zzan2, zzm2));
    }

    @VisibleForTesting
    final zzan zzb(zzan zzan2, zzm zzm2) {
        String string;
        zzm zzm3 = zzm2;
        zzan zzan3 = zzan2;
        zzgb zzgb2 = this;
        if (!"_cmp".equals(zzan3.zza) || zzan3.zzb == null || zzan3.zzb.zza() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzan3.zzb.zzd("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzgb2.zza.zzb().zze(zzm3.zza, zzap.zzao)) {
            this.zza.zzr().zzv().zza("Event has been filtered ", (Object)zzan2.toString());
            return new zzan("_cmpx", zzan2.zzb, zzan2.zzc, zzan2.zzd);
        }
        return zzan2;
    }

    @BinderThread
    public final void zza(zzan zzan2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzan2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzgm(this, zzan2, string));
    }

    @BinderThread
    public final byte[] zza(zzan zzan2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzan2);
        this.zza(string, true);
        this.zza.zzr().zzw().zza("Log and bundle. event", (Object)this.zza.zzi().zza(zzan2.zza));
        long l = this.zza.zzm().nanoTime() / 1000000L;
        Future future = this.zza.zzq().zzb((Callable)new zzgl(this, zzan2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzr().zzf().zza("Log and bundle returned null. appId", zzew.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzm().nanoTime() / 1000000L;
            this.zza.zzr().zzw().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzi().zza(zzan2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to log and bundle. appId, event, error", zzew.zza((String)string), (Object)this.zza.zzi().zza(zzan2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzkl zzkl2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzkl2);
        this.zzb(zzm2, false);
        this.zza(new zzgo(this, zzkl2, zzm2));
    }

    @BinderThread
    public final List<zzkl> zza(zzm zzm2, boolean bl) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgn(this, zzm2));
        try {
            List list = (List)future.get();
            ArrayList<zzkl> arrayList = new ArrayList<zzkl>(list.size());
            for (zzkn zzkn2 : list) {
                if (!bl && zzkm.zze((String)zzkn2.zzc)) continue;
                arrayList.add(new zzkl(zzkn2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzew.zza((String)zzm2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzgq(this, zzm2));
    }

    @BinderThread
    private final void zzb(zzm zzm2, boolean bl) {
        Preconditions.checkNotNull((Object)zzm2);
        this.zza(zzm2.zza, false);
        this.zza.zzj().zza(zzm2.zzb, zzm2.zzr, zzm2.zzv);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzr().zzf().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgb zzgb2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgb2 = this;
                    if (!bl2) break block9;
                    if (zzgb2.zzb == null) {
                        zzgb2.zzb = "com.google.android.gms".equals(zzgb2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzgb2.zza.zzn(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgb2.zza.zzn()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgb2.zzb.booleanValue()) break block10;
                }
                if (zzgb2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgb2.zza.zzn(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgb2.zzc = string2;
                }
                if (!string2.equals(zzgb2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzr().zzf().zza("Measurement Service called with invalid calling package. appId", zzew.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgp(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzm zzm2) {
        this.zzb(zzm2, false);
        return this.zza.zzd(zzm2);
    }

    @BinderThread
    public final void zza(zzv zzv2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzv2);
        Preconditions.checkNotNull((Object)zzv2.zzc);
        this.zzb(zzm2, false);
        zzv zzv3 = new zzv(zzv2);
        new zzv(zzv2).zza = zzm2.zza;
        this.zza(new zzgs(this, zzv3, zzm2));
    }

    @BinderThread
    public final void zza(zzv zzv2) {
        Preconditions.checkNotNull((Object)zzv2);
        Preconditions.checkNotNull((Object)zzv2.zzc);
        this.zza(zzv2.zza, true);
        zzv zzv3 = new zzv(zzv2);
        this.zza(new zzgd(this, zzv3));
    }

    @BinderThread
    public final List<zzkl> zza(String string, String string2, boolean bl, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgg(this, zzm2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzkl> arrayList = new ArrayList<zzkl>(list.size());
            for (zzkn zzkn2 : list) {
                if (!bl && zzkm.zze((String)zzkn2.zzc)) continue;
                arrayList.add(new zzkl(zzkn2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzew.zza((String)zzm2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzkl> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgf(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzkl> arrayList = new ArrayList<zzkl>(list.size());
            for (zzkn zzkn2 : list) {
                if (!bl && zzkm.zze((String)zzkn2.zzc)) continue;
                arrayList.add(new zzkl(zzkn2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzew.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzv> zza(String string, String string2, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgi(this, zzm2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzv> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgh(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzm zzm2) {
        this.zza(zzm2.zza, false);
        this.zza(new zzgk(this, zzm2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzq().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzq().zza(runnable);
    }

    static /* synthetic */ zzke zza(zzgb zzgb2) {
        return zzgb2.zza;
    }
}

