/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbo;
import com.google.android.gms.internal.measurement.zzbt;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzkd;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzko;
import java.util.ArrayList;
import java.util.Map;

public final class zzfr
extends zzkd
implements zzac {
    @VisibleForTesting
    private static int zzb = 65535;
    @VisibleForTesting
    private static int zzc = 2;
    private final Map<String, Map<String, String>> zzd = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zze = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzf = new ArrayMap();
    private final Map<String, zzbt.zzb> zzg = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzh;
    private final Map<String, String> zzi = new ArrayMap();

    zzfr(zzkg zzkg2) {
        super(zzkg2);
        this.zzh = new ArrayMap();
    }

    @WorkerThread
    private final void zzi(String string) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzg.get(string) == null) {
            byte[] byArray = ((zzke)this).zzi().zzd(string);
            if (byArray == null) {
                this.zzd.put(string, null);
                this.zze.put(string, null);
                this.zzf.put(string, null);
                this.zzg.put(string, null);
                this.zzi.put(string, null);
                this.zzh.put(string, null);
                return;
            }
            zzbt.zzb.zza zza2 = (zzbt.zzb.zza)this.zza(string, byArray).zzbm();
            this.zza(string, zza2);
            this.zzd.put(string, zzfr.zza((zzbt.zzb)((zzfi)zza2.zzu())));
            this.zzg.put(string, (zzbt.zzb)((zzfi)zza2.zzu()));
            this.zzi.put(string, null);
        }
    }

    @WorkerThread
    protected final zzbt.zzb zza(String string) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        this.zzi(string);
        return this.zzg.get(string);
    }

    @WorkerThread
    protected final String zzb(String string) {
        this.zzd();
        return this.zzi.get(string);
    }

    @WorkerThread
    protected final void zzc(String string) {
        this.zzd();
        this.zzi.put(string, null);
    }

    @WorkerThread
    final void zzd(String string) {
        this.zzd();
        this.zzg.remove(string);
    }

    @WorkerThread
    final boolean zze(String string) {
        this.zzd();
        zzbt.zzb zzb2 = this.zza(string);
        if (zzb2 == null) {
            return false;
        }
        return zzb2.zzh();
    }

    @WorkerThread
    public final String zza(String string, String string2) {
        this.zzd();
        this.zzi(string);
        Map<String, String> map = this.zzd.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzbt.zzb zzb2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzb2 != null) {
            for (zzbt.zzc zzc2 : zzb2.zze()) {
                arrayMap.put(zzc2.zza(), zzc2.zzb());
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzbt.zzb.zza zza2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zza2 != null) {
            for (int i = 0; i < zza2.zza(); ++i) {
                zzbt.zza.zza zza3 = (zzbt.zza.zza)zza2.zza(i).zzbm();
                if (TextUtils.isEmpty((CharSequence)zza3.zza())) {
                    this.zzr().zzi().zza("EventConfig contained null event name");
                    continue;
                }
                String string2 = zzgw.zzb((String)zza3.zza());
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zza3 = zza3.zza(string2);
                    zza2.zza(i, zza3);
                }
                arrayMap.put(zza3.zza(), zza3.zzb());
                arrayMap2.put(zza3.zza(), zza3.zzc());
                if (!zza3.zzd()) continue;
                if (zza3.zze() < zzc || zza3.zze() > zzb) {
                    this.zzr().zzi().zza("Invalid sampling rate. Event name, sample rate", (Object)zza3.zza(), (Object)zza3.zze());
                    continue;
                }
                arrayMap3.put(zza3.zza(), zza3.zze());
            }
        }
        this.zze.put(string, (Map<String, Boolean>)arrayMap);
        this.zzf.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzh.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        zzbt.zzb.zza zza2 = (zzbt.zzb.zza)this.zza(string, byArray).zzbm();
        if (zza2 == null) {
            return false;
        }
        this.zza(string, zza2);
        this.zzg.put(string, (zzbt.zzb)((zzfi)zza2.zzu()));
        this.zzi.put(string, string2);
        this.zzd.put(string, zzfr.zza((zzbt.zzb)((zzfi)zza2.zzu())));
        ((zzke)this).zzi().zza(string, new ArrayList<zzbo.zza>(zza2.zzb()));
        try {
            zza2.zzc();
            byArray = ((zzbt.zzb)((zzfi)zza2.zzu())).zzbi();
        }
        catch (RuntimeException runtimeException) {
            this.zzr().zzi().zza("Unable to serialize reduced-size config. Storing full config instead. appId", zzet.zza((String)string), (Object)runtimeException);
        }
        byte[] byArray2 = byArray;
        String string3 = string;
        zzab zzab2 = ((zzke)this).zzi();
        Preconditions.checkNotEmpty((String)string3);
        zzab2.zzd();
        zzab2.zzak();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray2);
        try {
            if ((long)zzab2.c_().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                zzab2.zzr().zzf().zza("Failed to update remote config (got 0). appId", zzet.zza((String)string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            zzab2.zzr().zzf().zza("Error storing remote config. appId", zzet.zza((String)string3), (Object)sQLiteException);
        }
        this.zzg.put(string, (zzbt.zzb)((zzfi)zza2.zzu()));
        return true;
    }

    @WorkerThread
    final boolean zzb(String string, String string2) {
        this.zzd();
        this.zzi(string);
        if (this.zzg(string) && zzko.zze((String)string2)) {
            return true;
        }
        if (this.zzh(string) && zzko.zza((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zze.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzc(String string, String string2) {
        this.zzd();
        this.zzi(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        if (zzjt.zzb() && this.zzt().zza(zzas.zzcj) && ("purchase".equals(string2) || "refund".equals(string2))) {
            return true;
        }
        Map<String, Boolean> map = this.zzf.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzd(String string, String string2) {
        this.zzd();
        this.zzi(string);
        Map<String, Integer> map = this.zzh.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zzf(String string) {
        String string2 = this.zza(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzr().zzi().zza("Unable to parse timezone offset. appId", zzet.zza((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    @WorkerThread
    private final zzbt.zzb zza(String string, byte[] byArray) {
        zzbt.zzb zzb2;
        if (byArray == null) {
            return zzbt.zzb.zzj();
        }
        try {
            zzb2 = (zzbt.zzb)((zzfi)zzkk.zza(zzbt.zzb.zzi(), byArray).zzu());
            this.zzr().zzx().zza("Parsed config. version, gmp_app_id", (Object)(zzb2.zza() ? Long.valueOf(zzb2.zzb()) : null), (Object)(zzb2.zzc() ? zzb2.zzd() : null));
        }
        catch (zzft zzft2) {
            this.zzr().zzi().zza("Unable to merge remote config. appId", zzet.zza((String)string), (Object)zzft2);
            return zzbt.zzb.zzj();
        }
        catch (RuntimeException runtimeException) {
            this.zzr().zzi().zza("Unable to merge remote config. appId", zzet.zza((String)string), (Object)runtimeException);
            return zzbt.zzb.zzj();
        }
        return zzb2;
    }

    final boolean zzg(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzh(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zze() {
        return false;
    }
}

