/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzbt;
import com.google.android.gms.internal.measurement.zzbw;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzjn;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzkr;
import com.google.android.gms.internal.measurement.zzle;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzkd;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzkf;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzkg
implements zzgu {
    private static volatile zzkg zza;
    private zzfr zzb;
    private zzfa zzc;
    private zzab zzd;
    private zzfd zze;
    private zzkc zzf;
    private zzq zzg;
    private final zzkk zzh;
    private zzig zzi;
    private final zzfx zzj;
    private boolean zzk = false;
    private boolean zzl;
    @VisibleForTesting
    private long zzm;
    private List<Runnable> zzn;
    private int zzo;
    private int zzp;
    private boolean zzq;
    private boolean zzr;
    private boolean zzs;
    private FileLock zzt;
    private FileChannel zzu;
    private List<Long> zzv;
    private List<Long> zzw;
    private long zzx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzkg zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzkg> clazz = zzkg.class;
        synchronized (zzkg.class) {
            if (zza != null) return zza;
            zzkl zzkl2 = new zzkl(context);
            zza = new zzkg(zzkl2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    private zzkg(zzkl zzkl2) {
        this(zzkl2, null);
    }

    private zzkg(zzkl zzkl2, zzfx zzfx2) {
        Preconditions.checkNotNull((Object)zzkl2);
        this.zzj = zzfx2 = zzfx.zza((Context)zzkl2.zza, null, null);
        this.zzx = -1L;
        zzkg zzkg2 = this;
        zzkk zzkk2 = new zzkk(zzkg2);
        zzkk2.zzal();
        this.zzh = zzkk2;
        zzkg2 = this;
        zzfa zzfa2 = new zzfa(zzkg2);
        zzfa2.zzal();
        this.zzc = zzfa2;
        zzkg2 = this;
        zzfr zzfr2 = new zzfr(zzkg2);
        zzfr2.zzal();
        this.zzb = zzfr2;
        this.zzj.zzq().zza((Runnable)new zzkf(this, zzkl2));
    }

    @WorkerThread
    private final void zza(zzkl zzkl2) {
        this.zzj.zzq().zzd();
        zzkg zzkg2 = this;
        zzab zzab2 = new zzab(zzkg2);
        zzab2.zzal();
        this.zzd = zzab2;
        this.zzj.zzb().zza((zzac)this.zzb);
        zzkg2 = this;
        zzq zzq2 = new zzq(zzkg2);
        zzq2.zzal();
        this.zzg = zzq2;
        zzkg2 = this;
        zzig zzig2 = new zzig(zzkg2);
        zzig2.zzal();
        this.zzi = zzig2;
        zzkg2 = this;
        zzkc zzkc2 = new zzkc(zzkg2);
        zzkc2.zzal();
        this.zzf = zzkc2;
        zzkg2 = this;
        this.zze = new zzfd(zzkg2);
        if (this.zzo != this.zzp) {
            this.zzj.zzr().zzf().zza("Not all upload components initialized", (Object)this.zzo, (Object)this.zzp);
        }
        this.zzk = true;
    }

    @WorkerThread
    protected final void zza() {
        this.zzj.zzq().zzd();
        this.zze().zzv();
        if (this.zzj.zzc().zzc.zza() == 0L) {
            this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
        }
        this.zzz();
    }

    public final zzv zzu() {
        return this.zzj.zzu();
    }

    public final zzaa zzb() {
        return this.zzj.zzb();
    }

    public final zzet zzr() {
        return this.zzj.zzr();
    }

    public final zzfu zzq() {
        return this.zzj.zzq();
    }

    public final zzfr zzc() {
        zzkg.zzb(this.zzb);
        return this.zzb;
    }

    public final zzfa zzd() {
        zzkg.zzb(this.zzc);
        return this.zzc;
    }

    public final zzab zze() {
        zzkg.zzb(this.zzd);
        return this.zzd;
    }

    private final zzfd zzt() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    private final zzkc zzv() {
        zzkg.zzb(this.zzf);
        return this.zzf;
    }

    public final zzq zzf() {
        zzkg.zzb(this.zzg);
        return this.zzg;
    }

    public final zzig zzg() {
        zzkg.zzb(this.zzi);
        return this.zzi;
    }

    public final zzkk zzh() {
        zzkg.zzb(this.zzh);
        return this.zzh;
    }

    public final zzer zzi() {
        return this.zzj.zzj();
    }

    public final Context zzn() {
        return this.zzj.zzn();
    }

    public final Clock zzm() {
        return this.zzj.zzm();
    }

    public final zzko zzj() {
        return this.zzj.zzi();
    }

    @WorkerThread
    private final void zzw() {
        this.zzj.zzq().zzd();
    }

    final void zzk() {
        if (!this.zzk) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zzb(zzkd zzkd2) {
        if (zzkd2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzkd2.zzaj()) {
            String string = String.valueOf(((Object)((Object)zzkd2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private final long zzx() {
        long l = this.zzj.zzm().currentTimeMillis();
        zzff zzff2 = this.zzj.zzc();
        zzff2.zzaa();
        zzff2.zzd();
        long l2 = zzff2.zzg.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzff2.zzp().zzh().nextInt(86400000);
            zzff2.zzg.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zza(zzaq zzaq2, String string) {
        zzg zzg2 = this.zze().zzb(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzl())) {
            this.zzj.zzr().zzw().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzb(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzaq2.zza)) {
                this.zzj.zzr().zzi().zza("Could not find package. appId", zzet.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj.zzr().zzf().zza("App version does not match; dropping event. appId", zzet.zza((String)string));
            return;
        }
        zzm zzm2 = new zzm(string, zzg2.zze(), zzg2.zzl(), zzg2.zzm(), zzg2.zzn(), zzg2.zzo(), zzg2.zzp(), null, zzg2.zzr(), false, zzg2.zzi(), zzg2.zzae(), 0L, 0, zzg2.zzaf(), zzg2.zzag(), false, zzg2.zzf(), zzg2.zzah(), zzg2.zzq(), zzg2.zzai(), zzle.zzb() && this.zzj.zzb().zze(zzg2.zzc(), zzas.zzbo) ? zzg2.zzg() : null);
        this.zza(zzaq2, zzm2);
    }

    @WorkerThread
    final void zza(zzaq zzaq2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.zza);
        this.zzw();
        this.zzk();
        String string = zzm2.zza;
        long l = zzaq2.zzd;
        this.zzh();
        if (!zzkk.zza(zzaq2, zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        if (this.zzj.zzb().zze(string, zzas.zzbc) && zzm2.zzu != null) {
            if (zzm2.zzu.contains(zzaq2.zza)) {
                Bundle bundle = zzaq2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzaq2 = new zzaq(zzaq2.zza, new zzal(bundle), zzaq2.zzc, zzaq2.zzd);
            } else {
                this.zzj.zzr().zzw().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzaq2.zza, (Object)zzaq2.zzc);
                return;
            }
        }
        this.zze().zzf();
        try {
            zzy zzy2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzab zzab2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzab2.zzd();
            zzab2.zzak();
            if (l2 < 0L) {
                zzab2.zzr().zzi().zza("Invalid time querying timed out conditional properties", zzet.zza((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzab2.zza(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj.zzr().zzx().zza("User property timed out", (Object)((zzy)object22).zza, (Object)this.zzj.zzj().zzc(((zzy)object22).zzc.zza), ((zzy)object22).zzc.zza());
                if (((zzy)object22).zzg != null) {
                    this.zzb(new zzaq(((zzy)object22).zzg, l), zzm2);
                }
                this.zze().zze(string, ((zzy)object22).zzc.zza);
            }
            l2 = l;
            string3 = string;
            zzab2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzab2.zzd();
            zzab2.zzak();
            if (l2 < 0L) {
                zzab2.zzr().zzi().zza("Invalid time querying expired conditional properties", zzet.zza((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzab2.zza(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzy)object4.next();
                if (object == null) continue;
                this.zzj.zzr().zzx().zza("User property expired", (Object)((zzy)object).zza, (Object)this.zzj.zzj().zzc(((zzy)object).zzc.zza), ((zzy)object).zzc.zza());
                this.zze().zzb(string, ((zzy)object).zzc.zza);
                if (((zzy)object).zzk != null) {
                    object22.add(((zzy)object).zzk);
                }
                this.zze().zze(string, ((zzy)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzaq)e;
                this.zzb(new zzaq((zzaq)object, l), zzm2);
            }
            long l3 = l;
            String string4 = zzaq2.zza;
            string3 = string;
            zzab2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzab2.zzd();
            zzab2.zzak();
            if (l3 < 0L) {
                zzab2.zzr().zzi().zza("Invalid time querying triggered conditional properties", zzet.zza((String)string3), (Object)zzab2.zzo().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzab2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzy2 = (zzy)iterator.next();
                if (zzy2 == null) continue;
                zzkn zzkn2 = zzy2.zzc;
                zzkp zzkp2 = new zzkp(zzy2.zza, zzy2.zzb, zzkn2.zza, l, zzkn2.zza());
                if (this.zze().zza(zzkp2)) {
                    this.zzj.zzr().zzx().zza("User property triggered", (Object)zzy2.zza, (Object)this.zzj.zzj().zzc(zzkp2.zzc), zzkp2.zze);
                } else {
                    this.zzj.zzr().zzf().zza("Too many active user properties, ignoring", zzet.zza((String)zzy2.zza), (Object)this.zzj.zzj().zzc(zzkp2.zzc), zzkp2.zze);
                }
                if (zzy2.zzi != null) {
                    object.add(zzy2.zzi);
                }
                zzy2.zzc = new zzkn(zzkp2);
                zzy2.zze = true;
                this.zze().zza(zzy2);
            }
            this.zzb(zzaq2, zzm2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzy2 = (zzaq)e;
                this.zzb(new zzaq((zzaq)zzy2, l), zzm2);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzb(zzaq var1_1, zzm var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzw();
        this.zzk();
        var5_4 = var2_2.zza;
        this.zzh();
        if (!zzkk.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zzc(var2_2);
            return;
        }
        if (this.zzc().zzb(var5_4, var1_1.zza)) {
            this.zzj.zzr().zzi().zza("Dropping blacklisted event. appId", zzet.zza((String)var5_4), (Object)this.zzj.zzj().zza(var1_1.zza));
            var6_5 = this.zzc().zzg(var5_4) != false || this.zzc().zzh(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzj.zzi().zza(var5_4, 11, "_ev", var1_1.zza, 0);
            }
            if (var6_5 && (var7_8 = this.zze().zzb(var5_4)) != null) {
                var8_10 = Math.max(var7_8.zzu(), var7_8.zzt());
                if (Math.abs(this.zzj.zzm().currentTimeMillis() - var8_10) > (Long)zzas.zzy.zza(null)) {
                    this.zzj.zzr().zzw().zza("Fetching config for blacklisted app");
                    this.zza(var7_8);
                }
            }
            return;
        }
        if (zzjn.zzb() && this.zzj.zzb().zza(zzas.zzck)) {
            var23_11 = var1_1;
            var6_6 = new zzex(var23_11.zza, var23_11.zzc, var23_11.zzb.zzb(), var23_11.zzd);
            var24_12 = var5_4;
            var25_13 = this.zzj.zzb().zza(var24_12, zzas.zzah, 25, 100);
            var24_12 = var6_6;
            var23_11 = this.zzj.zzi();
            var26_17 = 0;
            for (Object var29_23 : new TreeSet<E>(var24_12.zzd.keySet())) {
                if (!zzko.zza((String)var29_23) || ++var26_17 <= var25_13) continue;
                var30_24 = new StringBuilder(48).append("Event can't contain more than ").append(var25_13).append(" params").toString();
                var23_11.zzr().zzh().zza(var30_24, (Object)var23_11.zzo().zza(var24_12.zza), (Object)var23_11.zzo().zza(var24_12.zzd));
                zzko.zzb((Bundle)var24_12.zzd, (int)5);
                var24_12.zzd.remove((String)var29_23);
            }
            var23_11 = var6_6;
            var1_1 = new zzaq(var23_11.zza, new zzal(new Bundle(var23_11.zzd)), var23_11.zzb, var23_11.zzc);
        }
        if (this.zzj.zzr().zza(2)) {
            this.zzj.zzr().zzx().zza("Logging event", (Object)this.zzj.zzj().zza(var1_1));
        }
        this.zze().zzf();
        try {
            block74: {
                block75: {
                    block77: {
                        block81: {
                            block80: {
                                block78: {
                                    block79: {
                                        this.zzc(var2_2);
                                        var6_7 = zzjt.zzb() != false && this.zzj.zzb().zza(zzas.zzcj) != false;
                                        var7_9 = "ecommerce_purchase".equals(var1_1.zza) != false || var6_7 != false && ("purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false) ? 1 : 0;
                                        if (!("_iap".equals(var1_1.zza) != false || var7_9 != 0)) break block77;
                                        var26_17 = var7_9;
                                        var25_14 = var1_1;
                                        var24_12 = var5_4;
                                        var23_11 = this;
                                        var27_29 = var25_14.zzb.zzd("currency");
                                        if (var26_17 == 0) break block78;
                                        var30_25 = var25_14.zzb.zzc("value") * 1000000.0;
                                        if (var30_25 == 0.0) {
                                            var30_25 = (double)var25_14.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var30_25 <= 9.223372036854776E18) || !(var30_25 >= -9.223372036854776E18)) break block79;
                                        var28_20 = Math.round(var30_25);
                                        if (zzjt.zzb() && var23_11.zzj.zzb().zza(zzas.zzcj) && "refund".equals(var25_14.zza)) {
                                            var28_20 = -var28_20;
                                        }
                                        break block80;
                                    }
                                    var23_11.zzj.zzr().zzi().zza("Data lost. Currency value is too big. appId", zzet.zza((String)var24_12), (Object)var30_25);
                                    v0 = false;
                                    break block81;
                                }
                                var28_20 = var25_14.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var27_29) && (var27_29 = var27_29.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                v1 = String.valueOf("_ltv_");
                                v2 = String.valueOf(var27_29);
                                var30_26 = v2.length() != 0 ? v1.concat(v2) : new String(v1);
                                var31_30 /* !! */  = var23_11.zze().zzc(var24_12, var30_26);
                                if (var31_30 /* !! */  == null || !(var31_30 /* !! */ .zze instanceof Long)) {
                                    var35_31 = var24_12;
                                    var39_33 = var23_11.zzj.zzb().zzb(var35_31, zzas.zzad) - 1;
                                    var38_34 = var24_12;
                                    var37_35 = var23_11.zze();
                                    Preconditions.checkNotEmpty((String)var38_34);
                                    var37_35.zzd();
                                    var37_35.zzak();
                                    try {
                                        var37_35.c_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var38_34, var38_34, String.valueOf(var39_33)});
                                    }
                                    catch (SQLiteException var40_36) {
                                        var37_35.zzr().zzf().zza("Error pruning currencies. appId", zzet.zza((String)var38_34), (Object)var40_36);
                                    }
                                    var31_30 /* !! */  = new zzkp(var24_12, var25_14.zzc, var30_26, var23_11.zzj.zzm().currentTimeMillis(), (Object)var28_20);
                                } else {
                                    var32_37 = (Long)var31_30 /* !! */ .zze;
                                    var31_30 /* !! */  = new zzkp(var24_12, var25_14.zzc, var30_26, var23_11.zzj.zzm().currentTimeMillis(), (Object)(var32_37 + var28_20));
                                }
                                if (!var23_11.zze().zza(var31_30 /* !! */ )) {
                                    var23_11.zzj.zzr().zzf().zza("Too many unique user properties are set. Ignoring user property. appId", zzet.zza((String)var24_12), (Object)var23_11.zzj.zzj().zzc(var31_30 /* !! */ .zzc), var31_30 /* !! */ .zze);
                                    var23_11.zzj.zzi().zza(var24_12, 9, null, null, 0);
                                }
                            }
                            v0 = true;
                        }
                        if (!v0) {
                            this.zze().b_();
                            return;
                        }
                    }
                    var9_39 = zzko.zza((String)var1_1.zza);
                    var10_40 = "_err".equals(var1_1.zza);
                    var11_41 = 1L;
                    if (zzjt.zzb() && this.zzj.zzb().zze(var2_2.zza, zzas.zzcf)) {
                        this.zzj.zzi();
                        var11_41 = 1L + zzko.zza((zzal)var1_1.zzb);
                    }
                    var13_42 = this.zze().zza(this.zzx(), var5_4, var11_41, true, var9_39, false, var10_40, false);
                    var14_43 = var13_42.zzb - (long)((Integer)zzas.zzj.zza(null)).intValue();
                    if (var14_43 > 0L) {
                        if (var14_43 % 1000L == 1L) {
                            this.zzj.zzr().zzf().zza("Data loss. Too many events logged. appId, count", zzet.zza((String)var5_4), (Object)var13_42.zzb);
                        }
                        this.zze().b_();
                        return;
                    }
                    if (var9_39 && (var14_43 = var13_42.zza - (long)((Integer)zzas.zzl.zza(null)).intValue()) > 0L) {
                        if (var14_43 % 1000L == 1L) {
                            this.zzj.zzr().zzf().zza("Data loss. Too many public events logged. appId, count", zzet.zza((String)var5_4), (Object)var13_42.zza);
                        }
                        this.zzj.zzi().zza(var5_4, 16, "_ev", var1_1.zza, 0);
                        this.zze().b_();
                        return;
                    }
                    if (var10_40) {
                        var24_12 = var2_2.zza;
                        var25_15 = this.zzj.zzb().zzb(var24_12, zzas.zzk);
                        var14_43 = var13_42.zzd - (long)Math.max(0, var25_15 = Math.min(1000000, var25_15));
                        if (var14_43 > 0L) {
                            if (var14_43 == 1L) {
                                this.zzj.zzr().zzf().zza("Too many error events logged. appId, count", zzet.zza((String)var5_4), (Object)var13_42.zzd);
                            }
                            this.zze().b_();
                            return;
                        }
                    }
                    var16_44 = var1_1.zzb.zzb();
                    this.zzj.zzi().zza(var16_44, "_o", (Object)var1_1.zzc);
                    if (this.zzj.zzi().zzf(var5_4)) {
                        this.zzj.zzi().zza(var16_44, "_dbg", (Object)1L);
                        this.zzj.zzi().zza(var16_44, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var17_45 = this.zze().zzc(var2_2.zza, "_sno")) != null && var17_45.zze instanceof Long) {
                        this.zzj.zzi().zza(var16_44, "_sno", var17_45.zze);
                    }
                    if ((var17_46 = this.zze().zzc(var5_4)) > 0L) {
                        this.zzj.zzr().zzi().zza("Data lost. Too many events stored on disk, deleted. appId", zzet.zza((String)var5_4), (Object)var17_46);
                    }
                    var19_47 = new zzaj(this.zzj, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var16_44);
                    var20_48 = this.zze().zza(var5_4, var19_47.zzb);
                    if (var20_48 == null) {
                        if (this.zze().zzh(var5_4) >= (long)this.zzj.zzb().zza(var5_4) && var9_39) {
                            this.zzj.zzr().zzf().zza("Too many event names used, ignoring event. appId, name, supported count", zzet.zza((String)var5_4), (Object)this.zzj.zzj().zza(var19_47.zzb), (Object)this.zzj.zzb().zza(var5_4));
                            this.zzj.zzi().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var21_49 = new zzam(var5_4, var19_47.zzb, 0L, 0L, var19_47.zzc, 0L, null, null, null, null);
                    } else {
                        var19_47 = var19_47.zza(this.zzj, var20_48.zzf);
                        var21_49 = var20_48.zza(var19_47.zzc);
                    }
                    this.zze().zza(var21_49);
                    var25_16 = var2_2;
                    var24_12 = var19_47;
                    var23_11 = this;
                    var23_11.zzw();
                    var23_11.zzk();
                    Preconditions.checkNotNull((Object)var24_12);
                    Preconditions.checkNotNull((Object)var25_16);
                    Preconditions.checkNotEmpty((String)var24_12.zza);
                    Preconditions.checkArgument((boolean)var24_12.zza.equals(var25_16.zza));
                    var26_18 = zzbw.zzg.zzbf().zza(1).zza("android");
                    if (!TextUtils.isEmpty((CharSequence)var25_16.zza)) {
                        var26_18.zzf(var25_16.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var25_16.zzd)) {
                        var26_18.zze(var25_16.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var25_16.zzc)) {
                        var26_18.zzg(var25_16.zzc);
                    }
                    if (var25_16.zzj != -2147483648L) {
                        var26_18.zzh((int)var25_16.zzj);
                    }
                    var26_18.zzf(var25_16.zze);
                    if (!TextUtils.isEmpty((CharSequence)var25_16.zzb)) {
                        var26_18.zzk(var25_16.zzb);
                    }
                    if (zzle.zzb() && var23_11.zzj.zzb().zze(var25_16.zza, zzas.zzbo)) {
                        if (TextUtils.isEmpty((CharSequence)var26_18.zzl()) && !TextUtils.isEmpty((CharSequence)var25_16.zzv)) {
                            var26_18.zzp(var25_16.zzv);
                        }
                        if (TextUtils.isEmpty((CharSequence)var26_18.zzl()) && TextUtils.isEmpty((CharSequence)var26_18.zzo()) && !TextUtils.isEmpty((CharSequence)var25_16.zzr)) {
                            var26_18.zzo(var25_16.zzr);
                        }
                    } else if (TextUtils.isEmpty((CharSequence)var26_18.zzl()) && !TextUtils.isEmpty((CharSequence)var25_16.zzr)) {
                        var26_18.zzo(var25_16.zzr);
                    }
                    if (var25_16.zzf != 0L) {
                        var26_18.zzh(var25_16.zzf);
                    }
                    var26_18.zzk(var25_16.zzt);
                    if (var23_11.zzj.zzb().zze(var25_16.zza, zzas.zzaw) && (var27_29 = var23_11.zzh().zzf()) != null) {
                        var26_18.zzd((Iterable<? extends Integer>)var27_29);
                    }
                    if ((var27_29 = var23_11.zzj.zzc().zza(var25_16.zza)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var27_29.first))) {
                        if (var25_16.zzo) {
                            var26_18.zzh((String)var27_29.first);
                            if (var27_29.second != null) {
                                var26_18.zza((Boolean)var27_29.second);
                            }
                        }
                    } else if (!var23_11.zzj.zzx().zza(var23_11.zzj.zzn()) && var25_16.zzp) {
                        var28_21 = Settings.Secure.getString((ContentResolver)var23_11.zzj.zzn().getContentResolver(), (String)"android_id");
                        if (var28_21 == null) {
                            var23_11.zzj.zzr().zzi().zza("null secure ID. appId", zzet.zza((String)var26_18.zzj()));
                            var28_21 = "null";
                        } else if (var28_21.isEmpty()) {
                            var23_11.zzj.zzr().zzi().zza("empty secure ID. appId", zzet.zza((String)var26_18.zzj()));
                        }
                        var26_18.zzm(var28_21);
                    }
                    var23_11.zzj.zzx().zzaa();
                    v3 = var26_18.zzc(Build.MODEL);
                    var23_11.zzj.zzx().zzaa();
                    v3.zzb(Build.VERSION.RELEASE).zzf((int)var23_11.zzj.zzx().zzf()).zzd(var23_11.zzj.zzx().zzg());
                    if (!var23_11.zzj.zzb().zza(zzas.zzcm)) {
                        var26_18.zzj(var25_16.zzl);
                    }
                    if (var23_11.zzj.zzab()) {
                        var26_18.zzj();
                        if (!TextUtils.isEmpty(null)) {
                            var26_18.zzn(null);
                        }
                    }
                    if ((var28_22 = var23_11.zze().zzb(var25_16.zza)) == null) {
                        var28_22 = new zzg(var23_11.zzj, var25_16.zza);
                        var28_22.zza(var23_11.zzj.zzi().zzk());
                        var28_22.zzf(var25_16.zzk);
                        var28_22.zzb(var25_16.zzb);
                        var28_22.zze(var23_11.zzj.zzc().zzb(var25_16.zza));
                        var28_22.zzg(0L);
                        var28_22.zza(0L);
                        var28_22.zzb(0L);
                        var28_22.zzg(var25_16.zzc);
                        var28_22.zzc(var25_16.zzj);
                        var28_22.zzh(var25_16.zzd);
                        var28_22.zzd(var25_16.zze);
                        var28_22.zze(var25_16.zzf);
                        var28_22.zza(var25_16.zzh);
                        if (!var23_11.zzj.zzb().zza(zzas.zzcm)) {
                            var28_22.zzp(var25_16.zzl);
                        }
                        var28_22.zzf(var25_16.zzt);
                        var23_11.zze().zza(var28_22);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var28_22.zzd())) {
                        var26_18.zzi(var28_22.zzd());
                    }
                    if (!TextUtils.isEmpty((CharSequence)var28_22.zzi())) {
                        var26_18.zzl(var28_22.zzi());
                    }
                    var29_23 = var23_11.zze().zza(var25_16.zza);
                    for (var30_27 = 0; var30_27 < var29_23.size(); ++var30_27) {
                        var31_30 /* !! */  = zzbw.zzk.zzj().zza(((zzkp)var29_23.get((int)var30_27)).zzc).zza(((zzkp)var29_23.get((int)var30_27)).zzd);
                        var23_11.zzh().zza((zzbw.zzk.zza)var31_30 /* !! */ , ((zzkp)var29_23.get((int)var30_27)).zze);
                        var26_18.zza((zzbw.zzk.zza)var31_30 /* !! */ );
                    }
                    try {
                        var30_28 = var23_11.zze().zza((zzbw.zzg)((zzfi)var26_18.zzu()));
                    }
                    catch (IOException var32_38) {
                        var23_11.zzj.zzr().zzf().zza("Data loss. Failed to insert raw event metadata. appId", zzet.zza((String)var26_18.zzj()), (Object)var32_38);
                        break block74;
                    }
                    v4 = var23_11.zze();
                    var34_50 = var24_12;
                    var33_51 = var23_11;
                    if (var34_50.zze == null) ** GOTO lbl-1000
                    for (Object var36_52 : var34_50.zze) {
                        if (!"_r".equals(var36_52)) continue;
                        v5 = true;
                        break block75;
                    }
                    var35_32 = var33_51.zzc().zzc(var34_50.zza, var34_50.zzb);
                    var36_52 = var33_51.zze().zza(super.zzx(), var34_50.zza, false, false, false, false, false);
                    if (var35_32 && var36_52.zze < (long)var33_51.zzj.zzb().zzb(var34_50.zza)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                }
                if (v4.zza((zzaj)var24_12, var30_28, v5)) {
                    var23_11.zzm = 0L;
                }
            }
            this.zze().b_();
        }
        finally {
            this.zze().zzh();
        }
        this.zzz();
        this.zzj.zzr().zzx().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    @WorkerThread
    final void zzl() {
        this.zzw();
        this.zzk();
        this.zzs = true;
        try {
            String string;
            long l;
            zzv zzv2 = this.zzj.zzu();
            Boolean bl = this.zzj.zzw().zzag();
            if (bl == null) {
                this.zzj.zzr().zzi().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj.zzr().zzf().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzm > 0L) {
                this.zzz();
                return;
            }
            zzgu zzgu2 = this;
            zzgu2.zzw();
            if (zzgu2.zzv != null) {
                this.zzj.zzr().zzx().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzd().zzf()) {
                this.zzj.zzr().zzx().zza("Network not connected, ignoring upload request");
                this.zzz();
                return;
            }
            long l2 = this.zzj.zzm().currentTimeMillis();
            int n = this.zzj.zzb().zzb(null, zzas.zzap);
            long l3 = l2 - zzaa.zzv();
            for (int i = 0; i < n && this.zza(null, l = l3); ++i) {
            }
            long l4 = this.zzj.zzc().zzc.zza();
            if (l4 != 0L) {
                this.zzj.zzr().zzw().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l2 - l4));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zze().d_()))) {
                if (this.zzx == -1L) {
                    this.zzx = this.zze().zzaa();
                }
                Object object = string;
                int n2 = this.zzj.zzb().zzb((String)object, zzas.zzf);
                object = string;
                zzgu2 = this.zzj.zzb();
                int n3 = Math.max(0, zzgu2.zzb((String)object, zzas.zzg));
                List<Pair<zzbw.zzg, Long>> list = this.zze().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    String string2 = null;
                    Object object5 = list.iterator();
                    while (object5.hasNext()) {
                        object4 = (zzbw.zzg)((Object)object5.next().first);
                        if (TextUtils.isEmpty((CharSequence)object4.zzad())) continue;
                        string2 = object4.zzad();
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            zzbw.zzg zzg2 = (zzbw.zzg)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) || zzg2.zzad().equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object5 = zzbw.zzf.zzb();
                    int n4 = list.size();
                    object4 = new ArrayList(list.size());
                    boolean bl2 = this.zzj.zzb().zzf(string);
                    for (int i = 0; i < n4; ++i) {
                        object3 = (zzbw.zzg.zza)((zzbw.zzg)((Object)list.get((int)i).first)).zzbm();
                        object4.add((Long)list.get((int)i).second);
                        zzv2 = this.zzj.zzu();
                        ((zzbw.zzg.zza)((Object)object3)).zzg(this.zzj.zzb().zzf()).zza(l2).zzb(false);
                        if (!bl2) {
                            ((zzbw.zzg.zza)((Object)object3)).zzn();
                        }
                        if (this.zzj.zzb().zze(string, zzas.zzay)) {
                            object2 = ((zzbw.zzg)((zzfi)object3.zzu())).zzbi();
                            ((zzbw.zzg.zza)((Object)object3)).zzl(this.zzh().zza((byte[])object2));
                        }
                        ((zzbw.zzf.zza)((Object)object5)).zza((zzbw.zzg.zza)((Object)object3));
                    }
                    String string3 = null;
                    if (this.zzj.zzr().zza(2)) {
                        string3 = this.zzh().zza((zzbw.zzf)((zzfi)object5.zzu()));
                    }
                    this.zzh();
                    object3 = ((zzbw.zzf)((zzfi)object5.zzu())).zzbi();
                    object2 = (String)zzas.zzp.zza(null);
                    try {
                        URL uRL = new URL((String)object2);
                        object = object4;
                        zzgu2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzgu2.zzv != null) {
                            zzgu2.zzj.zzr().zzf().zza("Set uploading progress before finishing the previous upload");
                        } else {
                            zzgu2.zzv = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzj.zzc().zzd.zza(l2);
                        String string4 = "?";
                        if (n4 > 0) {
                            string4 = ((zzbw.zzf.zza)((Object)object5)).zza(0).zzx();
                        }
                        this.zzj.zzr().zzx().zza("Uploading data. app, uncompressed size, data", (Object)string4, (Object)((Object)object3).length, (Object)string3);
                        this.zzr = true;
                        zzki zzki2 = new zzki(this, string);
                        Object object6 = object3;
                        URL uRL2 = uRL;
                        object = string;
                        zzgu2 = this.zzd();
                        zzgu2.zzd();
                        zzgu2.zzak();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)object6);
                        Preconditions.checkNotNull((Object)zzki2);
                        zzgu2.zzq().zzb((Runnable)new zzfe((zzfa)zzgu2, (String)object, uRL2, (byte[])object6, null, zzki2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj.zzr().zzf().zza("Failed to parse upload URL. Not uploading. appId", zzet.zza((String)string), object2);
                    }
                }
            } else {
                zzg zzg3;
                this.zzx = -1L;
                String string5 = this.zze().zza(l2 - zzaa.zzv());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzg3 = this.zze().zzb(string5)) != null) {
                    this.zza(zzg3);
                }
            }
            return;
        }
        finally {
            this.zzs = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final boolean zza(String string, long l) {
        this.zze().zzf();
        try {
            block157: {
                zzg zzg2;
                int n;
                String[] stringArray;
                String string2;
                Object object;
                Object object2;
                Object object3;
                zza zza2;
                block155: {
                    zza2 = new zza(null);
                    object3 = zza2;
                    long l2 = this.zzx;
                    long l3 = l;
                    String string3 = null;
                    object2 = this.zze();
                    Preconditions.checkNotNull((Object)object3);
                    object2.zzd();
                    ((zzkd)((Object)object2)).zzak();
                    try (Cursor cursor = null;){
                        String string4;
                        Object object4;
                        Object[] objectArray;
                        object = ((zzab)((Object)object2)).c_();
                        if (TextUtils.isEmpty(null)) {
                            objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            object4 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = object.rawQuery(new StringBuilder(148 + String.valueOf(object4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append((String)object4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block155;
                            string3 = cursor.getString(0);
                            string2 = cursor.getString(1);
                            cursor.close();
                        } else {
                            objectArray = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            object4 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = object.rawQuery(new StringBuilder(84 + String.valueOf(object4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append((String)object4).append(" order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block155;
                            string2 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = object.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string3, string2}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object2.zzr().zzf().zza("Raw event metadata record is missing. appId", zzet.zza((String)string3));
                            break block155;
                        }
                        objectArray = cursor.getBlob(0);
                        try {
                            object4 = (zzbw.zzg)((zzfi)zzkk.zza(zzbw.zzg.zzbf(), (byte[])objectArray).zzu());
                        }
                        catch (IOException iOException) {
                            object2.zzr().zzf().zza("Data loss. Failed to merge raw event metadata. appId", zzet.zza((String)string3), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block155;
                        }
                        if (cursor.moveToNext()) {
                            object2.zzr().zzi().zza("Get multiple raw event metadata records, expected one. appId", zzet.zza((String)string3));
                        }
                        cursor.close();
                        object3.zza((zzbw.zzg)((Object)object4));
                        if (l2 != -1L) {
                            string4 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string3, string2, String.valueOf(l2)};
                        } else {
                            string4 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string3, string2};
                        }
                        cursor = object.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string4, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object2.zzr().zzi().zza("Raw event data disappeared while in transaction. appId", zzet.zza((String)string3));
                            break block155;
                        }
                        do {
                            zzbw.zzc.zza zza3;
                            long l4 = cursor.getLong(0);
                            objectArray = cursor.getBlob(3);
                            try {
                                zza3 = zzkk.zza(zzbw.zzc.zzj(), (byte[])objectArray);
                            }
                            catch (IOException iOException) {
                                object2.zzr().zzf().zza("Data loss. Failed to merge raw event. appId", zzet.zza((String)string3), (Object)iOException);
                                continue;
                            }
                            zza3.zza(cursor.getString(1)).zza(cursor.getLong(2));
                            if (!object3.zza(l4, (zzbw.zzc)((zzfi)zza3.zzu()))) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzc == null || ((zza)object2).zzc.isEmpty()) break block157;
                boolean bl = false;
                zzbw.zzg.zza zza4 = ((zzbw.zzg.zza)zza2.zza.zzbm()).zzc();
                int n2 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzj.zzb().zze(zza2.zza.zzx(), zzas.zzau);
                zzbw.zzc.zza zzgv3 = null;
                int n3 = -1;
                zzbw.zzc.zza zza5 = null;
                int n4 = -1;
                for (n = 0; n < zza2.zzc.size(); ++n) {
                    Object object5;
                    boolean bl3;
                    zzbw.zzc.zza zzgv22;
                    block159: {
                        boolean bl4;
                        block158: {
                            boolean bl5;
                            bl4 = bl;
                            zzgv22 = (zzbw.zzc.zza)zza2.zzc.get(n).zzbm();
                            if (this.zzc().zzb(zza2.zza.zzx(), zzgv22.zzd())) {
                                this.zzj.zzr().zzi().zza("Dropping blacklisted raw event. appId", zzet.zza((String)zza2.zza.zzx()), (Object)this.zzj.zzj().zza(zzgv22.zzd()));
                                if (this.zzc().zzg(zza2.zza.zzx()) || this.zzc().zzh(zza2.zza.zzx()) || "_err".equals(zzgv22.zzd())) continue;
                                this.zzj.zzi().zza(zza2.zza.zzx(), 11, "_ev", zzgv22.zzd(), 0);
                                continue;
                            }
                            bl3 = this.zzc().zzc(zza2.zza.zzx(), zzgv22.zzd());
                            if (bl3) break block158;
                            this.zzh();
                            object2 = zzgv22.zzd();
                            Preconditions.checkNotEmpty((String)object2);
                            switch (object2) {
                                case "_in": 
                                case "_ui": 
                                case "_ug": {
                                    bl5 = true;
                                    break;
                                }
                                default: {
                                    bl5 = false;
                                }
                            }
                            if (!bl5) break block159;
                        }
                        boolean l6 = false;
                        boolean bl6 = false;
                        for (int i = 0; i < zzgv22.zzb(); ++i) {
                            zzbw.zze zze2;
                            if ("_c".equals(zzgv22.zza(i).zzb())) {
                                zze2 = (zzbw.zze)((zzfi)((zzbw.zze.zza)zzgv22.zza(i).zzbm()).zza(1L).zzu());
                                l6 = true;
                                zzgv22.zza(i, zze2);
                                continue;
                            }
                            if (!"_r".equals(zzgv22.zza(i).zzb())) continue;
                            zze2 = (zzbw.zze)((zzfi)((zzbw.zze.zza)zzgv22.zza(i).zzbm()).zza(1L).zzu());
                            bl6 = true;
                            zzgv22.zza(i, zze2);
                        }
                        if (!l6 && bl3) {
                            this.zzj.zzr().zzx().zza("Marking event as conversion", (Object)this.zzj.zzj().zza(zzgv22.zzd()));
                            zzgv22.zza(zzbw.zze.zzk().zza("_c").zza(1L));
                        }
                        if (!bl6) {
                            this.zzj.zzr().zzx().zza("Marking event as real-time", (Object)this.zzj.zzj().zza(zzgv22.zzd()));
                            zzgv22.zza(zzbw.zze.zzk().zza("_r").zza(1L));
                        }
                        bl = true;
                        if (this.zze().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zze > (long)this.zzj.zzb().zzb(zza2.zza.zzx())) {
                            zzkg.zza(zzgv22, "_r");
                            bl = bl4;
                        }
                        if (zzko.zza((String)zzgv22.zzd()) && bl3) {
                            String string5 = zza2.zza.zzx();
                            if (this.zze().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzc > (long)this.zzj.zzb().zzb(string5, zzas.zzm)) {
                                this.zzj.zzr().zzi().zza("Too many conversions. Not logging as conversion. appId", zzet.zza((String)zza2.zza.zzx()));
                                boolean bl7 = false;
                                zzbw.zze.zza zza3 = null;
                                int n5 = -1;
                                for (int i = 0; i < zzgv22.zzb(); ++i) {
                                    zzbw.zze zze3 = zzgv22.zza(i);
                                    if ("_c".equals(zze3.zzb())) {
                                        zza3 = (zzbw.zze.zza)zze3.zzbm();
                                        n5 = i;
                                        continue;
                                    }
                                    if (!"_err".equals(zze3.zzb())) continue;
                                    bl7 = true;
                                }
                                if (bl7 && zza3 != null) {
                                    int n6 = n5;
                                    zzgv22.zzb(n6);
                                } else if (zza3 != null) {
                                    zzbw.zze zze4 = (zzbw.zze)((zzfi)((zzbw.zze.zza)((zzfi.zzb)zza3.clone())).zza("_err").zza(10L).zzu());
                                    zzgv22.zza(n5, zze4);
                                } else {
                                    this.zzj.zzr().zzf().zza("Did not find conversion parameter. appId", zzet.zza((String)zza2.zza.zzx()));
                                }
                            }
                        }
                    }
                    if (bl3) {
                        int n6;
                        zzbw.zzc.zza zzgv4 = zzgv22;
                        object2 = this;
                        object5 = new ArrayList<zzbw.zze>(zzgv4.zza());
                        int i = -1;
                        int n9 = -1;
                        for (n6 = 0; n6 < object5.size(); ++n6) {
                            if ("value".equals(((zzbw.zze)((Object)object5.get(n6))).zzb())) {
                                i = n6;
                                continue;
                            }
                            if (!"currency".equals(((zzbw.zze)((Object)object5.get(n6))).zzb())) continue;
                            n9 = n6;
                        }
                        if (i != -1) {
                            if (!((zzbw.zze)((Object)object5.get(i))).zze() && !((zzbw.zze)((Object)object5.get(i))).zzg()) {
                                ((zzkg)object2).zzj.zzr().zzk().zza("Value must be specified with a numeric type.");
                                int n10 = i;
                                zzgv4.zzb(n10);
                                zzkg.zza(zzgv4, "_c");
                                zzkg.zza(zzgv4, 18, "value");
                            } else {
                                n6 = 0;
                                if (n9 == -1) {
                                    n6 = 1;
                                } else {
                                    object3 = ((zzbw.zze)((Object)object5.get(n9))).zzd();
                                    if (((String)object3).length() != 3) {
                                        n6 = 1;
                                    } else {
                                        int n11;
                                        for (i = 0; i < ((String)object3).length(); i += Character.charCount(n11)) {
                                            n11 = ((String)object3).codePointAt(i);
                                            if (Character.isLetter(n11)) continue;
                                            n6 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n6 != 0) {
                                    ((zzkg)object2).zzj.zzr().zzk().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    int n12 = i;
                                    zzgv4.zzb(n12);
                                    zzkg.zza(zzgv4, "_c");
                                    zzkg.zza(zzgv4, 19, "currency");
                                }
                            }
                        }
                    }
                    if (this.zzj.zzb().zze(zza2.zza.zzx(), zzas.zzat)) {
                        if ("_e".equals(zzgv22.zzd())) {
                            this.zzh();
                            if (zzkk.zza((zzbw.zzc)((zzfi)zzgv22.zzu()), "_fr") == null) {
                                if (zza5 != null && Math.abs(zza5.zzf() - zzgv22.zzf()) <= 1000L) {
                                    zzbw.zzc.zza l13 = (zzbw.zzc.zza)((zzfi.zzb)zza5.clone());
                                    if (this.zza(zzgv22, l13)) {
                                        zzgv3 = null;
                                        zza5 = null;
                                        zza4.zza(n4, l13);
                                    } else {
                                        zzgv3 = zzgv22;
                                        n3 = n2;
                                    }
                                } else {
                                    zzgv3 = zzgv22;
                                    n3 = n2;
                                }
                            }
                        } else if ("_vs".equals(zzgv22.zzd())) {
                            this.zzh();
                            if (zzkk.zza((zzbw.zzc)((zzfi)zzgv22.zzu()), "_et") == null) {
                                if (zzgv3 != null && Math.abs(zzgv3.zzf() - zzgv22.zzf()) <= 1000L) {
                                    zzbw.zzc.zza zzb2 = (zzbw.zzc.zza)((zzfi.zzb)zzgv3.clone());
                                    if (this.zza(zzb2, zzgv22)) {
                                        zzgv3 = null;
                                        zza5 = null;
                                        zza4.zza(n3, zzb2);
                                    } else {
                                        zza5 = zzgv22;
                                        n4 = n2;
                                    }
                                } else {
                                    zza5 = zzgv22;
                                    n4 = n2;
                                }
                            }
                        } else if (this.zzj.zzb().zze(zza2.zza.zzx(), zzas.zzbs) && "_ab".equals(zzgv22.zzd())) {
                            this.zzh();
                            if (zzkk.zza((zzbw.zzc)((zzfi)zzgv22.zzu()), "_et") == null && zzgv3 != null && Math.abs(zzgv3.zzf() - zzgv22.zzf()) <= 4000L) {
                                String string6;
                                zzbw.zzc.zza zza6 = (zzbw.zzc.zza)((zzfi.zzb)zzgv3.clone());
                                this.zzb(zza6, zzgv22);
                                object5 = zzgv22;
                                zzbw.zzc.zza zza10 = zza6;
                                object2 = this;
                                Preconditions.checkArgument((boolean)"_e".equals(zza10.zzd()));
                                ((zzkg)object2).zzh();
                                zzbw.zze sQLiteException = zzkk.zza((zzbw.zzc)((zzfi)zza10.zzu()), "_sn");
                                ((zzkg)object2).zzh();
                                zzbw.zze zze6 = zzkk.zza((zzbw.zzc)((zzfi)zza10.zzu()), "_sc");
                                ((zzkg)object2).zzh();
                                zzbw.zze zze5 = zzkk.zza((zzbw.zzc)((zzfi)zza10.zzu()), "_si");
                                object3 = sQLiteException != null ? sQLiteException.zzd() : "";
                                if (!TextUtils.isEmpty((CharSequence)object3)) {
                                    ((zzkg)object2).zzh().zza((zzbw.zzc.zza)((Object)object5), "_sn", object3);
                                }
                                if (!TextUtils.isEmpty((CharSequence)(string6 = zze6 != null ? zze6.zzd() : ""))) {
                                    ((zzkg)object2).zzh().zza((zzbw.zzc.zza)((Object)object5), "_sc", string6);
                                }
                                if (zze5 != null) {
                                    ((zzkg)object2).zzh().zza((zzbw.zzc.zza)((Object)object5), "_si", zze5.zzf());
                                }
                                zzgv3 = null;
                                zza4.zza(n3, zza6);
                            }
                        }
                    }
                    if (!bl2 && "_e".equals(zzgv22.zzd())) {
                        if (zzgv22.zzb() == 0) {
                            this.zzj.zzr().zzi().zza("Engagement event does not contain any parameters. appId", zzet.zza((String)zza2.zza.zzx()));
                        } else {
                            Long l2 = (Long)this.zzh().zzb((zzbw.zzc)((zzfi)zzgv22.zzu()), "_et");
                            if (l2 == null) {
                                this.zzj.zzr().zzi().zza("Engagement event does not include duration. appId", zzet.zza((String)zza2.zza.zzx()));
                            } else {
                                l5 += l2.longValue();
                            }
                        }
                    }
                    zza2.zzc.set(n, (zzbw.zzc)((zzfi)zzgv22.zzu()));
                    ++n2;
                    zza4.zza(zzgv22);
                }
                if (bl2) {
                    for (n = 0; n < n2; ++n) {
                        Long l3;
                        zzbw.zzc zzc2 = zza4.zzb(n);
                        if ("_e".equals(zzc2.zzc())) {
                            this.zzh();
                            if (zzkk.zza(zzc2, "_fr") != null) {
                                zza4.zzc(n);
                                --n2;
                                --n;
                                continue;
                            }
                        }
                        this.zzh();
                        zzbw.zze string8 = zzkk.zza(zzc2, "_et");
                        if (string8 == null || (l3 = string8.zze() ? Long.valueOf(string8.zzf()) : null) == null || l3 <= 0L) continue;
                        l5 += l3.longValue();
                    }
                }
                this.zza(zza4, l5, false);
                n = 0;
                for (zzbw.zzc zzc2 : zza4.zza()) {
                    if (!"_s".equals(zzc2.zzc())) continue;
                    n = 1;
                    break;
                }
                if (n != 0) {
                    this.zze().zzb(zza4.zzj(), "_se");
                }
                if (zzkk.zza(zza4, "_sid") >= 0) {
                    this.zza(zza4, l5, true);
                } else {
                    int n7 = zzkk.zza(zza4, "_se");
                    if (n7 >= 0) {
                        zza4.zze(n7);
                        this.zzj.zzr().zzf().zza("Session engagement user property is in the bundle without session ID. appId", zzet.zza((String)zza2.zza.zzx()));
                    }
                }
                Object object6 = zza4;
                object2 = this.zzh();
                object2.zzr().zzx().zza("Checking account type status for ad personalization signals");
                if (((zzke)((Object)object2)).zzj().zze(((zzbw.zzg.zza)((Object)object6)).zzj()) && (zzg2 = ((zzke)((Object)object2)).zzi().zzb(((zzbw.zzg.zza)((Object)object6)).zzj())) != null && zzg2.zzaf() && object2.zzl().zzj()) {
                    object2.zzr().zzw().zza("Turning off ad personalization due to account type");
                    zzbw.zzk zzk2 = (zzbw.zzk)((zzfi)zzbw.zzk.zzj().zza("_npa").zza(object2.zzl().zzh()).zzb(1L).zzu());
                    boolean bl9 = false;
                    for (int i = 0; i < ((zzbw.zzg.zza)((Object)object6)).zze(); ++i) {
                        if (!"_npa".equals(((zzbw.zzg.zza)((Object)object6)).zzd(i).zzc())) continue;
                        ((zzbw.zzg.zza)((Object)object6)).zza(i, zzk2);
                        bl9 = true;
                        break;
                    }
                    if (!bl9) {
                        ((zzbw.zzg.zza)((Object)object6)).zza(zzk2);
                    }
                }
                if (this.zzj.zzb().zze(zza4.zzj(), zzas.zzbn)) {
                    zzkg.zza(zza4);
                }
                zza4.zzm().zzc(this.zzf().zza(zza4.zzj(), zza4.zza(), zza4.zzd(), zza4.zzf(), zza4.zzg()));
                if (this.zzj.zzb().zzg(zza2.zza.zzx())) {
                    zza zza11 = zza2;
                    object6 = zza4;
                    object2 = this;
                    HashMap<Object, String> hashMap = new HashMap<Object, String>();
                    ArrayList<zzbw.zzc> arrayList = new ArrayList<zzbw.zzc>();
                    SecureRandom secureRandom = ((zzkg)object2).zzj.zzi().zzh();
                    for (int i = 0; i < ((zzbw.zzg.zza)((Object)object6)).zzb(); ++i) {
                        Long l8;
                        boolean bl8;
                        int n14;
                        long l9;
                        long l10;
                        zzbw.zzc.zza zza12;
                        block156: {
                            zza12 = (zzbw.zzc.zza)((zzbw.zzg.zza)((Object)object6)).zzb(i).zzbm();
                            if (zza12.zzd().equals("_ep")) {
                                object = (String)((zzkg)object2).zzh().zzb((zzbw.zzc)((zzfi)zza12.zzu()), "_en");
                                string2 = (zzam)hashMap.get(object);
                                if (string2 == null) {
                                    string2 = ((zzkg)object2).zze().zza(zza11.zza.zzx(), (String)object);
                                    hashMap.put(object, string2);
                                }
                                if (((zzam)string2).zzi == null) {
                                    if (((zzam)string2).zzj > 1L) {
                                        ((zzkg)object2).zzh().zza(zza12, "_sr", ((zzam)string2).zzj);
                                    }
                                    if (((zzam)string2).zzk != null && ((zzam)string2).zzk.booleanValue()) {
                                        ((zzkg)object2).zzh().zza(zza12, "_efs", 1L);
                                    }
                                    arrayList.add((zzbw.zzc)((zzfi)zza12.zzu()));
                                }
                                ((zzbw.zzg.zza)((Object)object6)).zza(i, zza12);
                                continue;
                            }
                            l10 = ((zzkg)object2).zzc().zzf(zza11.zza.zzx());
                            ((zzkg)object2).zzj.zzi();
                            l9 = zzko.zza((long)zza12.zzf(), (long)l10);
                            n14 = 1;
                            Long l4 = 1L;
                            String string3 = "_dbg";
                            zzbw.zzc zzc3 = (zzbw.zzc)((zzfi)zza12.zzu());
                            if (TextUtils.isEmpty((CharSequence)string3) || l4 == null) {
                                bl8 = false;
                            } else {
                                for (zzbw.zze zze6 : zzc3.zza()) {
                                    if (!string3.equals(zze6.zzb())) continue;
                                    bl8 = l4 instanceof Long && ((Object)l4).equals(zze6.zzf()) || l4 instanceof String && ((Object)l4).equals(zze6.zzd()) || l4 instanceof Double && ((Object)l4).equals(zze6.zzh());
                                    break block156;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) {
                            n14 = ((zzkg)object2).zzc().zzd(zza11.zza.zzx(), zza12.zzd());
                        }
                        if (n14 <= 0) {
                            ((zzkg)object2).zzj.zzr().zzi().zza("Sample rate must be positive. event, rate", (Object)zza12.zzd(), (Object)n14);
                            arrayList.add((zzbw.zzc)((zzfi)zza12.zzu()));
                            ((zzbw.zzg.zza)((Object)object6)).zza(i, zza12);
                            continue;
                        }
                        stringArray = (String[])hashMap.get(zza12.zzd());
                        if (stringArray == null && (stringArray = ((zzkg)object2).zze().zza(zza11.zza.zzx(), zza12.zzd())) == null) {
                            ((zzkg)object2).zzj.zzr().zzi().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)zza11.zza.zzx(), (Object)zza12.zzd());
                            stringArray = new zzam(zza11.zza.zzx(), zza12.zzd(), 1L, 1L, 1L, zza12.zzf(), 0L, null, null, null, null);
                        }
                        Boolean bl9 = (l8 = (Long)((zzkg)object2).zzh().zzb((zzbw.zzc)((zzfi)zza12.zzu()), "_eid")) != null;
                        if (n14 == 1) {
                            arrayList.add((zzbw.zzc)((zzfi)zza12.zzu()));
                            if (bl9.booleanValue() && (stringArray.zzi != null || stringArray.zzj != null || stringArray.zzk != null)) {
                                stringArray = stringArray.zza(null, null, null);
                                hashMap.put(zza12.zzd(), (String)stringArray);
                            }
                            ((zzbw.zzg.zza)((Object)object6)).zza(i, zza12);
                            continue;
                        }
                        if (secureRandom.nextInt(n14) == 0) {
                            ((zzkg)object2).zzh().zza(zza12, "_sr", n14);
                            arrayList.add((zzbw.zzc)((zzfi)zza12.zzu()));
                            if (bl9.booleanValue()) {
                                stringArray = stringArray.zza(null, Long.valueOf(n14), null);
                            }
                            hashMap.put(zza12.zzd(), (String)stringArray.zza(zza12.zzf(), l9));
                        } else {
                            long l12;
                            if (stringArray.zzh != null) {
                                l12 = stringArray.zzh;
                            } else {
                                ((zzkg)object2).zzj.zzi();
                                l12 = zzko.zza((long)zza12.zzg(), (long)l10);
                            }
                            if (l12 != l9) {
                                ((zzkg)object2).zzh().zza(zza12, "_efs", 1L);
                                ((zzkg)object2).zzh().zza(zza12, "_sr", n14);
                                arrayList.add((zzbw.zzc)((zzfi)zza12.zzu()));
                                if (bl9.booleanValue()) {
                                    stringArray = stringArray.zza(null, Long.valueOf(n14), Boolean.valueOf(true));
                                }
                                hashMap.put(zza12.zzd(), (String)stringArray.zza(zza12.zzf(), l9));
                            } else if (bl9.booleanValue()) {
                                hashMap.put(zza12.zzd(), (String)stringArray.zza(l8, null, null));
                            }
                        }
                        ((zzbw.zzg.zza)((Object)object6)).zza(i, zza12);
                    }
                    if (arrayList.size() < ((zzbw.zzg.zza)((Object)object6)).zzb()) {
                        ((zzbw.zzg.zza)((Object)object6)).zzc().zza(arrayList);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        ((zzkg)object2).zze().zza((zzam)entry.getValue());
                    }
                }
                if (!this.zzj.zzb().zze(zza4.zzj(), zzas.zzbn)) {
                    zzkg.zza(zza4);
                }
                String string4 = zza2.zza.zzx();
                zzg zzg3 = this.zze().zzb(string4);
                if (zzg3 == null) {
                    this.zzj.zzr().zzf().zza("Bundling raw events w/o app info. appId", zzet.zza((String)zza2.zza.zzx()));
                } else if (zza4.zzb() > 0) {
                    long l6 = zzg3.zzk();
                    if (l6 != 0L) {
                        zza4.zze(l6);
                    } else {
                        zza4.zzi();
                    }
                    long l7 = zzg3.zzj();
                    if (l7 == 0L) {
                        l7 = l6;
                    }
                    if (l7 != 0L) {
                        zza4.zzd(l7);
                    } else {
                        zza4.zzh();
                    }
                    zzg3.zzv();
                    zza4.zzg((int)zzg3.zzs());
                    zzg3.zza(zza4.zzf());
                    zzg3.zzb(zza4.zzg());
                    String string5 = zzg3.zzad();
                    if (string5 != null) {
                        zza4.zzj(string5);
                    } else {
                        zza4.zzk();
                    }
                    this.zze().zza(zzg3);
                }
                if (zza4.zzb() > 0) {
                    zzv zzv2 = this.zzj.zzu();
                    zzbt.zzb zzb2 = this.zzc().zza(zza2.zza.zzx());
                    if (zzb2 == null || !zzb2.zza()) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zza.zzam())) {
                            zza4.zzi(-1L);
                        } else {
                            this.zzj.zzr().zzi().zza("Did not find measurement config or missing version info. appId", zzet.zza((String)zza2.zza.zzx()));
                        }
                    } else {
                        zza4.zzi(zzb2.zzb());
                    }
                    this.zze().zza((zzbw.zzg)((zzfi)zza4.zzu()), bl);
                }
                object6 = zza2.zzb;
                object2 = this.zze();
                Preconditions.checkNotNull((Object)object6);
                object2.zzd();
                ((zzkd)((Object)object2)).zzak();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (int i = 0; i < object6.size(); ++i) {
                    if (i != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((Long)object6.get(i));
                }
                stringBuilder.append(")");
                int n15 = ((zzab)((Object)object2)).c_().delete("raw_events", stringBuilder.toString(), null);
                if (n15 != object6.size()) {
                    object2.zzr().zzf().zza("Deleted fewer rows from raw events table than expected", (Object)n15, (Object)object6.size());
                }
                object6 = string4;
                object2 = this.zze();
                stringBuilder = ((zzab)((Object)object2)).c_();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object6, object6});
                }
                catch (SQLiteException sQLiteException) {
                    object2.zzr().zzf().zza("Failed to remove unused event metadata. appId", zzet.zza((String)object6), (Object)sQLiteException);
                }
                this.zze().b_();
                return true;
            }
            this.zze().b_();
            return false;
        }
        finally {
            this.zze().zzh();
        }
    }

    private static void zza(zzbw.zzg.zza zza2) {
        zza2.zzb(Long.MAX_VALUE).zzc(Long.MIN_VALUE);
        for (int i = 0; i < zza2.zzb(); ++i) {
            zzbw.zzc zzc2 = zza2.zzb(i);
            if (zzc2.zze() < zza2.zzf()) {
                zza2.zzb(zzc2.zze());
            }
            if (zzc2.zze() <= zza2.zzg()) continue;
            zza2.zzc(zzc2.zze());
        }
    }

    @VisibleForTesting
    private final void zza(zzbw.zzg.zza zza2, long l, boolean bl) {
        zzkp zzkp2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzkp2 = (zzkp2 = this.zze().zzc(zza2.zzj(), string)) == null || zzkp2.zze == null ? new zzkp(zza2.zzj(), "auto", string, this.zzj.zzm().currentTimeMillis(), (Object)l) : new zzkp(zza2.zzj(), "auto", string, this.zzj.zzm().currentTimeMillis(), (Object)((Long)zzkp2.zze + l));
        zzbw.zzk zzk2 = (zzbw.zzk)((zzfi)zzbw.zzk.zzj().zza(string).zza(this.zzj.zzm().currentTimeMillis()).zzb((Long)zzkp2.zze).zzu());
        boolean bl2 = false;
        int n = zzkk.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzk2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzk2);
        }
        if (l > 0L) {
            this.zze().zza(zzkp2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj.zzr().zzx().zza("Updated engagement user property. scope, value", (Object)string2, zzkp2.zze);
        }
    }

    private final boolean zza(zzbw.zzc.zza zza2, zzbw.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzd()));
        this.zzh();
        zzbw.zze zze2 = zzkk.zza((zzbw.zzc)((zzfi)zza2.zzu()), "_sc");
        String string = zze2 == null ? null : zze2.zzd();
        this.zzh();
        zzbw.zze zze3 = zzkk.zza((zzbw.zzc)((zzfi)zza3.zzu()), "_pc");
        String string2 = zze3 == null ? null : zze3.zzd();
        if (string2 != null && string2.equals(string)) {
            this.zzb(zza2, zza3);
            return true;
        }
        return false;
    }

    private final void zzb(zzbw.zzc.zza zza2, zzbw.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzd()));
        this.zzh();
        zzbw.zze zze2 = zzkk.zza((zzbw.zzc)((zzfi)zza2.zzu()), "_et");
        if (!zze2.zze() || zze2.zzf() <= 0L) {
            return;
        }
        long l = zze2.zzf();
        this.zzh();
        zze2 = zzkk.zza((zzbw.zzc)((zzfi)zza3.zzu()), "_et");
        if (zze2 != null && zze2.zzf() > 0L) {
            l += zze2.zzf();
        }
        this.zzh().zza(zza3, "_et", l);
        this.zzh().zza(zza2, "_fr", 1L);
    }

    @VisibleForTesting
    private static void zza(zzbw.zzc.zza zza2, @NonNull String string) {
        List<zzbw.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzb())) continue;
            int n = i;
            zza2.zzb(n);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzbw.zzc.zza zza2, int n, String string) {
        List<zzbw.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzb())) continue;
            return;
        }
        zzbw.zze zze2 = (zzbw.zze)((zzfi)zzbw.zze.zzk().zza("_err").zza(n).zzu());
        zzbw.zze zze3 = (zzbw.zze)((zzfi)zzbw.zze.zzk().zza("_ev").zzb(string).zzu());
        zza2.zza(zze2).zza(zze3);
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzw();
        this.zzk();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzv;
            this.zzv = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
                    this.zzj.zzc().zzd.zza(0L);
                    this.zzz();
                    this.zzj.zzr().zzx().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zze().zzf();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzab zzab2 = this.zze();
                                zzab2.zzd();
                                zzab2.zzak();
                                SQLiteDatabase sQLiteDatabase = zzab2.c_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzab2.zzr().zzf().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzw != null && this.zzw.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zze().b_();
                    }
                    finally {
                        this.zze().zzh();
                    }
                    this.zzw = null;
                    if (this.zzd().zzf() && this.zzy()) {
                        this.zzl();
                    } else {
                        this.zzx = -1L;
                        this.zzz();
                    }
                    this.zzm = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj.zzr().zzf().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzm = this.zzj.zzm().elapsedRealtime();
                    this.zzj.zzr().zzx().zza("Disable upload, time", (Object)this.zzm);
                }
            } else {
                this.zzj.zzr().zzx().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzc().zzd.zza(this.zzj.zzm().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzc().zze.zza(this.zzj.zzm().currentTimeMillis());
                }
                this.zze().zza(list);
                this.zzz();
            }
            return;
        }
        finally {
            this.zzr = false;
            this.zzaa();
        }
    }

    private final boolean zzy() {
        this.zzw();
        this.zzk();
        return this.zze().zzy() || !TextUtils.isEmpty((CharSequence)this.zze().d_());
    }

    @WorkerThread
    private final void zza(zzg zzg2) {
        this.zzw();
        if (zzle.zzb() && this.zzj.zzb().zze(zzg2.zzc(), zzas.zzbo)) {
            if (TextUtils.isEmpty((CharSequence)zzg2.zze()) && TextUtils.isEmpty((CharSequence)zzg2.zzg()) && TextUtils.isEmpty((CharSequence)zzg2.zzf())) {
                this.zza(zzg2.zzc(), 204, null, null, null);
                return;
            }
        } else if (TextUtils.isEmpty((CharSequence)zzg2.zze()) && TextUtils.isEmpty((CharSequence)zzg2.zzf())) {
            this.zza(zzg2.zzc(), 204, null, null, null);
            return;
        }
        String string = this.zzj.zzb().zza(zzg2);
        try {
            URL uRL = new URL(string);
            this.zzj.zzr().zzx().zza("Fetching remote configuration", (Object)zzg2.zzc());
            zzbt.zzb zzb2 = this.zzc().zza(zzg2.zzc());
            ArrayMap arrayMap = null;
            String string2 = this.zzc().zzb(zzg2.zzc());
            if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string2)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string2);
            }
            this.zzq = true;
            zzkh zzkh2 = new zzkh(this);
            ArrayMap arrayMap2 = arrayMap;
            URL uRL2 = uRL;
            String string3 = zzg2.zzc();
            zzfa zzfa2 = this.zzd();
            zzfa2.zzd();
            zzfa2.zzak();
            Preconditions.checkNotNull((Object)uRL2);
            Preconditions.checkNotNull((Object)zzkh2);
            zzfa2.zzq().zzb((Runnable)new zzfe(zzfa2, string3, uRL2, null, (Map)arrayMap2, zzkh2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj.zzr().zzf().zza("Failed to parse config URL. Not fetching. appId", zzet.zza((String)zzg2.zzc()), (Object)string);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj.zzr().zzx().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zze().zzf();
            try {
                boolean bl;
                zzg zzg2 = this.zze().zzb(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzj.zzr().zzi().zza("App does not exist in onConfigFetched. appId", zzet.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzc().zza(string) == null && !this.zzc().zza(string, null, null) : !this.zzc().zza(string, byArray, string2)) {
                        return;
                    }
                    zzg2.zzh(this.zzj.zzm().currentTimeMillis());
                    this.zze().zza(zzg2);
                    if (n == 404) {
                        this.zzj.zzr().zzk().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj.zzr().zzx().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzd().zzf() && this.zzy()) {
                        this.zzl();
                    } else {
                        this.zzz();
                    }
                } else {
                    zzg2.zzi(this.zzj.zzm().currentTimeMillis());
                    this.zze().zza(zzg2);
                    this.zzj.zzr().zzx().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzc().zzc(string);
                    this.zzj.zzc().zzd.zza(this.zzj.zzm().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzc().zze.zza(this.zzj.zzm().currentTimeMillis());
                    }
                    this.zzz();
                }
                this.zze().b_();
            }
            finally {
                this.zze().zzh();
            }
            return;
        }
        finally {
            this.zzq = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final void zzz() {
        long l;
        long l2;
        long l3;
        block14: {
            String string;
            this.zzw();
            this.zzk();
            if (this.zzm > 0L) {
                l3 = this.zzj.zzm().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzm);
                if (l2 > 0L) {
                    this.zzj.zzr().zzx().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzt().zzb();
                    this.zzv().zzf();
                    return;
                }
                this.zzm = 0L;
            }
            if (!this.zzj.zzag() || !this.zzy()) {
                this.zzj.zzr().zzx().zza("Nothing to upload or uploading impossible");
                this.zzt().zzb();
                this.zzv().zzf();
                return;
            }
            zzkg zzkg2 = this;
            long l4 = zzkg2.zzj.zzm().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzas.zzz.zza(null));
            boolean bl = zzkg2.zze().zzz() || zzkg2.zze().zzk();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzkg2.zzj.zzb().zzw())) && !".none.".equals(string) ? Math.max(0L, (Long)zzas.zzu.zza(null)) : Math.max(0L, (Long)zzas.zzt.zza(null))) : Math.max(0L, (Long)zzas.zzs.zza(null));
            long l7 = zzkg2.zzj.zzc().zzc.zza();
            long l8 = zzkg2.zzj.zzc().zzd.zza();
            long l9 = zzkg2.zze().zzw();
            long l10 = zzkg2.zze().zzx();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzkg2.zzh().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzas.zzab.zza(null))); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzas.zzaa.zza(null)) * l15) <= l8) continue;
                        l = l14;
                        break block14;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj.zzr().zzx().zza("Next upload time is 0");
            this.zzt().zzb();
            this.zzv().zzf();
            return;
        }
        if (!this.zzd().zzf()) {
            this.zzj.zzr().zzx().zza("No network");
            this.zzt().zza();
            this.zzv().zzf();
            return;
        }
        l2 = this.zzj.zzc().zze.zza();
        long l16 = Math.max(0L, (Long)zzas.zzq.zza(null));
        if (!this.zzh().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzt().zzb();
        long l17 = l3 - this.zzj.zzm().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzas.zzv.zza(null));
            this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
        }
        this.zzj.zzr().zzx().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzv().zza(l17);
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzw();
        if (this.zzn == null) {
            this.zzn = new ArrayList<Runnable>();
        }
        this.zzn.add(runnable);
    }

    @WorkerThread
    private final void zzaa() {
        this.zzw();
        if (this.zzq || this.zzr || this.zzs) {
            this.zzj.zzr().zzx().zza("Not stopping services. fetch, network, upload", (Object)this.zzq, (Object)this.zzr, (Object)this.zzs);
            return;
        }
        this.zzj.zzr().zzx().zza("Stopping uploading service(s)");
        if (this.zzn == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzn.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzn.clear();
    }

    @WorkerThread
    private final Boolean zzb(zzg zzg2) {
        try {
            if (zzg2.zzm() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzj.zzn()).getPackageInfo((String)zzg2.zzc(), (int)0).versionCode;
                if (zzg2.zzm() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzj.zzn()).getPackageInfo((String)zzg2.zzc(), (int)0).versionName;
                if (zzg2.zzl() != null && zzg2.zzl().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @WorkerThread
    final void zzo() {
        int n;
        this.zzw();
        this.zzk();
        if (this.zzl) return;
        this.zzl = true;
        if (!this.zzab()) return;
        int n2 = this.zza(this.zzu);
        int n3 = n = this.zzj.zzy().zzaf();
        int n4 = n2;
        zzkg zzkg2 = this;
        zzkg2.zzw();
        if (n4 > n3) {
            zzkg2.zzj.zzr().zzf().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zzkg2.zza(n3, zzkg2.zzu)) {
            zzkg2.zzj.zzr().zzf().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zzkg2.zzj.zzr().zzx().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzab() {
        this.zzw();
        if (this.zzj.zzb().zza(zzas.zzbm) && this.zzt != null && this.zzt.isValid()) {
            this.zzj.zzr().zzx().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzj.zzn().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzu = new RandomAccessFile(file2, "rw").getChannel();
            this.zzt = this.zzu.tryLock();
            if (this.zzt != null) {
                this.zzj.zzr().zzx().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj.zzr().zzf().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj.zzr().zzf().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj.zzr().zzi().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzw();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzr().zzf().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj.zzr().zzi().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzw();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzr().zzf().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            if (this.zzj.zzb().zza(zzas.zzbz) && Build.VERSION.SDK_INT <= 19) {
                fileChannel.position(0L);
            }
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj.zzr().zzf().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(zzm zzm2) {
        if (this.zzv != null) {
            this.zzw = new ArrayList<Long>();
            this.zzw.addAll(this.zzv);
        }
        String string = zzm2.zza;
        zzab zzab2 = this.zze();
        Preconditions.checkNotEmpty((String)string);
        zzab2.zzd();
        zzab2.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = zzab2.c_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzab2.zzr().zzx().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzab2.zzr().zzf().zza("Error resetting analytics data. appId, error", zzet.zza((String)string), (Object)sQLiteException);
        }
        if (zzm2.zzh) {
            this.zzb(zzm2);
        }
    }

    @WorkerThread
    final void zza(zzkn zzkn2, zzm zzm2) {
        this.zzw();
        this.zzk();
        if (!this.zze(zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        int n = this.zzj.zzi().zzc(zzkn2.zza);
        if (n != 0) {
            this.zzj.zzi();
            String string = zzko.zza((String)zzkn2.zza, (int)24, (boolean)true);
            int n2 = zzkn2.zza != null ? zzkn2.zza.length() : 0;
            this.zzj.zzi().zza(zzm2.zza, n, "_ev", string, n2);
            return;
        }
        n = this.zzj.zzi().zzb(zzkn2.zza, zzkn2.zza());
        if (n != 0) {
            this.zzj.zzi();
            String string = zzko.zza((String)zzkn2.zza, (int)24, (boolean)true);
            Object object = zzkn2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzj.zzi().zza(zzm2.zza, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzj.zzi().zzc(zzkn2.zza, zzkn2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzkn2.zza)) {
            zzam zzam2;
            zzm zzm3 = zzm2;
            String string = zzkn2.zze;
            long l = zzkn2.zzb;
            zzkg zzkg2 = this;
            long l2 = 0L;
            zzkp zzkp2 = zzkg2.zze().zzc(zzm3.zza, "_sno");
            if (zzkp2 != null && zzkp2.zze instanceof Long) {
                l2 = (Long)zzkp2.zze;
            } else {
                if (zzkp2 != null) {
                    zzkg2.zzj.zzr().zzi().zza("Retrieved last session number from database does not contain a valid (long) value", zzkp2.zze);
                }
                if ((zzam2 = zzkg2.zze().zza(zzm3.zza, "_s")) != null) {
                    l2 = zzam2.zzc;
                    zzkg2.zzj.zzr().zzx().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzam2 = new zzkn("_sno", l, (Object)(++l2), string);
            zzkg2.zza((zzkn)zzam2, zzm3);
        }
        zzkp zzkp3 = new zzkp(zzm2.zza, zzkn2.zze, zzkn2.zza, zzkn2.zzb, object);
        this.zzj.zzr().zzx().zza("Setting user property", (Object)this.zzj.zzj().zzc(zzkp3.zzc), object);
        this.zze().zzf();
        try {
            this.zzc(zzm2);
            boolean bl = this.zze().zza(zzkp3);
            this.zze().b_();
            if (!bl) {
                this.zzj.zzr().zzf().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzj.zzj().zzc(zzkp3.zzc), zzkp3.zze);
                this.zzj.zzi().zza(zzm2.zza, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    final void zzb(zzkn zzkn2, zzm zzm2) {
        this.zzw();
        this.zzk();
        if (!this.zze(zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        if ("_npa".equals(zzkn2.zza) && zzm2.zzs != null) {
            this.zzj.zzr().zzw().zza("Falling back to manifest metadata value for ad personalization");
            zzkn zzkn3 = new zzkn("_npa", this.zzj.zzm().currentTimeMillis(), (Object)(zzm2.zzs != false ? 1L : 0L), "auto");
            this.zza(zzkn3, zzm2);
            return;
        }
        this.zzj.zzr().zzw().zza("Removing user property", (Object)this.zzj.zzj().zzc(zzkn2.zza));
        this.zze().zzf();
        try {
            this.zzc(zzm2);
            this.zze().zzb(zzm2.zza, zzkn2.zza);
            this.zze().b_();
            this.zzj.zzr().zzw().zza("User property removed", (Object)this.zzj.zzj().zzc(zzkn2.zza));
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    final void zza(zzkd zzkd2) {
        ++this.zzo;
    }

    final void zzp() {
        ++this.zzp;
    }

    final zzfx zzs() {
        return this.zzj;
    }

    @WorkerThread
    final void zzb(zzm zzm2) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.zza);
        if (!this.zze(zzm2)) {
            return;
        }
        zzg zzg2 = this.zze().zzb(zzm2.zza);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.zze()) && !TextUtils.isEmpty((CharSequence)zzm2.zzb)) {
            zzg2.zzh(0L);
            this.zze().zza(zzg2);
            this.zzc().zzd(zzm2.zza);
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        long l = zzm2.zzm;
        if (l == 0L) {
            l = this.zzj.zzm().currentTimeMillis();
        }
        this.zzj.zzx().zzi();
        int n = zzm2.zzn;
        if (n != 0 && n != 1) {
            this.zzj.zzr().zzi().zza("Incorrect app type, assuming installed app. appId, appType", zzet.zza((String)zzm2.zza), (Object)n);
            n = 0;
        }
        this.zze().zzf();
        try {
            zzkn zzkn2;
            zzkp zzkp2 = this.zze().zzc(zzm2.zza, "_npa");
            if (zzkp2 == null || "auto".equals(zzkp2.zzb)) {
                if (zzm2.zzs != null) {
                    zzkn2 = new zzkn("_npa", l, (Object)(zzm2.zzs != false ? 1L : 0L), "auto");
                    if (zzkp2 == null || !zzkp2.zze.equals(zzkn2.zzc)) {
                        this.zza(zzkn2, zzm2);
                    }
                } else if (zzkp2 != null) {
                    zzkn2 = new zzkn("_npa", l, null, "auto");
                    this.zzb(zzkn2, zzm2);
                }
            }
            long l2 = l;
            zzm zzm3 = zzm2;
            zzkg zzkg2 = this;
            zzg zzg3 = zzkg2.zze().zzb(zzm3.zza);
            if (zzg3 != null) {
                zzkg2.zzj.zzi();
                if (zzko.zza((String)zzm3.zzb, (String)zzg3.zze(), (String)zzm3.zzr, (String)zzg3.zzf())) {
                    zzkg2.zzj.zzr().zzi().zza("New GMP App Id passed in. Removing cached database data. appId", zzet.zza((String)zzg3.zzc()));
                    String string = zzg3.zzc();
                    zzab zzab2 = zzkg2.zze();
                    zzab2.zzak();
                    zzab2.zzd();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzab2.c_();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzab2.zzr().zzx().zza("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzab2.zzr().zzf().zza("Error deleting application data. appId, error", zzet.zza((String)string), (Object)sQLiteException);
                    }
                    zzg3 = null;
                }
            }
            if (zzg3 != null && (zzg3.zzm() != Integer.MIN_VALUE && zzg3.zzm() != zzm3.zzj) | (zzg3.zzm() == Integer.MIN_VALUE && zzg3.zzl() != null && !zzg3.zzl().equals(zzm3.zzc))) {
                Bundle bundle = new Bundle();
                bundle.putString("_pv", zzg3.zzl());
                zzaq zzaq2 = new zzaq("_au", new zzal(bundle), "auto", l2);
                zzkg2.zza(zzaq2, zzm3);
            }
            this.zzc(zzm2);
            zzkn2 = null;
            if (n == 0) {
                zzkn2 = this.zze().zza(zzm2.zza, "_f");
            } else if (n == 1) {
                zzkn2 = this.zze().zza(zzm2.zza, "_v");
            }
            if (zzkn2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    PackageInfo packageInfo;
                    zzkn zzkn3 = new zzkn("_fot", l, (Object)l3, "auto");
                    this.zza(zzkn3, zzm2);
                    if (this.zzj.zzb().zze(zzm2.zzb, zzas.zzar)) {
                        zzm3 = zzm2;
                        zzkg2 = this;
                        zzkg2.zzw();
                        zzkg2.zzj.zzf().zza(zzm3.zza);
                    }
                    l2 = l;
                    zzm3 = zzm2;
                    zzkg2 = this;
                    zzkg2.zzw();
                    zzkg2.zzk();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    zzg3.putLong("_uwa", 0L);
                    zzg3.putLong("_pfo", 0L);
                    zzg3.putLong("_sys", 0L);
                    zzg3.putLong("_sysu", 0L);
                    if (zzkg2.zzj.zzb().zze(zzm3.zza, zzas.zzat)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzm3.zzq) {
                        zzg3.putLong("_dac", 1L);
                    }
                    String string = zzm3.zza;
                    zzab zzab3 = zzkg2.zze();
                    Preconditions.checkNotEmpty((String)string);
                    zzab3.zzd();
                    zzab3.zzak();
                    long l4 = zzab3.zzh(string, "first_open_count");
                    if (zzkg2.zzj.zzn().getPackageManager() == null) {
                        zzkg2.zzj.zzr().zzf().zza("PackageManager is null, first open report might be inaccurate. appId", zzet.zza((String)zzm3.zza));
                    } else {
                        packageInfo = null;
                        try {
                            packageInfo = Wrappers.packageManager((Context)zzkg2.zzj.zzn()).getPackageInfo(zzm3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzkg2.zzj.zzr().zzf().zza("Package info is null, first open report might be inaccurate. appId", zzet.zza((String)zzm3.zza), (Object)nameNotFoundException);
                        }
                        if (packageInfo != null && packageInfo.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (packageInfo.firstInstallTime != packageInfo.lastUpdateTime) {
                                if (zzkg2.zzj.zzb().zza(zzas.zzbt)) {
                                    if (l4 == 0L) {
                                        zzg3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    zzg3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl = true;
                            }
                            zzkn zzkn4 = new zzkn("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzkg2.zza(zzkn4, zzm3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzkg2.zzj.zzn()).getApplicationInfo(zzm3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzkg2.zzj.zzr().zzf().zza("Application info is null, first open report might be inaccurate. appId", zzet.zza((String)zzm3.zza), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzg3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzg3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l4 >= 0L) {
                        zzg3.putLong("_pfo", l4);
                    }
                    packageInfo = new zzaq("_f", new zzal((Bundle)zzg3), "auto", l2);
                    zzkg2.zza((zzaq)packageInfo, zzm3);
                } else if (n == 1) {
                    zzkn zzkn5 = new zzkn("_fvt", l, (Object)l3, "auto");
                    this.zza(zzkn5, zzm2);
                    l2 = l;
                    zzm3 = zzm2;
                    zzkg2 = this;
                    zzkg2.zzw();
                    zzkg2.zzk();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    if (zzkg2.zzj.zzb().zze(zzm3.zza, zzas.zzat)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzm3.zzq) {
                        zzg3.putLong("_dac", 1L);
                    }
                    zzaq zzaq3 = new zzaq("_v", new zzal((Bundle)zzg3), "auto", l2);
                    zzkg2.zza(zzaq3, zzm3);
                }
                if (!this.zzj.zzb().zze(zzm2.zza, zzas.zzau)) {
                    l2 = l;
                    zzm3 = zzm2;
                    zzkg2 = this;
                    zzg3 = new Bundle();
                    zzg3.putLong("_et", 1L);
                    if (zzkg2.zzj.zzb().zze(zzm3.zza, zzas.zzat)) {
                        zzg3.putLong("_fr", 1L);
                    }
                    zzaq zzaq4 = new zzaq("_e", new zzal((Bundle)zzg3), "auto", l2);
                    zzkg2.zza(zzaq4, zzm3);
                }
            } else if (zzm2.zzi) {
                l2 = l;
                zzm3 = zzm2;
                zzkg2 = this;
                zzg3 = new Bundle();
                zzaq zzaq5 = new zzaq("_cd", new zzal((Bundle)zzg3), "auto", l2);
                zzkg2.zza(zzaq5, zzm3);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    private final zzm zza(String string) {
        zzg zzg2 = this.zze().zzb(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzl())) {
            this.zzj.zzr().zzw().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzb(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj.zzr().zzf().zza("App version does not match; dropping. appId", zzet.zza((String)string));
            return null;
        }
        return new zzm(string, zzg2.zze(), zzg2.zzl(), zzg2.zzm(), zzg2.zzn(), zzg2.zzo(), zzg2.zzp(), null, zzg2.zzr(), false, zzg2.zzi(), zzg2.zzae(), 0L, 0, zzg2.zzaf(), zzg2.zzag(), false, zzg2.zzf(), zzg2.zzah(), zzg2.zzq(), zzg2.zzai(), zzle.zzb() && this.zzj.zzb().zze(string, zzas.zzbo) ? zzg2.zzg() : null);
    }

    @WorkerThread
    final void zza(zzy zzy2) {
        zzm zzm2 = this.zza(zzy2.zza);
        if (zzm2 != null) {
            this.zza(zzy2, zzm2);
        }
    }

    @WorkerThread
    final void zza(zzy zzy2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzy2);
        Preconditions.checkNotEmpty((String)zzy2.zza);
        Preconditions.checkNotNull((Object)zzy2.zzb);
        Preconditions.checkNotNull((Object)zzy2.zzc);
        Preconditions.checkNotEmpty((String)zzy2.zzc.zza);
        this.zzw();
        this.zzk();
        if (!this.zze(zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        zzy zzy3 = new zzy(zzy2);
        new zzy(zzy2).zze = false;
        this.zze().zzf();
        try {
            boolean bl = false;
            zzy zzy4 = this.zze().zzd(zzy3.zza, zzy3.zzc.zza);
            if (zzy4 != null && !zzy4.zzb.equals(zzy3.zzb)) {
                this.zzj.zzr().zzi().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzj.zzj().zzc(zzy3.zzc.zza), (Object)zzy3.zzb, (Object)zzy4.zzb);
            }
            if (zzy4 != null && zzy4.zze) {
                zzy3.zzb = zzy4.zzb;
                zzy3.zzd = zzy4.zzd;
                zzy3.zzh = zzy4.zzh;
                zzy3.zzf = zzy4.zzf;
                zzy3.zzi = zzy4.zzi;
                zzy3.zze = zzy4.zze;
                zzy3.zzc = new zzkn(zzy3.zzc.zza, zzy4.zzc.zzb, zzy3.zzc.zza(), zzy4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzy3.zzf)) {
                zzy3.zzc = new zzkn(zzy3.zzc.zza, zzy3.zzd, zzy3.zzc.zza(), zzy3.zzc.zze);
                zzy3.zze = true;
                bl = true;
            }
            if (zzy3.zze) {
                zzkn zzkn2 = zzy3.zzc;
                zzkp zzkp2 = new zzkp(zzy3.zza, zzy3.zzb, zzkn2.zza, zzkn2.zzb, zzkn2.zza());
                if (this.zze().zza(zzkp2)) {
                    this.zzj.zzr().zzw().zza("User property updated immediately", (Object)zzy3.zza, (Object)this.zzj.zzj().zzc(zzkp2.zzc), zzkp2.zze);
                } else {
                    this.zzj.zzr().zzf().zza("(2)Too many active user properties, ignoring", zzet.zza((String)zzy3.zza), (Object)this.zzj.zzj().zzc(zzkp2.zzc), zzkp2.zze);
                }
                if (bl && zzy3.zzi != null) {
                    zzaq zzaq2 = new zzaq(zzy3.zzi, zzy3.zzd);
                    this.zzb(zzaq2, zzm2);
                }
            }
            if (this.zze().zza(zzy3)) {
                this.zzj.zzr().zzw().zza("Conditional property added", (Object)zzy3.zza, (Object)this.zzj.zzj().zzc(zzy3.zzc.zza), zzy3.zzc.zza());
            } else {
                this.zzj.zzr().zzf().zza("Too many conditional properties, ignoring", zzet.zza((String)zzy3.zza), (Object)this.zzj.zzj().zzc(zzy3.zzc.zza), zzy3.zzc.zza());
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    final void zzb(zzy zzy2) {
        zzm zzm2 = this.zza(zzy2.zza);
        if (zzm2 != null) {
            this.zzb(zzy2, zzm2);
        }
    }

    @WorkerThread
    final void zzb(zzy zzy2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzy2);
        Preconditions.checkNotEmpty((String)zzy2.zza);
        Preconditions.checkNotNull((Object)zzy2.zzc);
        Preconditions.checkNotEmpty((String)zzy2.zzc.zza);
        this.zzw();
        this.zzk();
        if (!this.zze(zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        this.zze().zzf();
        try {
            this.zzc(zzm2);
            zzy zzy3 = this.zze().zzd(zzy2.zza, zzy2.zzc.zza);
            if (zzy3 != null) {
                this.zzj.zzr().zzw().zza("Removing conditional user property", (Object)zzy2.zza, (Object)this.zzj.zzj().zzc(zzy2.zzc.zza));
                this.zze().zze(zzy2.zza, zzy2.zzc.zza);
                if (zzy3.zze) {
                    this.zze().zzb(zzy2.zza, zzy2.zzc.zza);
                }
                if (zzy2.zzk != null) {
                    Bundle bundle = null;
                    if (zzy2.zzk.zzb != null) {
                        bundle = zzy2.zzk.zzb.zzb();
                    }
                    zzaq zzaq2 = this.zzj.zzi().zza(zzy2.zza, zzy2.zzk.zza, bundle, zzy3.zzb, zzy2.zzk.zzd, true, false);
                    this.zzb(zzaq2, zzm2);
                }
            } else {
                this.zzj.zzr().zzi().zza("Conditional user property doesn't exist", zzet.zza((String)zzy2.zza), (Object)this.zzj.zzj().zzc(zzy2.zzc.zza));
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    private final zzg zza(zzm zzm2, zzg zzg2, String string) {
        boolean bl = false;
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzj, zzm2.zza);
            zzg2.zza(this.zzj.zzi().zzk());
            zzg2.zze(string);
            bl = true;
        } else if (!string.equals(zzg2.zzh())) {
            zzg2.zze(string);
            zzg2.zza(this.zzj.zzi().zzk());
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzm2.zzb, (CharSequence)zzg2.zze())) {
            zzg2.zzb(zzm2.zzb);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzm2.zzr, (CharSequence)zzg2.zzf())) {
            zzg2.zzc(zzm2.zzr);
            bl = true;
        }
        if (zzle.zzb() && this.zzj.zzb().zze(zzg2.zzc(), zzas.zzbo) && !TextUtils.equals((CharSequence)zzm2.zzv, (CharSequence)zzg2.zzg())) {
            zzg2.zzd(zzm2.zzv);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzk) && !zzm2.zzk.equals(zzg2.zzi())) {
            zzg2.zzf(zzm2.zzk);
            bl = true;
        }
        if (zzm2.zze != 0L && zzm2.zze != zzg2.zzo()) {
            zzg2.zzd(zzm2.zze);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzc) && !zzm2.zzc.equals(zzg2.zzl())) {
            zzg2.zzg(zzm2.zzc);
            bl = true;
        }
        if (zzm2.zzj != zzg2.zzm()) {
            zzg2.zzc(zzm2.zzj);
            bl = true;
        }
        if (zzm2.zzd != null && !zzm2.zzd.equals(zzg2.zzn())) {
            zzg2.zzh(zzm2.zzd);
            bl = true;
        }
        if (zzm2.zzf != zzg2.zzp()) {
            zzg2.zze(zzm2.zzf);
            bl = true;
        }
        if (zzm2.zzh != zzg2.zzr()) {
            zzg2.zza(zzm2.zzh);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzg) && !zzm2.zzg.equals(zzg2.zzac())) {
            zzg2.zzi(zzm2.zzg);
            bl = true;
        }
        if (!this.zzj.zzb().zza(zzas.zzcm) && zzm2.zzl != zzg2.zzae()) {
            zzg2.zzp(zzm2.zzl);
            bl = true;
        }
        if (zzm2.zzo != zzg2.zzaf()) {
            zzg2.zzb(zzm2.zzo);
            bl = true;
        }
        if (zzm2.zzp != zzg2.zzag()) {
            zzg2.zzc(zzm2.zzp);
            bl = true;
        }
        if (zzm2.zzs != zzg2.zzah()) {
            zzg2.zza(zzm2.zzs);
            bl = true;
        }
        if (zzm2.zzt != 0L && zzm2.zzt != zzg2.zzq()) {
            zzg2.zzf(zzm2.zzt);
            bl = true;
        }
        if (bl) {
            this.zze().zza(zzg2);
        }
        return zzg2;
    }

    @WorkerThread
    final zzg zzc(zzm zzm2) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.zza);
        zzg zzg2 = this.zze().zzb(zzm2.zza);
        String string = this.zzj.zzc().zzb(zzm2.zza);
        if (zzkr.zzb() && this.zzj.zzb().zza(zzas.zzbu)) {
            if (zzg2 == null) {
                zzg2 = new zzg(this.zzj, zzm2.zza);
                zzg2.zza(this.zzj.zzi().zzk());
                zzg2.zze(string);
            } else if (!string.equals(zzg2.zzh())) {
                zzg2.zze(string);
                zzg2.zza(this.zzj.zzi().zzk());
            }
            zzg2.zzb(zzm2.zzb);
            zzg2.zzc(zzm2.zzr);
            if (zzle.zzb() && this.zzj.zzb().zze(zzg2.zzc(), zzas.zzbo)) {
                zzg2.zzd(zzm2.zzv);
            }
            if (!TextUtils.isEmpty((CharSequence)zzm2.zzk)) {
                zzg2.zzf(zzm2.zzk);
            }
            if (zzm2.zze != 0L) {
                zzg2.zzd(zzm2.zze);
            }
            if (!TextUtils.isEmpty((CharSequence)zzm2.zzc)) {
                zzg2.zzg(zzm2.zzc);
            }
            zzg2.zzc(zzm2.zzj);
            if (zzm2.zzd != null) {
                zzg2.zzh(zzm2.zzd);
            }
            zzg2.zze(zzm2.zzf);
            zzg2.zza(zzm2.zzh);
            if (!TextUtils.isEmpty((CharSequence)zzm2.zzg)) {
                zzg2.zzi(zzm2.zzg);
            }
            if (!this.zzj.zzb().zza(zzas.zzcm)) {
                zzg2.zzp(zzm2.zzl);
            }
            zzg2.zzb(zzm2.zzo);
            zzg2.zzc(zzm2.zzp);
            zzg2.zza(zzm2.zzs);
            zzg2.zzf(zzm2.zzt);
            if (zzg2.zza()) {
                this.zze().zza(zzg2);
            }
            return zzg2;
        }
        return this.zza(zzm2, zzg2, string);
    }

    final String zzd(zzm zzm2) {
        Future future = this.zzj.zzq().zza((Callable)new zzkj(this, zzm2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj.zzr().zzf().zza("Failed to get app instance id. appId", zzet.zza((String)zzm2.zza), (Object)exception);
            return null;
        }
    }

    final void zza(boolean bl) {
        this.zzz();
    }

    private final boolean zze(zzm zzm2) {
        if (zzle.zzb() && this.zzj.zzb().zze(zzm2.zza, zzas.zzbo)) {
            return !TextUtils.isEmpty((CharSequence)zzm2.zzb) || !TextUtils.isEmpty((CharSequence)zzm2.zzv) || !TextUtils.isEmpty((CharSequence)zzm2.zzr);
        }
        return !TextUtils.isEmpty((CharSequence)zzm2.zzb) || !TextUtils.isEmpty((CharSequence)zzm2.zzr);
    }

    static /* synthetic */ void zza(zzkg zzkg2, zzkl zzkl2) {
        zzkg2.zza(zzkl2);
    }

    final class zza
    implements zzad {
        zzbw.zzg zza;
        List<Long> zzb;
        List<zzbw.zzc> zzc;
        private long zzd;

        private zza() {
        }

        @Override
        public final void zza(zzbw.zzg zzg2) {
            Preconditions.checkNotNull((Object)((Object)zzg2));
            this.zza = zzg2;
        }

        @Override
        public final boolean zza(long l, zzbw.zzc zzc2) {
            Preconditions.checkNotNull((Object)((Object)zzc2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzbw.zzc>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (this.zzc.size() > 0 && com.google.android.gms.measurement.internal.zzkg$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzkg$zza.zza(zzc2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzc2.zzbn();
            if (l2 >= (long)Math.max(0, (Integer)zzas.zzh.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzc2);
            this.zzb.add(l);
            return this.zzc.size() < Math.max(1, (Integer)zzas.zzi.zza(null));
        }

        private static long zza(zzbw.zzc zzc2) {
            return zzc2.zze() / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzkf zzkf2) {
            this();
        }
    }
}

