/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzlr;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgd
extends zzep {
    private final zzkj zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzgd(zzkj zzkj2) {
        this(zzkj2, null);
    }

    private zzgd(zzkj zzkj2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzkj2);
        this.zza = zzkj2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzgf(this, zzn2));
    }

    @BinderThread
    public final void zza(zzao zzao2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzao2);
        this.zzb(zzn2, false);
        this.zza(new zzgk(this, zzao2, zzn2));
    }

    @VisibleForTesting
    final zzao zzb(zzao zzao2, zzn zzn2) {
        String string;
        zzn zzn3 = zzn2;
        zzao zzao3 = zzao2;
        zzgd zzgd2 = this;
        if (!"_cmp".equals(zzao3.zza) || zzao3.zzb == null || zzao3.zzb.zza() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzao3.zzb.zzd("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzgd2.zza.zzb().zze(zzn3.zza, zzaq.zzar)) {
            this.zza.zzr().zzv().zza("Event has been filtered ", (Object)zzao2.toString());
            return new zzao("_cmpx", zzao2.zzb, zzao2.zzc, zzao2.zzd);
        }
        return zzao2;
    }

    @BinderThread
    public final void zza(zzao zzao2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzao2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzgn(this, zzao2, string));
    }

    @BinderThread
    public final byte[] zza(zzao zzao2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzao2);
        this.zza(string, true);
        this.zza.zzr().zzw().zza("Log and bundle. event", (Object)this.zza.zzi().zza(zzao2.zza));
        long l = this.zza.zzm().nanoTime() / 1000000L;
        Future future = this.zza.zzq().zzb((Callable)new zzgm(this, zzao2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzr().zzf().zza("Log and bundle returned null. appId", zzeu.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzm().nanoTime() / 1000000L;
            this.zza.zzr().zzw().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzi().zza(zzao2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to log and bundle. appId, event, error", zzeu.zza((String)string), (Object)this.zza.zzi().zza(zzao2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzkq zzkq2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzkq2);
        this.zzb(zzn2, false);
        this.zza(new zzgp(this, zzkq2, zzn2));
    }

    @BinderThread
    public final List<zzkq> zza(zzn zzn2, boolean bl) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgo(this, zzn2));
        try {
            List list = (List)future.get();
            ArrayList<zzkq> arrayList = new ArrayList<zzkq>(list.size());
            for (zzks zzks2 : list) {
                if (!bl && zzkr.zze((String)zzks2.zzc)) continue;
                arrayList.add(new zzkq(zzks2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user properties. appId", zzeu.zza((String)zzn2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzgr(this, zzn2));
    }

    @BinderThread
    private final void zzb(zzn zzn2, boolean bl) {
        Preconditions.checkNotNull((Object)zzn2);
        this.zza(zzn2.zza, false);
        this.zza.zzj().zza(zzn2.zzb, zzn2.zzr, zzn2.zzv);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzr().zzf().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgd zzgd2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgd2 = this;
                    if (!bl2) break block9;
                    if (zzgd2.zzb == null) {
                        zzgd2.zzb = "com.google.android.gms".equals(zzgd2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzgd2.zza.zzn(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgd2.zza.zzn()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgd2.zzb.booleanValue()) break block10;
                }
                if (zzgd2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgd2.zza.zzn(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgd2.zzc = string2;
                }
                if (!string2.equals(zzgd2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzr().zzf().zza("Measurement Service called with invalid calling package. appId", zzeu.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgq(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzn zzn2) {
        if (zzlr.zzb() && this.zza.zzb().zza(zzaq.zzcn)) {
            this.zzb(zzn2, false);
            this.zza(new zzgc(this, zzn2, bundle));
        }
    }

    @BinderThread
    public final String zzc(zzn zzn2) {
        this.zzb(zzn2, false);
        return this.zza.zzd(zzn2);
    }

    @BinderThread
    public final void zza(zzw zzw2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzw2);
        Preconditions.checkNotNull((Object)zzw2.zzc);
        this.zzb(zzn2, false);
        zzw zzw3 = new zzw(zzw2);
        new zzw(zzw2).zza = zzn2.zza;
        this.zza(new zzgt(this, zzw3, zzn2));
    }

    @BinderThread
    public final void zza(zzw zzw2) {
        Preconditions.checkNotNull((Object)zzw2);
        Preconditions.checkNotNull((Object)zzw2.zzc);
        this.zza(zzw2.zza, true);
        zzw zzw3 = new zzw(zzw2);
        this.zza(new zzge(this, zzw3));
    }

    @BinderThread
    public final List<zzkq> zza(String string, String string2, boolean bl, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgh(this, zzn2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzkq> arrayList = new ArrayList<zzkq>(list.size());
            for (zzks zzks2 : list) {
                if (!bl && zzkr.zze((String)zzks2.zzc)) continue;
                arrayList.add(new zzkq(zzks2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to query user properties. appId", zzeu.zza((String)zzn2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzkq> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgg(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzkq> arrayList = new ArrayList<zzkq>(list.size());
            for (zzks zzks2 : list) {
                if (!bl && zzkr.zze((String)zzks2.zzc)) continue;
                arrayList.add(new zzkq(zzks2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user properties as. appId", zzeu.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzw> zza(String string, String string2, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgj(this, zzn2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzw> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgi(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzn zzn2) {
        this.zza(zzn2.zza, false);
        this.zza(new zzgl(this, zzn2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzq().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzq().zza(runnable);
    }

    final /* synthetic */ void zza(zzn zzn2, Bundle bundle) {
        this.zza.zze().zza(zzn2.zza, bundle);
    }

    static /* synthetic */ zzkj zza(zzgd zzgd2) {
        return zzgd2.zza;
    }
}

