/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzof;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzge
extends zzeq {
    private final zzkk zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzge(zzkk zzkk2) {
        this(zzkk2, null);
    }

    private zzge(zzkk zzkk2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzkk2);
        this.zza = zzkk2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzgg(this, zzn2));
    }

    @BinderThread
    public final void zza(zzao zzao2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzao2);
        this.zzb(zzn2, false);
        this.zza(new zzgp(this, zzao2, zzn2));
    }

    @VisibleForTesting
    final zzao zzb(zzao zzao2, zzn zzn2) {
        String string;
        zzn zzn3 = zzn2;
        zzao zzao3 = zzao2;
        zzge zzge2 = this;
        if (!"_cmp".equals(zzao3.zza) || zzao3.zzb == null || zzao3.zzb.zza() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzao3.zzb.zzd("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzge2.zza.zzb().zze(zzn3.zza, zzaq.zzar)) {
            this.zza.zzr().zzv().zza("Event has been filtered ", (Object)zzao2.toString());
            return new zzao("_cmpx", zzao2.zzb, zzao2.zzc, zzao2.zzd);
        }
        return zzao2;
    }

    @BinderThread
    public final void zza(zzao zzao2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzao2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzgo(this, zzao2, string));
    }

    @BinderThread
    public final byte[] zza(zzao zzao2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzao2);
        this.zza(string, true);
        this.zza.zzr().zzw().zza("Log and bundle. event", (Object)this.zza.zzi().zza(zzao2.zza));
        long l = this.zza.zzm().nanoTime() / 1000000L;
        Future future = this.zza.zzq().zzb((Callable)new zzgr(this, zzao2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzr().zzf().zza("Log and bundle returned null. appId", zzez.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzm().nanoTime() / 1000000L;
            this.zza.zzr().zzw().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzi().zza(zzao2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to log and bundle. appId, event, error", zzez.zza((String)string), (Object)this.zza.zzi().zza(zzao2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzkr zzkr2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzkr2);
        this.zzb(zzn2, false);
        this.zza(new zzgq(this, zzkr2, zzn2));
    }

    @BinderThread
    public final List<zzkr> zza(zzn zzn2, boolean bl) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgt(this, zzn2));
        try {
            List list = (List)future.get();
            ArrayList<zzkr> arrayList = new ArrayList<zzkr>(list.size());
            for (zzkt zzkt2 : list) {
                if (!bl && zzkw.zze((String)zzkt2.zzc)) continue;
                arrayList.add(new zzkr(zzkt2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user properties. appId", zzez.zza((String)zzn2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzgs(this, zzn2));
    }

    @BinderThread
    private final void zzb(zzn zzn2, boolean bl) {
        Preconditions.checkNotNull((Object)zzn2);
        this.zza(zzn2.zza, false);
        this.zza.zzj().zza(zzn2.zzb, zzn2.zzr, zzn2.zzv);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzr().zzf().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzge zzge2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzge2 = this;
                    if (!bl2) break block9;
                    if (zzge2.zzb == null) {
                        zzge2.zzb = "com.google.android.gms".equals(zzge2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzge2.zza.zzn(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzge2.zza.zzn()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzge2.zzb.booleanValue()) break block10;
                }
                if (zzge2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzge2.zza.zzn(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzge2.zzc = string2;
                }
                if (!string2.equals(zzge2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzr().zzf().zza("Measurement Service called with invalid calling package. appId", zzez.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgv(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzn zzn2) {
        if (zzof.zzb() && this.zza.zzb().zza(zzaq.zzcn)) {
            this.zzb(zzn2, false);
            this.zza(new zzgh(this, zzn2, bundle));
        }
    }

    @BinderThread
    public final String zzc(zzn zzn2) {
        this.zzb(zzn2, false);
        return this.zza.zzd(zzn2);
    }

    @BinderThread
    public final void zza(zzw zzw2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzw2);
        Preconditions.checkNotNull((Object)zzw2.zzc);
        this.zzb(zzn2, false);
        zzw zzw3 = new zzw(zzw2);
        new zzw(zzw2).zza = zzn2.zza;
        this.zza(new zzgu(this, zzw3, zzn2));
    }

    @BinderThread
    public final void zza(zzw zzw2) {
        Preconditions.checkNotNull((Object)zzw2);
        Preconditions.checkNotNull((Object)zzw2.zzc);
        this.zza(zzw2.zza, true);
        zzw zzw3 = new zzw(zzw2);
        this.zza(new zzgj(this, zzw3));
    }

    @BinderThread
    public final List<zzkr> zza(String string, String string2, boolean bl, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgi(this, zzn2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzkr> arrayList = new ArrayList<zzkr>(list.size());
            for (zzkt zzkt2 : list) {
                if (!bl && zzkw.zze((String)zzkt2.zzc)) continue;
                arrayList.add(new zzkr(zzkt2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to query user properties. appId", zzez.zza((String)zzn2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzkr> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgl(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzkr> arrayList = new ArrayList<zzkr>(list.size());
            for (zzkt zzkt2 : list) {
                if (!bl && zzkw.zze((String)zzkt2.zzc)) continue;
                arrayList.add(new zzkr(zzkt2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user properties as. appId", zzez.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzw> zza(String string, String string2, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgk(this, zzn2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzw> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgn(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzn zzn2) {
        this.zza(zzn2.zza, false);
        this.zza(new zzgm(this, zzn2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzq().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzq().zza(runnable);
    }

    final /* synthetic */ void zza(zzn zzn2, Bundle bundle) {
        this.zza.zze().zza(zzn2.zza, bundle);
    }

    static /* synthetic */ zzkk zza(zzge zzge2) {
        return zzge2.zza;
    }
}

