/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzh;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzx;

public final class zzkg
extends zzkl {
    private final AlarmManager zzb = (AlarmManager)this.zzn().getSystemService("alarm");
    private final zzag zzc;
    private Integer zzd;

    protected zzkg(zzkk zzkk2) {
        super(zzkk2);
        this.zzc = new zzkj(this, (zzgz)zzkk2.zzs(), zzkk2);
    }

    @Override
    protected final boolean zze() {
        this.zzb.cancel(this.zzw());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzk();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzk() {
        JobScheduler jobScheduler = (JobScheduler)this.zzn().getSystemService("jobscheduler");
        int n = this.zzv();
        jobScheduler.cancel(n);
    }

    public final void zza(long l) {
        this.zzak();
        zzx zzx2 = this.zzu();
        Context context = this.zzn();
        if (!zzfv.zza((Context)context)) {
            this.zzr().zzw().zza("Receiver not registered/enabled");
        }
        if (!zzkw.zza((Context)context, (boolean)false)) {
            this.zzr().zzw().zza("Service not registered/enabled");
        }
        this.zzf();
        this.zzr().zzx().zza("Scheduling upload, millis", (Object)l);
        long l2 = this.zzm().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzaq.zzw.zza(null)) && !this.zzc.zzb()) {
            this.zzc.zza(l);
        }
        zzx2 = this.zzu();
        if (Build.VERSION.SDK_INT >= 24) {
            long l3 = l;
            zzkg zzkg2 = this;
            Context context2 = zzkg2.zzn();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zzkg2.zzv();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            zzh.zza(context2, jobInfo, "com.google.android.gms", "UploadAlarm");
            return;
        }
        this.zzb.setInexactRepeating(2, l2, Math.max((Long)zzaq.zzr.zza(null), l), this.zzw());
    }

    private final int zzv() {
        if (this.zzd == null) {
            String string = String.valueOf(this.zzn().getPackageName());
            this.zzd = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzd;
    }

    public final void zzf() {
        this.zzak();
        this.zzr().zzx().zza("Unscheduling upload");
        this.zzb.cancel(this.zzw());
        this.zzc.zzc();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzk();
        }
    }

    private final PendingIntent zzw() {
        Context context = this.zzn();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
    }
}

