/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzmb;
import com.google.android.gms.internal.measurement.zznr;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgc
extends zzeo {
    private final zzkp zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzgc(zzkp zzkp2) {
        this(zzkp2, null);
    }

    private zzgc(zzkp zzkp2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzkp2);
        this.zza = zzkp2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzge(this, zzn2));
    }

    @BinderThread
    public final void zze(zzn zzn2) {
        if (zzmb.zzb() && this.zza.zzb().zza(zzat.zzcp)) {
            Preconditions.checkNotEmpty((String)zzn2.zza);
            Preconditions.checkNotNull((Object)zzn2.zzw);
            zzgm zzgm2 = new zzgm(this, zzn2);
            zzgc zzgc2 = this;
            Preconditions.checkNotNull((Object)zzgm2);
            if (zzgc2.zza.zzp().zzf()) {
                zzgm2.run();
                return;
            }
            zzgc2.zza.zzp().zzb((Runnable)zzgm2);
        }
    }

    @BinderThread
    public final void zza(zzar zzar2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzar2);
        this.zzb(zzn2, false);
        this.zza(new zzgp(this, zzar2, zzn2));
    }

    @VisibleForTesting
    final zzar zzb(zzar zzar2, zzn zzn2) {
        String string;
        zzn zzn3 = zzn2;
        zzar zzar3 = zzar2;
        zzgc zzgc2 = this;
        if (!"_cmp".equals(zzar3.zza) || zzar3.zzb == null || zzar3.zzb.zza() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzar3.zzb.zzd("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzgc2.zza.zzb().zze(zzn3.zza, zzat.zzar)) {
            this.zza.zzq().zzu().zza("Event has been filtered ", (Object)zzar2.toString());
            return new zzar("_cmpx", zzar2.zzb, zzar2.zzc, zzar2.zzd);
        }
        return zzar2;
    }

    @BinderThread
    public final void zza(zzar zzar2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzar2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzgo(this, zzar2, string));
    }

    @BinderThread
    public final byte[] zza(zzar zzar2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzar2);
        this.zza(string, true);
        this.zza.zzq().zzv().zza("Log and bundle. event", (Object)this.zza.zzj().zza(zzar2.zza));
        long l = this.zza.zzl().nanoTime() / 1000000L;
        Future future = this.zza.zzp().zzb((Callable)new zzgr(this, zzar2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzq().zze().zza("Log and bundle returned null. appId", zzex.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzl().nanoTime() / 1000000L;
            this.zza.zzq().zzv().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzj().zza(zzar2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to log and bundle. appId, event, error", zzex.zza((String)string), (Object)this.zza.zzj().zza(zzar2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzkw zzkw2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzkw2);
        this.zzb(zzn2, false);
        this.zza(new zzgq(this, zzkw2, zzn2));
    }

    @BinderThread
    public final List<zzkw> zza(zzn zzn2, boolean bl) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzp().zza((Callable)new zzgt(this, zzn2));
        try {
            List list = (List)future.get();
            ArrayList<zzkw> arrayList = new ArrayList<zzkw>(list.size());
            for (zzky zzky2 : list) {
                if (!bl && zzkx.zzd((String)zzky2.zzc)) continue;
                arrayList.add(new zzkw(zzky2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get user properties. appId", zzex.zza((String)zzn2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzgs(this, zzn2));
    }

    @BinderThread
    private final void zzb(zzn zzn2, boolean bl) {
        Preconditions.checkNotNull((Object)zzn2);
        this.zza(zzn2.zza, false);
        this.zza.zzk().zza(zzn2.zzb, zzn2.zzr, zzn2.zzv);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzq().zze().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgc zzgc2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgc2 = this;
                    if (!bl2) break block9;
                    if (zzgc2.zzb == null) {
                        zzgc2.zzb = "com.google.android.gms".equals(zzgc2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzgc2.zza.zzm(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgc2.zza.zzm()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgc2.zzb.booleanValue()) break block10;
                }
                if (zzgc2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgc2.zza.zzm(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgc2.zzc = string2;
                }
                if (!string2.equals(zzgc2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzq().zze().zza("Measurement Service called with invalid calling package. appId", zzex.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgv(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzn zzn2) {
        if (zznr.zzb() && this.zza.zzb().zza(zzat.zzch)) {
            this.zzb(zzn2, false);
            this.zza(new zzgf(this, zzn2, bundle));
        }
    }

    @BinderThread
    public final String zzc(zzn zzn2) {
        this.zzb(zzn2, false);
        return this.zza.zzd(zzn2);
    }

    @BinderThread
    public final void zza(zzw zzw2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzw2);
        Preconditions.checkNotNull((Object)zzw2.zzc);
        this.zzb(zzn2, false);
        zzw zzw3 = new zzw(zzw2);
        new zzw(zzw2).zza = zzn2.zza;
        this.zza(new zzgh(this, zzw3, zzn2));
    }

    @BinderThread
    public final void zza(zzw zzw2) {
        Preconditions.checkNotNull((Object)zzw2);
        Preconditions.checkNotNull((Object)zzw2.zzc);
        this.zza(zzw2.zza, true);
        zzw zzw3 = new zzw(zzw2);
        this.zza(new zzgg(this, zzw3));
    }

    @BinderThread
    public final List<zzkw> zza(String string, String string2, boolean bl, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzp().zza((Callable)new zzgj(this, zzn2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzkw> arrayList = new ArrayList<zzkw>(list.size());
            for (zzky zzky2 : list) {
                if (!bl && zzkx.zzd((String)zzky2.zzc)) continue;
                arrayList.add(new zzkw(zzky2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to query user properties. appId", zzex.zza((String)zzn2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzkw> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzp().zza((Callable)new zzgi(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzkw> arrayList = new ArrayList<zzkw>(list.size());
            for (zzky zzky2 : list) {
                if (!bl && zzkx.zzd((String)zzky2.zzc)) continue;
                arrayList.add(new zzkw(zzky2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get user properties as. appId", zzex.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzw> zza(String string, String string2, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzp().zza((Callable)new zzgl(this, zzn2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzw> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzp().zza((Callable)new zzgk(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzn zzn2) {
        this.zza(zzn2.zza, false);
        this.zza(new zzgn(this, zzn2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzp().zzf()) {
            runnable.run();
            return;
        }
        this.zza.zzp().zza(runnable);
    }

    final /* synthetic */ void zza(zzn zzn2, Bundle bundle) {
        this.zza.zze().zza(zzn2.zza, bundle);
    }

    static /* synthetic */ zzkp zza(zzgc zzgc2) {
        return zzgc2.zza;
    }
}

