/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbv;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzks;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class zzv {
    String zza;
    int zzb;
    Boolean zzc;
    Boolean zzd;
    Long zze;
    Long zzf;

    zzv(String string, int n) {
        this.zza = string;
        this.zzb = n;
    }

    abstract int zza();

    abstract boolean zzb();

    abstract boolean zzc();

    @VisibleForTesting
    static Boolean zza(Boolean bl, boolean bl2) {
        if (bl == null) {
            return null;
        }
        return bl != bl2;
    }

    @VisibleForTesting
    static Boolean zza(String string, zzbv.zzf zzf2, zzer zzer2) {
        List<String> list;
        Preconditions.checkNotNull((Object)((Object)zzf2));
        if (string == null) {
            return null;
        }
        if (!zzf2.zza() || zzf2.zzb() == zzbv.zzf.zzb.zza) {
            return null;
        }
        if (zzf2.zzb() == zzbv.zzf.zzb.zzg ? zzf2.zzh() == 0 : !zzf2.zzc()) {
            return null;
        }
        zzbv.zzf.zzb zzb2 = zzf2.zzb();
        boolean bl = zzf2.zzf();
        String string2 = bl || zzb2 == zzbv.zzf.zzb.zzb || zzb2 == zzbv.zzf.zzb.zzg ? zzf2.zzd() : zzf2.zzd().toUpperCase(Locale.ENGLISH);
        if (zzf2.zzh() == 0) {
            list = null;
        } else {
            boolean bl2 = bl;
            List<String> list2 = zzf2.zzg();
            if (bl2) {
                list = list2;
            } else {
                ArrayList<String> arrayList = new ArrayList<String>(list2.size());
                for (String string3 : list2) {
                    arrayList.add(string3.toUpperCase(Locale.ENGLISH));
                }
                list = Collections.unmodifiableList(arrayList);
            }
        }
        List<String> list3 = list;
        String string4 = null;
        if (zzb2 == zzbv.zzf.zzb.zzb) {
            string4 = string2;
        }
        return zzv.zza(string, zzb2, bl, string2, list3, string4, zzer2);
    }

    private static Boolean zza(String string, zzbv.zzf.zzb zzb2, boolean bl, String string2, List<String> list, String string3, zzer zzer2) {
        if (string == null) {
            return null;
        }
        if (zzb2 == zzbv.zzf.zzb.zzg ? list == null || list.size() == 0 : string2 == null) {
            return null;
        }
        string = bl || zzb2 == zzbv.zzf.zzb.zzb ? string : string.toUpperCase(Locale.ENGLISH);
        switch (zzb2) {
            case zzb: {
                int n = bl ? 0 : 66;
                try {
                    return Pattern.compile(string3, n).matcher(string).matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    if (zzer2 != null) {
                        zzer2.zzh().zza("Invalid regular expression in REGEXP audience filter. expression", (Object)string3);
                    }
                    return null;
                }
            }
            case zzc: {
                return string.startsWith(string2);
            }
            case zzd: {
                return string.endsWith(string2);
            }
            case zze: {
                return string.contains(string2);
            }
            case zzf: {
                return string.equals(string2);
            }
            case zzg: {
                return list.contains(string);
            }
        }
        return null;
    }

    static Boolean zza(long l, zzbv.zzd zzd2) {
        try {
            return zzv.zza(new BigDecimal(l), zzd2, 0.0);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Boolean zza(double d, zzbv.zzd zzd2) {
        try {
            return zzv.zza(new BigDecimal(d), zzd2, Math.ulp(d));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Boolean zza(String string, zzbv.zzd zzd2) {
        if (!zzks.zza(string)) {
            return null;
        }
        try {
            return zzv.zza(new BigDecimal(string), zzd2, 0.0);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @VisibleForTesting
    private static Boolean zza(BigDecimal bigDecimal, zzbv.zzd zzd2, double d) {
        block24: {
            BigDecimal bigDecimal2;
            zzbv.zzd.zza zza2;
            BigDecimal bigDecimal3;
            BigDecimal bigDecimal4;
            BigDecimal bigDecimal5;
            double d2;
            block23: {
                block22: {
                    Preconditions.checkNotNull((Object)((Object)zzd2));
                    if (!zzd2.zza() || zzd2.zzb() == zzbv.zzd.zza.zza) {
                        return null;
                    }
                    if (zzd2.zzb() == zzbv.zzd.zza.zze ? !zzd2.zzg() || !zzd2.zzi() : !zzd2.zze()) {
                        return null;
                    }
                    zzbv.zzd.zza zza3 = zzd2.zzb();
                    BigDecimal bigDecimal6 = null;
                    BigDecimal bigDecimal7 = null;
                    BigDecimal bigDecimal8 = null;
                    if (zzd2.zzb() == zzbv.zzd.zza.zze) {
                        if (!zzks.zza(zzd2.zzh()) || !zzks.zza(zzd2.zzj())) {
                            return null;
                        }
                        try {
                            bigDecimal7 = new BigDecimal(zzd2.zzh());
                            bigDecimal8 = new BigDecimal(zzd2.zzj());
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                    }
                    if (!zzks.zza(zzd2.zzf())) {
                        return null;
                    }
                    try {
                        bigDecimal6 = new BigDecimal(zzd2.zzf());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                    d2 = d;
                    bigDecimal5 = bigDecimal8;
                    bigDecimal4 = bigDecimal7;
                    bigDecimal3 = bigDecimal6;
                    zza2 = zza3;
                    bigDecimal2 = bigDecimal;
                    if (zza2 != zzbv.zzd.zza.zze) break block22;
                    if (bigDecimal4 == null) {
                        return null;
                    }
                    break block23;
                }
                if (bigDecimal3 == null) break block24;
            }
            switch (zza2) {
                case zzb: {
                    return bigDecimal2.compareTo(bigDecimal3) == -1;
                }
                case zzc: {
                    return bigDecimal2.compareTo(bigDecimal3) == 1;
                }
                case zzd: {
                    if (d2 != 0.0) {
                        return bigDecimal2.compareTo(bigDecimal3.subtract(new BigDecimal(d2).multiply(new BigDecimal(2)))) == 1 && bigDecimal2.compareTo(bigDecimal3.add(new BigDecimal(d2).multiply(new BigDecimal(2)))) == -1;
                    }
                    return bigDecimal2.compareTo(bigDecimal3) == 0;
                }
                case zze: {
                    return bigDecimal2.compareTo(bigDecimal4) != -1 && bigDecimal2.compareTo(bigDecimal5) != 1;
                }
            }
        }
        return null;
    }
}

