/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzml;
import com.google.android.gms.internal.measurement.zznw;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzfz
extends zzel {
    private final zzkl zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzfz(zzkl zzkl2) {
        this(zzkl2, null);
    }

    private zzfz(zzkl zzkl2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzkl2);
        this.zza = zzkl2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzgb(this, zzn2));
    }

    @BinderThread
    public final void zze(zzn zzn2) {
        if (zzml.zzb() && this.zza.zzb().zza(zzas.zzci)) {
            Preconditions.checkNotEmpty((String)zzn2.zza);
            Preconditions.checkNotNull((Object)zzn2.zzw);
            zzgj zzgj2 = new zzgj(this, zzn2);
            zzfz zzfz2 = this;
            Preconditions.checkNotNull((Object)zzgj2);
            if (zzfz2.zza.zzp().zzf()) {
                zzgj2.run();
                return;
            }
            zzfz2.zza.zzp().zzb((Runnable)zzgj2);
        }
    }

    @BinderThread
    public final void zza(zzaq zzaq2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzaq2);
        this.zzb(zzn2, false);
        this.zza(new zzgi(this, zzaq2, zzn2));
    }

    @VisibleForTesting
    final zzaq zzb(zzaq zzaq2, zzn zzn2) {
        String string;
        zzaq zzaq3 = zzaq2;
        if (!"_cmp".equals(zzaq3.zza) || zzaq3.zzb == null || zzaq3.zzb.zza() == 0 ? false : "referrer broadcast".equals(string = zzaq3.zzb.zzd("_cis")) || "referrer API".equals(string)) {
            this.zza.zzq().zzu().zza("Event has been filtered ", (Object)zzaq2.toString());
            return new zzaq("_cmpx", zzaq2.zzb, zzaq2.zzc, zzaq2.zzd);
        }
        return zzaq2;
    }

    @BinderThread
    public final void zza(zzaq zzaq2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzaq2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzgl(this, zzaq2, string));
    }

    @BinderThread
    public final byte[] zza(zzaq zzaq2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzaq2);
        this.zza(string, true);
        this.zza.zzq().zzv().zza("Log and bundle. event", (Object)this.zza.zzj().zza(zzaq2.zza));
        long l = this.zza.zzl().nanoTime() / 1000000L;
        Future future = this.zza.zzp().zzb((Callable)new zzgk(this, zzaq2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzq().zze().zza("Log and bundle returned null. appId", zzeq.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzl().nanoTime() / 1000000L;
            this.zza.zzq().zzv().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzj().zza(zzaq2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to log and bundle. appId, event, error", zzeq.zza((String)string), (Object)this.zza.zzj().zza(zzaq2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzku zzku2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzku2);
        this.zzb(zzn2, false);
        this.zza(new zzgn(this, zzku2, zzn2));
    }

    @BinderThread
    public final List<zzku> zza(zzn zzn2, boolean bl) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzp().zza((Callable)new zzgm(this, zzn2));
        try {
            List list = (List)future.get();
            ArrayList<zzku> arrayList = new ArrayList<zzku>(list.size());
            for (zzkw zzkw2 : list) {
                if (!bl && zzkv.zzd((String)zzkw2.zzc)) continue;
                arrayList.add(new zzku(zzkw2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get user properties. appId", zzeq.zza((String)zzn2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzgp(this, zzn2));
    }

    @BinderThread
    private final void zzb(zzn zzn2, boolean bl) {
        Preconditions.checkNotNull((Object)zzn2);
        this.zza(zzn2.zza, false);
        this.zza.zzk().zza(zzn2.zzb, zzn2.zzr, zzn2.zzv);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzq().zze().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzfz zzfz2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzfz2 = this;
                    if (!bl2) break block9;
                    if (zzfz2.zzb == null) {
                        zzfz2.zzb = "com.google.android.gms".equals(zzfz2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzfz2.zza.zzm(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzfz2.zza.zzm()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzfz2.zzb.booleanValue()) break block10;
                }
                if (zzfz2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzfz2.zza.zzm(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzfz2.zzc = string2;
                }
                if (!string2.equals(zzfz2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzq().zze().zza("Measurement Service called with invalid calling package. appId", zzeq.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgo(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzn zzn2) {
        if (zznw.zzb() && this.zza.zzb().zza(zzas.zzbz)) {
            this.zzb(zzn2, false);
            this.zza(new zzfy(this, zzn2, bundle));
        }
    }

    @BinderThread
    public final String zzc(zzn zzn2) {
        this.zzb(zzn2, false);
        return this.zza.zzd(zzn2);
    }

    @BinderThread
    public final void zza(zzz zzz2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzz2);
        Preconditions.checkNotNull((Object)zzz2.zzc);
        this.zzb(zzn2, false);
        zzz zzz3 = new zzz(zzz2);
        new zzz(zzz2).zza = zzn2.zza;
        this.zza(new zzga(this, zzz3, zzn2));
    }

    @BinderThread
    public final void zza(zzz zzz2) {
        Preconditions.checkNotNull((Object)zzz2);
        Preconditions.checkNotNull((Object)zzz2.zzc);
        this.zza(zzz2.zza, true);
        zzz zzz3 = new zzz(zzz2);
        this.zza(new zzgd(this, zzz3));
    }

    @BinderThread
    public final List<zzku> zza(String string, String string2, boolean bl, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzp().zza((Callable)new zzgc(this, zzn2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzku> arrayList = new ArrayList<zzku>(list.size());
            for (zzkw zzkw2 : list) {
                if (!bl && zzkv.zzd((String)zzkw2.zzc)) continue;
                arrayList.add(new zzku(zzkw2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to query user properties. appId", zzeq.zza((String)zzn2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzku> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzp().zza((Callable)new zzgf(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzku> arrayList = new ArrayList<zzku>(list.size());
            for (zzkw zzkw2 : list) {
                if (!bl && zzkv.zzd((String)zzkw2.zzc)) continue;
                arrayList.add(new zzku(zzkw2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get user properties as. appId", zzeq.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzz> zza(String string, String string2, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzp().zza((Callable)new zzge(this, zzn2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzz> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzp().zza((Callable)new zzgh(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzn zzn2) {
        this.zza(zzn2.zza, false);
        this.zza(new zzgg(this, zzn2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzp().zzf()) {
            runnable.run();
            return;
        }
        this.zza.zzp().zza(runnable);
    }

    final /* synthetic */ void zza(zzn zzn2, Bundle bundle) {
        this.zza.zze().zza(zzn2.zza, bundle);
    }

    static /* synthetic */ zzkl zza(zzfz zzfz2) {
        return zzfz2.zza;
    }
}

