/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzh;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkv;

public final class zzkh
extends zzki {
    private final AlarmManager zzb = (AlarmManager)this.zzm().getSystemService("alarm");
    private final zzai zzc;
    private Integer zzd;

    protected zzkh(zzkl zzkl2) {
        super(zzkl2);
        this.zzc = new zzkg(this, (zzgt)zzkl2.zzu(), zzkl2);
    }

    @Override
    protected final boolean zzd() {
        this.zzb.cancel(this.zzw());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzu();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzu() {
        JobScheduler jobScheduler = (JobScheduler)this.zzm().getSystemService("jobscheduler");
        int n = this.zzv();
        jobScheduler.cancel(n);
    }

    public final void zza(long l) {
        this.zzaj();
        Context context = this.zzm();
        if (!zzfm.zza((Context)context)) {
            this.zzq().zzv().zza("Receiver not registered/enabled");
        }
        if (!zzkv.zza((Context)context, (boolean)false)) {
            this.zzq().zzv().zza("Service not registered/enabled");
        }
        this.zze();
        this.zzq().zzw().zza("Scheduling upload, millis", (Object)l);
        long l2 = this.zzl().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzas.zzw.zza(null)) && !this.zzc.zzb()) {
            this.zzc.zza(l);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            long l3 = l;
            zzkh zzkh2 = this;
            Context context2 = zzkh2.zzm();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zzkh2.zzv();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            zzh.zza(context2, jobInfo, "com.google.android.gms", "UploadAlarm");
            return;
        }
        this.zzb.setInexactRepeating(2, l2, Math.max((Long)zzas.zzr.zza(null), l), this.zzw());
    }

    private final int zzv() {
        if (this.zzd == null) {
            String string = String.valueOf(this.zzm().getPackageName());
            this.zzd = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzd;
    }

    public final void zze() {
        this.zzaj();
        this.zzq().zzw().zza("Unscheduling upload");
        this.zzb.cancel(this.zzw());
        this.zzc.zzc();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzu();
        }
    }

    private final PendingIntent zzw() {
        Context context = this.zzm();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
    }
}

