/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzca;
import com.google.android.gms.internal.measurement.zzcd;
import com.google.android.gms.internal.measurement.zzhy;
import com.google.android.gms.internal.measurement.zzlo;
import com.google.android.gms.internal.measurement.zzmg;
import com.google.android.gms.internal.measurement.zzml;
import com.google.android.gms.internal.measurement.zzne;
import com.google.android.gms.internal.measurement.zznv;
import com.google.android.gms.internal.measurement.zznw;
import com.google.android.gms.internal.measurement.zzoz;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzkl
implements zzgt {
    private static volatile zzkl zza;
    private zzfo zzb;
    private zzex zzc;
    private zzaf zzd;
    private zzfa zze;
    private zzkh zzf;
    private zzr zzg;
    private final zzkr zzh;
    private zzih zzi;
    private zzjr zzj;
    private final zzfu zzk;
    private boolean zzl = false;
    private boolean zzm;
    @VisibleForTesting
    private long zzn;
    private List<Runnable> zzo;
    private int zzp;
    private int zzq;
    private boolean zzr;
    private boolean zzs;
    private boolean zzt;
    private FileLock zzu;
    private FileChannel zzv;
    private List<Long> zzw;
    private List<Long> zzx;
    private long zzy;
    private final Map<String, zzac> zzz;
    private final zzky zzaa = new zzko(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzkl zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzkl> clazz = zzkl.class;
        synchronized (zzkl.class) {
            if (zza != null) return zza;
            zzks zzks2 = new zzks(context);
            zza = new zzkl(zzks2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    private zzkl(zzks zzks2) {
        this(zzks2, null);
    }

    private zzkl(zzks zzks2, zzfu zzfu2) {
        Preconditions.checkNotNull((Object)zzks2);
        this.zzk = zzfu2 = zzfu.zza((Context)zzks2.zza, null, null);
        this.zzy = -1L;
        zzkl zzkl2 = this;
        zzkr zzkr2 = new zzkr(zzkl2);
        zzkr2.zzak();
        this.zzh = zzkr2;
        zzkl2 = this;
        zzex zzex2 = new zzex(zzkl2);
        zzex2.zzak();
        this.zzc = zzex2;
        zzkl2 = this;
        zzfo zzfo2 = new zzfo(zzkl2);
        zzfo2.zzak();
        this.zzb = zzfo2;
        this.zzz = new HashMap<String, zzac>();
        this.zzk.zzp().zza((Runnable)new zzkk(this, zzks2));
    }

    @WorkerThread
    private final void zza(zzks zzks2) {
        this.zzk.zzp().zzc();
        zzkl zzkl2 = this;
        zzaf zzaf2 = new zzaf(zzkl2);
        zzaf2.zzak();
        this.zzd = zzaf2;
        this.zzk.zza().zza((zzad)this.zzb);
        zzkl2 = this;
        zzjr zzjr2 = new zzjr(zzkl2);
        zzjr2.zzak();
        this.zzj = zzjr2;
        zzkl2 = this;
        zzr zzr2 = new zzr(zzkl2);
        zzr2.zzak();
        this.zzg = zzr2;
        zzkl2 = this;
        zzih zzih2 = new zzih(zzkl2);
        zzih2.zzak();
        this.zzi = zzih2;
        zzkl2 = this;
        zzkh zzkh2 = new zzkh(zzkl2);
        zzkh2.zzak();
        this.zzf = zzkh2;
        zzkl2 = this;
        this.zze = new zzfa(zzkl2);
        if (this.zzp != this.zzq) {
            this.zzk.zzq().zze().zza("Not all upload components initialized", (Object)this.zzp, (Object)this.zzq);
        }
        this.zzl = true;
    }

    @WorkerThread
    protected final void zza() {
        this.zzk.zzp().zzc();
        this.zze().zzu();
        if (this.zzk.zzb().zzc.zza() == 0L) {
            this.zzk.zzb().zzc.zza(this.zzk.zzl().currentTimeMillis());
        }
        this.zzab();
    }

    public final zzw zzt() {
        return this.zzk.zzt();
    }

    public final zzab zzb() {
        return this.zzk.zza();
    }

    public final zzeq zzq() {
        return this.zzk.zzq();
    }

    public final zzfr zzp() {
        return this.zzk.zzp();
    }

    public final zzfo zzc() {
        zzkl.zzb(this.zzb);
        return this.zzb;
    }

    public final zzex zzd() {
        zzkl.zzb(this.zzc);
        return this.zzc;
    }

    public final zzaf zze() {
        zzkl.zzb(this.zzd);
        return this.zzd;
    }

    private final zzfa zzv() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    private final zzkh zzw() {
        zzkl.zzb(this.zzf);
        return this.zzf;
    }

    public final zzr zzf() {
        zzkl.zzb(this.zzg);
        return this.zzg;
    }

    public final zzih zzg() {
        zzkl.zzb(this.zzi);
        return this.zzi;
    }

    public final zzkr zzh() {
        zzkl.zzb(this.zzh);
        return this.zzh;
    }

    public final zzjr zzi() {
        return this.zzj;
    }

    public final zzeo zzj() {
        return this.zzk.zzi();
    }

    public final Context zzm() {
        return this.zzk.zzm();
    }

    public final Clock zzl() {
        return this.zzk.zzl();
    }

    public final zzkv zzk() {
        return this.zzk.zzh();
    }

    @WorkerThread
    private final void zzx() {
        this.zzk.zzp().zzc();
    }

    final void zzn() {
        if (!this.zzl) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zzb(zzki zzki2) {
        if (zzki2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzki2.zzai()) {
            String string = String.valueOf(((Object)((Object)zzki2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    @WorkerThread
    final void zza(String string, zzac zzac2) {
        if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci)) {
            this.zzx();
            this.zzn();
            this.zzz.put(string, zzac2);
            zzac zzac3 = zzac2;
            String string2 = string;
            zzaf zzaf2 = this.zze();
            if (zzml.zzb() && zzaf2.zzs().zza(zzas.zzci)) {
                Preconditions.checkNotNull((Object)string2);
                Preconditions.checkNotNull((Object)zzac3);
                zzaf2.zzc();
                zzaf2.zzaj();
                ContentValues contentValues = new ContentValues();
                contentValues.put("app_id", string2);
                contentValues.put("consent_state", zzac3.zza());
                try {
                    if (zzaf2.c_().insertWithOnConflict("consent_settings", null, contentValues, 5) == -1L) {
                        zzaf2.zzq().zze().zza("Failed to insert/update consent setting (got -1). appId", zzeq.zza((String)string2));
                    }
                    return;
                }
                catch (SQLiteException sQLiteException) {
                    zzaf2.zzq().zze().zza("Error storing consent setting. appId, error", zzeq.zza((String)string2), (Object)sQLiteException);
                }
            }
        }
    }

    @WorkerThread
    final zzac zza(String string) {
        zzac zzac2 = zzac.zza;
        if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci)) {
            this.zzx();
            this.zzn();
            zzac2 = this.zzz.get(string);
            if (zzac2 == null) {
                zzac2 = this.zze().zzj(string);
                if (zzac2 == null) {
                    zzac2 = zzac.zza;
                }
                this.zza(string, zzac2);
            }
        }
        return zzac2;
    }

    private final long zzy() {
        long l = this.zzk.zzl().currentTimeMillis();
        zzfc zzfc2 = this.zzk.zzb();
        zzfc2.zzab();
        zzfc2.zzc();
        long l2 = zzfc2.zzg.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzfc2.zzo().zzg().nextInt(86400000);
            zzfc2.zzg.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zza(zzaq zzaq2, String string) {
        zzf zzf2 = this.zze().zzb(string);
        if (zzf2 == null || TextUtils.isEmpty((CharSequence)zzf2.zzl())) {
            this.zzk.zzq().zzv().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzb(zzf2);
        if (bl == null) {
            if (!"_ui".equals(zzaq2.zza)) {
                this.zzk.zzq().zzh().zza("Could not find package. appId", zzeq.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzk.zzq().zze().zza("App version does not match; dropping event. appId", zzeq.zza((String)string));
            return;
        }
        zzn zzn2 = new zzn(string, zzf2.zze(), zzf2.zzl(), zzf2.zzm(), zzf2.zzn(), zzf2.zzo(), zzf2.zzp(), null, zzf2.zzr(), false, zzf2.zzi(), zzf2.zzae(), 0L, 0, zzf2.zzaf(), zzf2.zzag(), false, zzf2.zzf(), zzf2.zzah(), zzf2.zzq(), zzf2.zzai(), zznv.zzb() && this.zzk.zza().zze(zzf2.zzc(), zzas.zzbi) ? zzf2.zzg() : null, zzml.zzb() && this.zzk.zza().zza(zzas.zzci) ? this.zza(string).zza() : "");
        this.zzb(zzaq2, zzn2);
    }

    @WorkerThread
    private final void zzb(zzaq zzaq2, zzn zzn2) {
        if (zznw.zzb() && this.zzk.zza().zza(zzas.zzbz)) {
            zzeu zzeu2 = zzeu.zza((zzaq)zzaq2);
            this.zzk.zzh().zza(zzeu2.zzb, this.zze().zzi(zzn2.zza));
            this.zzk.zzh().zza(zzeu2, this.zzk.zza().zza(zzn2.zza));
            zzaq2 = zzeu2.zza();
        }
        if (this.zzk.zza().zza(zzas.zzbd)) {
            String string;
            zzn zzn3 = zzn2;
            zzaq zzaq3 = zzaq2;
            zzkl zzkl2 = this;
            if ("_cmp".equals(zzaq3.zza) && "referrer API v2".equals(zzaq3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzaq3.zzb.zzd("gclid")))) {
                zzku zzku2 = new zzku("_lgclid", zzaq3.zzd, (Object)string, "auto");
                zzkl2.zza(zzku2, zzn3);
            }
        }
        this.zza(zzaq2, zzn2);
    }

    @WorkerThread
    final void zza(zzaq zzaq2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        this.zzx();
        this.zzn();
        String string = zzn2.zza;
        long l = zzaq2.zzd;
        this.zzh();
        if (!zzkr.zza(zzaq2, zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        if (zzn2.zzu != null) {
            if (zzn2.zzu.contains(zzaq2.zza)) {
                Bundle bundle = zzaq2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzaq2 = new zzaq(zzaq2.zza, new zzap(bundle), zzaq2.zzc, zzaq2.zzd);
            } else {
                this.zzk.zzq().zzv().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzaq2.zza, (Object)zzaq2.zzc);
                return;
            }
        }
        this.zze().zze();
        try {
            zzz zzz2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzaf zzaf2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzaf2.zzc();
            zzaf2.zzaj();
            if (l2 < 0L) {
                zzaf2.zzq().zzh().zza("Invalid time querying timed out conditional properties", zzeq.zza((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzaf2.zza(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzk.zzq().zzw().zza("User property timed out", (Object)((zzz)object22).zza, (Object)this.zzk.zzi().zzc(((zzz)object22).zzc.zza), ((zzz)object22).zzc.zza());
                if (((zzz)object22).zzg != null) {
                    this.zzc(new zzaq(((zzz)object22).zzg, l), zzn2);
                }
                this.zze().zze(string, ((zzz)object22).zzc.zza);
            }
            l2 = l;
            string3 = string;
            zzaf2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzaf2.zzc();
            zzaf2.zzaj();
            if (l2 < 0L) {
                zzaf2.zzq().zzh().zza("Invalid time querying expired conditional properties", zzeq.zza((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzaf2.zza(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzz)object4.next();
                if (object == null) continue;
                this.zzk.zzq().zzw().zza("User property expired", (Object)((zzz)object).zza, (Object)this.zzk.zzi().zzc(((zzz)object).zzc.zza), ((zzz)object).zzc.zza());
                this.zze().zzb(string, ((zzz)object).zzc.zza);
                if (((zzz)object).zzk != null) {
                    object22.add(((zzz)object).zzk);
                }
                this.zze().zze(string, ((zzz)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzaq)e;
                this.zzc(new zzaq((zzaq)object, l), zzn2);
            }
            long l3 = l;
            String string4 = zzaq2.zza;
            string3 = string;
            zzaf2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzaf2.zzc();
            zzaf2.zzaj();
            if (l3 < 0L) {
                zzaf2.zzq().zzh().zza("Invalid time querying triggered conditional properties", zzeq.zza((String)string3), (Object)zzaf2.zzn().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzaf2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzz2 = (zzz)iterator.next();
                if (zzz2 == null) continue;
                zzku zzku2 = zzz2.zzc;
                zzkw zzkw2 = new zzkw(zzz2.zza, zzz2.zzb, zzku2.zza, l, zzku2.zza());
                if (this.zze().zza(zzkw2)) {
                    this.zzk.zzq().zzw().zza("User property triggered", (Object)zzz2.zza, (Object)this.zzk.zzi().zzc(zzkw2.zzc), zzkw2.zze);
                } else {
                    this.zzk.zzq().zze().zza("Too many active user properties, ignoring", zzeq.zza((String)zzz2.zza), (Object)this.zzk.zzi().zzc(zzkw2.zzc), zzkw2.zze);
                }
                if (zzz2.zzi != null) {
                    object.add(zzz2.zzi);
                }
                zzz2.zzc = new zzku(zzkw2);
                zzz2.zze = true;
                this.zze().zza(zzz2);
            }
            this.zzc(zzaq2, zzn2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzz2 = (zzaq)e;
                this.zzc(new zzaq((zzaq)zzz2, l), zzn2);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzg();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzc(zzaq var1_1, zzn var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzx();
        this.zzn();
        var5_4 = var2_2.zza;
        this.zzh();
        if (!zzkr.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zzc(var2_2);
            return;
        }
        if (this.zzc().zzb(var5_4, var1_1.zza)) {
            this.zzk.zzq().zzh().zza("Dropping blacklisted event. appId", zzeq.zza((String)var5_4), (Object)this.zzk.zzi().zza(var1_1.zza));
            var6_5 = this.zzc().zzg(var5_4) != false || this.zzc().zzh(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzk.zzh().zza(this.zzaa, var5_4, 11, "_ev", var1_1.zza, 0);
            }
            if (var6_5 && (var7_8 = this.zze().zzb(var5_4)) != null) {
                var8_9 = Math.max(var7_8.zzu(), var7_8.zzt());
                if (Math.abs(this.zzk.zzl().currentTimeMillis() - var8_9) > (Long)zzas.zzy.zza(null)) {
                    this.zzk.zzq().zzv().zza("Fetching config for blacklisted app");
                    this.zza(var7_8);
                }
            }
            return;
        }
        if (zzmg.zzb() && this.zzk.zza().zza(zzas.zzbv)) {
            var6_6 = zzeu.zza((zzaq)var1_1);
            this.zzk.zzh().zza(var6_6, this.zzk.zza().zza(var5_4));
            var1_1 = var6_6.zza();
        }
        if (this.zzk.zzq().zza(2)) {
            this.zzk.zzq().zzw().zza("Logging event", (Object)this.zzk.zzi().zza(var1_1));
        }
        this.zze().zze();
        try {
            block79: {
                block80: {
                    block82: {
                        block86: {
                            block85: {
                                block83: {
                                    block84: {
                                        this.zzc(var2_2);
                                        var6_7 = "ecommerce_purchase".equals(var1_1.zza) != false || "purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false;
                                        if (!("_iap".equals(var1_1.zza) != false || var6_7 != false)) break block82;
                                        var25_11 = var6_7;
                                        var24_13 = var1_1;
                                        var23_16 = var5_4;
                                        var22_17 = this;
                                        var26_18 = var24_13.zzb.zzd("currency");
                                        if (!var25_11) break block83;
                                        var29_19 = var24_13.zzb.zzc("value") * 1000000.0;
                                        if (var29_19 == 0.0) {
                                            var29_19 = (double)var24_13.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var29_19 <= 9.223372036854776E18) || !(var29_19 >= -9.223372036854776E18)) break block84;
                                        var27_23 = Math.round(var29_19);
                                        if ("refund".equals(var24_13.zza)) {
                                            var27_23 = -var27_23;
                                        }
                                        break block85;
                                    }
                                    var22_17.zzk.zzq().zzh().zza("Data lost. Currency value is too big. appId", zzeq.zza((String)var23_16), (Object)var29_19);
                                    v0 = false;
                                    break block86;
                                }
                                var27_23 = var24_13.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var26_18) && (var26_18 = var26_18.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                v1 = String.valueOf("_ltv_");
                                v2 = String.valueOf(var26_18);
                                var29_20 = v2.length() != 0 ? v1.concat(v2) : new String(v1);
                                var30_25 = var22_17.zze().zzc(var23_16, var29_20);
                                if (var30_25 == null || !(var30_25.zze instanceof Long)) {
                                    var39_28 = var22_17.zzk.zza().zzb(var23_16, zzas.zzad) - 1;
                                    var38_29 = var23_16;
                                    var37_30 = var22_17.zze();
                                    Preconditions.checkNotEmpty((String)var38_29);
                                    var37_30.zzc();
                                    var37_30.zzaj();
                                    try {
                                        var37_30.c_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var38_29, var38_29, String.valueOf(var39_28)});
                                    }
                                    catch (SQLiteException var40_31) {
                                        var37_30.zzq().zze().zza("Error pruning currencies. appId", zzeq.zza((String)var38_29), (Object)var40_31);
                                    }
                                    var30_25 = new zzkw(var23_16, var24_13.zzc, var29_20, var22_17.zzk.zzl().currentTimeMillis(), (Object)var27_23);
                                } else {
                                    var31_32 = (Long)var30_25.zze;
                                    var30_25 = new zzkw(var23_16, var24_13.zzc, var29_20, var22_17.zzk.zzl().currentTimeMillis(), (Object)(var31_32 + var27_23));
                                }
                                if (!var22_17.zze().zza(var30_25)) {
                                    var22_17.zzk.zzq().zze().zza("Too many unique user properties are set. Ignoring user property. appId", zzeq.zza((String)var23_16), (Object)var22_17.zzk.zzi().zzc(var30_25.zzc), var30_25.zze);
                                    var22_17.zzk.zzh().zza(var22_17.zzaa, var23_16, 9, null, null, 0);
                                }
                            }
                            v0 = true;
                        }
                        if (!v0) {
                            this.zze().b_();
                            return;
                        }
                    }
                    var8_10 = zzkv.zza((String)var1_1.zza);
                    var9_34 = "_err".equals(var1_1.zza);
                    this.zzk.zzh();
                    var10_35 = 1L + zzkv.zza((zzap)var1_1.zzb);
                    var12_36 = this.zze().zza(this.zzy(), var5_4, var10_35, true, var8_10, false, var9_34, false);
                    var13_37 = var12_36.zzb - (long)((Integer)zzas.zzj.zza(null)).intValue();
                    if (var13_37 > 0L) {
                        if (var13_37 % 1000L == 1L) {
                            this.zzk.zzq().zze().zza("Data loss. Too many events logged. appId, count", zzeq.zza((String)var5_4), (Object)var12_36.zzb);
                        }
                        this.zze().b_();
                        return;
                    }
                    if (var8_10 && (var13_37 = var12_36.zza - (long)((Integer)zzas.zzl.zza(null)).intValue()) > 0L) {
                        if (var13_37 % 1000L == 1L) {
                            this.zzk.zzq().zze().zza("Data loss. Too many public events logged. appId, count", zzeq.zza((String)var5_4), (Object)var12_36.zza);
                        }
                        this.zzk.zzh().zza(this.zzaa, var5_4, 16, "_ev", var1_1.zza, 0);
                        this.zze().b_();
                        return;
                    }
                    if (var9_34) {
                        var24_14 = this.zzk.zza().zzb(var2_2.zza, zzas.zzk);
                        var13_37 = var12_36.zzd - (long)Math.max(0, var24_14 = Math.min(1000000, var24_14));
                        if (var13_37 > 0L) {
                            if (var13_37 == 1L) {
                                this.zzk.zzq().zze().zza("Too many error events logged. appId, count", zzeq.zza((String)var5_4), (Object)var12_36.zzd);
                            }
                            this.zze().b_();
                            return;
                        }
                    }
                    var15_38 = var1_1.zzb.zzb();
                    this.zzk.zzh().zza(var15_38, "_o", (Object)var1_1.zzc);
                    if (this.zzk.zzh().zze(var5_4)) {
                        this.zzk.zzh().zza(var15_38, "_dbg", (Object)1L);
                        this.zzk.zzh().zza(var15_38, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var16_39 = this.zze().zzc(var2_2.zza, "_sno")) != null && var16_39.zze instanceof Long) {
                        this.zzk.zzh().zza(var15_38, "_sno", var16_39.zze);
                    }
                    if ((var16_40 = this.zze().zzc(var5_4)) > 0L) {
                        this.zzk.zzq().zzh().zza("Data lost. Too many events stored on disk, deleted. appId", zzeq.zza((String)var5_4), (Object)var16_40);
                    }
                    var18_41 = new zzan(this.zzk, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var15_38);
                    var19_42 = this.zze().zza(var5_4, var18_41.zzb);
                    if (var19_42 == null) {
                        if (this.zze().zzh(var5_4) >= (long)this.zzk.zza().zzb(var5_4) && var8_10) {
                            this.zzk.zzq().zze().zza("Too many event names used, ignoring event. appId, name, supported count", zzeq.zza((String)var5_4), (Object)this.zzk.zzi().zza(var18_41.zzb), (Object)this.zzk.zza().zzb(var5_4));
                            this.zzk.zzh().zza(this.zzaa, var5_4, 8, null, null, 0);
                            return;
                        }
                        var20_43 = new zzam(var5_4, var18_41.zzb, 0L, 0L, var18_41.zzc, 0L, null, null, null, null);
                    } else {
                        var18_41 = var18_41.zza(this.zzk, var19_42.zzf);
                        var20_43 = var19_42.zza(var18_41.zzc);
                    }
                    this.zze().zza(var20_43);
                    var24_15 = var2_2;
                    var23_16 = var18_41;
                    var22_17 = this;
                    var22_17.zzx();
                    var22_17.zzn();
                    Preconditions.checkNotNull((Object)var23_16);
                    Preconditions.checkNotNull((Object)var24_15);
                    Preconditions.checkNotEmpty((String)var23_16.zza);
                    Preconditions.checkArgument((boolean)var23_16.zza.equals(var24_15.zza));
                    var25_12 = zzcd.zzg.zzbh().zza(1).zza("android");
                    if (!TextUtils.isEmpty((CharSequence)var24_15.zza)) {
                        var25_12.zzf(var24_15.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var24_15.zzd)) {
                        var25_12.zze(var24_15.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var24_15.zzc)) {
                        var25_12.zzg(var24_15.zzc);
                    }
                    if (var24_15.zzj != -2147483648L) {
                        var25_12.zzh((int)var24_15.zzj);
                    }
                    var25_12.zzf(var24_15.zze);
                    if (!TextUtils.isEmpty((CharSequence)var24_15.zzb)) {
                        var25_12.zzk(var24_15.zzb);
                    }
                    if (zzml.zzb() && var22_17.zzk.zza().zza(zzas.zzci)) {
                        var26_18 = var22_17.zza(var24_15.zza).zzb(zzac.zza((String)var24_15.zzw));
                        var25_12.zzq(var26_18.zza());
                    }
                    if (zznv.zzb() && var22_17.zzk.zza().zze(var24_15.zza, zzas.zzbi)) {
                        if (TextUtils.isEmpty((CharSequence)var25_12.zzo()) && !TextUtils.isEmpty((CharSequence)var24_15.zzv)) {
                            var25_12.zzp(var24_15.zzv);
                        }
                        if (TextUtils.isEmpty((CharSequence)var25_12.zzo()) && TextUtils.isEmpty((CharSequence)var25_12.zzs()) && !TextUtils.isEmpty((CharSequence)var24_15.zzr)) {
                            var25_12.zzo(var24_15.zzr);
                        }
                    } else if (TextUtils.isEmpty((CharSequence)var25_12.zzo()) && !TextUtils.isEmpty((CharSequence)var24_15.zzr)) {
                        var25_12.zzo(var24_15.zzr);
                    }
                    if (var24_15.zzf != 0L) {
                        var25_12.zzh(var24_15.zzf);
                    }
                    var25_12.zzk(var24_15.zzt);
                    var26_18 = var22_17.zzh().zze();
                    if (var26_18 != null) {
                        var25_12.zzd((Iterable<? extends Integer>)var26_18);
                    }
                    var27_24 = var22_17.zza(var24_15.zza).zzb(zzac.zza((String)var24_15.zzw));
                    if (!zzml.zzb() || !var22_17.zzk.zza().zza(zzas.zzci) || var27_24.zzc()) {
                        var28_44 = var22_17.zzj.zza(var24_15.zza, var27_24);
                        if (var28_44 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var28_44.first))) {
                            if (var24_15.zzo) {
                                var25_12.zzh((String)var28_44.first);
                                if (var28_44.second != null) {
                                    var25_12.zza((Boolean)var28_44.second);
                                }
                            }
                        } else if (!(var22_17.zzk.zzw().zza(var22_17.zzk.zzm()) || !var24_15.zzp || zzoz.zzb() && var22_17.zzk.zza().zze(var24_15.zza, zzas.zzcf))) {
                            var29_21 = Settings.Secure.getString((ContentResolver)var22_17.zzk.zzm().getContentResolver(), (String)"android_id");
                            if (var29_21 == null) {
                                var22_17.zzk.zzq().zzh().zza("null secure ID. appId", zzeq.zza((String)var25_12.zzj()));
                                var29_21 = "null";
                            } else if (var29_21.isEmpty()) {
                                var22_17.zzk.zzq().zzh().zza("empty secure ID. appId", zzeq.zza((String)var25_12.zzj()));
                            }
                            var25_12.zzm(var29_21);
                        }
                    }
                    var22_17.zzk.zzw().zzab();
                    v3 = var25_12.zzc(Build.MODEL);
                    var22_17.zzk.zzw().zzab();
                    v3.zzb(Build.VERSION.RELEASE).zzf((int)var22_17.zzk.zzw().zze()).zzd(var22_17.zzk.zzw().zzf());
                    if (!var22_17.zzk.zza().zza(zzas.zzbx)) {
                        var25_12.zzj(var24_15.zzl);
                    }
                    if (var22_17.zzk.zzaa()) {
                        if (zzml.zzb() && var22_17.zzk.zza().zza(zzas.zzci)) {
                            var25_12.zzj();
                        } else {
                            var25_12.zzj();
                        }
                        if (!TextUtils.isEmpty(null)) {
                            var25_12.zzn(null);
                        }
                    }
                    if ((var28_44 = var22_17.zze().zzb(var24_15.zza)) == null) {
                        var28_44 = new zzf(var22_17.zzk, var24_15.zza);
                        if (zzml.zzb() && var22_17.zzk.zza().zza(zzas.zzci)) {
                            var28_44.zza(var22_17.zza(var27_24));
                        } else {
                            var28_44.zza(var22_17.zzz());
                        }
                        var28_44.zzf(var24_15.zzk);
                        var28_44.zzb(var24_15.zzb);
                        if (!zzml.zzb() || !var22_17.zzk.zza().zza(zzas.zzci) || var27_24.zzc()) {
                            var28_44.zze(var22_17.zzj.zza(var24_15.zza));
                        }
                        var28_44.zzg(0L);
                        var28_44.zza(0L);
                        var28_44.zzb(0L);
                        var28_44.zzg(var24_15.zzc);
                        var28_44.zzc(var24_15.zzj);
                        var28_44.zzh(var24_15.zzd);
                        var28_44.zzd(var24_15.zze);
                        var28_44.zze(var24_15.zzf);
                        var28_44.zza(var24_15.zzh);
                        if (!var22_17.zzk.zza().zza(zzas.zzbx)) {
                            var28_44.zzp(var24_15.zzl);
                        }
                        var28_44.zzf(var24_15.zzt);
                        var22_17.zze().zza(var28_44);
                    }
                    if (!(zzml.zzb() && var22_17.zzk.zza().zza(zzas.zzci) && !var27_24.zze() || TextUtils.isEmpty((CharSequence)var28_44.zzd()))) {
                        var25_12.zzi(var28_44.zzd());
                    }
                    if (!TextUtils.isEmpty((CharSequence)var28_44.zzi())) {
                        var25_12.zzl(var28_44.zzi());
                    }
                    var29_22 = var22_17.zze().zza(var24_15.zza);
                    for (var30_26 = 0; var30_26 < var29_22.size(); ++var30_26) {
                        var31_33 = zzcd.zzk.zzj().zza(var29_22.get((int)var30_26).zzc).zza(var29_22.get((int)var30_26).zzd);
                        var22_17.zzh().zza(var31_33, var29_22.get((int)var30_26).zze);
                        var25_12.zza(var31_33);
                    }
                    try {
                        var30_27 = var22_17.zze().zza((zzcd.zzg)((zzhy)var25_12.zzy()));
                    }
                    catch (IOException var32_45) {
                        var22_17.zzk.zzq().zze().zza("Data loss. Failed to insert raw event metadata. appId", zzeq.zza((String)var25_12.zzj()), (Object)var32_45);
                        break block79;
                    }
                    v4 = var22_17.zze();
                    var34_46 = var23_16;
                    var33_47 = var22_17;
                    if (var34_46.zze == null) ** GOTO lbl-1000
                    for (Object var36_50 : var34_46.zze) {
                        if (!"_r".equals(var36_50)) continue;
                        v5 = true;
                        break block80;
                    }
                    var35_49 = var33_47.zzc().zzc(var34_46.zza, var34_46.zzb);
                    var36_50 = var33_47.zze().zza(var33_47.zzy(), var34_46.zza, false, false, false, false, false);
                    if (var35_49 && var36_50.zze < (long)var33_47.zzk.zza().zzc(var34_46.zza)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                }
                if (v4.zza((zzan)var23_16, var30_27, v5)) {
                    var22_17.zzn = 0L;
                }
            }
            this.zze().b_();
        }
        finally {
            this.zze().zzg();
        }
        this.zzab();
        this.zzk.zzq().zzw().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    @WorkerThread
    private final String zza(zzac zzac2) {
        if (!zzml.zzb() || !this.zzk.zza().zza(zzas.zzci) || zzac2.zze()) {
            return this.zzz();
        }
        return null;
    }

    @Deprecated
    @WorkerThread
    private final String zzz() {
        byte[] byArray = new byte[16];
        this.zzk.zzh().zzg().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    final void zzo() {
        this.zzx();
        this.zzn();
        this.zzt = true;
        try {
            String string;
            long l;
            Boolean bl = this.zzk.zzv().zzaf();
            if (bl == null) {
                this.zzk.zzq().zzh().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzk.zzq().zze().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzn > 0L) {
                this.zzab();
                return;
            }
            zzgt zzgt2 = this;
            zzgt2.zzx();
            if (zzgt2.zzw != null) {
                this.zzk.zzq().zzw().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzd().zze()) {
                this.zzk.zzq().zzw().zza("Network not connected, ignoring upload request");
                this.zzab();
                return;
            }
            long l2 = this.zzk.zzl().currentTimeMillis();
            int n = this.zzk.zza().zzb(null, zzas.zzap);
            long l3 = l2 - zzab.zzv();
            for (int i = 0; i < n && this.zza(null, l = l3); ++i) {
            }
            long l4 = this.zzk.zzb().zzc.zza();
            if (l4 != 0L) {
                this.zzk.zzq().zzv().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l2 - l4));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zze().d_()))) {
                if (this.zzy == -1L) {
                    this.zzy = this.zze().zzz();
                }
                int n2 = this.zzk.zza().zzb(string, zzas.zzf);
                Object object = string;
                zzgt2 = this.zzk.zza();
                int n3 = Math.max(0, zzgt2.zzb((String)object, zzas.zzg));
                List<Pair<zzcd.zzg, Long>> list = this.zze().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    if (!zzml.zzb() || !this.zzk.zza().zza(zzas.zzci) || this.zza(string).zzc()) {
                        object5 = null;
                        Iterator<Pair<zzcd.zzg, Long>> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            zzcd.zzg zzg2 = (zzcd.zzg)((Object)iterator.next().first);
                            if (TextUtils.isEmpty((CharSequence)zzg2.zzad())) continue;
                            object5 = zzg2.zzad();
                            break;
                        }
                        if (object5 != null) {
                            for (int i = 0; i < list.size(); ++i) {
                                object4 = (zzcd.zzg)((Object)list.get((int)i).first);
                                if (TextUtils.isEmpty((CharSequence)((zzcd.zzg)((Object)object4)).zzad()) || ((zzcd.zzg)((Object)object4)).zzad().equals(object5)) continue;
                                list = list.subList(0, i);
                                break;
                            }
                        }
                    }
                    object5 = zzcd.zzf.zzb();
                    int n4 = list.size();
                    object4 = new ArrayList(list.size());
                    boolean bl2 = this.zzk.zza().zzh(string) && (!zzml.zzb() || !this.zzk.zza().zza(zzas.zzci) || this.zza(string).zzc());
                    boolean bl3 = !zzml.zzb() || !this.zzk.zza().zza(zzas.zzci) || this.zza(string).zzc();
                    boolean bl4 = !zzml.zzb() || !this.zzk.zza().zza(zzas.zzci) || this.zza(string).zze();
                    for (int i = 0; i < n4; ++i) {
                        object3 = (zzcd.zzg.zza)((zzcd.zzg)((Object)list.get((int)i).first)).zzbo();
                        object4.add((Long)list.get((int)i).second);
                        ((zzcd.zzg.zza)((Object)object3)).zzg(33025L).zza(l2).zzb(false);
                        if (!bl2) {
                            ((zzcd.zzg.zza)((Object)object3)).zzr();
                        }
                        if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci)) {
                            if (!bl3) {
                                ((zzcd.zzg.zza)((Object)object3)).zzk();
                                ((zzcd.zzg.zza)((Object)object3)).zzl();
                            }
                            if (!bl4) {
                                ((zzcd.zzg.zza)((Object)object3)).zzm();
                            }
                        }
                        if (this.zzk.zza().zze(string, zzas.zzaw)) {
                            object2 = ((zzcd.zzg)((zzhy)object3.zzy())).zzbk();
                            ((zzcd.zzg.zza)((Object)object3)).zzl(this.zzh().zza((byte[])object2));
                        }
                        ((zzcd.zzf.zza)((Object)object5)).zza((zzcd.zzg.zza)((Object)object3));
                    }
                    String string2 = null;
                    if (this.zzk.zzq().zza(2)) {
                        string2 = this.zzh().zza((zzcd.zzf)((zzhy)object5.zzy()));
                    }
                    this.zzh();
                    object3 = ((zzcd.zzf)((zzhy)object5.zzy())).zzbk();
                    object2 = (String)zzas.zzp.zza(null);
                    try {
                        URL uRL = new URL((String)object2);
                        object = object4;
                        zzgt2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzgt2.zzw != null) {
                            zzgt2.zzk.zzq().zze().zza("Set uploading progress before finishing the previous upload");
                        } else {
                            zzgt2.zzw = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzk.zzb().zzd.zza(l2);
                        String string3 = "?";
                        if (n4 > 0) {
                            string3 = ((zzcd.zzf.zza)((Object)object5)).zza(0).zzx();
                        }
                        this.zzk.zzq().zzw().zza("Uploading data. app, uncompressed size, data", (Object)string3, (Object)((Object)object3).length, (Object)string2);
                        this.zzs = true;
                        zzkn zzkn2 = new zzkn(this, string);
                        Object object6 = object3;
                        URL uRL2 = uRL;
                        object = string;
                        zzgt2 = this.zzd();
                        zzgt2.zzc();
                        zzgt2.zzaj();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)object6);
                        Preconditions.checkNotNull((Object)zzkn2);
                        zzgt2.zzp().zzc((Runnable)new zzfb((zzex)zzgt2, (String)object, uRL2, (byte[])object6, null, zzkn2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzk.zzq().zze().zza("Failed to parse upload URL. Not uploading. appId", zzeq.zza((String)string), object2);
                    }
                }
            } else {
                zzf zzf2;
                this.zzy = -1L;
                String string4 = this.zze().zza(l2 - zzab.zzv());
                if (!TextUtils.isEmpty((CharSequence)string4) && (zzf2 = this.zze().zzb(string4)) != null) {
                    this.zza(zzf2);
                }
            }
            return;
        }
        finally {
            this.zzt = false;
            this.zzac();
        }
    }

    @WorkerThread
    private final boolean zza(String string, long l) {
        this.zze().zze();
        try {
            block160: {
                zzf zzf2;
                int n;
                String[] stringArray;
                String string2;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                zza zza2;
                block158: {
                    zza2 = new zza(null);
                    object4 = zza2;
                    long l2 = this.zzy;
                    long l3 = l;
                    object3 = null;
                    object2 = this.zze();
                    Preconditions.checkNotNull((Object)object4);
                    object2.zzc();
                    ((zzki)((Object)object2)).zzaj();
                    try (Cursor cursor = null;){
                        String string3;
                        Object object5;
                        Object[] objectArray;
                        object = ((zzaf)((Object)object2)).c_();
                        if (TextUtils.isEmpty(null)) {
                            objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            object5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = object.rawQuery(new StringBuilder(148 + String.valueOf(object5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append((String)object5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block158;
                            object3 = cursor.getString(0);
                            string2 = cursor.getString(1);
                            cursor.close();
                        } else {
                            objectArray = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            object5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = object.rawQuery(new StringBuilder(84 + String.valueOf(object5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append((String)object5).append(" order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block158;
                            string2 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = object.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object3, string2}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object2.zzq().zze().zza("Raw event metadata record is missing. appId", zzeq.zza((String)object3));
                            break block158;
                        }
                        objectArray = cursor.getBlob(0);
                        try {
                            object5 = (zzcd.zzg)((zzhy)zzkr.zza(zzcd.zzg.zzbh(), (byte[])objectArray).zzy());
                        }
                        catch (IOException iOException) {
                            object2.zzq().zze().zza("Data loss. Failed to merge raw event metadata. appId", zzeq.zza((String)object3), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block158;
                        }
                        if (cursor.moveToNext()) {
                            object2.zzq().zzh().zza("Get multiple raw event metadata records, expected one. appId", zzeq.zza((String)object3));
                        }
                        cursor.close();
                        object4.zza((zzcd.zzg)((Object)object5));
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object3, string2, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object3, string2};
                        }
                        cursor = object.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object2.zzq().zzh().zza("Raw event data disappeared while in transaction. appId", zzeq.zza((String)object3));
                            break block158;
                        }
                        do {
                            zzcd.zzc.zza zza3;
                            long l4 = cursor.getLong(0);
                            objectArray = cursor.getBlob(3);
                            try {
                                zza3 = zzkr.zza(zzcd.zzc.zzj(), (byte[])objectArray);
                            }
                            catch (IOException iOException) {
                                object2.zzq().zze().zza("Data loss. Failed to merge raw event. appId", zzeq.zza((String)object3), (Object)iOException);
                                continue;
                            }
                            zza3.zza(cursor.getString(1)).zza(cursor.getLong(2));
                            if (!object4.zza(l4, (zzcd.zzc)((zzhy)zza3.zzy()))) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzc == null || ((zza)object2).zzc.isEmpty()) break block160;
                boolean bl = false;
                zzcd.zzg.zza zza4 = ((zzcd.zzg.zza)zza2.zza.zzbo()).zzc();
                int n2 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzk.zza().zze(zza2.zza.zzx(), zzas.zzat);
                zzcd.zzc.zza zzjl3 = null;
                int n3 = -1;
                zzcd.zzc.zza zza5 = null;
                int n4 = -1;
                for (n = 0; n < zza2.zzc.size(); ++n) {
                    Object zzjl4;
                    int n5;
                    zzcd.zzc.zza zzjl22;
                    block162: {
                        boolean bl3;
                        block161: {
                            boolean bl4;
                            bl3 = bl;
                            zzjl22 = (zzcd.zzc.zza)zza2.zzc.get(n).zzbo();
                            if (this.zzc().zzb(zza2.zza.zzx(), zzjl22.zzd())) {
                                this.zzk.zzq().zzh().zza("Dropping blacklisted raw event. appId", zzeq.zza((String)zza2.zza.zzx()), (Object)this.zzk.zzi().zza(zzjl22.zzd()));
                                if (this.zzc().zzg(zza2.zza.zzx()) || this.zzc().zzh(zza2.zza.zzx()) || "_err".equals(zzjl22.zzd())) continue;
                                this.zzk.zzh().zza(this.zzaa, zza2.zza.zzx(), 11, "_ev", zzjl22.zzd(), 0);
                                continue;
                            }
                            if (zzlo.zzb() && this.zzk.zza().zze(zza2.zza.zzx(), zzas.zzcl) && zzjl22.zzd().equals(zzgv.zza((String)"_ai"))) {
                                zzjl22.zza("_ai");
                                this.zzk.zzq().zzw().zza("Renaming ad_impression to _ai");
                                if (this.zzk.zzq().zza(5)) {
                                    for (n5 = 0; n5 < zzjl22.zzb(); ++n5) {
                                        if (!"ad_platform".equals(zzjl22.zza(n5).zzb()) || TextUtils.isEmpty((CharSequence)zzjl22.zza(n5).zzd()) || !"admob".equalsIgnoreCase(zzjl22.zza(n5).zzd())) continue;
                                        this.zzk.zzq().zzj().zza("AdMob ad impression logged from app. Potentially duplicative.");
                                    }
                                }
                            }
                            if ((n5 = this.zzc().zzc(zza2.zza.zzx(), zzjl22.zzd())) != 0) break block161;
                            this.zzh();
                            object2 = zzjl22.zzd();
                            Preconditions.checkNotEmpty((String)object2);
                            switch (object2) {
                                case "_in": 
                                case "_ui": 
                                case "_ug": {
                                    bl4 = true;
                                    break;
                                }
                                default: {
                                    bl4 = false;
                                }
                            }
                            if (!bl4) break block162;
                        }
                        boolean l6 = false;
                        boolean bl5 = false;
                        for (int i = 0; i < zzjl22.zzb(); ++i) {
                            zzcd.zze zze2;
                            if ("_c".equals(zzjl22.zza(i).zzb())) {
                                zze2 = (zzcd.zze)((zzhy)((zzcd.zze.zza)zzjl22.zza(i).zzbo()).zza(1L).zzy());
                                l6 = true;
                                zzjl22.zza(i, zze2);
                                continue;
                            }
                            if (!"_r".equals(zzjl22.zza(i).zzb())) continue;
                            zze2 = (zzcd.zze)((zzhy)((zzcd.zze.zza)zzjl22.zza(i).zzbo()).zza(1L).zzy());
                            bl5 = true;
                            zzjl22.zza(i, zze2);
                        }
                        if (!l6 && n5 != 0) {
                            this.zzk.zzq().zzw().zza("Marking event as conversion", (Object)this.zzk.zzi().zza(zzjl22.zzd()));
                            zzjl22.zza(zzcd.zze.zzm().zza("_c").zza(1L));
                        }
                        if (!bl5) {
                            this.zzk.zzq().zzw().zza("Marking event as real-time", (Object)this.zzk.zzi().zza(zzjl22.zzd()));
                            zzjl22.zza(zzcd.zze.zzm().zza("_r").zza(1L));
                        }
                        bl = true;
                        if (this.zze().zza((long)this.zzy(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zze > (long)this.zzk.zza().zzc(zza2.zza.zzx())) {
                            zzkl.zza(zzjl22, "_r");
                            bl = bl3;
                        }
                        if (zzkv.zza((String)zzjl22.zzd()) && n5 != 0 && this.zze().zza((long)this.zzy(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzc > (long)this.zzk.zza().zzb(zza2.zza.zzx(), zzas.zzm)) {
                            this.zzk.zzq().zzh().zza("Too many conversions. Not logging as conversion. appId", zzeq.zza((String)zza2.zza.zzx()));
                            boolean bl6 = false;
                            zzcd.zze.zza zza3 = null;
                            int n6 = -1;
                            for (int i = 0; i < zzjl22.zzb(); ++i) {
                                zzcd.zze zze3 = zzjl22.zza(i);
                                if ("_c".equals(zze3.zzb())) {
                                    zza3 = (zzcd.zze.zza)zze3.zzbo();
                                    n6 = i;
                                    continue;
                                }
                                if (!"_err".equals(zze3.zzb())) continue;
                                bl6 = true;
                            }
                            if (bl6 && zza3 != null) {
                                zzjl22.zzb(n6);
                            } else if (zza3 != null) {
                                zzcd.zze zze4 = (zzcd.zze)((zzhy)((zzcd.zze.zza)((zzhy.zzb)zza3.clone())).zza("_err").zza(10L).zzy());
                                zzjl22.zza(n6, zze4);
                            } else {
                                this.zzk.zzq().zze().zza("Did not find conversion parameter. appId", zzeq.zza((String)zza2.zza.zzx()));
                            }
                        }
                    }
                    if (n5 != 0) {
                        int n7;
                        object3 = zzjl22;
                        object2 = this;
                        zzjl4 = new ArrayList<zzcd.zze>(((zzcd.zzc.zza)((Object)object3)).zza());
                        int hashMap = -1;
                        int n9 = -1;
                        for (n7 = 0; n7 < zzjl4.size(); ++n7) {
                            if ("value".equals(((zzcd.zze)((Object)zzjl4.get(n7))).zzb())) {
                                hashMap = n7;
                                continue;
                            }
                            if (!"currency".equals(((zzcd.zze)((Object)zzjl4.get(n7))).zzb())) continue;
                            n9 = n7;
                        }
                        if (hashMap != -1) {
                            if (!((zzcd.zze)((Object)zzjl4.get(hashMap))).zze() && !((zzcd.zze)((Object)zzjl4.get(hashMap))).zzi()) {
                                ((zzkl)object2).zzk.zzq().zzj().zza("Value must be specified with a numeric type.");
                                ((zzcd.zzc.zza)((Object)object3)).zzb(hashMap);
                                zzkl.zza((zzcd.zzc.zza)((Object)object3), "_c");
                                zzkl.zza((zzcd.zzc.zza)((Object)object3), 18, "value");
                            } else {
                                n7 = 0;
                                if (n9 == -1) {
                                    n7 = 1;
                                } else {
                                    object4 = ((zzcd.zze)((Object)zzjl4.get(n9))).zzd();
                                    if (((String)object4).length() != 3) {
                                        n7 = 1;
                                    } else {
                                        int n10;
                                        for (int i = 0; i < ((String)object4).length(); i += Character.charCount(n10)) {
                                            n10 = ((String)object4).codePointAt(i);
                                            if (Character.isLetter(n10)) continue;
                                            n7 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n7 != 0) {
                                    ((zzkl)object2).zzk.zzq().zzj().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    ((zzcd.zzc.zza)((Object)object3)).zzb(hashMap);
                                    zzkl.zza((zzcd.zzc.zza)((Object)object3), "_c");
                                    zzkl.zza((zzcd.zzc.zza)((Object)object3), 19, "currency");
                                }
                            }
                        }
                    }
                    if (this.zzk.zza().zze(zza2.zza.zzx(), zzas.zzas)) {
                        if ("_e".equals(zzjl22.zzd())) {
                            this.zzh();
                            if (zzkr.zza((zzcd.zzc)((zzhy)zzjl22.zzy()), "_fr") == null) {
                                if (zza5 != null && Math.abs(zza5.zzf() - zzjl22.zzf()) <= 1000L) {
                                    zzcd.zzc.zza l13 = (zzcd.zzc.zza)((zzhy.zzb)zza5.clone());
                                    if (this.zza(zzjl22, l13)) {
                                        zzjl3 = null;
                                        zza5 = null;
                                        zza4.zza(n4, l13);
                                    } else {
                                        zzjl3 = zzjl22;
                                        n3 = n2;
                                    }
                                } else {
                                    zzjl3 = zzjl22;
                                    n3 = n2;
                                }
                            }
                        } else if ("_vs".equals(zzjl22.zzd())) {
                            this.zzh();
                            if (zzkr.zza((zzcd.zzc)((zzhy)zzjl22.zzy()), "_et") == null) {
                                if (zzjl3 != null && Math.abs(zzjl3.zzf() - zzjl22.zzf()) <= 1000L) {
                                    zzcd.zzc.zza zzb2 = (zzcd.zzc.zza)((zzhy.zzb)zzjl3.clone());
                                    if (this.zza(zzb2, zzjl22)) {
                                        zzjl3 = null;
                                        zza5 = null;
                                        zza4.zza(n3, zzb2);
                                    } else {
                                        zza5 = zzjl22;
                                        n4 = n2;
                                    }
                                } else {
                                    zza5 = zzjl22;
                                    n4 = n2;
                                }
                            }
                        } else if (this.zzk.zza().zze(zza2.zza.zzx(), zzas.zzbl) && "_ab".equals(zzjl22.zzd())) {
                            this.zzh();
                            if (zzkr.zza((zzcd.zzc)((zzhy)zzjl22.zzy()), "_et") == null && zzjl3 != null && Math.abs(zzjl3.zzf() - zzjl22.zzf()) <= 4000L) {
                                String string4;
                                zzcd.zzc.zza zza6 = (zzcd.zzc.zza)((zzhy.zzb)zzjl3.clone());
                                this.zzb(zza6, zzjl22);
                                zzjl4 = zzjl22;
                                object3 = zza6;
                                object2 = this;
                                Preconditions.checkArgument((boolean)"_e".equals(((zzcd.zzc.zza)((Object)object3)).zzd()));
                                ((zzkl)object2).zzh();
                                zzcd.zze i = zzkr.zza((zzcd.zzc)((zzhy)object3.zzy()), "_sn");
                                ((zzkl)object2).zzh();
                                zzcd.zze zze6 = zzkr.zza((zzcd.zzc)((zzhy)object3.zzy()), "_sc");
                                ((zzkl)object2).zzh();
                                zzcd.zze zze5 = zzkr.zza((zzcd.zzc)((zzhy)object3.zzy()), "_si");
                                object4 = i != null ? i.zzd() : "";
                                if (!TextUtils.isEmpty((CharSequence)object4)) {
                                    ((zzkl)object2).zzh();
                                    zzkr.zza(zzjl4, "_sn", object4);
                                }
                                if (!TextUtils.isEmpty((CharSequence)(string4 = zze6 != null ? zze6.zzd() : ""))) {
                                    ((zzkl)object2).zzh();
                                    zzkr.zza(zzjl4, "_sc", string4);
                                }
                                if (zze5 != null) {
                                    ((zzkl)object2).zzh();
                                    zzkr.zza(zzjl4, "_si", zze5.zzf());
                                }
                                zzjl3 = null;
                                zza4.zza(n3, zza6);
                            }
                        }
                    }
                    if (!bl2 && "_e".equals(zzjl22.zzd())) {
                        if (zzjl22.zzb() == 0) {
                            this.zzk.zzq().zzh().zza("Engagement event does not contain any parameters. appId", zzeq.zza((String)zza2.zza.zzx()));
                        } else {
                            this.zzh();
                            Long l2 = (Long)zzkr.zzb((zzcd.zzc)((zzhy)zzjl22.zzy()), "_et");
                            if (l2 == null) {
                                this.zzk.zzq().zzh().zza("Engagement event does not include duration. appId", zzeq.zza((String)zza2.zza.zzx()));
                            } else {
                                l5 += l2.longValue();
                            }
                        }
                    }
                    zza2.zzc.set(n, (zzcd.zzc)((zzhy)zzjl22.zzy()));
                    ++n2;
                    zza4.zza(zzjl22);
                }
                if (bl2) {
                    for (n = 0; n < n2; ++n) {
                        Long l3;
                        zzcd.zzc zzc2 = zza4.zzb(n);
                        if ("_e".equals(zzc2.zzc())) {
                            this.zzh();
                            if (zzkr.zza(zzc2, "_fr") != null) {
                                zza4.zzc(n);
                                --n2;
                                --n;
                                continue;
                            }
                        }
                        this.zzh();
                        zzcd.zze string6 = zzkr.zza(zzc2, "_et");
                        if (string6 == null || (l3 = string6.zze() ? Long.valueOf(string6.zzf()) : null) == null || l3 <= 0L) continue;
                        l5 += l3.longValue();
                    }
                }
                this.zza(zza4, l5, false);
                n = 0;
                for (zzcd.zzc zzc2 : zza4.zza()) {
                    if (!"_s".equals(zzc2.zzc())) continue;
                    n = 1;
                    break;
                }
                if (n != 0) {
                    this.zze().zzb(zza4.zzj(), "_se");
                }
                if (zzkr.zza(zza4, "_sid") >= 0) {
                    this.zza(zza4, l5, true);
                } else {
                    int n8 = zzkr.zza(zza4, "_se");
                    if (n8 >= 0) {
                        zza4.zze(n8);
                        this.zzk.zzq().zze().zza("Session engagement user property is in the bundle without session ID. appId", zzeq.zza((String)zza2.zza.zzx()));
                    }
                }
                object3 = zza4;
                object2 = this.zzh();
                object2.zzq().zzw().zza("Checking account type status for ad personalization signals");
                if (((zzkj)((Object)object2)).zzj().zze(((zzcd.zzg.zza)((Object)object3)).zzj()) && (zzf2 = ((zzkj)((Object)object2)).zzi().zzb(((zzcd.zzg.zza)((Object)object3)).zzj())) != null && zzf2.zzaf() && object2.zzk().zzi()) {
                    object2.zzq().zzv().zza("Turning off ad personalization due to account type");
                    zzcd.zzk sQLiteException = (zzcd.zzk)((zzhy)zzcd.zzk.zzj().zza("_npa").zza(object2.zzk().zzg()).zzb(1L).zzy());
                    boolean bl8 = false;
                    for (int i = 0; i < ((zzcd.zzg.zza)((Object)object3)).zze(); ++i) {
                        if (!"_npa".equals(((zzcd.zzg.zza)((Object)object3)).zzd(i).zzc())) continue;
                        ((zzcd.zzg.zza)((Object)object3)).zza(i, sQLiteException);
                        bl8 = true;
                        break;
                    }
                    if (!bl8) {
                        ((zzcd.zzg.zza)((Object)object3)).zza(sQLiteException);
                    }
                }
                object2 = zza4;
                ((zzcd.zzg.zza)((Object)object2)).zzb(Long.MAX_VALUE).zzc(Long.MIN_VALUE);
                for (int i = 0; i < ((zzcd.zzg.zza)((Object)object2)).zzb(); ++i) {
                    zzcd.zzc zzc3 = ((zzcd.zzg.zza)((Object)object2)).zzb(i);
                    if (zzc3.zze() < ((zzcd.zzg.zza)((Object)object2)).zzf()) {
                        ((zzcd.zzg.zza)((Object)object2)).zzb(zzc3.zze());
                    }
                    if (zzc3.zze() <= ((zzcd.zzg.zza)((Object)object2)).zzg()) continue;
                    ((zzcd.zzg.zza)((Object)object2)).zzc(zzc3.zze());
                }
                if (zzoz.zzb() && this.zzk.zza().zze(zza4.zzj(), zzas.zzcf)) {
                    zza4.zzq();
                }
                zza4.zzp().zzc(this.zzf().zza(zza4.zzj(), zza4.zza(), zza4.zzd(), zza4.zzf(), zza4.zzg()));
                if (this.zzk.zza().zzi(zza2.zza.zzx())) {
                    zza zza10 = zza2;
                    object3 = zza4;
                    object2 = this;
                    HashMap<Object, String> hashMap = new HashMap<Object, String>();
                    ArrayList<zzcd.zzc> arrayList = new ArrayList<zzcd.zzc>();
                    SecureRandom secureRandom = ((zzkl)object2).zzk.zzh().zzg();
                    for (int i = 0; i < ((zzcd.zzg.zza)((Object)object3)).zzb(); ++i) {
                        boolean bl7;
                        int n12;
                        long l8;
                        long l9;
                        zzcd.zzc.zza zza11;
                        block159: {
                            zza11 = (zzcd.zzc.zza)((zzcd.zzg.zza)((Object)object3)).zzb(i).zzbo();
                            if (zza11.zzd().equals("_ep")) {
                                ((zzkl)object2).zzh();
                                object = (String)zzkr.zzb((zzcd.zzc)((zzhy)zza11.zzy()), "_en");
                                string2 = (zzam)hashMap.get(object);
                                if (string2 == null) {
                                    string2 = ((zzkl)object2).zze().zza(zza10.zza.zzx(), (String)object);
                                    hashMap.put(object, string2);
                                }
                                if (((zzam)string2).zzi == null) {
                                    if (((zzam)string2).zzj > 1L) {
                                        ((zzkl)object2).zzh();
                                        zzkr.zza(zza11, "_sr", ((zzam)string2).zzj);
                                    }
                                    if (((zzam)string2).zzk != null && ((zzam)string2).zzk.booleanValue()) {
                                        ((zzkl)object2).zzh();
                                        zzkr.zza(zza11, "_efs", 1L);
                                    }
                                    arrayList.add((zzcd.zzc)((zzhy)zza11.zzy()));
                                }
                                ((zzcd.zzg.zza)((Object)object3)).zza(i, zza11);
                                continue;
                            }
                            l9 = ((zzkl)object2).zzc().zzf(zza10.zza.zzx());
                            ((zzkl)object2).zzk.zzh();
                            l8 = zzkv.zza((long)zza11.zzf(), (long)l9);
                            n12 = 1;
                            Long l4 = 1L;
                            String string3 = "_dbg";
                            zzcd.zzc zzc4 = (zzcd.zzc)((zzhy)zza11.zzy());
                            if (TextUtils.isEmpty((CharSequence)string3) || l4 == null) {
                                bl7 = false;
                            } else {
                                for (zzcd.zze zze6 : zzc4.zza()) {
                                    if (!string3.equals(zze6.zzb())) continue;
                                    bl7 = l4 instanceof Long && ((Object)l4).equals(zze6.zzf()) || l4 instanceof String && ((Object)l4).equals(zze6.zzd()) || l4 instanceof Double && ((Object)l4).equals(zze6.zzj());
                                    break block159;
                                }
                                bl7 = false;
                            }
                        }
                        if (!bl7) {
                            n12 = ((zzkl)object2).zzc().zzd(zza10.zza.zzx(), zza11.zzd());
                        }
                        if (n12 <= 0) {
                            ((zzkl)object2).zzk.zzq().zzh().zza("Sample rate must be positive. event, rate", (Object)zza11.zzd(), (Object)n12);
                            arrayList.add((zzcd.zzc)((zzhy)zza11.zzy()));
                            ((zzcd.zzg.zza)((Object)object3)).zza(i, zza11);
                            continue;
                        }
                        stringArray = (String[])hashMap.get(zza11.zzd());
                        if (stringArray == null && (stringArray = ((zzkl)object2).zze().zza(zza10.zza.zzx(), zza11.zzd())) == null) {
                            ((zzkl)object2).zzk.zzq().zzh().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)zza10.zza.zzx(), (Object)zza11.zzd());
                            stringArray = new zzam(zza10.zza.zzx(), zza11.zzd(), 1L, 1L, 1L, zza11.zzf(), 0L, null, null, null, null);
                        }
                        ((zzkl)object2).zzh();
                        Long l11 = (Long)zzkr.zzb((zzcd.zzc)((zzhy)zza11.zzy()), "_eid");
                        Boolean bl8 = l11 != null;
                        if (n12 == 1) {
                            arrayList.add((zzcd.zzc)((zzhy)zza11.zzy()));
                            if (bl8.booleanValue() && (stringArray.zzi != null || stringArray.zzj != null || stringArray.zzk != null)) {
                                stringArray = stringArray.zza(null, null, null);
                                hashMap.put(zza11.zzd(), (String)stringArray);
                            }
                            ((zzcd.zzg.zza)((Object)object3)).zza(i, zza11);
                            continue;
                        }
                        if (secureRandom.nextInt(n12) == 0) {
                            ((zzkl)object2).zzh();
                            zzkr.zza(zza11, "_sr", n12);
                            arrayList.add((zzcd.zzc)((zzhy)zza11.zzy()));
                            if (bl8.booleanValue()) {
                                stringArray = stringArray.zza(null, Long.valueOf(n12), null);
                            }
                            hashMap.put(zza11.zzd(), (String)stringArray.zza(zza11.zzf(), l8));
                        } else {
                            long l12;
                            if (stringArray.zzh != null) {
                                l12 = stringArray.zzh;
                            } else {
                                ((zzkl)object2).zzk.zzh();
                                l12 = zzkv.zza((long)zza11.zzg(), (long)l9);
                            }
                            if (l12 != l8) {
                                ((zzkl)object2).zzh();
                                zzkr.zza(zza11, "_efs", 1L);
                                ((zzkl)object2).zzh();
                                zzkr.zza(zza11, "_sr", n12);
                                arrayList.add((zzcd.zzc)((zzhy)zza11.zzy()));
                                if (bl8.booleanValue()) {
                                    stringArray = stringArray.zza(null, Long.valueOf(n12), Boolean.valueOf(true));
                                }
                                hashMap.put(zza11.zzd(), (String)stringArray.zza(zza11.zzf(), l8));
                            } else if (bl8.booleanValue()) {
                                hashMap.put(zza11.zzd(), (String)stringArray.zza(l11, null, null));
                            }
                        }
                        ((zzcd.zzg.zza)((Object)object3)).zza(i, zza11);
                    }
                    if (arrayList.size() < ((zzcd.zzg.zza)((Object)object3)).zzb()) {
                        ((zzcd.zzg.zza)((Object)object3)).zzc().zza(arrayList);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        ((zzkl)object2).zze().zza((zzam)entry.getValue());
                    }
                }
                String string4 = zza2.zza.zzx();
                zzf zzf3 = this.zze().zzb(string4);
                if (zzf3 == null) {
                    this.zzk.zzq().zze().zza("Bundling raw events w/o app info. appId", zzeq.zza((String)zza2.zza.zzx()));
                } else if (zza4.zzb() > 0) {
                    long l6 = zzf3.zzk();
                    if (l6 != 0L) {
                        zza4.zze(l6);
                    } else {
                        zza4.zzi();
                    }
                    long l7 = zzf3.zzj();
                    if (l7 == 0L) {
                        l7 = l6;
                    }
                    if (l7 != 0L) {
                        zza4.zzd(l7);
                    } else {
                        zza4.zzh();
                    }
                    zzf3.zzv();
                    zza4.zzg((int)zzf3.zzs());
                    zzf3.zza(zza4.zzf());
                    zzf3.zzb(zza4.zzg());
                    String string5 = zzf3.zzad();
                    if (string5 != null) {
                        zza4.zzj(string5);
                    } else {
                        zza4.zzn();
                    }
                    this.zze().zza(zzf3);
                }
                if (zza4.zzb() > 0) {
                    zzca.zzb zzb2 = this.zzc().zza(zza2.zza.zzx());
                    if (zzb2 == null || !zzb2.zza()) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zza.zzam())) {
                            zza4.zzi(-1L);
                        } else {
                            this.zzk.zzq().zzh().zza("Did not find measurement config or missing version info. appId", zzeq.zza((String)zza2.zza.zzx()));
                        }
                    } else {
                        zza4.zzi(zzb2.zzb());
                    }
                    this.zze().zza((zzcd.zzg)((zzhy)zza4.zzy()), bl);
                }
                object3 = zza2.zzb;
                object2 = this.zze();
                Preconditions.checkNotNull((Object)object3);
                object2.zzc();
                ((zzki)((Object)object2)).zzaj();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (int i = 0; i < object3.size(); ++i) {
                    if (i != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((Long)object3.get(i));
                }
                stringBuilder.append(")");
                int n13 = ((zzaf)((Object)object2)).c_().delete("raw_events", stringBuilder.toString(), null);
                if (n13 != object3.size()) {
                    object2.zzq().zze().zza("Deleted fewer rows from raw events table than expected", (Object)n13, (Object)object3.size());
                }
                object3 = string4;
                object2 = this.zze();
                stringBuilder = ((zzaf)((Object)object2)).c_();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object3, object3});
                }
                catch (SQLiteException sQLiteException) {
                    object2.zzq().zze().zza("Failed to remove unused event metadata. appId", zzeq.zza((String)object3), (Object)sQLiteException);
                }
                this.zze().b_();
                return true;
            }
            this.zze().b_();
            return false;
        }
        finally {
            this.zze().zzg();
        }
    }

    @VisibleForTesting
    private final void zza(zzcd.zzg.zza zza2, long l, boolean bl) {
        zzkw zzkw2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzkw2 = (zzkw2 = this.zze().zzc(zza2.zzj(), string)) == null || zzkw2.zze == null ? new zzkw(zza2.zzj(), "auto", string, this.zzk.zzl().currentTimeMillis(), (Object)l) : new zzkw(zza2.zzj(), "auto", string, this.zzk.zzl().currentTimeMillis(), (Object)((Long)zzkw2.zze + l));
        zzcd.zzk zzk2 = (zzcd.zzk)((zzhy)zzcd.zzk.zzj().zza(string).zza(this.zzk.zzl().currentTimeMillis()).zzb((Long)zzkw2.zze).zzy());
        boolean bl2 = false;
        int n = zzkr.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzk2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzk2);
        }
        if (l > 0L) {
            this.zze().zza(zzkw2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzk.zzq().zzw().zza("Updated engagement user property. scope, value", (Object)string2, zzkw2.zze);
        }
    }

    private final boolean zza(zzcd.zzc.zza zza2, zzcd.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzd()));
        this.zzh();
        zzcd.zze zze2 = zzkr.zza((zzcd.zzc)((zzhy)zza2.zzy()), "_sc");
        String string = zze2 == null ? null : zze2.zzd();
        this.zzh();
        zzcd.zze zze3 = zzkr.zza((zzcd.zzc)((zzhy)zza3.zzy()), "_pc");
        String string2 = zze3 == null ? null : zze3.zzd();
        if (string2 != null && string2.equals(string)) {
            this.zzb(zza2, zza3);
            return true;
        }
        return false;
    }

    private final void zzb(zzcd.zzc.zza zza2, zzcd.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzd()));
        this.zzh();
        zzcd.zze zze2 = zzkr.zza((zzcd.zzc)((zzhy)zza2.zzy()), "_et");
        if (!zze2.zze() || zze2.zzf() <= 0L) {
            return;
        }
        long l = zze2.zzf();
        this.zzh();
        zze2 = zzkr.zza((zzcd.zzc)((zzhy)zza3.zzy()), "_et");
        if (zze2 != null && zze2.zzf() > 0L) {
            l += zze2.zzf();
        }
        this.zzh();
        zzkr.zza(zza3, "_et", l);
        this.zzh();
        zzkr.zza(zza2, "_fr", 1L);
    }

    @VisibleForTesting
    private static void zza(zzcd.zzc.zza zza2, @NonNull String string) {
        List<zzcd.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzb())) continue;
            zza2.zzb(i);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzcd.zzc.zza zza2, int n, String string) {
        List<zzcd.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzb())) continue;
            return;
        }
        zzcd.zze zze2 = (zzcd.zze)((zzhy)zzcd.zze.zzm().zza("_err").zza(n).zzy());
        zzcd.zze zze3 = (zzcd.zze)((zzhy)zzcd.zze.zzm().zza("_ev").zzb(string).zzy());
        zza2.zza(zze2).zza(zze3);
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzx();
        this.zzn();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzw;
            this.zzw = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzk.zzb().zzc.zza(this.zzk.zzl().currentTimeMillis());
                    this.zzk.zzb().zzd.zza(0L);
                    this.zzab();
                    this.zzk.zzq().zzw().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zze().zze();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzaf zzaf2 = this.zze();
                                zzaf2.zzc();
                                zzaf2.zzaj();
                                SQLiteDatabase sQLiteDatabase = zzaf2.c_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzaf2.zzq().zze().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzx != null && this.zzx.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zze().b_();
                    }
                    finally {
                        this.zze().zzg();
                    }
                    this.zzx = null;
                    if (this.zzd().zze() && this.zzaa()) {
                        this.zzo();
                    } else {
                        this.zzy = -1L;
                        this.zzab();
                    }
                    this.zzn = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzk.zzq().zze().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzn = this.zzk.zzl().elapsedRealtime();
                    this.zzk.zzq().zzw().zza("Disable upload, time", (Object)this.zzn);
                }
            } else {
                this.zzk.zzq().zzw().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzk.zzb().zzd.zza(this.zzk.zzl().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzk.zzb().zze.zza(this.zzk.zzl().currentTimeMillis());
                }
                this.zze().zza(list);
                this.zzab();
            }
            return;
        }
        finally {
            this.zzs = false;
            this.zzac();
        }
    }

    private final boolean zzaa() {
        this.zzx();
        this.zzn();
        return this.zze().zzx() || !TextUtils.isEmpty((CharSequence)this.zze().d_());
    }

    @WorkerThread
    private final void zza(zzf zzf2) {
        this.zzx();
        if (zznv.zzb() && this.zzk.zza().zze(zzf2.zzc(), zzas.zzbi)) {
            if (TextUtils.isEmpty((CharSequence)zzf2.zze()) && TextUtils.isEmpty((CharSequence)zzf2.zzg()) && TextUtils.isEmpty((CharSequence)zzf2.zzf())) {
                this.zza(zzf2.zzc(), 204, null, null, null);
                return;
            }
        } else if (TextUtils.isEmpty((CharSequence)zzf2.zze()) && TextUtils.isEmpty((CharSequence)zzf2.zzf())) {
            this.zza(zzf2.zzc(), 204, null, null, null);
            return;
        }
        String string = this.zzk.zza().zza(zzf2);
        try {
            URL uRL = new URL(string);
            this.zzk.zzq().zzw().zza("Fetching remote configuration", (Object)zzf2.zzc());
            zzca.zzb zzb2 = this.zzc().zza(zzf2.zzc());
            ArrayMap arrayMap = null;
            String string2 = this.zzc().zzb(zzf2.zzc());
            if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string2)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string2);
            }
            this.zzr = true;
            zzkm zzkm2 = new zzkm(this);
            ArrayMap arrayMap2 = arrayMap;
            URL uRL2 = uRL;
            String string3 = zzf2.zzc();
            zzex zzex2 = this.zzd();
            zzex2.zzc();
            zzex2.zzaj();
            Preconditions.checkNotNull((Object)uRL2);
            Preconditions.checkNotNull((Object)zzkm2);
            zzex2.zzp().zzc((Runnable)new zzfb(zzex2, string3, uRL2, null, (Map)arrayMap2, zzkm2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzk.zzq().zze().zza("Failed to parse config URL. Not fetching. appId", zzeq.zza((String)zzf2.zzc()), (Object)string);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzx();
        this.zzn();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzk.zzq().zzw().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zze().zze();
            try {
                boolean bl;
                zzf zzf2 = this.zze().zzb(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzf2 == null) {
                    this.zzk.zzq().zzh().zza("App does not exist in onConfigFetched. appId", zzeq.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzc().zza(string) == null && !this.zzc().zza(string, null, null) : !this.zzc().zza(string, byArray, string2)) {
                        return;
                    }
                    zzf2.zzh(this.zzk.zzl().currentTimeMillis());
                    this.zze().zza(zzf2);
                    if (n == 404) {
                        this.zzk.zzq().zzj().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzk.zzq().zzw().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzd().zze() && this.zzaa()) {
                        this.zzo();
                    } else {
                        this.zzab();
                    }
                } else {
                    zzf2.zzi(this.zzk.zzl().currentTimeMillis());
                    this.zze().zza(zzf2);
                    this.zzk.zzq().zzw().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzc().zzc(string);
                    this.zzk.zzb().zzd.zza(this.zzk.zzl().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzk.zzb().zze.zza(this.zzk.zzl().currentTimeMillis());
                    }
                    this.zzab();
                }
                this.zze().b_();
            }
            finally {
                this.zze().zzg();
            }
            return;
        }
        finally {
            this.zzr = false;
            this.zzac();
        }
    }

    @WorkerThread
    private final void zzab() {
        long l;
        long l2;
        long l3;
        block14: {
            String string;
            this.zzx();
            this.zzn();
            if (this.zzn > 0L) {
                l3 = this.zzk.zzl().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzn);
                if (l2 > 0L) {
                    this.zzk.zzq().zzw().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzv().zzb();
                    this.zzw().zze();
                    return;
                }
                this.zzn = 0L;
            }
            if (!this.zzk.zzaf() || !this.zzaa()) {
                this.zzk.zzq().zzw().zza("Nothing to upload or uploading impossible");
                this.zzv().zzb();
                this.zzw().zze();
                return;
            }
            zzkl zzkl2 = this;
            long l4 = zzkl2.zzk.zzl().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzas.zzz.zza(null));
            boolean bl = zzkl2.zze().zzy() || zzkl2.zze().e_();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzkl2.zzk.zza().zzw())) && !".none.".equals(string) ? Math.max(0L, (Long)zzas.zzu.zza(null)) : Math.max(0L, (Long)zzas.zzt.zza(null))) : Math.max(0L, (Long)zzas.zzs.zza(null));
            long l7 = zzkl2.zzk.zzb().zzc.zza();
            long l8 = zzkl2.zzk.zzb().zzd.zza();
            long l9 = zzkl2.zze().zzv();
            long l10 = zzkl2.zze().zzw();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzkl2.zzh().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzas.zzab.zza(null))); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzas.zzaa.zza(null)) * l15) <= l8) continue;
                        l = l14;
                        break block14;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzk.zzq().zzw().zza("Next upload time is 0");
            this.zzv().zzb();
            this.zzw().zze();
            return;
        }
        if (!this.zzd().zze()) {
            this.zzk.zzq().zzw().zza("No network");
            this.zzv().zza();
            this.zzw().zze();
            return;
        }
        l2 = this.zzk.zzb().zze.zza();
        long l16 = Math.max(0L, (Long)zzas.zzq.zza(null));
        if (!this.zzh().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzv().zzb();
        long l17 = l3 - this.zzk.zzl().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzas.zzv.zza(null));
            this.zzk.zzb().zzc.zza(this.zzk.zzl().currentTimeMillis());
        }
        this.zzk.zzq().zzw().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzw().zza(l17);
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzx();
        if (this.zzo == null) {
            this.zzo = new ArrayList<Runnable>();
        }
        this.zzo.add(runnable);
    }

    @WorkerThread
    private final void zzac() {
        this.zzx();
        if (this.zzr || this.zzs || this.zzt) {
            this.zzk.zzq().zzw().zza("Not stopping services. fetch, network, upload", (Object)this.zzr, (Object)this.zzs, (Object)this.zzt);
            return;
        }
        this.zzk.zzq().zzw().zza("Stopping uploading service(s)");
        if (this.zzo == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzo.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzo.clear();
    }

    @WorkerThread
    private final Boolean zzb(zzf zzf2) {
        try {
            if (zzf2.zzm() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzk.zzm()).getPackageInfo((String)zzf2.zzc(), (int)0).versionCode;
                if (zzf2.zzm() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzk.zzm()).getPackageInfo((String)zzf2.zzc(), (int)0).versionName;
                if (zzf2.zzl() != null && zzf2.zzl().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @WorkerThread
    final void zzr() {
        int n;
        this.zzx();
        this.zzn();
        if (this.zzm) return;
        this.zzm = true;
        if (!this.zzad()) return;
        int n2 = this.zza(this.zzv);
        int n3 = n = this.zzk.zzx().zzae();
        int n4 = n2;
        zzkl zzkl2 = this;
        zzkl2.zzx();
        if (n4 > n3) {
            zzkl2.zzk.zzq().zze().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zzkl2.zza(n3, zzkl2.zzv)) {
            zzkl2.zzk.zzq().zze().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zzkl2.zzk.zzq().zzw().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzad() {
        this.zzx();
        if (this.zzk.zza().zza(zzas.zzbh) && this.zzu != null && this.zzu.isValid()) {
            this.zzk.zzq().zzw().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzk.zzm().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzv = new RandomAccessFile(file2, "rw").getChannel();
            this.zzu = this.zzv.tryLock();
            if (this.zzu != null) {
                this.zzk.zzq().zzw().zza("Storage concurrent access okay");
                return true;
            }
            this.zzk.zzq().zze().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzk.zzq().zze().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzk.zzq().zze().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzk.zzq().zzh().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzx();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzk.zzq().zze().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzk.zzq().zzh().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzk.zzq().zze().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzx();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzk.zzq().zze().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            if (this.zzk.zza().zza(zzas.zzbr) && Build.VERSION.SDK_INT <= 19) {
                fileChannel.position(0L);
            }
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzk.zzq().zze().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzk.zzq().zze().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(zzn zzn2) {
        if (this.zzw != null) {
            this.zzx = new ArrayList<Long>();
            this.zzx.addAll(this.zzw);
        }
        String string = zzn2.zza;
        zzaf zzaf2 = this.zze();
        Preconditions.checkNotEmpty((String)string);
        zzaf2.zzc();
        zzaf2.zzaj();
        try {
            SQLiteDatabase sQLiteDatabase = zzaf2.c_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("default_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzaf2.zzq().zzw().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzaf2.zzq().zze().zza("Error resetting analytics data. appId, error", zzeq.zza((String)string), (Object)sQLiteException);
        }
        if (zzn2.zzh) {
            this.zzb(zzn2);
        }
    }

    @WorkerThread
    final void zza(zzku zzku2, zzn zzn2) {
        this.zzx();
        this.zzn();
        if (!this.zze(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        int n = this.zzk.zzh().zzb(zzku2.zza);
        if (n != 0) {
            this.zzk.zzh();
            String string = zzkv.zza((String)zzku2.zza, (int)24, (boolean)true);
            int n2 = zzku2.zza != null ? zzku2.zza.length() : 0;
            this.zzk.zzh().zza(this.zzaa, zzn2.zza, n, "_ev", string, n2);
            return;
        }
        n = this.zzk.zzh().zzb(zzku2.zza, zzku2.zza());
        if (n != 0) {
            this.zzk.zzh();
            String string = zzkv.zza((String)zzku2.zza, (int)24, (boolean)true);
            Object object = zzku2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzk.zzh().zza(this.zzaa, zzn2.zza, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzk.zzh().zzc(zzku2.zza, zzku2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzku2.zza)) {
            zzam zzam2;
            zzn zzn3 = zzn2;
            String string = zzku2.zze;
            long l = zzku2.zzb;
            zzkl zzkl2 = this;
            long l2 = 0L;
            zzkw zzkw2 = zzkl2.zze().zzc(zzn3.zza, "_sno");
            if (zzkw2 != null && zzkw2.zze instanceof Long) {
                l2 = (Long)zzkw2.zze;
            } else {
                if (zzkw2 != null) {
                    zzkl2.zzk.zzq().zzh().zza("Retrieved last session number from database does not contain a valid (long) value", zzkw2.zze);
                }
                if ((zzam2 = zzkl2.zze().zza(zzn3.zza, "_s")) != null) {
                    l2 = zzam2.zzc;
                    zzkl2.zzk.zzq().zzw().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzam2 = new zzku("_sno", l, (Object)(++l2), string);
            zzkl2.zza((zzku)zzam2, zzn3);
        }
        zzkw zzkw3 = new zzkw(zzn2.zza, zzku2.zze, zzku2.zza, zzku2.zzb, object);
        this.zzk.zzq().zzw().zza("Setting user property", (Object)this.zzk.zzi().zzc(zzkw3.zzc), object);
        this.zze().zze();
        try {
            this.zzc(zzn2);
            boolean bl = this.zze().zza(zzkw3);
            this.zze().b_();
            if (!bl) {
                this.zzk.zzq().zze().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzk.zzi().zzc(zzkw3.zzc), zzkw3.zze);
                this.zzk.zzh().zza(this.zzaa, zzn2.zza, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zze().zzg();
        }
    }

    @WorkerThread
    final void zzb(zzku zzku2, zzn zzn2) {
        this.zzx();
        this.zzn();
        if (!this.zze(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        if ("_npa".equals(zzku2.zza) && zzn2.zzs != null) {
            this.zzk.zzq().zzv().zza("Falling back to manifest metadata value for ad personalization");
            zzku zzku3 = new zzku("_npa", this.zzk.zzl().currentTimeMillis(), (Object)(zzn2.zzs != false ? 1L : 0L), "auto");
            this.zza(zzku3, zzn2);
            return;
        }
        this.zzk.zzq().zzv().zza("Removing user property", (Object)this.zzk.zzi().zzc(zzku2.zza));
        this.zze().zze();
        try {
            this.zzc(zzn2);
            this.zze().zzb(zzn2.zza, zzku2.zza);
            this.zze().b_();
            this.zzk.zzq().zzv().zza("User property removed", (Object)this.zzk.zzi().zzc(zzku2.zza));
            return;
        }
        finally {
            this.zze().zzg();
        }
    }

    final void zza(zzki zzki2) {
        ++this.zzp;
    }

    final void zzs() {
        ++this.zzq;
    }

    final zzfu zzu() {
        return this.zzk;
    }

    @WorkerThread
    final void zzb(zzn zzn2) {
        this.zzx();
        this.zzn();
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        if (!this.zze(zzn2)) {
            return;
        }
        zzf zzf2 = this.zze().zzb(zzn2.zza);
        if (zzf2 != null && TextUtils.isEmpty((CharSequence)zzf2.zze()) && !TextUtils.isEmpty((CharSequence)zzn2.zzb)) {
            zzf2.zzh(0L);
            this.zze().zza(zzf2);
            this.zzc().zzd(zzn2.zza);
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        long l = zzn2.zzm;
        if (l == 0L) {
            l = this.zzk.zzl().currentTimeMillis();
        }
        this.zzk.zzw().zzh();
        int n = zzn2.zzn;
        if (n != 0 && n != 1) {
            this.zzk.zzq().zzh().zza("Incorrect app type, assuming installed app. appId, appType", zzeq.zza((String)zzn2.zza), (Object)n);
            n = 0;
        }
        this.zze().zze();
        try {
            zzku zzku2;
            zzkw zzkw2 = this.zze().zzc(zzn2.zza, "_npa");
            if (zzkw2 == null || "auto".equals(zzkw2.zzb)) {
                if (zzn2.zzs != null) {
                    zzku2 = new zzku("_npa", l, (Object)(zzn2.zzs != false ? 1L : 0L), "auto");
                    if (zzkw2 == null || !zzkw2.zze.equals(zzku2.zzc)) {
                        this.zza(zzku2, zzn2);
                    }
                } else if (zzkw2 != null) {
                    zzku2 = new zzku("_npa", l, null, "auto");
                    this.zzb(zzku2, zzn2);
                }
            }
            long l2 = l;
            zzn zzn3 = zzn2;
            zzkl zzkl2 = this;
            zzf zzf3 = zzkl2.zze().zzb(zzn3.zza);
            if (zzf3 != null) {
                zzkl2.zzk.zzh();
                if (zzkv.zza((String)zzn3.zzb, (String)zzf3.zze(), (String)zzn3.zzr, (String)zzf3.zzf())) {
                    zzkl2.zzk.zzq().zzh().zza("New GMP App Id passed in. Removing cached database data. appId", zzeq.zza((String)zzf3.zzc()));
                    String string = zzf3.zzc();
                    zzaf zzaf2 = zzkl2.zze();
                    zzaf2.zzaj();
                    zzaf2.zzc();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzaf2.c_();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("consent_settings", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzaf2.zzq().zzw().zza("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzaf2.zzq().zze().zza("Error deleting application data. appId, error", zzeq.zza((String)string), (Object)sQLiteException);
                    }
                    zzf3 = null;
                }
            }
            if (zzf3 != null && (zzf3.zzm() != Integer.MIN_VALUE && zzf3.zzm() != zzn3.zzj) | (zzf3.zzm() == Integer.MIN_VALUE && zzf3.zzl() != null && !zzf3.zzl().equals(zzn3.zzc))) {
                Bundle bundle = new Bundle();
                bundle.putString("_pv", zzf3.zzl());
                zzaq zzaq2 = new zzaq("_au", new zzap(bundle), "auto", l2);
                zzkl2.zza(zzaq2, zzn3);
            }
            this.zzc(zzn2);
            zzku2 = null;
            if (n == 0) {
                zzku2 = this.zze().zza(zzn2.zza, "_f");
            } else if (n == 1) {
                zzku2 = this.zze().zza(zzn2.zza, "_v");
            }
            if (zzku2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    PackageInfo packageInfo;
                    zzku zzku3 = new zzku("_fot", l, (Object)l3, "auto");
                    this.zza(zzku3, zzn2);
                    zzn3 = zzn2;
                    zzkl2 = this;
                    zzkl2.zzx();
                    zzkl2.zzk.zze().zza(zzn3.zza);
                    l2 = l;
                    zzn3 = zzn2;
                    zzkl2 = this;
                    zzkl2.zzx();
                    zzkl2.zzn();
                    zzf3 = new Bundle();
                    zzf3.putLong("_c", 1L);
                    zzf3.putLong("_r", 1L);
                    zzf3.putLong("_uwa", 0L);
                    zzf3.putLong("_pfo", 0L);
                    zzf3.putLong("_sys", 0L);
                    zzf3.putLong("_sysu", 0L);
                    if (zzkl2.zzk.zza().zze(zzn3.zza, zzas.zzas)) {
                        zzf3.putLong("_et", 1L);
                    }
                    if (zzn3.zzq) {
                        zzf3.putLong("_dac", 1L);
                    }
                    String string = zzn3.zza;
                    zzaf zzaf3 = zzkl2.zze();
                    Preconditions.checkNotEmpty((String)string);
                    zzaf3.zzc();
                    zzaf3.zzaj();
                    long l4 = zzaf3.zzh(string, "first_open_count");
                    if (zzkl2.zzk.zzm().getPackageManager() == null) {
                        zzkl2.zzk.zzq().zze().zza("PackageManager is null, first open report might be inaccurate. appId", zzeq.zza((String)zzn3.zza));
                    } else {
                        packageInfo = null;
                        try {
                            packageInfo = Wrappers.packageManager((Context)zzkl2.zzk.zzm()).getPackageInfo(zzn3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzkl2.zzk.zzq().zze().zza("Package info is null, first open report might be inaccurate. appId", zzeq.zza((String)zzn3.zza), (Object)nameNotFoundException);
                        }
                        if (packageInfo != null && packageInfo.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (packageInfo.firstInstallTime != packageInfo.lastUpdateTime) {
                                if (zzkl2.zzk.zza().zza(zzas.zzbm)) {
                                    if (l4 == 0L) {
                                        zzf3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    zzf3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl = true;
                            }
                            zzku zzku4 = new zzku("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzkl2.zza(zzku4, zzn3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzkl2.zzk.zzm()).getApplicationInfo(zzn3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzkl2.zzk.zzq().zze().zza("Application info is null, first open report might be inaccurate. appId", zzeq.zza((String)zzn3.zza), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzf3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzf3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l4 >= 0L) {
                        zzf3.putLong("_pfo", l4);
                    }
                    packageInfo = new zzaq("_f", new zzap((Bundle)zzf3), "auto", l2);
                    zzkl2.zzb((zzaq)packageInfo, zzn3);
                } else if (n == 1) {
                    zzku zzku5 = new zzku("_fvt", l, (Object)l3, "auto");
                    this.zza(zzku5, zzn2);
                    l2 = l;
                    zzn3 = zzn2;
                    zzkl2 = this;
                    zzkl2.zzx();
                    zzkl2.zzn();
                    zzf3 = new Bundle();
                    zzf3.putLong("_c", 1L);
                    zzf3.putLong("_r", 1L);
                    if (zzkl2.zzk.zza().zze(zzn3.zza, zzas.zzas)) {
                        zzf3.putLong("_et", 1L);
                    }
                    if (zzn3.zzq) {
                        zzf3.putLong("_dac", 1L);
                    }
                    zzaq zzaq3 = new zzaq("_v", new zzap((Bundle)zzf3), "auto", l2);
                    zzkl2.zzb(zzaq3, zzn3);
                }
                if (!this.zzk.zza().zze(zzn2.zza, zzas.zzat)) {
                    l2 = l;
                    zzn3 = zzn2;
                    zzkl2 = this;
                    zzf3 = new Bundle();
                    zzf3.putLong("_et", 1L);
                    if (zzkl2.zzk.zza().zze(zzn3.zza, zzas.zzas)) {
                        zzf3.putLong("_fr", 1L);
                    }
                    zzaq zzaq4 = new zzaq("_e", new zzap((Bundle)zzf3), "auto", l2);
                    zzkl2.zzb(zzaq4, zzn3);
                }
            } else if (zzn2.zzi) {
                l2 = l;
                zzn3 = zzn2;
                zzkl2 = this;
                zzf3 = new Bundle();
                zzaq zzaq5 = new zzaq("_cd", new zzap((Bundle)zzf3), "auto", l2);
                zzkl2.zzb(zzaq5, zzn3);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzg();
        }
    }

    @WorkerThread
    private final zzn zzb(String string) {
        zzf zzf2 = this.zze().zzb(string);
        if (zzf2 == null || TextUtils.isEmpty((CharSequence)zzf2.zzl())) {
            this.zzk.zzq().zzv().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzb(zzf2);
        if (bl != null && !bl.booleanValue()) {
            this.zzk.zzq().zze().zza("App version does not match; dropping. appId", zzeq.zza((String)string));
            return null;
        }
        return new zzn(string, zzf2.zze(), zzf2.zzl(), zzf2.zzm(), zzf2.zzn(), zzf2.zzo(), zzf2.zzp(), null, zzf2.zzr(), false, zzf2.zzi(), zzf2.zzae(), 0L, 0, zzf2.zzaf(), zzf2.zzag(), false, zzf2.zzf(), zzf2.zzah(), zzf2.zzq(), zzf2.zzai(), zznv.zzb() && this.zzk.zza().zze(string, zzas.zzbi) ? zzf2.zzg() : null, zzml.zzb() && this.zzk.zza().zza(zzas.zzci) ? this.zza(string).zza() : "");
    }

    @WorkerThread
    final void zza(zzz zzz2) {
        zzn zzn2 = this.zzb(zzz2.zza);
        if (zzn2 != null) {
            this.zza(zzz2, zzn2);
        }
    }

    @WorkerThread
    final void zza(zzz zzz2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzz2);
        Preconditions.checkNotEmpty((String)zzz2.zza);
        Preconditions.checkNotNull((Object)zzz2.zzb);
        Preconditions.checkNotNull((Object)zzz2.zzc);
        Preconditions.checkNotEmpty((String)zzz2.zzc.zza);
        this.zzx();
        this.zzn();
        if (!this.zze(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        zzz zzz3 = new zzz(zzz2);
        new zzz(zzz2).zze = false;
        this.zze().zze();
        try {
            boolean bl = false;
            zzz zzz4 = this.zze().zzd(zzz3.zza, zzz3.zzc.zza);
            if (zzz4 != null && !zzz4.zzb.equals(zzz3.zzb)) {
                this.zzk.zzq().zzh().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzk.zzi().zzc(zzz3.zzc.zza), (Object)zzz3.zzb, (Object)zzz4.zzb);
            }
            if (zzz4 != null && zzz4.zze) {
                zzz3.zzb = zzz4.zzb;
                zzz3.zzd = zzz4.zzd;
                zzz3.zzh = zzz4.zzh;
                zzz3.zzf = zzz4.zzf;
                zzz3.zzi = zzz4.zzi;
                zzz3.zze = zzz4.zze;
                zzz3.zzc = new zzku(zzz3.zzc.zza, zzz4.zzc.zzb, zzz3.zzc.zza(), zzz4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzz3.zzf)) {
                zzz3.zzc = new zzku(zzz3.zzc.zza, zzz3.zzd, zzz3.zzc.zza(), zzz3.zzc.zze);
                zzz3.zze = true;
                bl = true;
            }
            if (zzz3.zze) {
                zzku zzku2 = zzz3.zzc;
                zzkw zzkw2 = new zzkw(zzz3.zza, zzz3.zzb, zzku2.zza, zzku2.zzb, zzku2.zza());
                if (this.zze().zza(zzkw2)) {
                    this.zzk.zzq().zzv().zza("User property updated immediately", (Object)zzz3.zza, (Object)this.zzk.zzi().zzc(zzkw2.zzc), zzkw2.zze);
                } else {
                    this.zzk.zzq().zze().zza("(2)Too many active user properties, ignoring", zzeq.zza((String)zzz3.zza), (Object)this.zzk.zzi().zzc(zzkw2.zzc), zzkw2.zze);
                }
                if (bl && zzz3.zzi != null) {
                    zzaq zzaq2 = new zzaq(zzz3.zzi, zzz3.zzd);
                    this.zzc(zzaq2, zzn2);
                }
            }
            if (this.zze().zza(zzz3)) {
                this.zzk.zzq().zzv().zza("Conditional property added", (Object)zzz3.zza, (Object)this.zzk.zzi().zzc(zzz3.zzc.zza), zzz3.zzc.zza());
            } else {
                this.zzk.zzq().zze().zza("Too many conditional properties, ignoring", zzeq.zza((String)zzz3.zza), (Object)this.zzk.zzi().zzc(zzz3.zzc.zza), zzz3.zzc.zza());
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzg();
        }
    }

    @WorkerThread
    final void zzb(zzz zzz2) {
        zzn zzn2 = this.zzb(zzz2.zza);
        if (zzn2 != null) {
            this.zzb(zzz2, zzn2);
        }
    }

    @WorkerThread
    final void zzb(zzz zzz2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzz2);
        Preconditions.checkNotEmpty((String)zzz2.zza);
        Preconditions.checkNotNull((Object)zzz2.zzc);
        Preconditions.checkNotEmpty((String)zzz2.zzc.zza);
        this.zzx();
        this.zzn();
        if (!this.zze(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        this.zze().zze();
        try {
            this.zzc(zzn2);
            zzz zzz3 = this.zze().zzd(zzz2.zza, zzz2.zzc.zza);
            if (zzz3 != null) {
                this.zzk.zzq().zzv().zza("Removing conditional user property", (Object)zzz2.zza, (Object)this.zzk.zzi().zzc(zzz2.zzc.zza));
                this.zze().zze(zzz2.zza, zzz2.zzc.zza);
                if (zzz3.zze) {
                    this.zze().zzb(zzz2.zza, zzz2.zzc.zza);
                }
                if (zzz2.zzk != null) {
                    Bundle bundle = null;
                    if (zzz2.zzk.zzb != null) {
                        bundle = zzz2.zzk.zzb.zzb();
                    }
                    zzaq zzaq2 = this.zzk.zzh().zza(zzz2.zza, zzz2.zzk.zza, bundle, zzz3.zzb, zzz2.zzk.zzd, true, false, zzlo.zzb() && this.zzk.zza().zza(zzas.zzcl));
                    this.zzc(zzaq2, zzn2);
                }
            } else {
                this.zzk.zzq().zzh().zza("Conditional user property doesn't exist", zzeq.zza((String)zzz2.zza), (Object)this.zzk.zzi().zzc(zzz2.zzc.zza));
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzg();
        }
    }

    private final zzf zza(zzn zzn2, zzf zzf2, String string) {
        boolean bl = false;
        zzac zzac2 = zzac.zza;
        if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci)) {
            zzac2 = this.zza(zzn2.zza).zzb(zzac.zza((String)zzn2.zzw));
        }
        if (zzf2 == null) {
            zzf2 = new zzf(this.zzk, zzn2.zza);
            if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci)) {
                if (zzac2.zze()) {
                    zzf2.zza(this.zza(zzac2));
                }
                if (zzac2.zzc()) {
                    zzf2.zze(string);
                }
            } else {
                zzf2.zza(this.zzz());
                zzf2.zze(string);
            }
            bl = true;
        } else if (!(zzml.zzb() && this.zzk.zza().zza(zzas.zzci) && !zzac2.zzc() || string.equals(zzf2.zzh()))) {
            zzf2.zze(string);
            if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci)) {
                if (zzac2.zze()) {
                    zzf2.zza(this.zza(zzac2));
                }
            } else {
                zzf2.zza(this.zzz());
            }
            bl = true;
        } else if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci) && TextUtils.isEmpty((CharSequence)zzf2.zzd()) && zzac2.zze()) {
            zzf2.zza(this.zza(zzac2));
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzn2.zzb, (CharSequence)zzf2.zze())) {
            zzf2.zzb(zzn2.zzb);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzn2.zzr, (CharSequence)zzf2.zzf())) {
            zzf2.zzc(zzn2.zzr);
            bl = true;
        }
        if (zznv.zzb() && this.zzk.zza().zze(zzf2.zzc(), zzas.zzbi) && !TextUtils.equals((CharSequence)zzn2.zzv, (CharSequence)zzf2.zzg())) {
            zzf2.zzd(zzn2.zzv);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzk) && !zzn2.zzk.equals(zzf2.zzi())) {
            zzf2.zzf(zzn2.zzk);
            bl = true;
        }
        if (zzn2.zze != 0L && zzn2.zze != zzf2.zzo()) {
            zzf2.zzd(zzn2.zze);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzc) && !zzn2.zzc.equals(zzf2.zzl())) {
            zzf2.zzg(zzn2.zzc);
            bl = true;
        }
        if (zzn2.zzj != zzf2.zzm()) {
            zzf2.zzc(zzn2.zzj);
            bl = true;
        }
        if (zzn2.zzd != null && !zzn2.zzd.equals(zzf2.zzn())) {
            zzf2.zzh(zzn2.zzd);
            bl = true;
        }
        if (zzn2.zzf != zzf2.zzp()) {
            zzf2.zze(zzn2.zzf);
            bl = true;
        }
        if (zzn2.zzh != zzf2.zzr()) {
            zzf2.zza(zzn2.zzh);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzg) && !zzn2.zzg.equals(zzf2.zzac())) {
            zzf2.zzi(zzn2.zzg);
            bl = true;
        }
        if (!this.zzk.zza().zza(zzas.zzbx) && zzn2.zzl != zzf2.zzae()) {
            zzf2.zzp(zzn2.zzl);
            bl = true;
        }
        if (zzn2.zzo != zzf2.zzaf()) {
            zzf2.zzb(zzn2.zzo);
            bl = true;
        }
        if (zzn2.zzp != zzf2.zzag()) {
            zzf2.zzc(zzn2.zzp);
            bl = true;
        }
        if (zzn2.zzs != zzf2.zzah()) {
            zzf2.zza(zzn2.zzs);
            bl = true;
        }
        if (zzn2.zzt != 0L && zzn2.zzt != zzf2.zzq()) {
            zzf2.zzf(zzn2.zzt);
            bl = true;
        }
        if (bl) {
            this.zze().zza(zzf2);
        }
        return zzf2;
    }

    @WorkerThread
    final zzf zzc(zzn zzn2) {
        this.zzx();
        this.zzn();
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        zzf zzf2 = this.zze().zzb(zzn2.zza);
        zzac zzac2 = zzac.zza;
        if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci)) {
            zzac2 = this.zza(zzn2.zza).zzb(zzac.zza((String)zzn2.zzw));
        }
        String string = !zzml.zzb() || !this.zzk.zza().zza(zzas.zzci) || zzac2.zzc() ? this.zzj.zza(zzn2.zza) : "";
        if (zzne.zzb() && this.zzk.zza().zza(zzas.zzbn)) {
            if (zzf2 == null) {
                zzf2 = new zzf(this.zzk, zzn2.zza);
                if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci)) {
                    if (zzac2.zze()) {
                        zzf2.zza(this.zza(zzac2));
                    }
                    if (zzac2.zzc()) {
                        zzf2.zze(string);
                    }
                } else {
                    zzf2.zza(this.zzz());
                    zzf2.zze(string);
                }
            } else if (!(zzml.zzb() && this.zzk.zza().zza(zzas.zzci) && !zzac2.zzc() || string.equals(zzf2.zzh()))) {
                zzf2.zze(string);
                if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci)) {
                    zzf2.zza(this.zza(zzac2));
                } else {
                    zzf2.zza(this.zzz());
                }
            } else if (zzml.zzb() && this.zzk.zza().zza(zzas.zzci) && TextUtils.isEmpty((CharSequence)zzf2.zzd()) && zzac2.zze()) {
                zzf2.zza(this.zza(zzac2));
            }
            zzf2.zzb(zzn2.zzb);
            zzf2.zzc(zzn2.zzr);
            if (zznv.zzb() && this.zzk.zza().zze(zzf2.zzc(), zzas.zzbi)) {
                zzf2.zzd(zzn2.zzv);
            }
            if (!TextUtils.isEmpty((CharSequence)zzn2.zzk)) {
                zzf2.zzf(zzn2.zzk);
            }
            if (zzn2.zze != 0L) {
                zzf2.zzd(zzn2.zze);
            }
            if (!TextUtils.isEmpty((CharSequence)zzn2.zzc)) {
                zzf2.zzg(zzn2.zzc);
            }
            zzf2.zzc(zzn2.zzj);
            if (zzn2.zzd != null) {
                zzf2.zzh(zzn2.zzd);
            }
            zzf2.zze(zzn2.zzf);
            zzf2.zza(zzn2.zzh);
            if (!TextUtils.isEmpty((CharSequence)zzn2.zzg)) {
                zzf2.zzi(zzn2.zzg);
            }
            if (!this.zzk.zza().zza(zzas.zzbx)) {
                zzf2.zzp(zzn2.zzl);
            }
            zzf2.zzb(zzn2.zzo);
            zzf2.zzc(zzn2.zzp);
            zzf2.zza(zzn2.zzs);
            zzf2.zzf(zzn2.zzt);
            if (zzf2.zza()) {
                this.zze().zza(zzf2);
            }
            return zzf2;
        }
        return this.zza(zzn2, zzf2, string);
    }

    final String zzd(zzn zzn2) {
        Future future = this.zzk.zzp().zza((Callable)new zzkp(this, zzn2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzk.zzq().zze().zza("Failed to get app instance id. appId", zzeq.zza((String)zzn2.zza), (Object)exception);
            return null;
        }
    }

    final void zza(boolean bl) {
        this.zzab();
    }

    private final boolean zze(zzn zzn2) {
        if (zznv.zzb() && this.zzk.zza().zze(zzn2.zza, zzas.zzbi)) {
            return !TextUtils.isEmpty((CharSequence)zzn2.zzb) || !TextUtils.isEmpty((CharSequence)zzn2.zzv) || !TextUtils.isEmpty((CharSequence)zzn2.zzr);
        }
        return !TextUtils.isEmpty((CharSequence)zzn2.zzb) || !TextUtils.isEmpty((CharSequence)zzn2.zzr);
    }

    static /* synthetic */ void zza(zzkl zzkl2, zzks zzks2) {
        zzkl2.zza(zzks2);
    }

    static /* synthetic */ zzfu zza(zzkl zzkl2) {
        return zzkl2.zzk;
    }

    private final class zza
    implements zzah {
        zzcd.zzg zza;
        List<Long> zzb;
        List<zzcd.zzc> zzc;
        private long zzd;

        private zza() {
        }

        @Override
        public final void zza(zzcd.zzg zzg2) {
            Preconditions.checkNotNull((Object)((Object)zzg2));
            this.zza = zzg2;
        }

        @Override
        public final boolean zza(long l, zzcd.zzc zzc2) {
            Preconditions.checkNotNull((Object)((Object)zzc2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzcd.zzc>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (this.zzc.size() > 0 && com.google.android.gms.measurement.internal.zzkl$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzkl$zza.zza(zzc2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzc2.zzbp();
            if (l2 >= (long)Math.max(0, (Integer)zzas.zzh.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzc2);
            this.zzb.add(l);
            return this.zzc.size() < Math.max(1, (Integer)zzas.zzi.zza(null));
        }

        private static long zza(zzcd.zzc zzc2) {
            return zzc2.zze() / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzkk zzkk2) {
            this();
        }
    }
}

