/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzlf;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class zzgh
extends zzec {
    private final zzki zza;
    private Boolean zzb;
    private String zzc;

    public zzgh(zzki zzki2, String string) {
        Preconditions.checkNotNull((Object)zzki2);
        this.zza = zzki2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzh(zzp zzp2) {
        this.zzx(zzp2, false);
        zzfy zzfy2 = new zzfy(this, zzp2);
        this.zzc(zzfy2);
    }

    @BinderThread
    public final void zzu(zzp zzp2) {
        zzlf.zzb();
        if (this.zza.zzd().zzn(null, zzea.zzaw)) {
            Preconditions.checkNotEmpty((String)zzp2.zza);
            Preconditions.checkNotNull((Object)zzp2.zzv);
            zzfz zzfz2 = new zzfz(this, zzp2);
            Preconditions.checkNotNull((Object)zzfz2);
            if (this.zza.zzav().zzd()) {
                zzfz2.run();
                return;
            }
            this.zza.zzav().zzj((Runnable)zzfz2);
            return;
        }
    }

    @BinderThread
    public final void zzd(zzas zzas2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzas2);
        this.zzx(zzp2, false);
        zzga zzga2 = new zzga(this, zzas2, zzp2);
        this.zzc(zzga2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final zzas zzb(zzas zzas2, zzp object) {
        if (!"_cmp".equals(zzas2.zza)) return zzas2;
        zzaq zzaq2 = zzas2.zzb;
        if (zzaq2 == null) return zzas2;
        if (zzaq2.zze() == 0) {
            return zzas2;
        }
        String string = zzas2.zzb.zzd("_cis");
        if (!"referrer broadcast".equals(string)) {
            if (!"referrer API".equals(string)) return zzas2;
        }
        this.zza.zzau().zzi().zzb("Event has been filtered ", (Object)zzas2.toString());
        return new zzas("_cmpx", zzas2.zzb, zzas2.zzc, zzas2.zzd);
    }

    @BinderThread
    public final void zzg(zzas zzas2, String string, String object) {
        Preconditions.checkNotNull((Object)zzas2);
        Preconditions.checkNotEmpty((String)string);
        this.zzy(string, true);
        object = new zzgb(this, zzas2, string);
        this.zzc((Runnable)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzj(zzas zzas2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzas2);
        this.zzy(string, true);
        this.zza.zzau().zzj().zzb("Log and bundle. event", (Object)this.zza.zzo().zzc(zzas2.zza));
        long l = this.zza.zzay().nanoTime() / 1000000L;
        Object object = this.zza;
        object = ((zzki)object).zzav();
        Object object2 = new zzgc(this, zzas2, string);
        object = object.zzf((Callable)object2);
        try {
            object = (byte[])object.get();
            if (object == null) {
                this.zza.zzau().zzb().zzb("Log and bundle returned null. appId", zzem.zzl((String)string));
                object = new byte[0];
            }
            object2 = this.zza;
            object2 = ((zzki)object2).zzay();
            long l2 = object2.nanoTime();
            this.zza.zzau().zzj().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzo().zzc(zzas2.zza), (Object)((Object)object).length, (Object)(l2 / 1000000L - l));
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzd("Failed to log and bundle. appId, event, error", zzem.zzl((String)string), (Object)this.zza.zzo().zzc(zzas2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zze(zzkl zzkl2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzkl2);
        this.zzx(zzp2, false);
        zzgd zzgd2 = new zzgd(this, zzkl2, zzp2);
        this.zzc(zzgd2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkl> zzi(zzp zzp2, boolean bl) {
        this.zzx(zzp2, false);
        Iterator iterator = zzp2.zza;
        Preconditions.checkNotNull((Object)iterator);
        ArrayList<zzkl> arrayList = this.zza;
        arrayList = ((zzki)((Object)arrayList)).zzav();
        zzge zzge2 = new zzge(this, (String)((Object)iterator));
        iterator = arrayList.zze(zzge2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkl>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                String string;
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzge2 = (zzkn)iterator.next();
                if (!bl && (bl2 = zzkp.zzR((String)(string = ((zzkn)zzge2).zzc)))) continue;
                zzkl zzkl2 = new zzkl((zzkn)zzge2);
                arrayList.add(zzkl2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzc("Failed to get user properties. appId", zzem.zzl((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zzf(zzp zzp2) {
        this.zzx(zzp2, false);
        zzgf zzgf2 = new zzgf(this, zzp2);
        this.zzc(zzgf2);
    }

    @BinderThread
    private final void zzx(zzp zzp2, boolean bl) {
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzy(zzp2.zza, false);
        this.zza.zzq().zzA(zzp2.zzb, zzp2.zzq, zzp2.zzu);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzy(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            int n;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzau().zzb().zza("Measurement Service called without app package");
                                SecurityException securityException = new SecurityException("Measurement Service called without app package");
                                throw securityException;
                            }
                            if (!bl4) break block11;
                            try {
                                Context context;
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                Context context2 = this.zza.zzax();
                                bl5 = UidVerifier.isGooglePlayServicesUid((Context)context2, (int)(n = Binder.getCallingUid()));
                                bl5 = !bl5 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)(context = this.zza.zzax())).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                this.zza.zzau().zzb().zzb("Measurement Service called with invalid calling package. appId", zzem.zzl((String)var1_2));
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)(string2 = this.zza.zzax()), (int)(n = Binder.getCallingUid()), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                Object[] objectArray = new Object[]{var1_2};
                SecurityException securityException = new SecurityException(String.format("Unknown calling package name '%s'.", objectArray));
                throw securityException;
            }
        }
    }

    @BinderThread
    public final void zzk(long l, String string, String string2, String string3) {
        zzgg zzgg2 = new zzgg(this, string2, string3, string, l);
        this.zzc(zzgg2);
    }

    @BinderThread
    public final void zzt(Bundle bundle, zzp object) {
        this.zzx((zzp)object, false);
        object = object.zza;
        Preconditions.checkNotNull((Object)object);
        zzfq zzfq2 = new zzfq(this, (String)object, bundle);
        this.zzc(zzfq2);
    }

    @BinderThread
    public final String zzl(zzp zzp2) {
        this.zzx(zzp2, false);
        return this.zza.zzV(zzp2);
    }

    @BinderThread
    public final void zzm(zzaa object, zzp zzp2) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        this.zzx(zzp2, false);
        zzaa zzaa2 = new zzaa(object);
        zzaa2.zza = zzp2.zza;
        object = new zzfr(this, zzaa2, zzp2);
        this.zzc((Runnable)object);
    }

    @BinderThread
    public final void zzn(zzaa object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        Preconditions.checkNotEmpty((String)object.zza);
        this.zzy(object.zza, true);
        zzaa zzaa2 = new zzaa(object);
        object = new zzfs(this, zzaa2);
        this.zzc((Runnable)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkl> zzo(String iterator, String arrayList, boolean bl, zzp zzp2) {
        this.zzx(zzp2, false);
        String string = zzp2.zza;
        Preconditions.checkNotNull((Object)string);
        zzki zzki2 = this.zza;
        zzki2 = zzki2.zzav();
        zzft zzft2 = new zzft(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzki2.zze(zzft2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkl>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                String string2;
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                string = (zzkn)iterator.next();
                if (!bl && (bl2 = zzkp.zzR((String)(string2 = ((zzkn)string).zzc)))) continue;
                zzkl zzkl2 = new zzkl((zzkn)string);
                arrayList.add(zzkl2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzc("Failed to query user properties. appId", zzem.zzl((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkl> zzp(String string, String iterator, String arrayList, boolean bl) {
        this.zzy(string, true);
        zzki zzki2 = this.zza;
        zzki2 = zzki2.zzav();
        zzfu zzfu2 = new zzfu(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzki2.zze(zzfu2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkl>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                String string2;
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzki2 = (zzkn)iterator.next();
                if (!bl && (bl2 = zzkp.zzR((String)(string2 = ((zzkn)zzki2).zzc)))) continue;
                zzkl zzkl2 = new zzkl((zzkn)zzki2);
                arrayList.add(zzkl2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzc("Failed to get user properties as. appId", zzem.zzl((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzaa> zzq(String object, String string, zzp object2) {
        this.zzx((zzp)object2, false);
        object2 = object2.zza;
        Preconditions.checkNotNull((Object)object2);
        zzki zzki2 = this.zza;
        zzki2 = zzki2.zzav();
        zzfv zzfv2 = new zzfv(this, (String)object2, (String)object, string);
        object = zzki2.zze(zzfv2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzaa> zzr(String object, String string, String string2) {
        this.zzy((String)object, true);
        zzki zzki2 = this.zza;
        zzki2 = zzki2.zzav();
        zzfw zzfw2 = new zzfw(this, (String)object, string, string2);
        object = zzki2.zze(zzfw2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzs(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzy(zzp2.zza, false);
        zzfx zzfx2 = new zzfx(this, zzp2);
        this.zzc(zzfx2);
    }

    @VisibleForTesting
    final void zzc(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzav().zzd()) {
            runnable.run();
            return;
        }
        this.zza.zzav().zzh(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzv(String string, Bundle object) {
        zzai zzai2 = ((zzgh)((Object)zzai2)).zza.zzi();
        zzai2.zzg();
        zzai2.zzZ();
        zzan zzan2 = new zzan(zzai2.zzs, "", string, "dep", 0L, 0L, object);
        byte[] byArray = zzai2.zzf.zzm().zzf(zzan2).zzbp();
        zzai2.zzs.zzau().zzk().zzc("Saving default event parameters, appId, data size", (Object)zzai2.zzs.zzm().zzc(string), (Object)byArray.length);
        zzan2 = new ContentValues();
        zzan2.put("app_id", string);
        zzan2.put("parameters", byArray);
        try {
            long l = zzai2.zze().insertWithOnConflict("default_event_params", null, (ContentValues)zzan2, 5);
            if (l != -1L) return;
        }
        catch (SQLiteException sQLiteException) {
            zzai2.zzs.zzau().zzb().zzc("Error storing default event parameters. appId", zzem.zzl((String)string), (Object)sQLiteException);
            return;
        }
        zzem zzem2 = zzai2.zzs.zzau();
        zzem2.zzb().zzb("Failed to insert default event parameters (got -1). appId", zzem.zzl((String)string));
    }

    static /* synthetic */ zzki zzw(zzgh zzgh2) {
        return zzgh2.zza;
    }
}

