/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzcd;
import com.google.android.gms.internal.measurement.zzce;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzkk;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class zzw {
    final String zzb;
    final int zzc;
    Boolean zzd;
    Boolean zze;
    Long zzf;
    Long zzg;

    zzw(String string, int n) {
        this.zzb = string;
        this.zzc = n;
    }

    abstract int zza();

    abstract boolean zzb();

    abstract boolean zzc();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    static Boolean zze(Boolean bl, boolean bl2) {
        boolean bl3;
        if (bl == null) {
            return null;
        }
        if (bl != bl2) {
            bl3 = true;
            return bl3;
        }
        bl3 = false;
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static Boolean zzf(String string, zzcl object, zzem zzem2) {
        ArrayList<String> arrayList;
        Preconditions.checkNotNull((Object)object);
        if (string == null) {
            return null;
        }
        if (!((zzcl)((Object)object)).zza()) return null;
        if (((zzcl)((Object)object)).zzb() == zzck.zza) {
            return null;
        }
        if (((zzcl)((Object)object)).zzb() == zzck.zzg) {
            if (((zzcl)((Object)object)).zzh() == 0) return null;
        } else if (!((zzcl)((Object)object)).zzc()) {
            return null;
        }
        zzck zzck2 = ((zzcl)((Object)object)).zzb();
        boolean bl = ((zzcl)((Object)object)).zzf();
        String string2 = bl || zzck2 == zzck.zzb || zzck2 == zzck.zzg ? ((zzcl)((Object)object)).zzd() : ((zzcl)((Object)object)).zzd().toUpperCase(Locale.ENGLISH);
        if (((zzcl)((Object)object)).zzh() == 0) {
            object = null;
        } else {
            object = ((zzcl)((Object)object)).zzg();
            if (!bl) {
                arrayList = new ArrayList<String>(object.size());
                object = object.iterator();
                while (object.hasNext()) {
                    arrayList.add(((String)object.next()).toUpperCase(Locale.ENGLISH));
                }
                object = Collections.unmodifiableList(arrayList);
            }
        }
        if (zzck2 == zzck.zzb) {
            arrayList = string2;
            return zzw.zzd(string, zzck2, bl, string2, (List<String>)object, arrayList, zzem2);
        }
        arrayList = null;
        return zzw.zzd(string, zzck2, bl, string2, (List<String>)object, arrayList, zzem2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Boolean zzd(String object, zzck zzck2, boolean bl, String string, List<String> list, String string2, zzem zzem2) {
        if (zzck2 == zzck.zzg) {
            if (list == null) return null;
            if (list.size() == 0) {
                return null;
            }
        } else if (string == null) {
            return null;
        }
        if (!bl && zzck2 != zzck.zzb) {
            object = ((String)object).toUpperCase(Locale.ENGLISH);
        }
        switch (zzck2.ordinal()) {
            case 6: {
                if (list != null) return list.contains(object);
                return null;
            }
            case 5: {
                return ((String)object).equals(string);
            }
            case 4: {
                return ((String)object).contains(string);
            }
            case 3: {
                return ((String)object).endsWith(string);
            }
            case 2: {
                return ((String)object).startsWith(string);
            }
            case 1: {
                if (string2 == null) {
                    return null;
                }
                int n = true != bl ? 66 : 0;
                return Pattern.compile(string2, n).matcher((CharSequence)object).matches();
            }
        }
        return null;
        catch (PatternSyntaxException patternSyntaxException) {
            if (zzem2 == null) return null;
            zzem2.zze().zzb("Invalid regular expression in REGEXP audience filter. expression", (Object)string2);
            return null;
        }
    }

    static Boolean zzg(long l, zzce object) {
        try {
            BigDecimal bigDecimal = new BigDecimal(l);
            object = zzw.zzj(bigDecimal, object, 0.0);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Boolean zzh(double d, zzce object) {
        try {
            BigDecimal bigDecimal = new BigDecimal(d);
            object = zzw.zzj(bigDecimal, object, Math.ulp(d));
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Boolean zzi(String object, zzce zzce2) {
        if (!zzkk.zzl((String)object)) {
            return null;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal((String)object);
            object = zzw.zzj(bigDecimal, zzce2, 0.0);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static Boolean zzj(BigDecimal comparable, zzce object, double d) {
        boolean bl;
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        Preconditions.checkNotNull((Object)object);
        if (!((zzce)((Object)object)).zza()) return null;
        if (((zzce)((Object)object)).zzb() == zzcd.zza) {
            return null;
        }
        if (((zzce)((Object)object)).zzb() == zzcd.zze) {
            if (!((zzce)((Object)object)).zzg()) return null;
            if (!((zzce)((Object)object)).zzi()) return null;
        } else if (!((zzce)((Object)object)).zze()) {
            return null;
        }
        zzcd zzcd2 = ((zzce)((Object)object)).zzb();
        if (((zzce)((Object)object)).zzb() == zzcd.zze) {
            if (!zzkk.zzl(((zzce)((Object)object)).zzh())) return null;
            if (!zzkk.zzl(((zzce)((Object)object)).zzj())) {
                return null;
            }
            bigDecimal2 = new BigDecimal(((zzce)((Object)object)).zzh());
            bigDecimal = new BigDecimal(((zzce)((Object)object)).zzj());
            object = null;
        }
        if (!zzkk.zzl(((zzce)((Object)object)).zzf())) {
            return null;
        }
        try {
            bigDecimal2 = new BigDecimal(((zzce)((Object)object)).zzf());
            object = bigDecimal2;
            bigDecimal2 = null;
            bigDecimal = null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (zzcd2 == zzcd.zze ? bigDecimal2 == null : object == null) {
            return null;
        }
        switch (zzcd2.ordinal()) {
            default: {
                return null;
            }
            case 1: {
                boolean bl2;
                if (object == null) {
                    return null;
                }
                if (((BigDecimal)comparable).compareTo((BigDecimal)object) < 0) {
                    bl2 = true;
                    return bl2;
                }
                bl2 = false;
                return bl2;
            }
            case 4: {
                if (bigDecimal2 == null) {
                    return null;
                }
                boolean bl3 = ((BigDecimal)comparable).compareTo(bigDecimal2) >= 0 ? ((BigDecimal)comparable).compareTo(bigDecimal) <= 0 : false;
                return bl3;
            }
            case 3: {
                if (object == null) {
                    return null;
                }
                if (d != 0.0) {
                    bigDecimal2 = new BigDecimal(d);
                    bigDecimal = new BigDecimal(2);
                    boolean bl4 = ((BigDecimal)comparable).compareTo(((BigDecimal)object).subtract(bigDecimal2.multiply(bigDecimal))) > 0 ? ((BigDecimal)comparable).compareTo(((BigDecimal)object).add((bigDecimal2 = new BigDecimal(d)).multiply(bigDecimal = new BigDecimal(2)))) < 0 : false;
                    return bl4;
                }
                boolean bl5 = ((BigDecimal)comparable).compareTo((BigDecimal)object) == 0;
                return bl5;
            }
            case 2: 
        }
        if (object == null) {
            return null;
        }
        if (((BigDecimal)comparable).compareTo((BigDecimal)object) > 0) {
            bl = true;
            return bl;
        }
        bl = false;
        return bl;
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

