/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzac;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzaj;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzbb;
import com.google.android.gms.internal.measurement.zzg;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class zzae
implements Iterable<zzap>,
zzap,
zzal {
    final SortedMap<Integer, zzap> zza;
    final Map<String, zzap> zzb;

    public zzae() {
        TreeMap<String, zzap> treeMap = new TreeMap<String, zzap>();
        this.zza = treeMap;
        treeMap = new TreeMap<String, zzap>();
        this.zzb = treeMap;
    }

    public zzae(List<zzap> list) {
        this();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.zzn(i, list.get(i));
            }
        }
    }

    public final List<zzap> zzb() {
        ArrayList<zzap> arrayList = new ArrayList<zzap>(this.zzh());
        for (int i = 0; i < this.zzh(); ++i) {
            arrayList.add(this.zzl(i));
        }
        return arrayList;
    }

    @Override
    public final String zzc() {
        return this.zzs(",");
    }

    @Override
    public final Double zzd() {
        if (this.zza.size() == 1) {
            return this.zzl(0).zzd();
        }
        if (this.zza.size() <= 0) {
            return 0.0;
        }
        return Double.NaN;
    }

    @Override
    public final Boolean zze() {
        return true;
    }

    @Override
    public final Iterator<zzap> zzf() {
        Iterator iterator = this.zza;
        iterator = iterator.keySet();
        iterator = iterator.iterator();
        Iterator iterator2 = this.zzb;
        iterator2 = iterator2.keySet();
        iterator2 = iterator2.iterator();
        zzac zzac2 = new zzac(this, iterator, iterator2);
        return zzac2;
    }

    @Override
    public final Iterator<zzap> iterator() {
        zzad zzad2 = new zzad(this);
        return zzad2;
    }

    public final Iterator<Integer> zzg() {
        return this.zza.keySet().iterator();
    }

    public final int zzh() {
        if (this.zza.isEmpty()) {
            return 0;
        }
        return this.zza.lastKey() + 1;
    }

    public final int zzi() {
        return this.zza.size();
    }

    @Override
    public final zzap zzbK(String string, zzg zzg2, List<zzap> list) {
        if ("concat".equals(string) || "every".equals(string) || "filter".equals(string) || "forEach".equals(string) || "indexOf".equals(string) || "join".equals(string) || "lastIndexOf".equals(string) || "map".equals(string) || "pop".equals(string) || "push".equals(string) || "reduce".equals(string) || "reduceRight".equals(string) || "reverse".equals(string) || "shift".equals(string) || "slice".equals(string) || "some".equals(string) || "sort".equals(string) || "splice".equals(string) || "toString".equals(string) || "unshift".equals(string)) {
            return zzbb.zza(string, this, zzg2, list);
        }
        zzat zzat2 = new zzat(string);
        return zzaj.zza(this, zzat2, zzg2, list);
    }

    @Override
    public final boolean zzj(String string) {
        return "length".equals(string) || this.zzb.containsKey(string);
    }

    @Override
    public final zzap zzk(String object) {
        zzap zzap2;
        zzah zzah2;
        if ("length".equals(zzah2)) {
            zzah2 = new zzah(Double.valueOf(this.zzh()));
            return zzah2;
        }
        if (this.zzj((String)((Object)zzah2)) && (zzap2 = this.zzb.get(zzah2)) != null) {
            return zzap2;
        }
        return zzf;
    }

    public final zzap zzl(int n) {
        if (n >= ((zzae)object).zzh()) {
            Object object = new IndexOutOfBoundsException("Attempting to get element outside of current array");
            throw object;
        }
        if (((zzae)object).zzo(n) && (object = (zzap)((zzae)object).zza.get(n)) != null) {
            return object;
        }
        return zzf;
    }

    @Override
    public final void zzm(String string, zzap zzap2) {
        if (zzap2 == null) {
            this.zzb.remove(string);
            return;
        }
        this.zzb.put(string, zzap2);
    }

    @RequiresNonNull(value={"elements"})
    public final void zzn(int n, zzap object) {
        Object object2;
        if (n > 32468) {
            object2 = new IllegalStateException("Array too large");
            throw object2;
        }
        if (n < 0) {
            object = new StringBuilder(32);
            ((StringBuilder)object).append("Out of bounds index: ");
            ((StringBuilder)object).append(n);
            object2 = new IndexOutOfBoundsException(((StringBuilder)object).toString());
            throw object2;
        }
        if (object == null) {
            ((zzae)object2).zza.remove(n);
            return;
        }
        ((zzae)object2).zza.put(n, (zzap)object);
    }

    public final boolean zzo(int n) {
        if (n < 0 || n > ((zzae)object).zza.lastKey()) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Out of bounds index: ");
            stringBuilder.append(n);
            Object object = new IndexOutOfBoundsException(stringBuilder.toString());
            throw object;
        }
        return ((zzae)object).zza.containsKey(n);
    }

    public final void zzp() {
        this.zza.clear();
    }

    public final void zzq(int n, zzap object) {
        if (n < 0) {
            object = new StringBuilder(32);
            ((StringBuilder)object).append("Invalid value index: ");
            ((StringBuilder)object).append(n);
            Object object2 = new IllegalArgumentException(((StringBuilder)object).toString());
            throw object2;
        }
        if (n >= ((zzae)object2).zzh()) {
            ((zzae)object2).zzn(n, (zzap)object);
            return;
        }
        for (int i = ((zzae)object2).zza.lastKey().intValue(); i >= n; --i) {
            Object object3 = ((zzae)object2).zza;
            Integer n2 = i;
            if ((object3 = (zzap)object3.get(n2)) == null) continue;
            ((zzae)object2).zzn(i + 1, (zzap)object3);
            ((zzae)object2).zza.remove(n2);
        }
        ((zzae)object2).zzn(n, (zzap)object);
    }

    public final void zzr(int n) {
        int n2 = this.zza.lastKey();
        if (n > n2 || n < 0) {
            return;
        }
        this.zza.remove(n);
        if (n == n2) {
            Integer n3;
            SortedMap<Integer, zzap> sortedMap = this.zza;
            if (!sortedMap.containsKey(n3 = Integer.valueOf(--n)) && n >= 0) {
                this.zza.put(n3, zzap.zzf);
                return;
            }
            return;
        }
        ++n;
        while (n <= this.zza.lastKey()) {
            Object object = this.zza;
            Integer n4 = n;
            if ((object = (zzap)object.get(n4)) != null) {
                this.zza.put(n + -1, (zzap)object);
                this.zza.remove(n4);
            }
            ++n;
        }
    }

    public final int hashCode() {
        return this.zza.hashCode() * 31;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof zzae)) {
            return false;
        }
        zzae zzae2 = (zzae)object;
        if (this.zzh() != zzae2.zzh()) {
            return false;
        }
        if (this.zza.isEmpty()) {
            return zzae2.zza.isEmpty();
        }
        for (int i = this.zza.firstKey().intValue(); i <= this.zza.lastKey(); ++i) {
            if (this.zzl(i).equals(zzae2.zzl(i))) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        return this.zzs(",");
    }

    public final String zzs(String string) {
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.zza.isEmpty()) {
            for (int i = 0; i < this.zzh(); ++i) {
                zzap zzap2 = this.zzl(i);
                stringBuilder.append(string);
                if (zzap2 instanceof zzau || zzap2 instanceof zzan) continue;
                stringBuilder.append(zzap2.zzc());
            }
            stringBuilder.delete(0, string.length());
        }
        return stringBuilder.toString();
    }

    @Override
    public final zzap zzt() {
        zzae zzae2 = new zzae();
        for (Map.Entry entry : ((zzae)this).zza.entrySet()) {
            if (entry.getValue() instanceof zzal) {
                zzae2.zza.put((Integer)entry.getKey(), (zzap)entry.getValue());
                continue;
            }
            zzae2.zza.put((Integer)entry.getKey(), ((zzap)entry.getValue()).zzt());
        }
        return zzae2;
    }
}

