/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzd;
import com.google.android.gms.internal.measurement.zzpt;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class zzgm
extends zzec {
    private final zzkn zza;
    private Boolean zzb;
    private String zzc;

    public zzgm(zzkn zzkn2, String string) {
        Preconditions.checkNotNull((Object)zzkn2);
        this.zza = zzkn2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzh(zzp zzp2) {
        this.zzA(zzp2, false);
        zzgd zzgd2 = new zzgd(this, zzp2);
        this.zzv(zzgd2);
    }

    @BinderThread
    public final void zzu(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzv);
        zzge zzge2 = new zzge(this, zzp2);
        Preconditions.checkNotNull((Object)zzge2);
        if (this.zza.zzav().zzd()) {
            zzge2.run();
            return;
        }
        this.zza.zzav().zzj((Runnable)zzge2);
    }

    @BinderThread
    public final void zzd(zzas zzas2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzas2);
        this.zzA(zzp2, false);
        zzgf zzgf2 = new zzgf(this, zzas2, zzp2);
        this.zzv(zzgf2);
    }

    private final void zzz(zzas zzas2, zzp zzp2) {
        this.zza.zzG();
        this.zza.zzy(zzas2, zzp2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzb(zzas object, zzp zzp2) {
        block13: {
            void var3_5;
            block15: {
                block14: {
                    if (!this.zza.zzf().zzh(zzp2.zza)) {
                        this.zzz((zzas)object, zzp2);
                        return;
                    }
                    this.zza.zzau().zzk().zzb("EES config found for", (Object)zzp2.zza);
                    zzfl zzfl2 = this.zza.zzf();
                    String string = zzp2.zza;
                    zzpt.zzb();
                    if (zzfl2.zzs.zzc().zzn(null, zzea.zzaD)) {
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            Object var3_4 = null;
                        } else {
                            zzc zzc2 = (zzc)zzfl2.zza.get((Object)string);
                        }
                    } else {
                        Object var3_9 = null;
                    }
                    if (var3_5 == null) {
                        this.zza.zzau().zzk().zzb("EES not loaded for", (Object)zzp2.zza);
                        this.zzz((zzas)object, zzp2);
                        return;
                    }
                    try {
                        boolean bl;
                        boolean bl2;
                        string = ((zzas)object).zzb.zzf();
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        Object object2 = string.keySet().iterator();
                        while (bl2 = object2.hasNext()) {
                            String string2 = (String)object2.next();
                            Object object3 = string.get(string2);
                            if (object3 == null) continue;
                            hashMap.put(string2, object3);
                        }
                        string = zzgr.zza((String)((zzas)object).zza);
                        if (string == null) {
                            string = ((zzas)object).zza;
                        }
                        if (!(bl = var3_5.zzb((com.google.android.gms.internal.measurement.zzaa)(object2 = new com.google.android.gms.internal.measurement.zzaa(string, ((zzas)object).zzd, hashMap))))) break block13;
                        if (!var3_5.zzc()) break block14;
                    }
                    catch (zzd zzd2) {
                        this.zza.zzau().zzb().zzc("EES error. appId, eventName", (Object)zzp2.zzb, (Object)((zzas)object).zza);
                    }
                    this.zza.zzau().zzk().zzb("EES edited event", (Object)((zzas)object).zza);
                    this.zzz(zzkp.zzx(var3_5.zze().zzc()), zzp2);
                    break block15;
                }
                this.zzz((zzas)object, zzp2);
            }
            if (var3_5.zzd()) {
                for (com.google.android.gms.internal.measurement.zzaa zzaa2 : var3_5.zze().zzf()) {
                    this.zza.zzau().zzk().zzb("EES logging created event", (Object)zzaa2.zzb());
                    this.zzz(zzkp.zzx(zzaa2), zzp2);
                }
            }
            return;
        }
        this.zza.zzau().zzk().zzb("EES was not applied to event", (Object)((zzas)object).zza);
        this.zzz((zzas)object, zzp2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final zzas zzc(zzas zzas2, zzp object) {
        if (!"_cmp".equals(zzas2.zza)) return zzas2;
        zzaq zzaq2 = zzas2.zzb;
        if (zzaq2 == null) return zzas2;
        if (zzaq2.zze() == 0) {
            return zzas2;
        }
        String string = zzas2.zzb.zzd("_cis");
        if (!"referrer broadcast".equals(string)) {
            if (!"referrer API".equals(string)) return zzas2;
        }
        this.zza.zzau().zzi().zzb("Event has been filtered ", (Object)zzas2.toString());
        return new zzas("_cmpx", zzas2.zzb, zzas2.zzc, zzas2.zzd);
    }

    @BinderThread
    public final void zzg(zzas zzas2, String string, String object) {
        Preconditions.checkNotNull((Object)zzas2);
        Preconditions.checkNotEmpty((String)string);
        this.zzB(string, true);
        object = new zzgg(this, zzas2, string);
        this.zzv((Runnable)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzj(zzas zzas2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzas2);
        this.zzB(string, true);
        this.zza.zzau().zzj().zzb("Log and bundle. event", (Object)this.zza.zzo().zzc(zzas2.zza));
        long l = this.zza.zzay().nanoTime() / 1000000L;
        Object object = this.zza;
        object = ((zzkn)object).zzav();
        Object object2 = new zzgh(this, zzas2, string);
        object = object.zzf((Callable)object2);
        try {
            object = (byte[])object.get();
            if (object == null) {
                this.zza.zzau().zzb().zzb("Log and bundle returned null. appId", zzem.zzl((String)string));
                object = new byte[0];
            }
            object2 = this.zza;
            object2 = ((zzkn)object2).zzay();
            long l2 = object2.nanoTime();
            this.zza.zzau().zzj().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzo().zzc(zzas2.zza), (Object)((Object)object).length, (Object)(l2 / 1000000L - l));
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzd("Failed to log and bundle. appId, event, error", zzem.zzl((String)string), (Object)this.zza.zzo().zzc(zzas2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zze(zzkq zzkq2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzkq2);
        this.zzA(zzp2, false);
        zzgi zzgi2 = new zzgi(this, zzkq2, zzp2);
        this.zzv(zzgi2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkq> zzi(zzp zzp2, boolean bl) {
        this.zzA(zzp2, false);
        Iterator iterator = zzp2.zza;
        Preconditions.checkNotNull((Object)iterator);
        ArrayList<zzkq> arrayList = this.zza;
        arrayList = ((zzkn)((Object)arrayList)).zzav();
        zzgj zzgj2 = new zzgj(this, (String)((Object)iterator));
        iterator = arrayList.zze(zzgj2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkq>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzgj2 = (zzks)iterator.next();
                if (!bl && (bl2 = zzku.zzR((String)((zzks)zzgj2).zzc))) continue;
                zzkq zzkq2 = new zzkq((zzks)zzgj2);
                arrayList.add(zzkq2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzc("Failed to get user properties. appId", zzem.zzl((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zzf(zzp zzp2) {
        this.zzA(zzp2, false);
        zzgk zzgk2 = new zzgk(this, zzp2);
        this.zzv(zzgk2);
    }

    @BinderThread
    private final void zzA(zzp zzp2, boolean bl) {
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzB(zzp2.zza, false);
        this.zza.zzq().zzA(zzp2.zzb, zzp2.zzq, zzp2.zzu);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzB(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzau().zzb().zza("Measurement Service called without app package");
                                SecurityException securityException = new SecurityException("Measurement Service called without app package");
                                throw securityException;
                            }
                            if (!bl4) break block11;
                            try {
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                bl5 = UidVerifier.isGooglePlayServicesUid((Context)this.zza.zzax(), (int)Binder.getCallingUid());
                                bl5 = !bl5 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)this.zza.zzax()).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                this.zza.zzau().zzb().zzb("Measurement Service called with invalid calling package. appId", zzem.zzl((String)var1_2));
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)this.zza.zzax(), (int)Binder.getCallingUid(), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                Object[] objectArray = new Object[]{var1_2};
                SecurityException securityException = new SecurityException(String.format("Unknown calling package name '%s'.", objectArray));
                throw securityException;
            }
        }
    }

    @BinderThread
    public final void zzk(long l, String string, String string2, String string3) {
        zzgl zzgl2 = new zzgl(this, string2, string3, string, l);
        this.zzv(zzgl2);
    }

    @BinderThread
    public final void zzt(Bundle bundle, zzp object) {
        this.zzA((zzp)object, false);
        object = object.zza;
        Preconditions.checkNotNull((Object)object);
        zzfv zzfv2 = new zzfv(this, (String)object, bundle);
        this.zzv(zzfv2);
    }

    @BinderThread
    public final String zzl(zzp zzp2) {
        this.zzA(zzp2, false);
        return this.zza.zzU(zzp2);
    }

    @BinderThread
    public final void zzm(zzaa object, zzp zzp2) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        this.zzA(zzp2, false);
        zzaa zzaa2 = new zzaa(object);
        zzaa2.zza = zzp2.zza;
        object = new zzfw(this, zzaa2, zzp2);
        this.zzv((Runnable)object);
    }

    @BinderThread
    public final void zzn(zzaa object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        Preconditions.checkNotEmpty((String)object.zza);
        this.zzB(object.zza, true);
        zzaa zzaa2 = new zzaa(object);
        object = new zzfx(this, zzaa2);
        this.zzv((Runnable)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkq> zzo(String iterator, String arrayList, boolean bl, zzp zzp2) {
        this.zzA(zzp2, false);
        String string = zzp2.zza;
        Preconditions.checkNotNull((Object)string);
        zzkn zzkn2 = this.zza;
        zzkn2 = zzkn2.zzav();
        zzfy zzfy2 = new zzfy(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzkn2.zze(zzfy2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkq>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                string = (zzks)iterator.next();
                if (!bl && (bl2 = zzku.zzR((String)((zzks)string).zzc))) continue;
                zzkq zzkq2 = new zzkq((zzks)string);
                arrayList.add(zzkq2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzc("Failed to query user properties. appId", zzem.zzl((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkq> zzp(String string, String iterator, String arrayList, boolean bl) {
        this.zzB(string, true);
        zzkn zzkn2 = this.zza;
        zzkn2 = zzkn2.zzav();
        zzfz zzfz2 = new zzfz(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzkn2.zze(zzfz2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkq>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzkn2 = (zzks)iterator.next();
                if (!bl && (bl2 = zzku.zzR((String)((zzks)zzkn2).zzc))) continue;
                zzkq zzkq2 = new zzkq((zzks)zzkn2);
                arrayList.add(zzkq2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzc("Failed to get user properties as. appId", zzem.zzl((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzaa> zzq(String object, String string, zzp object2) {
        this.zzA((zzp)object2, false);
        object2 = object2.zza;
        Preconditions.checkNotNull((Object)object2);
        zzkn zzkn2 = this.zza;
        zzkn2 = zzkn2.zzav();
        zzga zzga2 = new zzga(this, (String)object2, (String)object, string);
        object = zzkn2.zze(zzga2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzaa> zzr(String object, String string, String string2) {
        this.zzB((String)object, true);
        zzkn zzkn2 = this.zza;
        zzkn2 = zzkn2.zzav();
        zzgb zzgb2 = new zzgb(this, (String)object, string, string2);
        object = zzkn2.zze(zzgb2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzau().zzb().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzs(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzB(zzp2.zza, false);
        zzgc zzgc2 = new zzgc(this, zzp2);
        this.zzv(zzgc2);
    }

    @VisibleForTesting
    final void zzv(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzav().zzd()) {
            runnable.run();
            return;
        }
        this.zza.zzav().zzh(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzw(String string, Bundle object) {
        zzai zzai2 = ((zzgm)((Object)zzai2)).zza.zzi();
        zzai2.zzg();
        zzai2.zzZ();
        zzan zzan2 = new zzan(zzai2.zzs, "", string, "dep", 0L, 0L, object);
        byte[] byArray = zzai2.zzf.zzm().zzf(zzan2).zzbp();
        zzai2.zzs.zzau().zzk().zzc("Saving default event parameters, appId, data size", (Object)zzai2.zzs.zzm().zzc(string), (Object)byArray.length);
        zzan2 = new ContentValues();
        zzan2.put("app_id", string);
        zzan2.put("parameters", byArray);
        try {
            long l = zzai2.zze().insertWithOnConflict("default_event_params", null, (ContentValues)zzan2, 5);
            if (l != -1L) return;
        }
        catch (SQLiteException sQLiteException) {
            zzai2.zzs.zzau().zzb().zzc("Error storing default event parameters. appId", zzem.zzl((String)string), (Object)sQLiteException);
            return;
        }
        zzem zzem2 = zzai2.zzs.zzau();
        zzem2.zzb().zzb("Failed to insert default event parameters (got -1). appId", zzem.zzl((String)string));
    }

    static /* synthetic */ zzkn zzx(zzgm zzgm2) {
        return zzgm2.zza;
    }

    static /* synthetic */ void zzy(zzgm zzgm2, zzas zzas2, zzp zzp2) {
        zzgm2.zzz(zzas2, zzp2);
    }
}

