/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzd;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class zzha
extends zzen {
    private final zzli zza;
    private Boolean zzb;
    private String zzc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final zzav zzb(zzav zzav2, zzp object) {
        if (!"_cmp".equals(zzav2.zza)) return zzav2;
        zzat zzat2 = zzav2.zzb;
        if (zzat2 == null) return zzav2;
        if (zzat2.zza() == 0) {
            return zzav2;
        }
        String string = zzav2.zzb.zzg("_cis");
        if (!"referrer broadcast".equals(string)) {
            if (!"referrer API".equals(string)) return zzav2;
        }
        this.zza.zzaz().zzi().zzb("Event has been filtered ", (Object)zzav2.toString());
        return new zzav("_cmpx", zzav2.zzb, zzav2.zzc, zzav2.zzd);
    }

    static /* bridge */ /* synthetic */ zzli zzc(zzha zzha2) {
        return zzha2.zza;
    }

    @BinderThread
    public final String zzd(zzp zzp2) {
        this.zzy(zzp2, false);
        return this.zza.zzx(zzp2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zze(zzp zzp2, boolean bl) {
        this.zzy(zzp2, false);
        Iterator iterator = zzp2.zza;
        Preconditions.checkNotNull((Object)iterator);
        ArrayList<zzll> arrayList = this.zza;
        arrayList = ((zzli)((Object)arrayList)).zzaA();
        zzgx zzgx2 = new zzgx(this, (String)((Object)iterator));
        iterator = arrayList.zzh(zzgx2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzll>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzgx2 = (zzln)iterator.next();
                if (!bl && (bl2 = zzlp.zzah((String)((zzln)zzgx2).zzc))) continue;
                zzll zzll2 = new zzll((zzln)zzgx2);
                arrayList.add(zzll2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzaz().zzd().zzc("Failed to get user properties. appId", zzey.zzn((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List zzf(String object, String string, zzp object2) {
        this.zzy((zzp)object2, false);
        object2 = object2.zza;
        Preconditions.checkNotNull((Object)object2);
        zzli zzli2 = this.zza;
        zzli2 = zzli2.zzaA();
        zzgo zzgo2 = new zzgo(this, (String)object2, (String)object, string);
        object = zzli2.zzh(zzgo2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzaz().zzd().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List zzg(String object, String string, String string2) {
        this.zzz((String)object, true);
        zzli zzli2 = this.zza;
        zzli2 = zzli2.zzaA();
        zzgp zzgp2 = new zzgp(this, (String)object, string, string2);
        object = zzli2.zzh(zzgp2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzaz().zzd().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzh(String iterator, String arrayList, boolean bl, zzp zzp2) {
        this.zzy(zzp2, false);
        String string = zzp2.zza;
        Preconditions.checkNotNull((Object)string);
        zzli zzli2 = this.zza;
        zzli2 = zzli2.zzaA();
        zzgm zzgm2 = new zzgm(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzli2.zzh(zzgm2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzll>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                string = (zzln)iterator.next();
                if (!bl && (bl2 = zzlp.zzah((String)((zzln)string).zzc))) continue;
                zzll zzll2 = new zzll((zzln)string);
                arrayList.add(zzll2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzaz().zzd().zzc("Failed to query user properties. appId", zzey.zzn((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzi(String string, String iterator, String arrayList, boolean bl) {
        this.zzz(string, true);
        zzli zzli2 = this.zza;
        zzli2 = zzli2.zzaA();
        zzgn zzgn2 = new zzgn(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzli2.zzh(zzgn2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzll>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzli2 = (zzln)iterator.next();
                if (!bl && (bl2 = zzlp.zzah((String)((zzln)zzli2).zzc))) continue;
                zzll zzll2 = new zzll((zzln)zzli2);
                arrayList.add(zzll2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzaz().zzd().zzc("Failed to get user properties as. appId", zzey.zzn((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public zzha(zzli zzli2, String string) {
        Preconditions.checkNotNull((Object)zzli2);
        this.zza = zzli2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzj(zzp zzp2) {
        this.zzy(zzp2, false);
        zzgy zzgy2 = new zzgy(this, zzp2);
        this.zzx(zzgy2);
    }

    @BinderThread
    private final void zzy(zzp zzp2, boolean bl) {
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzz(zzp2.zza, false);
        this.zza.zzv().zzX(zzp2.zzb, zzp2.zzq);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzz(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzaz().zzd().zza("Measurement Service called without app package");
                                SecurityException securityException = new SecurityException("Measurement Service called without app package");
                                throw securityException;
                            }
                            if (!bl4) break block11;
                            try {
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                bl5 = UidVerifier.isGooglePlayServicesUid((Context)this.zza.zzav(), (int)Binder.getCallingUid());
                                bl5 = !bl5 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)this.zza.zzav()).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                this.zza.zzaz().zzd().zzb("Measurement Service called with invalid calling package. appId", zzey.zzn((String)var1_2));
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)this.zza.zzav(), (int)Binder.getCallingUid(), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                Object[] objectArray = new Object[]{var1_2};
                SecurityException securityException = new SecurityException(String.format("Unknown calling package name '%s'.", objectArray));
                throw securityException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzv(zzav object, zzp zzp2) {
        block11: {
            Object object22;
            block10: {
                if (!this.zza.zzo().zzo(zzp2.zza)) {
                    this.zzA((zzav)object, zzp2);
                    return;
                }
                this.zza.zzaz().zzj().zzb("EES config found for", (Object)zzp2.zza);
                object22 = this.zza.zzo();
                Object object3 = zzp2.zza;
                object22 = TextUtils.isEmpty((CharSequence)object3) ? null : (zzc)((zzfz)((Object)object22)).zzd.get(object3);
                if (object22 == null) {
                    this.zza.zzaz().zzj().zzb("EES not loaded for", (Object)zzp2.zza);
                    this.zzA((zzav)object, zzp2);
                    return;
                }
                try {
                    zzaa zzaa2;
                    boolean bl;
                    object3 = this.zza.zzu();
                    Map map = ((zzlk)((Object)object3)).zzs(((zzav)object).zzb.zzc(), true);
                    object3 = zzhf.zza((String)((zzav)object).zza);
                    if (object3 == null) {
                        object3 = ((zzav)object).zza;
                    }
                    if (!(bl = ((zzc)object22).zze(zzaa2 = new zzaa((String)object3, ((zzav)object).zzd, map)))) {
                    }
                    break block10;
                }
                catch (zzd zzd2) {
                    this.zza.zzaz().zzd().zzc("EES error. appId, eventName", (Object)zzp2.zzb, (Object)((zzav)object).zza);
                }
                break block11;
            }
            if (((zzc)object22).zzg()) {
                this.zza.zzaz().zzj().zzb("EES edited event", (Object)((zzav)object).zza);
                this.zzA(this.zza.zzu().zzi(((zzc)object22).zza().zzb()), zzp2);
            } else {
                this.zzA((zzav)object, zzp2);
            }
            if (((zzc)object22).zzf()) {
                for (Object object22 : ((zzc)object22).zza().zzc()) {
                    this.zza.zzaz().zzj().zzb("EES logging created event", (Object)((zzaa)object22).zzd());
                    this.zzA(this.zza.zzu().zzi((zzaa)object22), zzp2);
                }
            }
            return;
        }
        this.zza.zzaz().zzj().zzb("EES was not applied to event", (Object)((zzav)object).zza);
        this.zzA((zzav)object, zzp2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzw(String string, Bundle object) {
        zzal zzal2 = ((zzha)((Object)zzal2)).zza.zzi();
        zzal2.zzg();
        zzal2.zzW();
        zzaq zzaq2 = new zzaq(zzal2.zzs, "", string, "dep", 0L, 0L, object);
        byte[] byArray = zzal2.zzf.zzu().zzj(zzaq2).zzby();
        zzal2.zzs.zzaz().zzj().zzc("Saving default event parameters, appId, data size", (Object)zzal2.zzs.zzj().zzd(string), (Object)byArray.length);
        zzaq2 = new ContentValues();
        zzaq2.put("app_id", string);
        zzaq2.put("parameters", byArray);
        try {
            long l = zzal2.zzh().insertWithOnConflict("default_event_params", null, (ContentValues)zzaq2, 5);
            if (l != -1L) return;
        }
        catch (SQLiteException sQLiteException) {
            zzal2.zzs.zzaz().zzd().zzc("Error storing default event parameters. appId", zzey.zzn((String)string), (Object)sQLiteException);
            return;
        }
        zzey zzey2 = zzal2.zzs.zzaz();
        zzey2.zzd().zzb("Failed to insert default event parameters (got -1). appId", zzey.zzn((String)string));
    }

    @BinderThread
    public final void zzk(zzav zzav2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzav2);
        this.zzy(zzp2, false);
        zzgt zzgt2 = new zzgt(this, zzav2, zzp2);
        this.zzx(zzgt2);
    }

    @BinderThread
    public final void zzl(zzav zzav2, String string, String object) {
        Preconditions.checkNotNull((Object)zzav2);
        Preconditions.checkNotEmpty((String)string);
        this.zzz(string, true);
        object = new zzgu(this, zzav2, string);
        this.zzx((Runnable)object);
    }

    private final void zzA(zzav zzav2, zzp zzp2) {
        this.zza.zzA();
        this.zza.zzD(zzav2, zzp2);
    }

    @BinderThread
    public final void zzm(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzz(zzp2.zza, false);
        zzgq zzgq2 = new zzgq(this, zzp2);
        this.zzx(zzgq2);
    }

    @VisibleForTesting
    final void zzx(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzaA().zzs()) {
            runnable.run();
            return;
        }
        this.zza.zzaA().zzp(runnable);
    }

    @BinderThread
    public final void zzn(zzab object, zzp zzp2) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        this.zzy(zzp2, false);
        zzab zzab2 = new zzab(object);
        zzab2.zza = zzp2.zza;
        object = new zzgk(this, zzab2, zzp2);
        this.zzx((Runnable)object);
    }

    @BinderThread
    public final void zzo(zzab object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        Preconditions.checkNotEmpty((String)object.zza);
        this.zzz(object.zza, true);
        zzab zzab2 = new zzab(object);
        object = new zzgl(this, zzab2);
        this.zzx((Runnable)object);
    }

    @BinderThread
    public final void zzp(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzv);
        zzgs zzgs2 = new zzgs(this, zzp2);
        Preconditions.checkNotNull((Object)zzgs2);
        if (this.zza.zzaA().zzs()) {
            zzgs2.run();
            return;
        }
        this.zza.zzaA().zzq((Runnable)zzgs2);
    }

    @BinderThread
    public final void zzq(long l, String string, String string2, String string3) {
        zzgz zzgz2 = new zzgz(this, string2, string3, string, l);
        this.zzx(zzgz2);
    }

    @BinderThread
    public final void zzr(Bundle bundle, zzp object) {
        this.zzy((zzp)object, false);
        object = object.zza;
        Preconditions.checkNotNull((Object)object);
        zzgj zzgj2 = new zzgj(this, (String)object, bundle);
        this.zzx(zzgj2);
    }

    @BinderThread
    public final void zzs(zzp zzp2) {
        this.zzy(zzp2, false);
        zzgr zzgr2 = new zzgr(this, zzp2);
        this.zzx(zzgr2);
    }

    @BinderThread
    public final void zzt(zzll zzll2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzll2);
        this.zzy(zzp2, false);
        zzgw zzgw2 = new zzgw(this, zzll2, zzp2);
        this.zzx(zzgw2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzu(zzav zzav2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzav2);
        this.zzz(string, true);
        this.zza.zzaz().zzc().zzb("Log and bundle. event", (Object)this.zza.zzj().zzd(zzav2.zza));
        long l = this.zza.zzaw().nanoTime() / 1000000L;
        Object object = this.zza;
        object = ((zzli)object).zzaA();
        Object object2 = new zzgv(this, zzav2, string);
        object = object.zzi((Callable)object2);
        try {
            object = (byte[])object.get();
            if (object == null) {
                this.zza.zzaz().zzd().zzb("Log and bundle returned null. appId", zzey.zzn((String)string));
                object = new byte[0];
            }
            object2 = this.zza;
            object2 = ((zzli)object2).zzaw();
            long l2 = object2.nanoTime();
            this.zza.zzaz().zzc().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzj().zzd(zzav2.zza), (Object)((Object)object).length, (Object)(l2 / 1000000L - l));
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzaz().zzd().zzd("Failed to log and bundle. appId, event, error", zzey.zzn((String)string), (Object)this.zza.zzj().zzd(zzav2.zza), (Object)exception);
            return null;
        }
    }
}

