/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzbt;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlp;

public final class zzku
extends zzkw {
    private final AlarmManager zza;
    private zzao zzb;
    private Integer zzc;

    private final int zzf() {
        if (this.zzc == null) {
            this.zzc = "measurement".concat(String.valueOf(this.zzs.zzav().getPackageName())).hashCode();
        }
        return this.zzc;
    }

    private final PendingIntent zzh() {
        zzku zzku2 = zzku2.zzs.zzav();
        Intent intent = new Intent();
        return PendingIntent.getBroadcast((Context)zzku2, (int)0, (Intent)intent.setClassName((Context)zzku2, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD"), (int)zzbs.zza);
    }

    private final zzao zzi() {
        if (this.zzb == null) {
            zzkt zzkt2 = new zzkt(this, (zzhd)this.zzf.zzq());
            this.zzb = zzkt2;
        }
        return this.zzb;
    }

    protected zzku(zzli zzli2) {
        super(zzli2);
        this.zza = (AlarmManager)this.zzs.zzav().getSystemService("alarm");
    }

    public final void zza() {
        this.zzW();
        this.zzs.zzaz().zzj().zza("Unscheduling upload");
        AlarmManager alarmManager = this.zza;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzh());
        }
        this.zzi().zzb();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzj();
            return;
        }
    }

    @TargetApi(value=24)
    private final void zzj() {
        JobScheduler jobScheduler = (JobScheduler)this.zzs.zzav().getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(this.zzf());
            return;
        }
    }

    public final void zzd(long l) {
        this.zzW();
        this.zzs.zzax();
        Context context = this.zzs.zzav();
        if (!zzlp.zzaj((Context)context)) {
            this.zzs.zzaz().zzc().zza("Receiver not registered/enabled");
        }
        if (!zzlp.zzak((Context)context, (boolean)false)) {
            this.zzs.zzaz().zzc().zza("Service not registered/enabled");
        }
        this.zza();
        this.zzs.zzaz().zzj().zzb("Scheduling upload, millis", (Object)l);
        long l2 = this.zzs.zzaw().elapsedRealtime() + l;
        this.zzs.zzf();
        if (l < Math.max(0L, (Long)zzel.zzw.zza(null)) && !this.zzi().zze()) {
            this.zzi().zzd(l);
        }
        this.zzs.zzax();
        if (Build.VERSION.SDK_INT >= 24) {
            context = this.zzs.zzav();
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = this.zzf();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo.Builder builder = new JobInfo.Builder(n, componentName);
            zzbt.zza(context, builder.setMinimumLatency(l).setOverrideDeadline(l + l).setExtras(persistableBundle).build(), "com.google.android.gms", "UploadAlarm");
            return;
        }
        context = this.zza;
        if (context != null) {
            this.zzs.zzf();
            context.setInexactRepeating(2, l2, Math.max((Long)zzel.zzr.zza(null), l), this.zzh());
            return;
        }
    }

    @Override
    protected final boolean zzb() {
        AlarmManager alarmManager = this.zza;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzh());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzj();
        }
        return false;
    }
}

