/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzbt;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzlb;

public final class zzkf
extends zzkh {
    private final AlarmManager zza;
    private zzap zzb;
    private Integer zzc;

    private final int zzf() {
        if (this.zzc == null) {
            this.zzc = "measurement".concat(String.valueOf(this.zzt.zzau().getPackageName())).hashCode();
        }
        return this.zzc;
    }

    private final PendingIntent zzh() {
        zzkf zzkf2 = zzkf2.zzt.zzau();
        Intent intent = new Intent();
        return PendingIntent.getBroadcast((Context)zzkf2, (int)0, (Intent)intent.setClassName((Context)zzkf2, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD"), (int)zzbs.zza);
    }

    private final zzap zzi() {
        if (this.zzb == null) {
            zzke zzke2 = new zzke(this, (zzgm)this.zzf.zzq());
            this.zzb = zzke2;
        }
        return this.zzb;
    }

    protected zzkf(zzkt zzkt2) {
        super(zzkt2);
        this.zza = (AlarmManager)this.zzt.zzau().getSystemService("alarm");
    }

    public final void zza() {
        this.zzW();
        this.zzt.zzay().zzj().zza("Unscheduling upload");
        AlarmManager alarmManager = this.zza;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzh());
        }
        this.zzi().zzb();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzj();
            return;
        }
    }

    @TargetApi(value=24)
    private final void zzj() {
        JobScheduler jobScheduler = (JobScheduler)this.zzt.zzau().getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(this.zzf());
            return;
        }
    }

    public final void zzd(long l) {
        this.zzW();
        this.zzt.zzaw();
        Context context = this.zzt.zzau();
        if (!zzlb.zzaj((Context)context)) {
            this.zzt.zzay().zzc().zza("Receiver not registered/enabled");
        }
        if (!zzlb.zzak((Context)context, (boolean)false)) {
            this.zzt.zzay().zzc().zza("Service not registered/enabled");
        }
        this.zza();
        this.zzt.zzay().zzj().zzb("Scheduling upload, millis", (Object)l);
        long l2 = this.zzt.zzav().elapsedRealtime() + l;
        this.zzt.zzf();
        if (l < Math.max(0L, (Long)zzdu.zzw.zza(null)) && !this.zzi().zze()) {
            this.zzi().zzd(l);
        }
        this.zzt.zzaw();
        if (Build.VERSION.SDK_INT >= 24) {
            context = this.zzt.zzau();
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = this.zzf();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo.Builder builder = new JobInfo.Builder(n, componentName);
            zzbt.zza(context, builder.setMinimumLatency(l).setOverrideDeadline(l + l).setExtras(persistableBundle).build(), "com.google.android.gms", "UploadAlarm");
            return;
        }
        context = this.zza;
        if (context != null) {
            this.zzt.zzf();
            context.setInexactRepeating(2, l2, Math.max((Long)zzdu.zzr.zza(null), l), this.zzh());
            return;
        }
    }

    @Override
    protected final boolean zzb() {
        AlarmManager alarmManager = this.zza;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzh());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzj();
        }
        return false;
    }
}

